/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb;

import java.io.IOException;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackend;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StateMigrationException;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public abstract class AbstractRocksDBState<K, N, V>
implements InternalKvState<K, N, V>,
State {
    TypeSerializer<N> namespaceSerializer;
    TypeSerializer<V> valueSerializer;
    private N currentNamespace;
    protected RocksDBKeyedStateBackend<K> backend;
    protected ColumnFamilyHandle columnFamily;
    protected V defaultValue;
    protected final WriteOptions writeOptions;
    protected final DataOutputSerializer dataOutputView;
    protected final DataInputDeserializer dataInputView;
    private final SerializedCompositeKeyBuilder<K> sharedKeyNamespaceSerializer;

    protected AbstractRocksDBState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer, V defaultValue, RocksDBKeyedStateBackend<K> backend) {
        this.namespaceSerializer = namespaceSerializer;
        this.backend = backend;
        this.columnFamily = columnFamily;
        this.writeOptions = backend.getWriteOptions();
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull(valueSerializer, (String)"State value serializer");
        this.defaultValue = defaultValue;
        this.dataOutputView = new DataOutputSerializer(128);
        this.dataInputView = new DataInputDeserializer();
        this.sharedKeyNamespaceSerializer = backend.getSharedRocksKeyBuilder();
    }

    public void clear() {
        try {
            this.backend.db.delete(this.columnFamily, this.writeOptions, this.serializeCurrentKeyWithGroupAndNamespace());
        }
        catch (RocksDBException e) {
            throw new FlinkRuntimeException("Error while removing entry from RocksDB", (Throwable)e);
        }
    }

    public void setCurrentNamespace(N namespace) {
        this.currentNamespace = namespace;
    }

    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        Tuple2 keyAndNamespace = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        int keyGroup = KeyGroupRangeAssignment.assignToKeyGroup((Object)keyAndNamespace.f0, (int)this.backend.getNumberOfKeyGroups());
        SerializedCompositeKeyBuilder keyBuilder = new SerializedCompositeKeyBuilder(safeKeySerializer, this.backend.getKeyGroupPrefixBytes(), 32);
        keyBuilder.setKeyAndKeyGroup(keyAndNamespace.f0, keyGroup);
        byte[] key = keyBuilder.buildCompositeKeyNamespace(keyAndNamespace.f1, this.namespaceSerializer);
        return this.backend.db.get(this.columnFamily, key);
    }

    <UK> byte[] serializeCurrentKeyWithGroupAndNamespacePlusUserKey(UK userKey, TypeSerializer<UK> userKeySerializer) throws IOException {
        return this.sharedKeyNamespaceSerializer.buildCompositeKeyNamesSpaceUserKey(this.currentNamespace, this.namespaceSerializer, userKey, userKeySerializer);
    }

    private <T> byte[] serializeValueInternal(T value, TypeSerializer<T> serializer) throws IOException {
        serializer.serialize(value, (DataOutputView)this.dataOutputView);
        return this.dataOutputView.getCopyOfBuffer();
    }

    byte[] serializeCurrentKeyWithGroupAndNamespace() {
        return this.sharedKeyNamespaceSerializer.buildCompositeKeyNamespace(this.currentNamespace, this.namespaceSerializer);
    }

    byte[] serializeValue(V value) throws IOException {
        return this.serializeValue(value, this.valueSerializer);
    }

    <T> byte[] serializeValueNullSensitive(T value, TypeSerializer<T> serializer) throws IOException {
        this.dataOutputView.clear();
        this.dataOutputView.writeBoolean(value == null);
        if (value != null) {
            serializer.serialize(value, (DataOutputView)this.dataOutputView);
        }
        return this.dataOutputView.getCopyOfBuffer();
    }

    <T> byte[] serializeValue(T value, TypeSerializer<T> serializer) throws IOException {
        this.dataOutputView.clear();
        return this.serializeValueInternal(value, serializer);
    }

    public void migrateSerializedValue(DataInputDeserializer serializedOldValueInput, DataOutputSerializer serializedMigratedValueOutput, TypeSerializer<V> priorSerializer, TypeSerializer<V> newSerializer) throws StateMigrationException {
        try {
            Object value = priorSerializer.deserialize((DataInputView)serializedOldValueInput);
            newSerializer.serialize(value, (DataOutputView)serializedMigratedValueOutput);
        }
        catch (Exception e) {
            throw new StateMigrationException("Error while trying to migrate RocksDB state.", (Throwable)e);
        }
    }

    byte[] getKeyBytes() {
        return this.serializeCurrentKeyWithGroupAndNamespace();
    }

    byte[] getValueBytes(V value) {
        try {
            this.dataOutputView.clear();
            this.valueSerializer.serialize(value, (DataOutputView)this.dataOutputView);
            return this.dataOutputView.getCopyOfBuffer();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Error while serializing value", (Throwable)e);
        }
    }

    protected V getDefaultValue() {
        if (this.defaultValue != null) {
            return (V)this.valueSerializer.copy(this.defaultValue);
        }
        return null;
    }

    protected AbstractRocksDBState<K, N, V> setNamespaceSerializer(TypeSerializer<N> namespaceSerializer) {
        this.namespaceSerializer = namespaceSerializer;
        return this;
    }

    protected AbstractRocksDBState<K, N, V> setValueSerializer(TypeSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    protected AbstractRocksDBState<K, N, V> setDefaultValue(V defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public InternalKvState.StateIncrementalVisitor<K, N, V> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        throw new UnsupportedOperationException("Global state entry iterator is unsupported for RocksDb backend");
    }
}

