/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.internal.InternalAppendingState;
import org.apache.flink.state.rocksdb.AbstractRocksDBState;
import org.apache.flink.state.rocksdb.RocksDBKeyedStateBackend;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

abstract class AbstractRocksDBAppendingState<K, N, IN, SV, OUT>
extends AbstractRocksDBState<K, N, SV>
implements InternalAppendingState<K, N, IN, SV, OUT> {
    protected AbstractRocksDBAppendingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<SV> valueSerializer, SV defaultValue, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
    }

    public SV getInternal() throws IOException, RocksDBException {
        return this.getInternal(this.getKeyBytes());
    }

    SV getInternal(byte[] key) throws IOException, RocksDBException {
        byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
        if (valueBytes == null) {
            return null;
        }
        this.dataInputView.setBuffer(valueBytes);
        return (SV)this.valueSerializer.deserialize((DataInputView)this.dataInputView);
    }

    public void updateInternal(SV valueToStore) throws RocksDBException {
        this.updateInternal(this.getKeyBytes(), valueToStore);
    }

    void updateInternal(byte[] key, SV valueToStore) throws RocksDBException {
        this.backend.db.put(this.columnFamily, this.writeOptions, key, this.getValueBytes(valueToStore));
    }
}

