/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

class RocksDBValueState<K, N, V>
extends AbstractRocksDBState<K, N, V>
implements InternalValueState<K, N, V> {
    private RocksDBValueState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer, V defaultValue, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public V value() throws IOException {
        try {
            byte[] valueBytes = this.backend.db.get(this.columnFamily, this.serializeCurrentKeyWithGroupAndNamespace());
            if (valueBytes == null) {
                return this.getDefaultValue();
            }
            this.dataInputView.setBuffer(valueBytes);
            return (V)this.valueSerializer.deserialize((DataInputView)this.dataInputView);
        }
        catch (RocksDBException e) {
            throw new IOException("Error while retrieving data from RocksDB.", e);
        }
    }

    public void update(V value) throws IOException {
        if (value == null) {
            this.clear();
            return;
        }
        try {
            this.backend.db.put(this.columnFamily, this.writeOptions, this.serializeCurrentKeyWithGroupAndNamespace(), this.serializeValue(value));
        }
        catch (RocksDBException e) {
            throw new IOException("Error while adding data to RocksDB", e);
        }
    }

    static <K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, Tuple2<ColumnFamilyHandle, RegisteredKeyValueStateBackendMetaInfo<N, SV>> registerResult, RocksDBKeyedStateBackend<K> backend) {
        return (IS)new RocksDBValueState<K, N, Object>((ColumnFamilyHandle)registerResult.f0, ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getNamespaceSerializer(), ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getStateSerializer(), stateDesc.getDefaultValue(), backend);
    }

    static <K, N, SV, S extends State, IS extends S> IS update(StateDescriptor<S, SV> stateDesc, Tuple2<ColumnFamilyHandle, RegisteredKeyValueStateBackendMetaInfo<N, SV>> registerResult, IS existingState) {
        return (IS)((RocksDBValueState)existingState).setNamespaceSerializer(((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getNamespaceSerializer()).setValueSerializer(((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getStateSerializer()).setDefaultValue(stateDesc.getDefaultValue());
    }
}

