/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.benchmark;

import java.util.function.Supplier;
import org.apache.flink.contrib.streaming.state.EmbeddedRocksDBStateBackend;
import org.apache.flink.contrib.streaming.state.benchmark.RescalingBenchmark;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.util.Preconditions;

public class RescalingBenchmarkBuilder<KEY> {
    private int maxParallelism = 128;
    private int parallelismBefore = 2;
    private int parallelismAfter = 1;
    private int managedMemorySize = 0x20000000;
    private StateBackend stateBackend = new EmbeddedRocksDBStateBackend();
    private RescalingBenchmark.StreamRecordGenerator<KEY> streamRecordGenerator;
    private Supplier<KeyedProcessFunction<KEY, KEY, Void>> stateProcessFunctionSupplier;
    private CheckpointStorageAccess checkpointStorageAccess;

    public RescalingBenchmarkBuilder<KEY> setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    public RescalingBenchmarkBuilder<KEY> setParallelismBefore(int parallelismBefore) {
        this.parallelismBefore = parallelismBefore;
        return this;
    }

    public RescalingBenchmarkBuilder<KEY> setParallelismAfter(int parallelismAfter) {
        this.parallelismAfter = parallelismAfter;
        return this;
    }

    public RescalingBenchmarkBuilder<KEY> setManagedMemorySize(int managedMemorySize) {
        this.managedMemorySize = managedMemorySize;
        return this;
    }

    public RescalingBenchmarkBuilder<KEY> setStateBackend(StateBackend stateBackend) {
        this.stateBackend = stateBackend;
        return this;
    }

    public RescalingBenchmarkBuilder<KEY> setStreamRecordGenerator(RescalingBenchmark.StreamRecordGenerator<KEY> generator) {
        this.streamRecordGenerator = generator;
        return this;
    }

    public RescalingBenchmarkBuilder<KEY> setStateProcessFunctionSupplier(Supplier<KeyedProcessFunction<KEY, KEY, Void>> supplier) {
        this.stateProcessFunctionSupplier = supplier;
        return this;
    }

    public RescalingBenchmarkBuilder<KEY> setCheckpointStorageAccess(CheckpointStorageAccess checkpointStorageAccess) {
        this.checkpointStorageAccess = checkpointStorageAccess;
        return this;
    }

    public RescalingBenchmark<KEY> build() {
        return new RescalingBenchmark(this.parallelismBefore, this.parallelismAfter, this.maxParallelism, this.managedMemorySize, this.stateBackend, (CheckpointStorageAccess)Preconditions.checkNotNull((Object)this.checkpointStorageAccess), (RescalingBenchmark.StreamRecordGenerator)Preconditions.checkNotNull(this.streamRecordGenerator), (Supplier)Preconditions.checkNotNull(this.stateProcessFunctionSupplier));
    }
}

