/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBWriteBatchWrapper
implements AutoCloseable {
    private static final int MIN_CAPACITY = 100;
    private static final int MAX_CAPACITY = 1000;
    private static final int PER_RECORD_BYTES = 100;
    private static final long DEFAULT_BATCH_SIZE = 0L;
    private final RocksDB db;
    private final WriteBatch batch;
    private final WriteOptions options;
    private final int capacity;
    @Nonnegative
    private final long batchSize;

    public RocksDBWriteBatchWrapper(@Nonnull RocksDB rocksDB, long writeBatchSize) {
        this(rocksDB, null, 500, writeBatchSize);
    }

    public RocksDBWriteBatchWrapper(@Nonnull RocksDB rocksDB, @Nullable WriteOptions options) {
        this(rocksDB, options, 500, 0L);
    }

    public RocksDBWriteBatchWrapper(@Nonnull RocksDB rocksDB, @Nullable WriteOptions options, long batchSize) {
        this(rocksDB, options, 500, batchSize);
    }

    public RocksDBWriteBatchWrapper(@Nonnull RocksDB rocksDB, @Nullable WriteOptions options, int capacity, long batchSize) {
        Preconditions.checkArgument((capacity >= 100 && capacity <= 1000 ? 1 : 0) != 0, (Object)"capacity should be between 100 and 1000");
        Preconditions.checkArgument((batchSize >= 0L ? 1 : 0) != 0, (Object)"Max batch size have to be no negative.");
        this.db = rocksDB;
        this.options = options;
        this.capacity = capacity;
        this.batchSize = batchSize;
        this.batch = this.batchSize > 0L ? new WriteBatch((int)Math.min(this.batchSize, (long)(this.capacity * 100))) : new WriteBatch(this.capacity * 100);
    }

    public void put(@Nonnull ColumnFamilyHandle handle, @Nonnull byte[] key, @Nonnull byte[] value) throws RocksDBException {
        this.batch.put(handle, key, value);
        this.flushIfNeeded();
    }

    public void remove(@Nonnull ColumnFamilyHandle handle, @Nonnull byte[] key) throws RocksDBException {
        this.batch.remove(handle, key);
        this.flushIfNeeded();
    }

    public void flush() throws RocksDBException {
        if (this.options != null) {
            this.db.write(this.options, this.batch);
        } else {
            try (WriteOptions writeOptions = new WriteOptions();){
                this.db.write(writeOptions, this.batch);
            }
        }
        this.batch.clear();
    }

    public WriteOptions getOptions() {
        return this.options;
    }

    @Override
    public void close() throws RocksDBException {
        if (this.batch.count() != 0) {
            this.flush();
        }
        IOUtils.closeQuietly((AutoCloseable)this.batch);
    }

    private void flushIfNeeded() throws RocksDBException {
        boolean needFlush;
        boolean bl = needFlush = this.batch.count() == this.capacity || this.batchSize > 0L && this.getDataSize() >= this.batchSize;
        if (needFlush) {
            this.flush();
        }
    }

    @VisibleForTesting
    long getDataSize() {
        return this.batch.getDataSize();
    }
}

