/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.apache.flink.runtime.state.v2.InternalValueState;
import org.apache.flink.runtime.state.v2.ValueStateDescriptor;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBGetRequest;
import org.apache.flink.state.forst.ForStDBPutRequest;
import org.apache.flink.state.forst.ForStInnerTable;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;

public class ForStValueState<K, V>
extends InternalValueState<K, V>
implements ValueState<V>,
ForStInnerTable<ContextKey<K>, V> {
    private final ColumnFamilyHandle columnFamilyHandle;
    private final ThreadLocal<SerializedCompositeKeyBuilder<K>> serializedKeyBuilder;
    private final ThreadLocal<DataOutputSerializer> valueSerializerView;
    private final ThreadLocal<DataInputDeserializer> valueDeserializerView;

    public ForStValueState(StateRequestHandler stateRequestHandler, ColumnFamilyHandle columnFamily, ValueStateDescriptor<V> valueStateDescriptor, Supplier<SerializedCompositeKeyBuilder<K>> serializedKeyBuilderInitializer, Supplier<DataOutputSerializer> valueSerializerViewInitializer, Supplier<DataInputDeserializer> valueDeserializerViewInitializer) {
        super(stateRequestHandler, valueStateDescriptor);
        this.columnFamilyHandle = columnFamily;
        this.serializedKeyBuilder = ThreadLocal.withInitial(serializedKeyBuilderInitializer);
        this.valueSerializerView = ThreadLocal.withInitial(valueSerializerViewInitializer);
        this.valueDeserializerView = ThreadLocal.withInitial(valueDeserializerViewInitializer);
    }

    @Override
    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.columnFamilyHandle;
    }

    @Override
    public byte[] serializeKey(ContextKey<K> contextKey) throws IOException {
        return contextKey.getOrCreateSerializedKey(ctxKey -> {
            SerializedCompositeKeyBuilder<K> builder = this.serializedKeyBuilder.get();
            builder.setKeyAndKeyGroup(ctxKey.getRawKey(), ctxKey.getKeyGroup());
            return builder.build();
        });
    }

    @Override
    public byte[] serializeValue(V value) throws IOException {
        DataOutputSerializer outputView = this.valueSerializerView.get();
        outputView.clear();
        this.getValueSerializer().serialize(value, (DataOutputView)outputView);
        return outputView.getCopyOfBuffer();
    }

    @Override
    public V deserializeValue(byte[] valueBytes) throws IOException {
        DataInputDeserializer inputView = this.valueDeserializerView.get();
        inputView.setBuffer(valueBytes);
        return (V)this.getValueSerializer().deserialize((DataInputView)inputView);
    }

    @Override
    public ForStDBGetRequest<ContextKey<K>, V> buildDBGetRequest(StateRequest<?, ?, ?> stateRequest) {
        Preconditions.checkArgument((stateRequest.getRequestType() == StateRequestType.VALUE_GET ? 1 : 0) != 0);
        ContextKey contextKey = new ContextKey(stateRequest.getRecordContext());
        return ForStDBGetRequest.of(contextKey, this, stateRequest.getFuture());
    }

    @Override
    public ForStDBPutRequest<ContextKey<K>, V> buildDBPutRequest(StateRequest<?, ?, ?> stateRequest) {
        Preconditions.checkArgument((stateRequest.getRequestType() == StateRequestType.VALUE_UPDATE || stateRequest.getRequestType() == StateRequestType.CLEAR ? 1 : 0) != 0);
        ContextKey contextKey = new ContextKey(stateRequest.getRecordContext());
        Object value = stateRequest.getRequestType() == StateRequestType.CLEAR ? null : stateRequest.getPayload();
        return ForStDBPutRequest.of(contextKey, value, this, (InternalStateFuture<Void>)stateRequest.getFuture());
    }
}

