/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import javax.annotation.Nullable;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.state.forst.ForStMemoryConfiguration;
import org.apache.flink.state.forst.ForStMemoryControllerUtils;
import org.apache.flink.state.forst.ForStOptions;
import org.apache.flink.state.forst.ForStSharedResources;
import org.apache.flink.state.forst.MemoryShareScope;
import org.apache.flink.util.function.LongFunctionWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;

enum ForStSharedResourcesFactory {
    SLOT_SHARED_MANAGED(false, MemoryShareScope.SLOT){

        @Override
        protected OpaqueMemoryResource<ForStSharedResources> createInternal(ForStMemoryConfiguration jobMemoryConfig, String resourceId, Environment env, double memoryFraction, LongFunctionWithException<ForStSharedResources, Exception> allocator) throws Exception {
            return env.getMemoryManager().getSharedMemoryResourceForManagedMemory(resourceId, allocator, memoryFraction);
        }
    }
    ,
    SLOT_SHARED_UNMANAGED(false, MemoryShareScope.SLOT){

        @Override
        protected OpaqueMemoryResource<ForStSharedResources> createInternal(ForStMemoryConfiguration jobMemoryConfig, String resourceId, Environment env, double memoryFraction, LongFunctionWithException<ForStSharedResources, Exception> allocator) throws Exception {
            return env.getMemoryManager().getExternalSharedMemoryResource(resourceId, allocator, jobMemoryConfig.getFixedMemoryPerSlot().getBytes());
        }
    }
    ,
    TM_SHARED_UNMANAGED(false, MemoryShareScope.TM){

        @Override
        protected OpaqueMemoryResource<ForStSharedResources> createInternal(ForStMemoryConfiguration jobMemoryConfig, String resourceId, Environment env, double memoryFraction, LongFunctionWithException<ForStSharedResources, Exception> allocator) throws Exception {
            SharedResources sharedResources = env.getSharedResources();
            Object leaseHolder = new Object();
            SharedResources.ResourceAndSize resource = sharedResources.getOrAllocateSharedResource(resourceId, leaseHolder, allocator, ForStSharedResourcesFactory.getTmSharedMemorySize(env));
            ThrowingRunnable disposer = () -> sharedResources.release(resourceId, leaseHolder, unused -> {});
            return new OpaqueMemoryResource((Object)resource.resourceHandle(), resource.size(), disposer);
        }
    };

    private final boolean managed;
    private final MemoryShareScope shareScope;
    private static final String MANAGED_MEMORY_RESOURCE_ID = "state-forst-managed-memory";
    private static final String UNMANAGED_MEMORY_RESOURCE_ID = "state-forst-fixed-slot-memory";

    private ForStSharedResourcesFactory(boolean managed, MemoryShareScope shareScope) {
        this.managed = managed;
        this.shareScope = shareScope;
    }

    @Nullable
    public static ForStSharedResourcesFactory from(ForStMemoryConfiguration jobMemoryConfig, Environment env) {
        if (jobMemoryConfig.isUsingFixedMemoryPerSlot()) {
            return SLOT_SHARED_UNMANAGED;
        }
        if (jobMemoryConfig.isUsingManagedMemory()) {
            return SLOT_SHARED_MANAGED;
        }
        if (ForStSharedResourcesFactory.getTmSharedMemorySize(env) > 0L) {
            return TM_SHARED_UNMANAGED;
        }
        return null;
    }

    public final OpaqueMemoryResource<ForStSharedResources> create(ForStMemoryConfiguration jobMemoryConfig, Environment env, double memoryFraction, Logger logger, ForStMemoryControllerUtils.ForStMemoryFactory forStMemoryFactory) throws Exception {
        logger.info("Getting shared memory for ForSt: shareScope={}, managed={}", (Object)this.shareScope, (Object)this.managed);
        return this.createInternal(jobMemoryConfig, this.managed ? MANAGED_MEMORY_RESOURCE_ID : UNMANAGED_MEMORY_RESOURCE_ID, env, memoryFraction, ForStSharedResourcesFactory.createAllocator(this.shareScope.getConfiguration(jobMemoryConfig, env), forStMemoryFactory));
    }

    protected abstract OpaqueMemoryResource<ForStSharedResources> createInternal(ForStMemoryConfiguration var1, String var2, Environment var3, double var4, LongFunctionWithException<ForStSharedResources, Exception> var6) throws Exception;

    private static long getTmSharedMemorySize(Environment env) {
        return env.getTaskManagerInfo().getConfiguration().getOptional(ForStOptions.FIX_PER_TM_MEMORY_SIZE).orElse(MemorySize.ZERO).getBytes();
    }

    private static LongFunctionWithException<ForStSharedResources, Exception> createAllocator(ForStMemoryConfiguration config, ForStMemoryControllerUtils.ForStMemoryFactory forStMemoryFactory) {
        return size -> ForStMemoryControllerUtils.allocateForStSharedResources(size, config.getWriteBufferRatio(), config.getHighPriorityPoolRatio(), config.isUsingPartitionedIndexFilters(), forStMemoryFactory);
    }
}

