/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.state.forst.ForStProperty;
import org.rocksdb.TickerType;

@Experimental
public class ForStNativeMetricOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String METRICS_COLUMN_FAMILY_AS_VARIABLE_KEY = "state.backend.rocksdb.metrics.column-family-as-variable";
    public static final ConfigOption<Boolean> MONITOR_NUM_IMMUTABLE_MEM_TABLES = ConfigOptions.key((String)ForStProperty.NumImmutableMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of immutable memtables in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_MEM_TABLE_FLUSH_PENDING = ConfigOptions.key((String)ForStProperty.MemTableFlushPending.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of pending memtable flushes in RocksDB.");
    public static final ConfigOption<Boolean> TRACK_COMPACTION_PENDING = ConfigOptions.key((String)ForStProperty.CompactionPending.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Track pending compactions in RocksDB. Returns 1 if a compaction is pending, 0 otherwise.");
    public static final ConfigOption<Boolean> MONITOR_BACKGROUND_ERRORS = ConfigOptions.key((String)ForStProperty.BackgroundErrors.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of background errors in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_CUR_SIZE_ACTIVE_MEM_TABLE = ConfigOptions.key((String)ForStProperty.CurSizeActiveMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the approximate size of the active memtable in bytes.");
    public static final ConfigOption<Boolean> MONITOR_CUR_SIZE_ALL_MEM_TABLE = ConfigOptions.key((String)ForStProperty.CurSizeAllMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the approximate size of the active and unflushed immutable memtables in bytes.");
    public static final ConfigOption<Boolean> MONITOR_SIZE_ALL_MEM_TABLES = ConfigOptions.key((String)ForStProperty.SizeAllMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the approximate size of the active, unflushed immutable, and pinned immutable memtables in bytes.");
    public static final ConfigOption<Boolean> MONITOR_NUM_ENTRIES_ACTIVE_MEM_TABLE = ConfigOptions.key((String)ForStProperty.NumEntriesActiveMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of entries in the active memtable.");
    public static final ConfigOption<Boolean> MONITOR_NUM_ENTRIES_IMM_MEM_TABLES = ConfigOptions.key((String)ForStProperty.NumEntriesImmMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of entries in the unflushed immutable memtables.");
    public static final ConfigOption<Boolean> MONITOR_NUM_DELETES_ACTIVE_MEM_TABLE = ConfigOptions.key((String)ForStProperty.NumDeletesActiveMemTable.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of delete entries in the active memtable.");
    public static final ConfigOption<Boolean> MONITOR_NUM_DELETES_IMM_MEM_TABLE = ConfigOptions.key((String)ForStProperty.NumDeletesImmMemTables.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total number of delete entries in the unflushed immutable memtables.");
    public static final ConfigOption<Boolean> ESTIMATE_NUM_KEYS = ConfigOptions.key((String)ForStProperty.EstimateNumKeys.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimate the number of keys in RocksDB.");
    public static final ConfigOption<Boolean> ESTIMATE_TABLE_READERS_MEM = ConfigOptions.key((String)ForStProperty.EstimateTableReadersMem.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimate the memory used for reading SST tables, excluding memory used in block cache (e.g.,filter and index blocks) in bytes.");
    public static final ConfigOption<Boolean> MONITOR_NUM_SNAPSHOTS = ConfigOptions.key((String)ForStProperty.NumSnapshots.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of unreleased snapshots of the database.");
    public static final ConfigOption<Boolean> MONITOR_NUM_LIVE_VERSIONS = ConfigOptions.key((String)ForStProperty.NumLiveVersions.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor number of live versions. Version is an internal data structure. See RocksDB file version_set.h for details. More live versions often mean more SST files are held from being deleted, by iterators or unfinished compactions.");
    public static final ConfigOption<Boolean> ESTIMATE_LIVE_DATA_SIZE = ConfigOptions.key((String)ForStProperty.EstimateLiveDataSize.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimate of the amount of live data in bytes (usually smaller than sst files size due to space amplification).");
    public static final ConfigOption<Boolean> MONITOR_TOTAL_SST_FILES_SIZE = ConfigOptions.key((String)ForStProperty.TotalSstFilesSize.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total size (bytes) of all SST files of all versions.WARNING: may slow down online queries if there are too many files.");
    public static final ConfigOption<Boolean> MONITOR_LIVE_SST_FILES_SIZE = ConfigOptions.key((String)ForStProperty.LiveSstFilesSize.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the total size (bytes) of all SST files belonging to the latest version.WARNING: may slow down online queries if there are too many files.");
    public static final ConfigOption<Boolean> ESTIMATE_PENDING_COMPACTION_BYTES = ConfigOptions.key((String)ForStProperty.EstimatePendingCompactionBytes.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Estimated total number of bytes compaction needs to rewrite to get all levels down to under target size. Not valid for other compactions than level-based.");
    public static final ConfigOption<Boolean> MONITOR_NUM_RUNNING_COMPACTIONS = ConfigOptions.key((String)ForStProperty.NumRunningCompactions.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of currently running compactions.");
    public static final ConfigOption<Boolean> MONITOR_NUM_RUNNING_FLUSHES = ConfigOptions.key((String)ForStProperty.NumRunningFlushes.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the number of currently running flushes.");
    public static final ConfigOption<Boolean> MONITOR_ACTUAL_DELAYED_WRITE_RATE = ConfigOptions.key((String)ForStProperty.ActualDelayedWriteRate.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the current actual delayed write rate. 0 means no delay.");
    public static final ConfigOption<Boolean> IS_WRITE_STOPPED = ConfigOptions.key((String)ForStProperty.IsWriteStopped.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Track whether write has been stopped in RocksDB. Returns 1 if write has been stopped, 0 otherwise.");
    public static final ConfigOption<Boolean> BLOCK_CACHE_CAPACITY = ConfigOptions.key((String)ForStProperty.BlockCacheCapacity.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor block cache capacity.");
    public static final ConfigOption<Boolean> BLOCK_CACHE_USAGE = ConfigOptions.key((String)ForStProperty.BlockCacheUsage.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the memory size for the entries residing in block cache.");
    public static final ConfigOption<Boolean> BLOCK_CACHE_PINNED_USAGE = ConfigOptions.key((String)ForStProperty.BlockCachePinnedUsage.getConfigKey()).booleanType().defaultValue((Object)false).withDescription("Monitor the memory size for the entries being pinned in block cache.");
    public static final ConfigOption<Boolean> COLUMN_FAMILY_AS_VARIABLE = ConfigOptions.key((String)"state.backend.rocksdb.metrics.column-family-as-variable").booleanType().defaultValue((Object)false).withDescription("Whether to expose the column family as a variable for RocksDB property based metrics.");
    public static final ConfigOption<Boolean> MONITOR_NUM_FILES_AT_LEVEL = ConfigOptions.key((String)"state.backend.rocksdb.metrics.num-files-at-level").booleanType().defaultValue((Object)false).withDescription("Monitor the number of files at each level.");
    public static final ConfigOption<Boolean> MONITOR_BLOCK_CACHE_HIT = ConfigOptions.key((String)"state.backend.rocksdb.metrics.block-cache-hit").booleanType().defaultValue((Object)false).withDescription("Monitor the total count of block cache hit in RocksDB (BLOCK_CACHE_HIT == BLOCK_CACHE_INDEX_HIT + BLOCK_CACHE_FILTER_HIT + BLOCK_CACHE_DATA_HIT).");
    public static final ConfigOption<Boolean> MONITOR_BLOCK_CACHE_MISS = ConfigOptions.key((String)"state.backend.rocksdb.metrics.block-cache-miss").booleanType().defaultValue((Object)false).withDescription("Monitor the total count of block cache misses in RocksDB (BLOCK_CACHE_MISS == BLOCK_CACHE_INDEX_MISS + BLOCK_CACHE_FILTER_MISS + BLOCK_CACHE_DATA_MISS).");
    public static final ConfigOption<Boolean> MONITOR_BLOOM_FILTER_USEFUL = ConfigOptions.key((String)"state.backend.rocksdb.metrics.bloom-filter-useful").booleanType().defaultValue((Object)false).withDescription("Monitor the total count of reads avoided by bloom filter.");
    public static final ConfigOption<Boolean> MONITOR_BLOOM_FILTER_FULL_POSITIVE = ConfigOptions.key((String)"state.backend.rocksdb.metrics.bloom-filter-full-positive").booleanType().defaultValue((Object)false).withDescription("Monitor the total count of reads not avoided by bloom full filter.");
    public static final ConfigOption<Boolean> MONITOR_BLOOM_FILTER_FULL_TRUE_POSITIVE = ConfigOptions.key((String)"state.backend.rocksdb.metrics.bloom-filter-full-true-positive").booleanType().defaultValue((Object)false).withDescription("Monitor the total count of reads not avoided by bloom full filter and the data actually exists in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_BYTES_READ = ConfigOptions.key((String)"state.backend.rocksdb.metrics.bytes-read").booleanType().defaultValue((Object)false).withDescription("Monitor the number of uncompressed bytes read (from memtables/cache/sst) from Get() operation in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_ITER_BYTES_READ = ConfigOptions.key((String)"state.backend.rocksdb.metrics.iter-bytes-read").booleanType().defaultValue((Object)false).withDescription("Monitor the number of uncompressed bytes read (from memtables/cache/sst) from an iterator operation in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_BYTES_WRITTEN = ConfigOptions.key((String)"state.backend.rocksdb.metrics.bytes-written").booleanType().defaultValue((Object)false).withDescription("Monitor the number of uncompressed bytes written by DB::{Put(), Delete(), Merge(), Write()} operations, which does not include the compaction written bytes, in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_COMPACTION_READ_BYTES = ConfigOptions.key((String)"state.backend.rocksdb.metrics.compaction-read-bytes").booleanType().defaultValue((Object)false).withDescription("Monitor the bytes read during compaction in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_COMPACTION_WRITE_BYTES = ConfigOptions.key((String)"state.backend.rocksdb.metrics.compaction-write-bytes").booleanType().defaultValue((Object)false).withDescription("Monitor the bytes written during compaction in RocksDB.");
    public static final ConfigOption<Boolean> MONITOR_STALL_MICROS = ConfigOptions.key((String)"state.backend.rocksdb.metrics.stall-micros").booleanType().defaultValue((Object)false).withDescription("Monitor the duration of writer requiring to wait for compaction or flush to finish in RocksDB.");
    private static final Map<ConfigOption<Boolean>, TickerType> tickerTypeMapping = new HashMap<ConfigOption<Boolean>, TickerType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(MONITOR_BLOCK_CACHE_HIT, TickerType.BLOCK_CACHE_HIT);
            this.put(MONITOR_BLOCK_CACHE_MISS, TickerType.BLOCK_CACHE_MISS);
            this.put(MONITOR_BLOOM_FILTER_USEFUL, TickerType.BLOOM_FILTER_USEFUL);
            this.put(MONITOR_BLOOM_FILTER_FULL_POSITIVE, TickerType.BLOOM_FILTER_FULL_POSITIVE);
            this.put(MONITOR_BLOOM_FILTER_FULL_TRUE_POSITIVE, TickerType.BLOOM_FILTER_FULL_TRUE_POSITIVE);
            this.put(MONITOR_BYTES_READ, TickerType.BYTES_READ);
            this.put(MONITOR_ITER_BYTES_READ, TickerType.ITER_BYTES_READ);
            this.put(MONITOR_BYTES_WRITTEN, TickerType.BYTES_WRITTEN);
            this.put(MONITOR_COMPACTION_READ_BYTES, TickerType.COMPACT_READ_BYTES);
            this.put(MONITOR_COMPACTION_WRITE_BYTES, TickerType.COMPACT_WRITE_BYTES);
            this.put(MONITOR_STALL_MICROS, TickerType.STALL_MICROS);
        }
    };
    private final Set<ForStProperty> properties;
    private final Set<TickerType> monitorTickerTypes;
    private boolean columnFamilyAsVariable = (Boolean)COLUMN_FAMILY_AS_VARIABLE.defaultValue();

    public static ForStNativeMetricOptions fromConfig(ReadableConfig config) {
        ForStNativeMetricOptions options = new ForStNativeMetricOptions();
        ForStNativeMetricOptions.configurePropertyMetrics(options, config);
        ForStNativeMetricOptions.configureStatisticsMetrics(options, config);
        return options;
    }

    private static void configurePropertyMetrics(ForStNativeMetricOptions options, ReadableConfig config) {
        if (((Boolean)config.get(MONITOR_NUM_IMMUTABLE_MEM_TABLES)).booleanValue()) {
            options.enableNumImmutableMemTable();
        }
        if (((Boolean)config.get(MONITOR_MEM_TABLE_FLUSH_PENDING)).booleanValue()) {
            options.enableMemTableFlushPending();
        }
        if (((Boolean)config.get(TRACK_COMPACTION_PENDING)).booleanValue()) {
            options.enableCompactionPending();
        }
        if (((Boolean)config.get(MONITOR_BACKGROUND_ERRORS)).booleanValue()) {
            options.enableBackgroundErrors();
        }
        if (((Boolean)config.get(MONITOR_CUR_SIZE_ACTIVE_MEM_TABLE)).booleanValue()) {
            options.enableCurSizeActiveMemTable();
        }
        if (((Boolean)config.get(MONITOR_CUR_SIZE_ALL_MEM_TABLE)).booleanValue()) {
            options.enableCurSizeAllMemTables();
        }
        if (((Boolean)config.get(MONITOR_SIZE_ALL_MEM_TABLES)).booleanValue()) {
            options.enableSizeAllMemTables();
        }
        if (((Boolean)config.get(MONITOR_NUM_ENTRIES_ACTIVE_MEM_TABLE)).booleanValue()) {
            options.enableNumEntriesActiveMemTable();
        }
        if (((Boolean)config.get(MONITOR_NUM_ENTRIES_IMM_MEM_TABLES)).booleanValue()) {
            options.enableNumEntriesImmMemTables();
        }
        if (((Boolean)config.get(MONITOR_NUM_DELETES_ACTIVE_MEM_TABLE)).booleanValue()) {
            options.enableNumDeletesActiveMemTable();
        }
        if (((Boolean)config.get(MONITOR_NUM_DELETES_IMM_MEM_TABLE)).booleanValue()) {
            options.enableNumDeletesImmMemTables();
        }
        if (((Boolean)config.get(ESTIMATE_NUM_KEYS)).booleanValue()) {
            options.enableEstimateNumKeys();
        }
        if (((Boolean)config.get(ESTIMATE_TABLE_READERS_MEM)).booleanValue()) {
            options.enableEstimateTableReadersMem();
        }
        if (((Boolean)config.get(MONITOR_NUM_SNAPSHOTS)).booleanValue()) {
            options.enableNumSnapshots();
        }
        if (((Boolean)config.get(MONITOR_NUM_LIVE_VERSIONS)).booleanValue()) {
            options.enableNumLiveVersions();
        }
        if (((Boolean)config.get(ESTIMATE_LIVE_DATA_SIZE)).booleanValue()) {
            options.enableEstimateLiveDataSize();
        }
        if (((Boolean)config.get(MONITOR_TOTAL_SST_FILES_SIZE)).booleanValue()) {
            options.enableTotalSstFilesSize();
        }
        if (((Boolean)config.get(MONITOR_LIVE_SST_FILES_SIZE)).booleanValue()) {
            options.enableLiveSstFilesSize();
        }
        if (((Boolean)config.get(ESTIMATE_PENDING_COMPACTION_BYTES)).booleanValue()) {
            options.enableEstimatePendingCompactionBytes();
        }
        if (((Boolean)config.get(MONITOR_NUM_RUNNING_COMPACTIONS)).booleanValue()) {
            options.enableNumRunningCompactions();
        }
        if (((Boolean)config.get(MONITOR_NUM_RUNNING_FLUSHES)).booleanValue()) {
            options.enableNumRunningFlushes();
        }
        if (((Boolean)config.get(MONITOR_ACTUAL_DELAYED_WRITE_RATE)).booleanValue()) {
            options.enableActualDelayedWriteRate();
        }
        if (((Boolean)config.get(IS_WRITE_STOPPED)).booleanValue()) {
            options.enableIsWriteStopped();
        }
        if (((Boolean)config.get(BLOCK_CACHE_CAPACITY)).booleanValue()) {
            options.enableBlockCacheCapacity();
        }
        if (((Boolean)config.get(BLOCK_CACHE_USAGE)).booleanValue()) {
            options.enableBlockCacheUsage();
        }
        if (((Boolean)config.get(BLOCK_CACHE_PINNED_USAGE)).booleanValue()) {
            options.enableBlockCachePinnedUsage();
        }
        if (((Boolean)config.get(MONITOR_NUM_FILES_AT_LEVEL)).booleanValue()) {
            options.enableNumFilesAtLevel();
        }
        options.setColumnFamilyAsVariable((Boolean)config.get(COLUMN_FAMILY_AS_VARIABLE));
    }

    private static void configureStatisticsMetrics(ForStNativeMetricOptions options, ReadableConfig config) {
        for (Map.Entry<ConfigOption<Boolean>, TickerType> entry : tickerTypeMapping.entrySet()) {
            if (!((Boolean)config.get(entry.getKey())).booleanValue()) continue;
            options.monitorTickerTypes.add(entry.getValue());
        }
    }

    public ForStNativeMetricOptions() {
        this.properties = new HashSet<ForStProperty>();
        this.monitorTickerTypes = new HashSet<TickerType>();
    }

    @VisibleForTesting
    public void enableNativeStatistics(ConfigOption<Boolean> nativeStatisticsOption) {
        TickerType tickerType = tickerTypeMapping.get(nativeStatisticsOption);
        if (tickerType == null) {
            throw new IllegalArgumentException("Unknown configurable native statistics option " + nativeStatisticsOption);
        }
        this.monitorTickerTypes.add(tickerType);
    }

    public void enableNumImmutableMemTable() {
        this.properties.add(ForStProperty.NumImmutableMemTable);
    }

    public void enableMemTableFlushPending() {
        this.properties.add(ForStProperty.MemTableFlushPending);
    }

    public void enableCompactionPending() {
        this.properties.add(ForStProperty.CompactionPending);
    }

    public void enableBackgroundErrors() {
        this.properties.add(ForStProperty.BackgroundErrors);
    }

    public void enableCurSizeActiveMemTable() {
        this.properties.add(ForStProperty.CurSizeActiveMemTable);
    }

    public void enableCurSizeAllMemTables() {
        this.properties.add(ForStProperty.CurSizeAllMemTables);
    }

    public void enableSizeAllMemTables() {
        this.properties.add(ForStProperty.SizeAllMemTables);
    }

    public void enableNumEntriesActiveMemTable() {
        this.properties.add(ForStProperty.NumEntriesActiveMemTable);
    }

    public void enableNumEntriesImmMemTables() {
        this.properties.add(ForStProperty.NumEntriesImmMemTables);
    }

    public void enableNumDeletesActiveMemTable() {
        this.properties.add(ForStProperty.NumDeletesActiveMemTable);
    }

    public void enableNumDeletesImmMemTables() {
        this.properties.add(ForStProperty.NumDeletesImmMemTables);
    }

    public void enableEstimateNumKeys() {
        this.properties.add(ForStProperty.EstimateNumKeys);
    }

    public void enableEstimateTableReadersMem() {
        this.properties.add(ForStProperty.EstimateTableReadersMem);
    }

    public void enableNumSnapshots() {
        this.properties.add(ForStProperty.NumSnapshots);
    }

    public void enableNumLiveVersions() {
        this.properties.add(ForStProperty.NumLiveVersions);
    }

    public void enableEstimateLiveDataSize() {
        this.properties.add(ForStProperty.EstimateLiveDataSize);
    }

    public void enableTotalSstFilesSize() {
        this.properties.add(ForStProperty.TotalSstFilesSize);
    }

    public void enableLiveSstFilesSize() {
        this.properties.add(ForStProperty.LiveSstFilesSize);
    }

    public void enableEstimatePendingCompactionBytes() {
        this.properties.add(ForStProperty.EstimatePendingCompactionBytes);
    }

    public void enableNumRunningCompactions() {
        this.properties.add(ForStProperty.NumRunningCompactions);
    }

    public void enableNumRunningFlushes() {
        this.properties.add(ForStProperty.NumRunningFlushes);
    }

    public void enableActualDelayedWriteRate() {
        this.properties.add(ForStProperty.ActualDelayedWriteRate);
    }

    public void enableIsWriteStopped() {
        this.properties.add(ForStProperty.IsWriteStopped);
    }

    public void enableBlockCacheCapacity() {
        this.properties.add(ForStProperty.BlockCacheCapacity);
    }

    public void enableBlockCacheUsage() {
        this.properties.add(ForStProperty.BlockCacheUsage);
    }

    public void enableBlockCachePinnedUsage() {
        this.properties.add(ForStProperty.BlockCachePinnedUsage);
    }

    public void enableNumFilesAtLevel() {
        this.properties.add(ForStProperty.NumFilesAtLevel0);
        this.properties.add(ForStProperty.NumFilesAtLevel1);
        this.properties.add(ForStProperty.NumFilesAtLevel2);
        this.properties.add(ForStProperty.NumFilesAtLevel3);
        this.properties.add(ForStProperty.NumFilesAtLevel4);
        this.properties.add(ForStProperty.NumFilesAtLevel5);
        this.properties.add(ForStProperty.NumFilesAtLevel6);
    }

    public void setColumnFamilyAsVariable(boolean columnFamilyAsVariable) {
        this.columnFamilyAsVariable = columnFamilyAsVariable;
    }

    public Collection<ForStProperty> getProperties() {
        return Collections.unmodifiableCollection(this.properties);
    }

    public Collection<TickerType> getMonitorTickerTypes() {
        return Collections.unmodifiableCollection(this.monitorTickerTypes);
    }

    public boolean isEnabled() {
        return !this.properties.isEmpty() || this.isStatisticsEnabled();
    }

    public boolean isStatisticsEnabled() {
        return !this.monitorTickerTypes.isEmpty();
    }

    public boolean isColumnFamilyAsVariable() {
        return this.columnFamilyAsVariable;
    }
}

