/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.core.fs.FSDataOutputStream;

@Experimental
public class ByteBufferWritableFSDataOutputStream
extends FSDataOutputStream {
    private final FSDataOutputStream originalOutputStream;

    public ByteBufferWritableFSDataOutputStream(FSDataOutputStream originalOutputStream) {
        this.originalOutputStream = originalOutputStream;
    }

    public void write(ByteBuffer bb) throws IOException {
        if (bb == null) {
            throw new NullPointerException();
        }
        if (bb.remaining() == 0) {
            return;
        }
        if (bb.hasArray()) {
            this.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        } else {
            int len = bb.remaining();
            for (int i = 0; i < len; ++i) {
                this.originalOutputStream.write((int)bb.get());
            }
        }
    }

    public long getPos() throws IOException {
        return this.originalOutputStream.getPos();
    }

    public void write(int b) throws IOException {
        this.originalOutputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.originalOutputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.originalOutputStream.write(b, off, len);
    }

    public void flush() throws IOException {
        this.originalOutputStream.flush();
    }

    public void sync() throws IOException {
        this.originalOutputStream.sync();
    }

    public void close() throws IOException {
        this.originalOutputStream.close();
    }
}

