/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.api.common.state.State;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.state.changelog.AbstractChangelogState;
import org.apache.flink.state.changelog.KvStateChangeLogger;
import org.apache.flink.state.changelog.restore.ChangelogApplierFactory;
import org.apache.flink.state.changelog.restore.StateChangeApplier;
import org.apache.flink.util.ExceptionUtils;

class ChangelogReducingState<K, N, V>
extends AbstractChangelogState<K, N, V, InternalReducingState<K, N, V>>
implements InternalReducingState<K, N, V> {
    private final InternalKeyContext<K> keyContext;

    ChangelogReducingState(InternalReducingState<K, N, V> delegatedState, KvStateChangeLogger<V, N> changeLogger, InternalKeyContext<K> keyContext) {
        super(delegatedState, changeLogger);
        this.keyContext = keyContext;
    }

    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        ((InternalReducingState)this.delegatedState).mergeNamespaces(target, sources);
        this.changeLogger.namespacesMerged(target, sources);
    }

    public V getInternal() throws Exception {
        return (V)((InternalReducingState)this.delegatedState).getInternal();
    }

    public void updateInternal(V valueToStore) throws Exception {
        ((InternalReducingState)this.delegatedState).updateInternal(valueToStore);
        this.changeLogger.valueUpdatedInternal(valueToStore, this.getCurrentNamespace());
    }

    public V get() throws Exception {
        return (V)((InternalReducingState)this.delegatedState).get();
    }

    public void add(V value) throws Exception {
        ((InternalReducingState)this.delegatedState).add(value);
        this.changeLogger.valueUpdatedInternal(((InternalReducingState)this.delegatedState).getInternal(), this.getCurrentNamespace());
    }

    public void clear() {
        ((InternalReducingState)this.delegatedState).clear();
        try {
            this.changeLogger.valueCleared(this.getCurrentNamespace());
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    static <K, N, SV, S extends State, IS extends S> IS create(InternalKvState<K, N, SV> reducingState, KvStateChangeLogger<SV, N> changeLogger, InternalKeyContext<K> keyContext) {
        return (IS)new ChangelogReducingState<K, N, SV>((InternalReducingState)reducingState, changeLogger, keyContext);
    }

    @Override
    public StateChangeApplier getChangeApplier(ChangelogApplierFactory factory) {
        return factory.forReducing((InternalReducingState)this.delegatedState, this.keyContext);
    }
}

