/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.changelog.StateChangelogWriter;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshotReadersWriters;
import org.apache.flink.state.changelog.StateChangeLogger;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

abstract class AbstractStateChangeLogger<Key, Value, Ns>
implements StateChangeLogger<Value, Ns>,
Closeable {
    protected final StateChangelogWriter<?> stateChangelogWriter;
    protected final InternalKeyContext<Key> keyContext;
    protected RegisteredStateMetaInfoBase metaInfo;
    private final StateMetaInfoSnapshot.BackendStateType stateType;
    private final DataOutputSerializer out = new DataOutputSerializer(128);
    private boolean metaDataWritten = false;
    private final short stateShortId;

    public AbstractStateChangeLogger(StateChangelogWriter<?> stateChangelogWriter, InternalKeyContext<Key> keyContext, RegisteredStateMetaInfoBase metaInfo, short stateId) {
        this.stateChangelogWriter = (StateChangelogWriter)Preconditions.checkNotNull(stateChangelogWriter);
        this.keyContext = (InternalKeyContext)Preconditions.checkNotNull(keyContext);
        this.metaInfo = (RegisteredStateMetaInfoBase)Preconditions.checkNotNull((Object)metaInfo);
        if (metaInfo instanceof RegisteredKeyValueStateBackendMetaInfo) {
            this.stateType = StateMetaInfoSnapshot.BackendStateType.KEY_VALUE;
        } else if (metaInfo instanceof RegisteredPriorityQueueStateBackendMetaInfo) {
            this.stateType = StateMetaInfoSnapshot.BackendStateType.PRIORITY_QUEUE;
        } else {
            throw new IllegalArgumentException("Unsupported state type: " + metaInfo);
        }
        this.stateShortId = stateId;
    }

    @Override
    public void valueUpdated(Value newValue, Ns ns) throws IOException {
        if (newValue == null) {
            this.valueCleared(ns);
        } else {
            this.log(StateChangeOperation.SET, (ThrowingConsumer<DataOutputView, IOException>)((ThrowingConsumer)out -> this.serializeValue(newValue, (DataOutputView)out)), ns);
        }
    }

    @Override
    public void valueUpdatedInternal(Value newValue, Ns ns) throws IOException {
        if (newValue == null) {
            this.valueCleared(ns);
        } else {
            this.log(StateChangeOperation.SET_INTERNAL, (ThrowingConsumer<DataOutputView, IOException>)((ThrowingConsumer)out -> this.serializeValue(newValue, (DataOutputView)out)), ns);
        }
    }

    protected abstract void serializeValue(Value var1, DataOutputView var2) throws IOException;

    @Override
    public void valueAdded(Value addedValue, Ns ns) throws IOException {
        this.log(StateChangeOperation.ADD, (ThrowingConsumer<DataOutputView, IOException>)((ThrowingConsumer)out -> this.serializeValue(addedValue, (DataOutputView)out)), ns);
    }

    @Override
    public void valueCleared(Ns ns) throws IOException {
        this.log(StateChangeOperation.CLEAR, ns);
    }

    @Override
    public void valueElementAdded(ThrowingConsumer<DataOutputView, IOException> dataSerializer, Ns ns) throws IOException {
        this.log(StateChangeOperation.ADD_ELEMENT, dataSerializer, ns);
    }

    @Override
    public void valueElementAddedOrUpdated(ThrowingConsumer<DataOutputView, IOException> dataSerializer, Ns ns) throws IOException {
        this.log(StateChangeOperation.ADD_OR_UPDATE_ELEMENT, dataSerializer, ns);
    }

    @Override
    public void valueElementRemoved(ThrowingConsumer<DataOutputView, IOException> dataSerializer, Ns ns) throws IOException {
        this.log(StateChangeOperation.REMOVE_ELEMENT, dataSerializer, ns);
    }

    @Override
    public void resetWritingMetaFlag() {
        this.metaDataWritten = false;
    }

    protected AbstractStateChangeLogger<Key, Value, Ns> setMetaInfo(RegisteredStateMetaInfoBase metaInfo) {
        this.metaInfo = metaInfo;
        return this;
    }

    protected void log(StateChangeOperation op, Ns ns) throws IOException {
        this.logMetaIfNeeded();
        this.stateChangelogWriter.append(this.keyContext.getCurrentKeyGroupIndex(), this.serialize(op, ns, null));
    }

    protected void log(StateChangeOperation op, @Nullable ThrowingConsumer<DataOutputView, IOException> dataWriter, Ns ns) throws IOException {
        this.logMetaIfNeeded();
        this.stateChangelogWriter.append(this.keyContext.getCurrentKeyGroupIndex(), this.serialize(op, ns, dataWriter));
    }

    private void logMetaIfNeeded() throws IOException {
        if (!this.metaDataWritten) {
            this.stateChangelogWriter.appendMeta(this.serializeRaw((ThrowingConsumer<DataOutputView, IOException>)((ThrowingConsumer)out -> {
                out.writeByte((int)StateChangeOperation.METADATA.getCode());
                out.writeInt(7);
                StateMetaInfoSnapshotReadersWriters.getWriter().writeStateMetaInfoSnapshot(this.metaInfo.snapshot(), out);
                this.writeDefaultValueAndTtl((DataOutputView)out);
                out.writeShort((int)this.stateShortId);
                out.writeByte((int)this.stateType.getCode());
            })));
            this.metaDataWritten = true;
        }
    }

    protected void writeDefaultValueAndTtl(DataOutputView out) throws IOException {
    }

    private byte[] serialize(StateChangeOperation op, Ns ns, @Nullable ThrowingConsumer<DataOutputView, IOException> dataWriter) throws IOException {
        return this.serializeRaw((ThrowingConsumer<DataOutputView, IOException>)((ThrowingConsumer)wrapper -> {
            wrapper.writeByte((int)op.getCode());
            wrapper.writeShort((int)this.stateShortId);
            this.serializeScope(ns, (DataOutputView)wrapper);
            if (dataWriter != null) {
                dataWriter.accept(wrapper);
            }
        }));
    }

    protected abstract void serializeScope(Ns var1, DataOutputView var2) throws IOException;

    private byte[] serializeRaw(ThrowingConsumer<DataOutputView, IOException> dataWriter) throws IOException {
        dataWriter.accept((Object)this.out);
        byte[] bytes = this.out.getCopyOfBuffer();
        this.out.clear();
        return bytes;
    }

    @Override
    public void close() throws IOException {
    }
}

