/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlShowColumns
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW COLUMNS", SqlKind.OTHER);
    protected final SqlIdentifier tableName;
    protected final String preposition;
    protected final boolean notLike;
    protected final SqlCharStringLiteral likeLiteral;

    public SqlShowColumns(SqlParserPos pos, String preposition, SqlIdentifier tableName, boolean notLike, SqlCharStringLiteral likeLiteral) {
        super(pos);
        this.preposition = Objects.requireNonNull(preposition, "Preposition of 'SHOW COLUMNS' must be 'FROM' or 'IN'.");
        this.tableName = Objects.requireNonNull(tableName, "tableName should not be null.");
        this.notLike = notLike;
        this.likeLiteral = likeLiteral;
    }

    public String getLikeSqlPattern() {
        return Objects.isNull(this.likeLiteral) ? null : (String)this.likeLiteral.getValueAs(String.class);
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public SqlCharStringLiteral getLikeLiteral() {
        return this.likeLiteral;
    }

    public boolean isWithLike() {
        return Objects.nonNull(this.likeLiteral);
    }

    public String getPreposition() {
        return this.preposition;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.tableName);
    }

    public String[] fullTableName() {
        return (String[])this.tableName.names.toArray((Object[])new String[0]);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SHOW COLUMNS " + this.preposition);
        this.tableName.unparse(writer, leftPrec, rightPrec);
        if (this.isWithLike()) {
            if (this.isNotLike()) {
                writer.keyword(String.format("NOT LIKE '%s'", this.likeLiteral.getValueAs(String.class)));
            } else {
                writer.keyword(String.format("LIKE '%s'", this.likeLiteral.getValueAs(String.class)));
            }
        }
    }
}

