/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dml;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.NlsString;
import org.apache.flink.annotation.Internal;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.sql.parser.dml.SqlStatementSet;

@Internal
public class SqlCompileAndExecutePlan
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COMPILE AND EXECUTE PLAN", SqlKind.OTHER);
    private final SqlNode planFile;
    private SqlNode operand;

    public SqlCompileAndExecutePlan(SqlParserPos pos, SqlNode planFile, SqlNode operand) {
        super(pos);
        this.planFile = planFile;
        this.operand = this.checkOperand(operand);
    }

    public String getPlanFile() {
        return ((NlsString)SqlLiteral.value((SqlNode)this.planFile)).getValue();
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.operand);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("COMPILE");
        writer.keyword("AND");
        writer.keyword("EXECUTE");
        writer.keyword("PLAN");
        this.planFile.unparse(writer, leftPrec, rightPrec);
        writer.keyword("FOR");
        this.operand.unparse(writer, leftPrec, rightPrec);
    }

    public void setOperand(int i, SqlNode operand) {
        if (i != 0) {
            throw new UnsupportedOperationException("SqlCompileAndExecutePlan supports only one operand with index 0");
        }
        this.operand = this.checkOperand(operand);
    }

    private SqlNode checkOperand(SqlNode operand) {
        if (!(operand instanceof RichSqlInsert) && !(operand instanceof SqlStatementSet)) {
            throw new UnsupportedOperationException("SqlCompileAndExecutePlan supports only RichSqlInsert or SqlStatementSet as operand");
        }
        return operand;
    }
}

