/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlAlterTableRenameColumn
extends SqlAlterTable {
    private final SqlIdentifier originColumnIdentifier;
    private final SqlIdentifier newColumnIdentifier;

    public SqlAlterTableRenameColumn(SqlParserPos pos, SqlIdentifier tableName, SqlIdentifier originColumnIdentifier, SqlIdentifier newColumnIdentifier, boolean ifTableExists) {
        super(pos, tableName, null, ifTableExists);
        this.originColumnIdentifier = originColumnIdentifier;
        this.newColumnIdentifier = newColumnIdentifier;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tableIdentifier, (Object)this.originColumnIdentifier, (Object)this.newColumnIdentifier);
    }

    public SqlIdentifier getOldColumnIdentifier() {
        return this.originColumnIdentifier;
    }

    public SqlIdentifier getNewColumnIdentifier() {
        return this.newColumnIdentifier;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("RENAME");
        this.originColumnIdentifier.unparse(writer, leftPrec, rightPrec);
        writer.keyword("TO");
        this.newColumnIdentifier.unparse(writer, leftPrec, rightPrec);
    }
}

