/* Generated By:JavaCC: Do not edit this line. FlinkSqlParserImpl.java */
package org.apache.flink.sql.parser.impl;

import org.apache.flink.sql.parser.ddl.constraint.SqlConstraintEnforcement;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.ddl.constraint.SqlUniqueSpec;
import org.apache.flink.sql.parser.ddl.position.SqlColumnPosSpec;
import org.apache.flink.sql.parser.ddl.position.SqlTableColumnPosition;
import org.apache.flink.sql.parser.ddl.resource.SqlResource;
import org.apache.flink.sql.parser.ddl.resource.SqlResourceType;
import org.apache.flink.sql.parser.ddl.SqlAddJar;
import org.apache.flink.sql.parser.ddl.SqlAddPartitions;
import org.apache.flink.sql.parser.ddl.SqlAddPartitions.AlterTableAddPartitionContext;
import org.apache.flink.sql.parser.ddl.SqlAlterDatabase;
import org.apache.flink.sql.parser.ddl.SqlAlterFunction;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlAlterTable.AlterTableContext;
import org.apache.flink.sql.parser.ddl.SqlAlterTableAdd;
import org.apache.flink.sql.parser.ddl.SqlAlterTableAddConstraint;
import org.apache.flink.sql.parser.ddl.SqlAlterTableCompact;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropColumn;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropConstraint;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropPrimaryKey;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropWatermark;
import org.apache.flink.sql.parser.ddl.SqlAlterTableModify;
import org.apache.flink.sql.parser.ddl.SqlAlterTableOptions;
import org.apache.flink.sql.parser.ddl.SqlAlterTableRename;
import org.apache.flink.sql.parser.ddl.SqlAlterTableRenameColumn;
import org.apache.flink.sql.parser.ddl.SqlAlterTableReset;
import org.apache.flink.sql.parser.ddl.SqlAlterView;
import org.apache.flink.sql.parser.ddl.SqlAlterViewAs;
import org.apache.flink.sql.parser.ddl.SqlAlterViewRename;
import org.apache.flink.sql.parser.ddl.SqlCompilePlan;
import org.apache.flink.sql.parser.ddl.SqlCreateCatalog;
import org.apache.flink.sql.parser.ddl.SqlCreateDatabase;
import org.apache.flink.sql.parser.ddl.SqlCreateFunction;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlCreateTable.TableCreationContext;
import org.apache.flink.sql.parser.ddl.SqlCreateTableAs;
import org.apache.flink.sql.parser.ddl.SqlCreateTableLike;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.sql.parser.ddl.SqlDropCatalog;
import org.apache.flink.sql.parser.ddl.SqlDropDatabase;
import org.apache.flink.sql.parser.ddl.SqlDropFunction;
import org.apache.flink.sql.parser.ddl.SqlDropPartitions;
import org.apache.flink.sql.parser.ddl.SqlDropPartitions.AlterTableDropPartitionsContext;
import org.apache.flink.sql.parser.ddl.SqlDropTable;
import org.apache.flink.sql.parser.ddl.SqlDropView;
import org.apache.flink.sql.parser.ddl.SqlRemoveJar;
import org.apache.flink.sql.parser.ddl.SqlReplaceTableAs;
import org.apache.flink.sql.parser.ddl.SqlReset;
import org.apache.flink.sql.parser.ddl.SqlSet;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlTableLike.FeatureOption;
import org.apache.flink.sql.parser.ddl.SqlTableLike.MergingStrategy;
import org.apache.flink.sql.parser.ddl.SqlTableLike.SqlTableLikeOption;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.SqlUseCatalog;
import org.apache.flink.sql.parser.ddl.SqlUseDatabase;
import org.apache.flink.sql.parser.ddl.SqlUseModules;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.SqlAnalyzeTable;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.sql.parser.dml.RichSqlInsertKeyword;
import org.apache.flink.sql.parser.dml.SqlBeginStatementSet;
import org.apache.flink.sql.parser.dml.SqlTruncateTable;
import org.apache.flink.sql.parser.dml.SqlCompileAndExecutePlan;
import org.apache.flink.sql.parser.dml.SqlEndStatementSet;
import org.apache.flink.sql.parser.dml.SqlExecute;
import org.apache.flink.sql.parser.dml.SqlExecutePlan;
import org.apache.flink.sql.parser.dml.SqlStatementSet;
import org.apache.flink.sql.parser.dql.SqlDescribeCatalog;
import org.apache.flink.sql.parser.dql.SqlDescribeDatabase;
import org.apache.flink.sql.parser.dql.SqlRichExplain;
import org.apache.flink.sql.parser.dql.SqlLoadModule;
import org.apache.flink.sql.parser.dql.SqlShowCatalogs;
import org.apache.flink.sql.parser.dql.SqlShowCurrentCatalog;
import org.apache.flink.sql.parser.dql.SqlShowDatabases;
import org.apache.flink.sql.parser.dql.SqlShowCurrentDatabase;
import org.apache.flink.sql.parser.dql.SqlShowFunctions;
import org.apache.flink.sql.parser.dql.SqlShowJars;
import org.apache.flink.sql.parser.dql.SqlShowModules;
import org.apache.flink.sql.parser.dql.SqlShowPartitions;
import org.apache.flink.sql.parser.dql.SqlShowProcedures;
import org.apache.flink.sql.parser.dql.SqlShowTables;
import org.apache.flink.sql.parser.dql.SqlShowColumns;
import org.apache.flink.sql.parser.dql.SqlShowCreate;
import org.apache.flink.sql.parser.dql.SqlShowCreateTable;
import org.apache.flink.sql.parser.dql.SqlShowCreateView;
import org.apache.flink.sql.parser.dql.SqlShowViews;
import org.apache.flink.sql.parser.dql.SqlRichDescribeTable;
import org.apache.flink.sql.parser.dql.SqlUnloadModule;
import org.apache.flink.sql.parser.expr.SqlUnresolvedTryCastFunction;
import org.apache.flink.sql.parser.ddl.SqlStopJob;
import org.apache.flink.sql.parser.dql.SqlShowJobs;
import org.apache.flink.sql.parser.type.ExtendedSqlCollectionTypeNameSpec;
import org.apache.flink.sql.parser.type.ExtendedSqlRowTypeNameSpec;
import org.apache.flink.sql.parser.type.SqlMapTypeNameSpec;
import org.apache.flink.sql.parser.type.SqlRawTypeNameSpec;
import org.apache.flink.sql.parser.type.SqlTimestampLtzTypeNameSpec;
import org.apache.flink.sql.parser.utils.ParserResource;
import org.apache.flink.sql.parser.validate.FlinkSqlConformance;
import org.apache.flink.sql.parser.SqlProperty;
import org.apache.flink.sql.parser.SqlPartitionSpecProperty;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlDrop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAlter;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDescribeSchema;
import org.apache.calcite.sql.SqlDescribeTable;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlHint;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJdbcDataTypeName;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonEncoding;
import org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlJsonValueReturning;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPivot;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlTableRef;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.SqlUnpivot;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.Span;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.Glossary;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.SourceStringReader;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import static org.apache.calcite.util.Static.RESOURCE;

/**
 * SQL parser, generated from Parser.jj by JavaCC.
 *
 * <p>The public wrapper for this parser is {@link SqlParser}.
 */
public class FlinkSqlParserImpl extends SqlAbstractParserImpl implements FlinkSqlParserImplConstants {
    private static final Logger LOGGER = CalciteTrace.getParserTracer();

    // Can't use quoted literal because of a bug in how JavaCC translates
    // backslash-backslash.
    private static final char BACKSLASH = 0x5c;
    private static final char DOUBLE_QUOTE = 0x22;
    private static final String DQ = DOUBLE_QUOTE + "";
    private static final String DQDQ = DQ + DQ;
    private static final SqlLiteral LITERAL_ZERO =
        SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_ONE =
        SqlLiteral.createExactNumeric("1", SqlParserPos.ZERO);
    private static final SqlLiteral LITERAL_MINUS_ONE =
        SqlLiteral.createExactNumeric("-1", SqlParserPos.ZERO);

    private static Metadata metadata;

    private Casing unquotedCasing;
    private Casing quotedCasing;
    private int identifierMaxLength;
    private ImmutableMap<String, TimeUnit> timeUnitCodes;
    private SqlConformance conformance;

    /**
     * {@link SqlParserImplFactory} implementation for creating parser.
     */
    public static final SqlParserImplFactory FACTORY = new SqlParserImplFactory() {
        public SqlAbstractParserImpl getParser(Reader reader) {
            final FlinkSqlParserImpl parser = new FlinkSqlParserImpl(reader);
            if (reader instanceof SourceStringReader) {
                final String sql =
                    ((SourceStringReader) reader).getSourceString();
                parser.setOriginalSql(sql);
            }
          return parser;
        }
    };

    public SqlParseException normalizeException(Throwable ex) {
        try {
            if (ex instanceof ParseException) {
                ex = cleanupParseException((ParseException) ex);
            }
            return convertException(ex);
        } catch (ParseException e) {
            throw new AssertionError(e);
        }
    }

    public Metadata getMetadata() {
        synchronized (FlinkSqlParserImpl.class) {
            if (metadata == null) {
                metadata = new MetadataImpl(
                    new FlinkSqlParserImpl(new java.io.StringReader("")));
            }
            return metadata;
        }
    }

    public void setTabSize(int tabSize) {
        jj_input_stream.setTabSize(tabSize);
    }

    public void switchTo(SqlAbstractParserImpl.LexicalState state) {
        final int stateOrdinal =
            Arrays.asList(FlinkSqlParserImplTokenManager.lexStateNames)
                .indexOf(state.name());
        token_source.SwitchTo(stateOrdinal);
    }

    public void setQuotedCasing(Casing quotedCasing) {
        this.quotedCasing = quotedCasing;
    }

    public void setUnquotedCasing(Casing unquotedCasing) {
        this.unquotedCasing = unquotedCasing;
    }

    public void setIdentifierMaxLength(int identifierMaxLength) {
        this.identifierMaxLength = identifierMaxLength;
    }

    public void setTimeUnitCodes(Map<String, TimeUnit> timeUnitCodes) {
        this.timeUnitCodes = ImmutableMap.copyOf(timeUnitCodes);
    }

    public void setConformance(SqlConformance conformance) {
        this.conformance = conformance;
    }

    public SqlNode parseSqlExpressionEof() throws Exception {
        return SqlExpressionEof();
    }

    public SqlNode parseSqlStmtEof() throws Exception {
        return SqlStmtEof();
    }

    public SqlNodeList parseSqlStmtList() throws Exception {
        return SqlStmtList();
    }

    private SqlNode extend(SqlNode table, SqlNodeList extendList) {
        return SqlStdOperatorTable.EXTEND.createCall(
            Span.of(table, extendList).pos(), table, extendList);
    }

    /** Adds a warning that a token such as "HOURS" was used,
    * whereas the SQL standard only allows "HOUR".
    *
    * <p>Currently, we silently add an exception to a list of warnings. In
    * future, we may have better compliance checking, for example a strict
    * compliance mode that throws if any non-standard features are used. */
    private TimeUnit warn(TimeUnit timeUnit) throws ParseException {
        final String token = getToken(0).image.toUpperCase(Locale.ROOT);
        warnings.add(
            SqlUtil.newContextException(getPos(),
                RESOURCE.nonStandardFeatureUsed(token)));
        return timeUnit;
    }

  void debug_message1() throws ParseException {
    LOGGER.info("{} , {}", getToken(0).image, getToken(1).image);
  }

  String unquotedIdentifier() throws ParseException {
    return SqlParserUtil.toCase(getToken(0).image, unquotedCasing);
  }

/**
 * Allows parser to be extended with new types of table references.  The
 * default implementation of this production is empty.
 */
  final public SqlNode ExtendedTableRef() throws ParseException {
    UnusedExtension();
        {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * Allows an OVER clause following a table expression as an extension to
 * standard SQL syntax. The default implementation of this production is empty.
 */
  final public SqlNode TableOverOpt() throws ParseException {
        {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/*
 * Parses dialect-specific keywords immediately following the SELECT keyword.
 */
  final public void SqlSelectKeywords(List<SqlLiteral> keywords) throws ParseException {
    E();
  }

/*
 * Parses dialect-specific keywords immediately following the INSERT keyword.
 */
  final public void SqlInsertKeywords(List<SqlLiteral> keywords) throws ParseException {
    E();
  }

/*
* Parse Floor/Ceil function parameters
*/
  final public SqlNode FloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
    SqlNode node;
    node = StandardFloorCeilOptions(s, floorFlag);
        {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  void E() throws ParseException {
  }

  List startList(Object o) throws ParseException {
    List list = new ArrayList();
    list.add(o);
    return list;
  }

  protected SqlParserPos getPos() throws ParseException {
    return new SqlParserPos(
        token.beginLine,
        token.beginColumn,
        token.endLine,
        token.endColumn);
  }

  Span span() throws ParseException {
    return Span.of(getPos());
  }

  void checkQueryExpression(ExprContext exprContext) throws ParseException {
    switch (exprContext) {
    case ACCEPT_NON_QUERY:
    case ACCEPT_SUB_QUERY:
    case ACCEPT_CURSOR:
        throw SqlUtil.newContextException(getPos(),
            RESOURCE.illegalQueryExpression());
    }
  }

  void checkNonQueryExpression(ExprContext exprContext) throws ParseException {
    switch (exprContext) {
    case ACCEPT_QUERY:
        throw SqlUtil.newContextException(getPos(),
            RESOURCE.illegalNonQueryExpression());
    }
  }

  SqlNode checkNotJoin(SqlNode e) throws ParseException {
    if (e instanceof SqlJoin) {
        throw SqlUtil.newContextException(e.getParserPosition(),
            RESOURCE.illegalJoinExpression());
    }
    return e;
  }

  SqlParseException convertException(Throwable ex) throws ParseException {
    if (ex instanceof SqlParseException) {
        return (SqlParseException) ex;
    }
    SqlParserPos pos = null;
    int[][] expectedTokenSequences = null;
    String[] tokenImage = null;
    if (ex instanceof ParseException) {
        ParseException pex = (ParseException) ex;
        expectedTokenSequences = pex.expectedTokenSequences;
        tokenImage = pex.tokenImage;
        if (pex.currentToken != null) {
            final Token token = pex.currentToken.next;
            // Checks token.image.equals("1") to avoid recursive call.
            // The SqlAbstractParserImpl#MetadataImpl constructor uses constant "1" to
            // throw intentionally to collect the expected tokens.
            if (!token.image.equals("1")
                && getMetadata().isKeyword(token.image)
                && SqlParserUtil.allowsIdentifier(tokenImage, expectedTokenSequences)) {
                // If the next token is a keyword, reformat the error message as:

                // Incorrect syntax near the keyword '{keyword}' at line {line_number},
                // column {column_number}.
                final String expecting = ex.getMessage()
                    .substring(ex.getMessage().indexOf("Was expecting"));
                final String errorMsg = String.format("Incorrect syntax near the keyword '%s' "
                        + "at line %d, column %d.\n%s",
                    token.image,
                    token.beginLine,
                    token.beginColumn,
                    expecting);
                // Replace the ParseException with explicit error message.
                ex = new ParseException(errorMsg);
            }
            pos = new SqlParserPos(
                token.beginLine,
                token.beginColumn,
                token.endLine,
                token.endColumn);
        }
    } else if (ex instanceof TokenMgrError) {
        expectedTokenSequences = null;
        tokenImage = null;
        // Example:
        //    Lexical error at line 3, column 24.  Encountered "#" after "a".
        final java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(
            "(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
        java.util.regex.Matcher matcher = pattern.matcher(ex.getMessage());
        if (matcher.matches()) {
            int line = Integer.parseInt(matcher.group(1));
            int column = Integer.parseInt(matcher.group(2));
            pos = new SqlParserPos(line, column, line, column);
        }
    } else if (ex instanceof CalciteContextException) {
        // CalciteContextException is the standard wrapper for exceptions
        // produced by the validator, but in the parser, the standard is
        // SqlParseException; so, strip it away. In case you were wondering,
        // the CalciteContextException appears because the parser
        // occasionally calls into validator-style code such as
        // SqlSpecialOperator.reduceExpr.
        CalciteContextException ece =
            (CalciteContextException) ex;
        pos = new SqlParserPos(
            ece.getPosLine(),
            ece.getPosColumn(),
            ece.getEndPosLine(),
            ece.getEndPosColumn());
        ex = ece.getCause();
    }

    return new SqlParseException(
        ex.getMessage(), pos, expectedTokenSequences, tokenImage, ex);
  }

  ParseException cleanupParseException(ParseException ex) throws ParseException {
    if (ex.expectedTokenSequences == null) {
        return ex;
    }
    int iIdentifier = Arrays.asList(ex.tokenImage).indexOf("<IDENTIFIER>");

    // Find all sequences in the error which contain identifier. For
    // example,
    //       {<IDENTIFIER>}
    //       {A}
    //       {B, C}
    //       {D, <IDENTIFIER>}
    //       {D, A}
    //       {D, B}
    //
    // would yield
    //       {}
    //       {D}
    final List<int[]> prefixList = new ArrayList<int[]>();
    for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
        int[] seq = ex.expectedTokenSequences[i];
        int j = seq.length - 1;
        int i1 = seq[j];
        if (i1 == iIdentifier) {
            int[] prefix = new int[j];
            System.arraycopy(seq, 0, prefix, 0, j);
            prefixList.add(prefix);
        }
    }

    if (prefixList.isEmpty()) {
        return ex;
    }

    int[][] prefixes = (int[][])
        prefixList.toArray(new int[prefixList.size()][]);

    // Since <IDENTIFIER> was one of the possible productions,
    // we know that the parser will also have included all
    // of the non-reserved keywords (which are treated as
    // identifiers in non-keyword contexts).  So, now we need
    // to clean those out, since they're totally irrelevant.

    final List<int[]> list = new ArrayList<int[]>();
    Metadata metadata = getMetadata();
    for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
        int [] seq = ex.expectedTokenSequences[i];
        String tokenImage = ex.tokenImage[seq[seq.length - 1]];
        String token = SqlParserUtil.getTokenVal(tokenImage);
        if (token == null  || !metadata.isNonReservedKeyword(token)) {
            list.add(seq);
            continue;
        }
        boolean match = matchesPrefix(seq, prefixes);
        if (!match) {
            list.add(seq);
        }
    }

    ex.expectedTokenSequences =
        (int [][]) list.toArray(new int [list.size()][]);
    return ex;
  }

  boolean matchesPrefix(int[] seq, int[][] prefixes) throws ParseException {
    nextPrefix:
    for (int[] prefix : prefixes) {
        if (seq.length == prefix.length + 1) {
            for (int k = 0; k < prefix.length; k++) {
                if (prefix[k] != seq[k]) {
                    continue nextPrefix;
                }
            }
            return true;
        }
    }
    return false;
  }

/*****************************************
 * Syntactical Descriptions              *
 *****************************************/
  final public SqlNode ExprOrJoinOrOrderedQuery(ExprContext exprContext) throws ParseException {
    SqlNode e;
    final List<Object> list = new ArrayList<Object>();
    if (jj_2_1(2)) {
      e = Query(exprContext);
      e = OrderByLimitOpt(e);
          {if (true) return e;}
    } else if (jj_2_2(1)) {
      e = TableRef1(ExprContext.ACCEPT_QUERY_OR_JOIN);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CROSS:
        case FULL:
        case INNER:
        case JOIN:
        case LEFT:
        case NATURAL:
        case OUTER:
        case RIGHT:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        e = JoinTable(e);
      }
          list.add(e);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXCEPT:
        case INTERSECT:
        case SET_MINUS:
        case UNION:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
        AddSetOpQuery(list, exprContext);
      }
          {if (true) return SqlParserUtil.toTree(list);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses either a row expression or a query expression with an optional
 * ORDER BY.
 *
 * <p>Postgres syntax for limit:
 *
 * <blockquote><pre>
 *    [ LIMIT { count | ALL } ]
 *    [ OFFSET start ]</pre>
 * </blockquote>
 *
 * <p>Trino syntax for limit:
 *
 * <blockquote><pre>
 *    [ OFFSET start ]
 *    [ LIMIT { count | ALL } ]</pre>
 * </blockquote>
 *
 * <p>MySQL syntax for limit:
 *
 * <blockquote><pre>
 *    [ LIMIT { count | start, count } ]</pre>
 * </blockquote>
 *
 * <p>SQL:2008 syntax for limit:
 *
 * <blockquote><pre>
 *    [ OFFSET start { ROW | ROWS } ]
 *    [ FETCH { FIRST | NEXT } [ count ] { ROW | ROWS } ONLY ]</pre>
 * </blockquote>
 */
  final public SqlNode OrderedQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    e = QueryOrExpr(exprContext);
    e = OrderByLimitOpt(e);
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Reads optional "ORDER BY", "LIMIT", "OFFSET", "FETCH" following a query,
 * {@code e}. If any of them are present, adds them to the query;
 * otherwise returns the query unchanged.
 * Throws if they are present and {@code e} is not a query. */
  final public SqlNode OrderByLimitOpt(SqlNode e) throws ParseException {
    final SqlNodeList orderBy;
    final Span s = Span.of();
    SqlNode[] offsetFetch = {null, null};
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      // use the syntactic type of the expression we just parsed
              // to decide whether ORDER BY makes sense
              orderBy = OrderBy(e.isA(SqlKind.QUERY));
      break;
    default:
      jj_la1[2] = jj_gen;
          orderBy = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FETCH:
    case LIMIT:
    case OFFSET:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIMIT:
        LimitClause(s, offsetFetch);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OFFSET:
          OffsetClause(s, offsetFetch);
          break;
        default:
          jj_la1[3] = jj_gen;
          ;
        }
        break;
      case OFFSET:
        OffsetClause(s, offsetFetch);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FETCH:
        case LIMIT:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LIMIT:
            LimitClause(s, offsetFetch);
                if (!this.conformance.isOffsetLimitAllowed()) {
                    {if (true) throw SqlUtil.newContextException(s.end(this),
                        RESOURCE.offsetLimitNotAllowed());}
                }
            break;
          case FETCH:
            FetchClause(offsetFetch);
            break;
          default:
            jj_la1[4] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[5] = jj_gen;
          ;
        }
        break;
      case FETCH:
        FetchClause(offsetFetch);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
        if (orderBy != null || offsetFetch[0] != null || offsetFetch[1] != null) {
            {if (true) return new SqlOrderBy(getPos(), e,
                Util.first(orderBy, SqlNodeList.EMPTY),
                offsetFetch[0], offsetFetch[1]);}
        }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an OFFSET clause in an ORDER BY expression.
 */
  final public void OffsetClause(Span s, SqlNode[] offsetFetch) throws ParseException {
    jj_consume_token(OFFSET);
               s.add(this);
    offsetFetch[0] = UnsignedNumericLiteralOrParam();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
    case ROWS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
        break;
      case ROWS:
        jj_consume_token(ROWS);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
  }

/**
 * Parses a FETCH clause in an ORDER BY expression.
 */
  final public void FetchClause(SqlNode[] offsetFetch) throws ParseException {
    jj_consume_token(FETCH);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
      break;
    case NEXT:
      jj_consume_token(NEXT);
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    offsetFetch[1] = UnsignedNumericLiteralOrParam();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ROW:
      jj_consume_token(ROW);
      break;
    case ROWS:
      jj_consume_token(ROWS);
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ONLY);
  }

/**
 * Parses a LIMIT clause in an ORDER BY expression.
 */
  final public void LimitClause(Span s, SqlNode[] offsetFetch) throws ParseException {
    jj_consume_token(LIMIT);
              s.add(this);
    if (jj_2_3(2)) {
      offsetFetch[0] = UnsignedNumericLiteralOrParam();
      jj_consume_token(COMMA);
      offsetFetch[1] = UnsignedNumericLiteralOrParam();
            if (!this.conformance.isLimitStartCountAllowed()) {
                {if (true) throw SqlUtil.newContextException(s.end(this),
                    RESOURCE.limitStartCountNotAllowed());}
            }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case HOOK:
        offsetFetch[1] = UnsignedNumericLiteralOrParam();
        break;
      case ALL:
        jj_consume_token(ALL);
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * Parses a leaf in a query expression (SELECT, VALUES or TABLE).
 */
  final public SqlNode LeafQuery(ExprContext exprContext) throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
        // ensure a query is legal in this context
        checkQueryExpression(exprContext);
      e = SqlSelect();
                      {if (true) return e;}
      break;
    case VALUES:
      e = TableConstructor();
                             {if (true) return e;}
      break;
    case TABLE:
      e = ExplicitTable(getPos());
                                  {if (true) return e;}
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a parenthesized query or single row expression.
 * Depending on {@code exprContext}, may also accept a join.
 */
  final public SqlNode ParenthesizedExpression(ExprContext exprContext) throws ParseException {
    SqlNode e;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so queries inside should
        // be allowed as sub-queries
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            exprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            exprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    e = ExprOrJoinOrOrderedQuery(exprContext);
    jj_consume_token(RPAREN);
        exprContext.throwIfNotCompatible(e);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a parenthesized query or comma-list of row expressions.
 *
 * <p>REVIEW jvs 8-Feb-2004: There's a small hole in this production.  It can be
 * used to construct something like
 *
 * <blockquote><pre>
 * WHERE x IN (select count(*) from t where c=d,5)</pre>
 * </blockquote>
 *
 * <p>which should be illegal.  The above is interpreted as equivalent to
 *
 * <blockquote><pre>
 * WHERE x IN ((select count(*) from t where c=d),5)</pre>
 * </blockquote>
 *
 * <p>which is a legal use of a sub-query.  The only way to fix the hole is to
 * be able to remember whether a subexpression was parenthesized or not, which
 * means preserving parentheses in the SqlNode tree.  This is probably
 * desirable anyway for use in purely syntactic parsing applications (e.g. SQL
 * pretty-printer).  However, if this is done, it's important to also make
 * isA() on the paren node call down to its operand so that we can
 * always correctly discriminate a query from a row expression.
 */
  final public SqlNodeList ParenthesizedQueryOrCommaList(ExprContext exprContext) throws ParseException {
    SqlNode e;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    ExprContext firstExprContext = exprContext;
    final Span s;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so a query by itself should
        // be interpreted as a sub-query
        s = span();
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    e = OrderedQueryOrExpr(firstExprContext);
                                               list.add(e);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      AddExpression(list, exprContext);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** As ParenthesizedQueryOrCommaList, but allows DEFAULT
 * in place of any of the expressions. For example,
 * {@code (x, DEFAULT, null, DEFAULT)}. */
  final public SqlNodeList ParenthesizedQueryOrCommaListWithDefault(ExprContext exprContext) throws ParseException {
    SqlNode e;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    ExprContext firstExprContext = exprContext;
    final Span s;
    jj_consume_token(LPAREN);
        // we've now seen left paren, so a query by itself should
        // be interpreted as a sub-query
        s = span();
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = OrderedQueryOrExpr(firstExprContext);
                                                   list.add(e);
      break;
    case DEFAULT_:
      e = Default();
                        list.add(e);
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = Expression(exprContext);
                                          list.add(e);
        break;
      case DEFAULT_:
        e = Default();
                            list.add(e);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses function parameter lists.
 * If the list starts with DISTINCT or ALL, it is discarded.
 */
  final public List<SqlNode> UnquantifiedFunctionParameterList(ExprContext exprContext) throws ParseException {
    final List<SqlNode> args;
    args = FunctionParameterList(exprContext);
        args.remove(0); // remove DISTINCT or ALL, if present
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses function parameter lists including DISTINCT keyword recognition,
 * DEFAULT, and named argument assignment.
 */
  final public List<SqlNode> FunctionParameterList(ExprContext exprContext) throws ParseException {
    final SqlLiteral qualifier;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      qualifier = AllOrDistinct();
                                      list.add(qualifier);
      break;
    default:
      jj_la1[18] = jj_gen;
          list.add(null);
    }
    AddArg0(list, exprContext);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            checkNonQueryExpression(exprContext);
      AddArg(list, exprContext);
    }
    jj_consume_token(RPAREN);
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral AllOrDistinct() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                 {if (true) return SqlSelectKeyword.DISTINCT.symbol(getPos());}
      break;
    case ALL:
      jj_consume_token(ALL);
            {if (true) return SqlSelectKeyword.ALL.symbol(getPos());}
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void AddArg0(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    final SqlIdentifier name;
    SqlNode e;
    final ExprContext firstExprContext;
    {
        // we've now seen left paren, so queries inside should
        // be allowed as sub-queries
        switch (exprContext) {
        case ACCEPT_SUB_QUERY:
            firstExprContext = ExprContext.ACCEPT_NONCURSOR;
            break;
        case ACCEPT_CURSOR:
            firstExprContext = ExprContext.ACCEPT_ALL;
            break;
        default:
            firstExprContext = exprContext;
            break;
        }
    }
    if (jj_2_4(2)) {
      name = SimpleIdentifier();
      jj_consume_token(NAMED_ARGUMENT_ASSIGNMENT);
    } else {
          name = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_:
      e = Default();
      break;
    default:
      jj_la1[21] = jj_gen;
      if (jj_2_5(3)) {
        e = TableParam();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ARRAY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CASE:
        case CAST:
        case CATALOG:
        case CATALOG_NAME:
        case CEIL:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASSIFIER:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CONVERT:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT:
        case CURRENT_CATALOG:
        case CURRENT_DATE:
        case CURRENT_DEFAULT_TRANSFORM_GROUP:
        case CURRENT_PATH:
        case CURRENT_ROLE:
        case CURRENT_SCHEMA:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURRENT_USER:
        case CURSOR:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXISTS:
        case EXP:
        case EXTRACT:
        case FALSE:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INTERVAL:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case JSON_ARRAY:
        case JSON_ARRAYAGG:
        case JSON_EXISTS:
        case JSON_OBJECT:
        case JSON_OBJECTAGG:
        case JSON_QUERY:
        case JSON_VALUE:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MATCH_NUMBER:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MULTISET:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NEW:
        case NEXT:
        case NORMALIZED:
        case NOT:
        case NTH_VALUE:
        case NTILE:
        case NULL:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERLAY:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENTILE_CONT:
        case PERCENTILE_DISC:
        case PERCENT_RANK:
        case PERIOD:
        case PLACING:
        case PLAN:
        case PLI:
        case POSITION:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PREV:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW:
        case ROW_COUNT:
        case ROW_NUMBER:
        case RUNNING:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELECT:
        case SELF:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SESSION_USER:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case SYSTEM_USER:
        case TABLE:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIME:
        case TIMESTAMP:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRANSLATE:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRIM:
        case TRUE:
        case TRUNCATE:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNIQUE:
        case UNKNOWN:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VALUES:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WITH:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case CHANGELOG_MODE:
        case COMPACT:
        case COMPILE:
        case COLUMNS:
        case DRAIN:
        case ENFORCED:
        case ESTIMATED_COST:
        case IF:
        case JSON_EXECUTION_PLAN:
        case PLAN_ADVICE:
        case JAR:
        case JARS:
        case JOB:
        case JOBS:
        case LOAD:
        case METADATA:
        case OVERWRITE:
        case OVERWRITING:
        case PARTITIONED:
        case PARTITIONS:
        case PYTHON:
        case REMOVE:
        case STOP:
        case UNLOAD:
        case VIRTUAL:
        case TRY_CAST:
        case ANALYZE:
        case COMPUTE:
        case STATISTICS:
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
        case BINARY_STRING_LITERAL:
        case QUOTED_STRING:
        case PREFIXED_STRING_LITERAL:
        case UNICODE_STRING_LITERAL:
        case BIG_QUERY_DOUBLE_QUOTED_STRING:
        case BIG_QUERY_QUOTED_STRING:
        case LPAREN:
        case LBRACE_D:
        case LBRACE_T:
        case LBRACE_TS:
        case LBRACE_FN:
        case HOOK:
        case PLUS:
        case MINUS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          e = PartitionedQueryOrQueryOrExpr(firstExprContext);
          break;
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(
                Span.of(name, e).pos(), e, name);
        }
        list.add(e);
  }

  final public void AddArg(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    final SqlIdentifier name;
    SqlNode e;
    if (jj_2_6(2)) {
      name = SimpleIdentifier();
      jj_consume_token(NAMED_ARGUMENT_ASSIGNMENT);
    } else {
          name = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFAULT_:
      e = Default();
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(exprContext);
      break;
    case TABLE:
      e = TableParam();
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (name != null) {
            e = SqlStdOperatorTable.ARGUMENT_ASSIGNMENT.createCall(
                Span.of(name, e).pos(), e, name);
        }
        list.add(e);
  }

  final public SqlNode Default() throws ParseException {
    jj_consume_token(DEFAULT_);
        {if (true) return SqlStdOperatorTable.DEFAULT.createCall(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a query (SELECT, UNION, INTERSECT, EXCEPT, VALUES, TABLE) followed by
 * the end-of-file symbol.
 */
  final public SqlNode SqlQueryEof() throws ParseException {
    SqlNode query;
    query = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
    jj_consume_token(0);
      {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of SQL statements separated by semicolon.
 * The semicolon is required between statements, but is
 * optional at the end.
 */
  final public SqlNodeList SqlStmtList() throws ParseException {
    final List<SqlNode> stmtList = new ArrayList<SqlNode>();
    SqlNode stmt;
    stmt = SqlStmt();
        stmtList.add(stmt);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_6;
      }
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BEGIN:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CALL:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CREATE:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DELETE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIBE:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DROP:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case END:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXECUTE:
      case EXISTS:
      case EXP:
      case EXPLAIN:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSERT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MERGE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESET:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SET:
      case SETS:
      case SHOW:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPDATE:
      case UPPER:
      case UPSERT:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case USE:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        stmt = SqlStmt();
                stmtList.add(stmt);
        break;
      default:
        jj_la1[25] = jj_gen;
        ;
      }
    }
    jj_consume_token(0);
        {if (true) return new SqlNodeList(stmtList, Span.of(stmtList).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an SQL statement.
 */
  final public SqlNode SqlStmt() throws ParseException {
    SqlNode stmt;
    if (jj_2_7(2)) {
      stmt = RichSqlInsert();
    } else if (jj_2_8(2)) {
      stmt = SqlBeginStatementSet();
    } else if (jj_2_9(2)) {
      stmt = SqlEndStatementSet();
    } else if (jj_2_10(2)) {
      stmt = SqlLoadModule();
    } else if (jj_2_11(2)) {
      stmt = SqlShowCatalogs();
    } else if (jj_2_12(2)) {
      stmt = SqlShowCurrentCatalogOrDatabase();
    } else if (jj_2_13(2)) {
      stmt = SqlDescribeCatalog();
    } else if (jj_2_14(2)) {
      stmt = SqlUseCatalog();
    } else if (jj_2_15(2)) {
      stmt = SqlShowDatabases();
    } else if (jj_2_16(2)) {
      stmt = SqlUseDatabase();
    } else if (jj_2_17(2)) {
      stmt = SqlAlterDatabase();
    } else if (jj_2_18(2)) {
      stmt = SqlDescribeDatabase();
    } else if (jj_2_19(2)) {
      stmt = SqlAlterFunction();
    } else if (jj_2_20(2)) {
      stmt = SqlShowFunctions();
    } else if (jj_2_21(2)) {
      stmt = SqlShowTables();
    } else if (jj_2_22(2)) {
      stmt = SqlShowColumns();
    } else if (jj_2_23(2)) {
      stmt = SqlShowCreate();
    } else if (jj_2_24(2)) {
      stmt = SqlReplaceTable();
    } else if (jj_2_25(2)) {
      stmt = SqlRichDescribeTable();
    } else if (jj_2_26(2)) {
      stmt = SqlAlterTable();
    } else if (jj_2_27(2)) {
      stmt = SqlAlterView();
    } else if (jj_2_28(2)) {
      stmt = SqlShowModules();
    } else if (jj_2_29(2)) {
      stmt = SqlShowPartitions();
    } else if (jj_2_30(2)) {
      stmt = SqlShowProcedures();
    } else if (jj_2_31(2)) {
      stmt = SqlShowViews();
    } else if (jj_2_32(2)) {
      stmt = SqlUnloadModule();
    } else if (jj_2_33(2)) {
      stmt = SqlUseModules();
    } else if (jj_2_34(2)) {
      stmt = SqlRichExplain();
    } else if (jj_2_35(2)) {
      stmt = SqlCompileAndExecutePlan();
    } else if (jj_2_36(2)) {
      stmt = SqlCompilePlan();
    } else if (jj_2_37(2)) {
      stmt = SqlExecutePlan();
    } else if (jj_2_38(2)) {
      stmt = SqlExecute();
    } else if (jj_2_39(2)) {
      stmt = SqlAddJar();
    } else if (jj_2_40(2)) {
      stmt = SqlRemoveJar();
    } else if (jj_2_41(2)) {
      stmt = SqlShowJars();
    } else if (jj_2_42(2)) {
      stmt = SqlSet();
    } else if (jj_2_43(2)) {
      stmt = SqlReset();
    } else if (jj_2_44(2)) {
      stmt = SqlAnalyzeTable();
    } else if (jj_2_45(2)) {
      stmt = SqlStopJob();
    } else if (jj_2_46(2)) {
      stmt = SqlShowJobs();
    } else if (jj_2_47(2)) {
      stmt = SqlTruncateTable();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESET:
      case SET:
        stmt = SqlSetOption(Span.of(), null);
        break;
      case ALTER:
        stmt = SqlAlter();
        break;
      case CREATE:
        stmt = SqlCreate();
        break;
      case DROP:
        stmt = SqlDrop();
        break;
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        break;
      case EXPLAIN:
        stmt = SqlExplain();
        break;
      case DESCRIBE:
        stmt = SqlDescribe();
        break;
      case INSERT:
      case UPSERT:
        stmt = SqlInsert();
        break;
      case DELETE:
        stmt = SqlDelete();
        break;
      case UPDATE:
        stmt = SqlUpdate();
        break;
      case MERGE:
        stmt = SqlMerge();
        break;
      case CALL:
        stmt = SqlProcedureCall();
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an SQL statement followed by the end-of-file symbol.
 */
  final public SqlNode SqlStmtEof() throws ParseException {
    SqlNode stmt;
    stmt = SqlStmt();
    jj_consume_token(0);
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a "IF EXISTS" option, default is false.
 */
  final public boolean IfExistsOpt() throws ParseException {
    if (jj_2_48(2)) {
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
                        {if (true) return true;}
    } else {
          {if (true) return false;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a "IF NOT EXISTS" option, default is false.
 */
  final public boolean IfNotExistsOpt() throws ParseException {
    if (jj_2_49(3)) {
      jj_consume_token(IF);
      jj_consume_token(NOT);
      jj_consume_token(EXISTS);
                              {if (true) return true;}
    } else {
          {if (true) return false;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "Show Catalogs" metadata query command.
*/
  final public SqlShowCatalogs SqlShowCatalogs() throws ParseException {
    jj_consume_token(SHOW);
    jj_consume_token(CATALOGS);
        {if (true) return new SqlShowCatalogs(getPos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall SqlShowCurrentCatalogOrDatabase() throws ParseException {
    jj_consume_token(SHOW);
    jj_consume_token(CURRENT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CATALOG:
      jj_consume_token(CATALOG);
            {if (true) return new SqlShowCurrentCatalog(getPos());}
      break;
    case DATABASE:
      jj_consume_token(DATABASE);
            {if (true) return new SqlShowCurrentDatabase(getPos());}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlDescribeCatalog SqlDescribeCatalog() throws ParseException {
    SqlIdentifier catalogName;
    SqlParserPos pos;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DESCRIBE:
      jj_consume_token(DESCRIBE);
      break;
    case DESC:
      jj_consume_token(DESC);
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(CATALOG);
                                        pos = getPos();
    catalogName = SimpleIdentifier();
        {if (true) return new SqlDescribeCatalog(pos, catalogName);}
    throw new Error("Missing return statement in function");
  }

  final public SqlUseCatalog SqlUseCatalog() throws ParseException {
    SqlIdentifier catalogName;
    SqlParserPos pos;
    jj_consume_token(USE);
    jj_consume_token(CATALOG);
                      pos = getPos();
    catalogName = SimpleIdentifier();
        {if (true) return new SqlUseCatalog(pos, catalogName);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a create catalog statement.
* CREATE CATALOG catalog_name [WITH (property_name=property_value, ...)];
*/
  final public SqlCreate SqlCreateCatalog(Span s, boolean replace) throws ParseException {
    SqlParserPos startPos;
    SqlIdentifier catalogName;
    SqlNodeList propertyList = SqlNodeList.EMPTY;
    jj_consume_token(CATALOG);
                startPos = getPos();
    catalogName = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      propertyList = TableProperties();
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
        {if (true) return new SqlCreateCatalog(startPos.plus(getPos()),
            catalogName,
            propertyList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlDrop SqlDropCatalog(Span s, boolean replace) throws ParseException {
    SqlIdentifier catalogName = null;
    boolean ifExists = false;
    jj_consume_token(CATALOG);
    ifExists = IfExistsOpt();
    catalogName = CompoundIdentifier();
        {if (true) return new SqlDropCatalog(s.pos(), catalogName, ifExists);}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "Show DATABASES" metadata query command.
*/
  final public SqlShowDatabases SqlShowDatabases() throws ParseException {
    jj_consume_token(SHOW);
    jj_consume_token(DATABASES);
        {if (true) return new SqlShowDatabases(getPos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlUseDatabase SqlUseDatabase() throws ParseException {
    SqlIdentifier databaseName;
    SqlParserPos pos;
    jj_consume_token(USE);
            pos = getPos();
    databaseName = CompoundIdentifier();
        {if (true) return new SqlUseDatabase(pos, databaseName);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a create database statement.
* <pre>CREATE DATABASE database_name
*       [COMMENT database_comment]
*       [WITH (property_name=property_value, ...)].</pre>
*/
  final public SqlCreate SqlCreateDatabase(Span s, boolean replace) throws ParseException {
    SqlParserPos startPos;
    SqlIdentifier databaseName;
    SqlCharStringLiteral comment = null;
    SqlNodeList propertyList = SqlNodeList.EMPTY;
    boolean ifNotExists = false;
    jj_consume_token(DATABASE);
                 startPos = getPos();
    ifNotExists = IfNotExistsOpt();
    databaseName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      jj_consume_token(COMMENT);
      jj_consume_token(QUOTED_STRING);
            String p = SqlParserUtil.parseString(token.image);
            comment = SqlLiteral.createCharString(p, getPos());
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      propertyList = TableProperties();
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
      {if (true) return new SqlCreateDatabase(startPos.plus(getPos()),
                    databaseName,
                    propertyList,
                    comment,
                    ifNotExists);}
    throw new Error("Missing return statement in function");
  }

  final public SqlAlterDatabase SqlAlterDatabase() throws ParseException {
    SqlParserPos startPos;
    SqlIdentifier databaseName;
    SqlNodeList propertyList = SqlNodeList.EMPTY;
    jj_consume_token(ALTER);
    jj_consume_token(DATABASE);
                         startPos = getPos();
    databaseName = CompoundIdentifier();
    jj_consume_token(SET);
    propertyList = TableProperties();
        {if (true) return new SqlAlterDatabase(startPos.plus(getPos()),
                    databaseName,
                    propertyList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlDrop SqlDropDatabase(Span s, boolean replace) throws ParseException {
    SqlIdentifier databaseName = null;
    boolean ifExists = false;
    boolean cascade = false;
    jj_consume_token(DATABASE);
    ifExists = IfExistsOpt();
    databaseName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASCADE:
    case RESTRICT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESTRICT:
        jj_consume_token(RESTRICT);
                     cascade = false;
        break;
      case CASCADE:
        jj_consume_token(CASCADE);
                     cascade = true;
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
         {if (true) return new SqlDropDatabase(s.pos(), databaseName, ifExists, cascade);}
    throw new Error("Missing return statement in function");
  }

  final public SqlDescribeDatabase SqlDescribeDatabase() throws ParseException {
    SqlIdentifier databaseName;
    SqlParserPos pos;
    boolean isExtended = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DESCRIBE:
      jj_consume_token(DESCRIBE);
      break;
    case DESC:
      jj_consume_token(DESC);
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(DATABASE);
                                         pos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDED:
      jj_consume_token(EXTENDED);
                   isExtended = true;
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    databaseName = CompoundIdentifier();
        {if (true) return new SqlDescribeDatabase(pos, databaseName, isExtended);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCreate SqlCreateFunction(Span s, boolean replace, boolean isTemporary) throws ParseException {
    SqlIdentifier functionIdentifier = null;
    SqlCharStringLiteral functionClassName = null;
    String functionLanguage = null;
    boolean ifNotExists = false;
    boolean isSystemFunction = false;
    SqlNodeList resourceInfos = SqlNodeList.EMPTY;
    SqlParserPos functionLanguagePos = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SYSTEM:
      jj_consume_token(SYSTEM);
            if (!isTemporary){
                {if (true) throw SqlUtil.newContextException(getPos(),
                    ParserResource.RESOURCE.createSystemFunctionOnlySupportTemporary());}
            }
      jj_consume_token(FUNCTION);
      ifNotExists = IfNotExistsOpt();
      functionIdentifier = SimpleIdentifier();
          isSystemFunction = true;
      break;
    case FUNCTION:
      jj_consume_token(FUNCTION);
      ifNotExists = IfNotExistsOpt();
      functionIdentifier = CompoundIdentifier();
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(AS);
    jj_consume_token(QUOTED_STRING);
        String p = SqlParserUtil.parseString(token.image);
        functionClassName = SqlLiteral.createCharString(p, getPos());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGUAGE:
      jj_consume_token(LANGUAGE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case JAVA:
        jj_consume_token(JAVA);
                functionLanguage = "JAVA";
                functionLanguagePos = getPos();
        break;
      case SCALA:
        jj_consume_token(SCALA);
                functionLanguage = "SCALA";
                functionLanguagePos = getPos();
        break;
      case SQL:
        jj_consume_token(SQL);
                functionLanguage = "SQL";
                functionLanguagePos = getPos();
        break;
      case PYTHON:
        jj_consume_token(PYTHON);
                functionLanguage = "PYTHON";
                functionLanguagePos = getPos();
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      jj_consume_token(USING);
            if ("SQL".equals(functionLanguage) || "PYTHON".equals(functionLanguage)) {
                {if (true) throw SqlUtil.newContextException(
                    functionLanguagePos,
                    ParserResource.RESOURCE.createFunctionUsingJar(functionLanguage));}
            }
            List<SqlNode> resourceList = new ArrayList<SqlNode>();
            SqlResource sqlResource = null;
      sqlResource = SqlResourceInfo();
            resourceList.add(sqlResource);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_7;
        }
        jj_consume_token(COMMA);
        sqlResource = SqlResourceInfo();
                resourceList.add(sqlResource);
      }
           resourceInfos = new SqlNodeList(resourceList, s.pos());
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
        {if (true) return new SqlCreateFunction(
                    s.pos(),
                    functionIdentifier,
                    functionClassName,
                    functionLanguage,
                    ifNotExists,
                    isTemporary,
                    isSystemFunction,
                    resourceInfos);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse resource type and path.
 */
  final public SqlResource SqlResourceInfo() throws ParseException {
    String resourcePath;
    jj_consume_token(JAR);
    jj_consume_token(QUOTED_STRING);
        resourcePath = SqlParserUtil.parseString(token.image);
        {if (true) return new SqlResource(
                    getPos(),
                    SqlResourceType.JAR.symbol(getPos()),
                    SqlLiteral.createCharString(resourcePath, getPos()));}
    throw new Error("Missing return statement in function");
  }

  final public SqlDrop SqlDropFunction(Span s, boolean replace, boolean isTemporary) throws ParseException {
    SqlIdentifier functionIdentifier = null;
    boolean ifExists = false;
    boolean isSystemFunction = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SYSTEM:
      jj_consume_token(SYSTEM);
                   isSystemFunction = true;
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    jj_consume_token(FUNCTION);
    ifExists = IfExistsOpt();
    functionIdentifier = CompoundIdentifier();
        {if (true) return new SqlDropFunction(s.pos(), functionIdentifier, ifExists, isTemporary, isSystemFunction);}
    throw new Error("Missing return statement in function");
  }

  final public SqlAlterFunction SqlAlterFunction() throws ParseException {
    SqlIdentifier functionIdentifier = null;
    SqlCharStringLiteral functionClassName = null;
    String functionLanguage = null;
    SqlParserPos startPos;
    boolean ifExists = false;
    boolean isTemporary = false;
    boolean isSystemFunction = false;
    jj_consume_token(ALTER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPORARY:
      jj_consume_token(TEMPORARY);
                    isTemporary = true;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SYSTEM:
        jj_consume_token(SYSTEM);
                        isSystemFunction = true;
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    jj_consume_token(FUNCTION);
                 startPos = getPos();
    ifExists = IfExistsOpt();
    functionIdentifier = CompoundIdentifier();
    jj_consume_token(AS);
    jj_consume_token(QUOTED_STRING);
        String p = SqlParserUtil.parseString(token.image);
        functionClassName = SqlLiteral.createCharString(p, getPos());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LANGUAGE:
      jj_consume_token(LANGUAGE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case JAVA:
        jj_consume_token(JAVA);
                      functionLanguage = "JAVA";
        break;
      case SCALA:
        jj_consume_token(SCALA);
                      functionLanguage = "SCALA";
        break;
      case SQL:
        jj_consume_token(SQL);
                      functionLanguage = "SQL";
        break;
      case PYTHON:
        jj_consume_token(PYTHON);
                         functionLanguage = "PYTHON";
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[45] = jj_gen;
      ;
    }
        {if (true) return new SqlAlterFunction(startPos.plus(getPos()), functionIdentifier, functionClassName,
            functionLanguage, ifExists, isTemporary, isSystemFunction);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a show functions statement.
* SHOW [USER] FUNCTIONS [ ( FROM | IN ) [catalog_name.]database_name ] [ [NOT] (LIKE | ILIKE) pattern;
*/
  final public SqlShowFunctions SqlShowFunctions() throws ParseException {
    SqlParserPos pos;
    boolean requireUser = false;
    String prep = null;
    SqlIdentifier databaseName = null;
    String likeType = null;
    SqlCharStringLiteral likeLiteral = null;
    boolean notLike = false;
    jj_consume_token(SHOW);
             pos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER:
      jj_consume_token(USER);
                 requireUser = true;
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    jj_consume_token(FUNCTIONS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
    case IN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
                   prep = "FROM";
        break;
      case IN:
        jj_consume_token(IN);
                                             prep = "IN";
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          pos = getPos();
      databaseName = CompoundIdentifier();
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ILIKE:
    case LIKE:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                notLike = true;
        break;
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIKE:
        jj_consume_token(LIKE);
                likeType = "LIKE";
        break;
      case ILIKE:
        jj_consume_token(ILIKE);
                likeType = "ILIKE";
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(QUOTED_STRING);
            String likeCondition = SqlParserUtil.parseString(token.image);
            likeLiteral = SqlLiteral.createCharString(likeCondition, getPos());
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
        {if (true) return new SqlShowFunctions(pos, requireUser, prep, databaseName, likeType, likeLiteral, notLike);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a show functions statement.
* SHOW PROCEDURES [ ( FROM | IN ) [catalog_name.]database_name ] [ [NOT] (LIKE | ILIKE) pattern;
*/
  final public SqlShowProcedures SqlShowProcedures() throws ParseException {
    String prep = null;
    SqlIdentifier databaseName = null;
    boolean notLike = false;
    String likeType = null;
    SqlCharStringLiteral likeLiteral = null;
    SqlParserPos pos;
    jj_consume_token(SHOW);
    jj_consume_token(PROCEDURES);
      pos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
    case IN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
                   prep = "FROM";
        break;
      case IN:
        jj_consume_token(IN);
                                             prep = "IN";
        break;
      default:
        jj_la1[52] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          pos = getPos();
      databaseName = CompoundIdentifier();
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ILIKE:
    case LIKE:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                notLike = true;
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIKE:
        jj_consume_token(LIKE);
                   likeType = "LIKE";
        break;
      case ILIKE:
        jj_consume_token(ILIKE);
                                                     likeType = "ILIKE";
        break;
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(QUOTED_STRING);
            String likeCondition = SqlParserUtil.parseString(token.image);
            likeLiteral = SqlLiteral.createCharString(likeCondition, getPos());
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
        {if (true) return new SqlShowProcedures(pos, prep, databaseName, notLike, likeType, likeLiteral);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parse a "Show Views" metadata query command.
 */
  final public SqlShowViews SqlShowViews() throws ParseException {
    SqlParserPos pos;
    jj_consume_token(SHOW);
    jj_consume_token(VIEWS);
                     pos = getPos();
        {if (true) return new SqlShowViews(pos);}
    throw new Error("Missing return statement in function");
  }

/**
* SHOW TABLES FROM [catalog.] database sql call.
*/
  final public SqlShowTables SqlShowTables() throws ParseException {
    SqlIdentifier databaseName = null;
    SqlCharStringLiteral likeLiteral = null;
    String prep = null;
    boolean notLike = false;
    SqlParserPos pos;
    jj_consume_token(SHOW);
    jj_consume_token(TABLES);
      pos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
    case IN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
                   prep = "FROM";
        break;
      case IN:
        jj_consume_token(IN);
                                             prep = "IN";
        break;
      default:
        jj_la1[57] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          pos = getPos();
      databaseName = CompoundIdentifier();
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIKE:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                notLike = true;
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      jj_consume_token(LIKE);
      jj_consume_token(QUOTED_STRING);
            String likeCondition = SqlParserUtil.parseString(token.image);
            likeLiteral = SqlLiteral.createCharString(likeCondition, getPos());
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
        {if (true) return new SqlShowTables(pos, prep, databaseName, notLike, likeLiteral);}
    throw new Error("Missing return statement in function");
  }

/**
* SHOW COLUMNS FROM [[catalog.] database.]sqlIdentifier sql call.
*/
  final public SqlShowColumns SqlShowColumns() throws ParseException {
    SqlIdentifier tableName;
    SqlCharStringLiteral likeLiteral = null;
    String prep = "FROM";
    boolean notLike = false;
    SqlParserPos pos;
    jj_consume_token(SHOW);
    jj_consume_token(COLUMNS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      break;
    case IN:
      jj_consume_token(IN);
                                       prep = "IN";
      break;
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      pos = getPos();
    tableName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIKE:
    case NOT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        jj_consume_token(NOT);
                notLike = true;
        break;
      default:
        jj_la1[62] = jj_gen;
        ;
      }
      jj_consume_token(LIKE);
      jj_consume_token(QUOTED_STRING);
            String likeCondition = SqlParserUtil.parseString(token.image);
            likeLiteral = SqlLiteral.createCharString(likeCondition, getPos());
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
        {if (true) return new SqlShowColumns(pos, prep, tableName, notLike, likeLiteral);}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "Show Create Table" query and "Show Create View" query commands.
*/
  final public SqlShowCreate SqlShowCreate() throws ParseException {
    SqlIdentifier sqlIdentifier;
    SqlParserPos pos;
    jj_consume_token(SHOW);
    jj_consume_token(CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLE:
      jj_consume_token(TABLE);
          pos = getPos();
      sqlIdentifier = CompoundIdentifier();
            {if (true) return new SqlShowCreateTable(pos, sqlIdentifier);}
      break;
    case VIEW:
      jj_consume_token(VIEW);
          pos = getPos();
      sqlIdentifier = CompoundIdentifier();
            {if (true) return new SqlShowCreateView(pos, sqlIdentifier);}
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * DESCRIBE | DESC [ EXTENDED] [[catalogName.] dataBasesName].tableName sql call.
 * Here we add Rich in className to distinguish from calcite's original SqlDescribeTable.
 */
  final public SqlRichDescribeTable SqlRichDescribeTable() throws ParseException {
    SqlIdentifier tableName;
    SqlParserPos pos;
    boolean isExtended = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DESCRIBE:
      jj_consume_token(DESCRIBE);
      break;
    case DESC:
      jj_consume_token(DESC);
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                              pos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDED:
      jj_consume_token(EXTENDED);
                   isExtended = true;
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
    tableName = CompoundIdentifier();
        {if (true) return new SqlRichDescribeTable(pos, tableName, isExtended);}
    throw new Error("Missing return statement in function");
  }

  final public SqlAlterTable SqlAlterTable() throws ParseException {
    SqlParserPos startPos;
    SqlIdentifier tableIdentifier;
    SqlIdentifier newTableIdentifier = null;
    boolean ifExists = false;
    boolean ifNotExists = false;
    SqlNodeList propertyList = SqlNodeList.EMPTY;
    SqlNodeList propertyKeyList = SqlNodeList.EMPTY;
    SqlNodeList partitionSpec = null;
    SqlIdentifier constraintName;
    SqlTableConstraint constraint;
    SqlIdentifier originColumnIdentifier;
    SqlIdentifier newColumnIdentifier;
    AlterTableContext ctx = new AlterTableContext();
    AlterTableAddPartitionContext addPartitionCtx = new AlterTableAddPartitionContext();
    AlterTableDropPartitionsContext dropPartitionsCtx = new AlterTableDropPartitionsContext();
    jj_consume_token(ALTER);
    jj_consume_token(TABLE);
                      startPos = getPos();
    ifExists = IfExistsOpt();
    tableIdentifier = CompoundIdentifier();
    if (jj_2_50(2)) {
      jj_consume_token(RENAME);
      jj_consume_token(TO);
      newTableIdentifier = CompoundIdentifier();
            {if (true) return new SqlAlterTableRename(
                        startPos.plus(getPos()),
                        tableIdentifier,
                        newTableIdentifier,
                        ifExists);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RENAME:
        jj_consume_token(RENAME);
        originColumnIdentifier = CompoundIdentifier();
        jj_consume_token(TO);
        newColumnIdentifier = CompoundIdentifier();
            {if (true) return new SqlAlterTableRenameColumn(
                    startPos.plus(getPos()),
                    tableIdentifier,
                    originColumnIdentifier,
                    newColumnIdentifier,
                    ifExists);}
        break;
      case RESET:
        jj_consume_token(RESET);
        propertyKeyList = TablePropertyKeys();
            {if (true) return new SqlAlterTableReset(
                        startPos.plus(getPos()),
                        tableIdentifier,
                        propertyKeyList,
                        ifExists);}
        break;
      case SET:
        jj_consume_token(SET);
        propertyList = TableProperties();
            {if (true) return new SqlAlterTableOptions(
                        startPos.plus(getPos()),
                        tableIdentifier,
                        propertyList,
                        ifExists);}
        break;
      case ADD:
        jj_consume_token(ADD);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PARTITION:
        case IF:
          AlterTableAddPartition(addPartitionCtx);
                {if (true) return new SqlAddPartitions(startPos.plus(getPos()),
                        tableIdentifier,
                        addPartitionCtx.ifNotExists,
                        addPartitionCtx.partSpecs,
                        addPartitionCtx.partProps);}
          break;
        case A:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CASCADE:
        case CATALOG:
        case CATALOG_NAME:
        case CENTURY:
        case CHAIN:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASS_ORIGIN:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case FINAL:
        case FIRST:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case HIERARCHY:
        case HOP:
        case HOURS:
        case IGNORE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAST:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LOCATOR:
        case M:
        case MAP:
        case MATCHED:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MINUTES:
        case MINVALUE:
        case MONTHS:
        case MORE_:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NORMALIZED:
        case NULLABLE:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PLACING:
        case PLAN:
        case PLI:
        case PRECEDING:
        case PRESERVE:
        case PRIMARY:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case READ:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW_COUNT:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOURCE:
        case SPACE:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case STATE:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNIQUE:
        case UNNAMED:
        case USAGE:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VERSION:
        case VIEW:
        case WEEK:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEARS:
        case ZONE:
        case CHANGELOG_MODE:
        case COMPACT:
        case COMPILE:
        case COLUMNS:
        case DRAIN:
        case ENFORCED:
        case ESTIMATED_COST:
        case JSON_EXECUTION_PLAN:
        case PLAN_ADVICE:
        case JAR:
        case JARS:
        case JOB:
        case JOBS:
        case LOAD:
        case METADATA:
        case OVERWRITE:
        case OVERWRITING:
        case PARTITIONED:
        case PARTITIONS:
        case PYTHON:
        case REMOVE:
        case STOP:
        case UNLOAD:
        case VIRTUAL:
        case WATERMARK:
        case TRY_CAST:
        case ANALYZE:
        case COMPUTE:
        case STATISTICS:
        case LPAREN:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case A:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CASCADE:
          case CATALOG:
          case CATALOG_NAME:
          case CENTURY:
          case CHAIN:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASS_ORIGIN:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case FINAL:
          case FIRST:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case HIERARCHY:
          case HOP:
          case HOURS:
          case IGNORE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAST:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LOCATOR:
          case M:
          case MAP:
          case MATCHED:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MINUTES:
          case MINVALUE:
          case MONTHS:
          case MORE_:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NORMALIZED:
          case NULLABLE:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PLACING:
          case PLAN:
          case PLI:
          case PRECEDING:
          case PRESERVE:
          case PRIMARY:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case READ:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW_COUNT:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOURCE:
          case SPACE:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case STATE:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNIQUE:
          case UNNAMED:
          case USAGE:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VERSION:
          case VIEW:
          case WEEK:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEARS:
          case ZONE:
          case CHANGELOG_MODE:
          case COMPACT:
          case COMPILE:
          case COLUMNS:
          case DRAIN:
          case ENFORCED:
          case ESTIMATED_COST:
          case IF:
          case JSON_EXECUTION_PLAN:
          case PLAN_ADVICE:
          case JAR:
          case JARS:
          case JOB:
          case JOBS:
          case LOAD:
          case METADATA:
          case OVERWRITE:
          case OVERWRITING:
          case PARTITIONED:
          case PARTITIONS:
          case PYTHON:
          case REMOVE:
          case STOP:
          case UNLOAD:
          case VIRTUAL:
          case WATERMARK:
          case TRY_CAST:
          case ANALYZE:
          case COMPUTE:
          case STATISTICS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            AlterTableAddOrModify(ctx);
            break;
          case LPAREN:
            jj_consume_token(LPAREN);
            AlterTableAddOrModify(ctx);
            label_8:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case COMMA:
                ;
                break;
              default:
                jj_la1[67] = jj_gen;
                break label_8;
              }
              jj_consume_token(COMMA);
              AlterTableAddOrModify(ctx);
            }
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[68] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
            {if (true) return new SqlAlterTableAdd(
                        startPos.plus(getPos()),
                        tableIdentifier,
                        new SqlNodeList(ctx.columnPositions, startPos.plus(getPos())),
                        ctx.constraints,
                        ctx.watermark,
                        ifExists);}
          break;
        default:
          jj_la1[69] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case MODIFY:
        jj_consume_token(MODIFY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CASCADE:
        case CATALOG:
        case CATALOG_NAME:
        case CENTURY:
        case CHAIN:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASS_ORIGIN:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case FINAL:
        case FIRST:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case HIERARCHY:
        case HOP:
        case HOURS:
        case IGNORE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAST:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LOCATOR:
        case M:
        case MAP:
        case MATCHED:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MINUTES:
        case MINVALUE:
        case MONTHS:
        case MORE_:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NORMALIZED:
        case NULLABLE:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PLACING:
        case PLAN:
        case PLI:
        case PRECEDING:
        case PRESERVE:
        case PRIMARY:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case READ:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW_COUNT:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOURCE:
        case SPACE:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case STATE:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNIQUE:
        case UNNAMED:
        case USAGE:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VERSION:
        case VIEW:
        case WEEK:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEARS:
        case ZONE:
        case CHANGELOG_MODE:
        case COMPACT:
        case COMPILE:
        case COLUMNS:
        case DRAIN:
        case ENFORCED:
        case ESTIMATED_COST:
        case IF:
        case JSON_EXECUTION_PLAN:
        case PLAN_ADVICE:
        case JAR:
        case JARS:
        case JOB:
        case JOBS:
        case LOAD:
        case METADATA:
        case OVERWRITE:
        case OVERWRITING:
        case PARTITIONED:
        case PARTITIONS:
        case PYTHON:
        case REMOVE:
        case STOP:
        case UNLOAD:
        case VIRTUAL:
        case WATERMARK:
        case TRY_CAST:
        case ANALYZE:
        case COMPUTE:
        case STATISTICS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          AlterTableAddOrModify(ctx);
          break;
        case LPAREN:
          jj_consume_token(LPAREN);
          AlterTableAddOrModify(ctx);
          label_9:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[70] = jj_gen;
              break label_9;
            }
            jj_consume_token(COMMA);
            AlterTableAddOrModify(ctx);
          }
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[71] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
            {if (true) return new SqlAlterTableModify(
                        startPos.plus(getPos()),
                        tableIdentifier,
                        new SqlNodeList(ctx.columnPositions, startPos.plus(getPos())),
                        ctx.constraints,
                        ctx.watermark,
                        ifExists);}
        break;
      case DROP:
        jj_consume_token(DROP);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PARTITION:
        case IF:
          AlterTableDropPartitions(dropPartitionsCtx);
                {if (true) return new SqlDropPartitions(
                        startPos.plus(getPos()),
                        tableIdentifier,
                        dropPartitionsCtx.ifExists,
                        dropPartitionsCtx.partSpecs);}
          break;
        case A:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CASCADE:
        case CATALOG:
        case CATALOG_NAME:
        case CENTURY:
        case CHAIN:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASS_ORIGIN:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case FINAL:
        case FIRST:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case HIERARCHY:
        case HOP:
        case HOURS:
        case IGNORE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAST:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LOCATOR:
        case M:
        case MAP:
        case MATCHED:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MINUTES:
        case MINVALUE:
        case MONTHS:
        case MORE_:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NORMALIZED:
        case NULLABLE:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PLACING:
        case PLAN:
        case PLI:
        case PRECEDING:
        case PRESERVE:
        case PRIMARY:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case READ:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW_COUNT:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOURCE:
        case SPACE:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case STATE:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNNAMED:
        case USAGE:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VERSION:
        case VIEW:
        case WEEK:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEARS:
        case ZONE:
        case CHANGELOG_MODE:
        case COMPACT:
        case COMPILE:
        case COLUMNS:
        case DRAIN:
        case ENFORCED:
        case ESTIMATED_COST:
        case JSON_EXECUTION_PLAN:
        case PLAN_ADVICE:
        case JAR:
        case JARS:
        case JOB:
        case JOBS:
        case LOAD:
        case METADATA:
        case OVERWRITE:
        case OVERWRITING:
        case PARTITIONED:
        case PARTITIONS:
        case PYTHON:
        case REMOVE:
        case STOP:
        case UNLOAD:
        case VIRTUAL:
        case WATERMARK:
        case TRY_CAST:
        case ANALYZE:
        case COMPUTE:
        case STATISTICS:
        case LPAREN:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case A:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CASCADE:
          case CATALOG:
          case CATALOG_NAME:
          case CENTURY:
          case CHAIN:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASS_ORIGIN:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case FINAL:
          case FIRST:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case HIERARCHY:
          case HOP:
          case HOURS:
          case IGNORE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAST:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LOCATOR:
          case M:
          case MAP:
          case MATCHED:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MINUTES:
          case MINVALUE:
          case MONTHS:
          case MORE_:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NORMALIZED:
          case NULLABLE:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PLACING:
          case PLAN:
          case PLI:
          case PRECEDING:
          case PRESERVE:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case READ:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW_COUNT:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOURCE:
          case SPACE:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case STATE:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNNAMED:
          case USAGE:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VERSION:
          case VIEW:
          case WEEK:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEARS:
          case ZONE:
          case CHANGELOG_MODE:
          case COMPACT:
          case COMPILE:
          case COLUMNS:
          case DRAIN:
          case ENFORCED:
          case ESTIMATED_COST:
          case IF:
          case JSON_EXECUTION_PLAN:
          case PLAN_ADVICE:
          case JAR:
          case JARS:
          case JOB:
          case JOBS:
          case LOAD:
          case METADATA:
          case OVERWRITE:
          case OVERWRITING:
          case PARTITIONED:
          case PARTITIONS:
          case PYTHON:
          case REMOVE:
          case STOP:
          case UNLOAD:
          case VIRTUAL:
          case TRY_CAST:
          case ANALYZE:
          case COMPUTE:
          case STATISTICS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
              SqlIdentifier columnName = null;
            columnName = CompoundIdentifier();
                {if (true) return new SqlAlterTableDropColumn(
                            startPos.plus(getPos()),
                            tableIdentifier,
                            new SqlNodeList(
                                Collections.singletonList(columnName),
                                getPos()),
                            ifExists);}
            break;
          case LPAREN:
              Pair<SqlNodeList, SqlNodeList> columnWithTypePair = null;
            columnWithTypePair = ParenthesizedCompoundIdentifierList();
                {if (true) return new SqlAlterTableDropColumn(
                            startPos.plus(getPos()),
                            tableIdentifier,
                            columnWithTypePair.getKey(),
                            ifExists);}
            break;
          case PRIMARY:
            jj_consume_token(PRIMARY);
            jj_consume_token(KEY);
                {if (true) return new SqlAlterTableDropPrimaryKey(
                        startPos.plus(getPos()),
                        tableIdentifier,
                        ifExists);}
            break;
          case CONSTRAINT:
            jj_consume_token(CONSTRAINT);
            constraintName = SimpleIdentifier();
                {if (true) return new SqlAlterTableDropConstraint(
                            startPos.plus(getPos()),
                            tableIdentifier,
                            constraintName,
                            ifExists);}
            break;
          case WATERMARK:
            jj_consume_token(WATERMARK);
                {if (true) return new SqlAlterTableDropWatermark(
                            startPos.plus(getPos()),
                            tableIdentifier,
                            ifExists);}
            break;
          default:
            jj_la1[72] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[73] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case PARTITION:
      case COMPACT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PARTITION:
          jj_consume_token(PARTITION);
                partitionSpec = new SqlNodeList(getPos());
                PartitionSpecCommaList(partitionSpec);
          break;
        default:
          jj_la1[74] = jj_gen;
          ;
        }
        jj_consume_token(COMPACT);
            {if (true) return new SqlAlterTableCompact(startPos.plus(getPos()), tableIdentifier, partitionSpec, ifExists);}
        break;
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parse a table option key list. */
  final public SqlNodeList TablePropertyKeys() throws ParseException {
    SqlNode key;
    final List<SqlNode> proKeyList = new ArrayList<SqlNode>();
    final Span span;
    jj_consume_token(LPAREN);
               span = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      key = StringLiteral();
            proKeyList.add(key);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[76] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        key = StringLiteral();
                proKeyList.add(key);
      }
      break;
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
       {if (true) return new SqlNodeList(proKeyList, span.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void TableColumn(TableCreationContext context) throws ParseException {
    SqlTableConstraint constraint;
    if (jj_2_51(2)) {
      TypedColumn(context);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONSTRAINT:
      case PRIMARY:
      case UNIQUE:
        constraint = TableConstraint();
            context.constraints.add(constraint);
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        ComputedColumn(context);
        break;
      case WATERMARK:
        Watermark(context);
        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void Watermark(TableCreationContext context) throws ParseException {
    SqlIdentifier eventTimeColumnName;
    SqlParserPos pos;
    SqlNode watermarkStrategy;
    jj_consume_token(WATERMARK);
                 pos = getPos();
    jj_consume_token(FOR);
    eventTimeColumnName = CompoundIdentifier();
    jj_consume_token(AS);
    watermarkStrategy = Expression(ExprContext.ACCEPT_NON_QUERY);
        if (context.watermark != null) {
            {if (true) throw SqlUtil.newContextException(pos,
                ParserResource.RESOURCE.multipleWatermarksUnsupported());}
        } else {
            context.watermark = new SqlWatermark(pos, eventTimeColumnName, watermarkStrategy);
        }
  }

/** Parses {@code column_name column_data_type [...]}. */
  final public SqlTableColumn TypedColumn(TableCreationContext context) throws ParseException {
    SqlTableColumn tableColumn;
    SqlIdentifier name;
    SqlParserPos pos;
    SqlDataTypeSpec type;
    name = CompoundIdentifier();
                                 pos = getPos();
    type = ExtendedDataType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case METADATA:
      tableColumn = MetadataColumn(context, name, type);
      break;
    default:
      jj_la1[79] = jj_gen;
      tableColumn = RegularColumn(context, name, type);
    }
        {if (true) return tableColumn;}
    throw new Error("Missing return statement in function");
  }

/** Parses {@code column_name AS expr [COMMENT 'comment']}. */
  final public SqlTableColumn ComputedColumn(TableCreationContext context) throws ParseException {
    SqlIdentifier name;
    SqlParserPos pos;
    SqlNode expr;
    SqlNode comment = null;
    name = SimpleIdentifier();
                               pos = getPos();
    jj_consume_token(AS);
    expr = Expression(ExprContext.ACCEPT_NON_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      jj_consume_token(COMMENT);
      comment = StringLiteral();
      break;
    default:
      jj_la1[80] = jj_gen;
      ;
    }
        SqlTableColumn computedColumn = new SqlTableColumn.SqlComputedColumn(
            getPos(),
            name,
            comment,
            expr);
        context.columnList.add(computedColumn);
        {if (true) return computedColumn;}
    throw new Error("Missing return statement in function");
  }

/** Parses {@code column_name column_data_type METADATA [FROM 'alias_name'] [VIRTUAL] [COMMENT 'comment']}. */
  final public SqlTableColumn MetadataColumn(TableCreationContext context, SqlIdentifier name, SqlDataTypeSpec type) throws ParseException {
    SqlNode metadataAlias = null;
    boolean isVirtual = false;
    SqlNode comment = null;
    jj_consume_token(METADATA);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      metadataAlias = StringLiteral();
      break;
    default:
      jj_la1[81] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VIRTUAL:
      jj_consume_token(VIRTUAL);
            isVirtual = true;
      break;
    default:
      jj_la1[82] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      jj_consume_token(COMMENT);
      comment = StringLiteral();
      break;
    default:
      jj_la1[83] = jj_gen;
      ;
    }
        SqlTableColumn metadataColumn = new SqlTableColumn.SqlMetadataColumn(
            getPos(),
            name,
            comment,
            type,
            metadataAlias,
            isVirtual);
        context.columnList.add(metadataColumn);
        {if (true) return metadataColumn;}
    throw new Error("Missing return statement in function");
  }

/** Parses {@code column_name column_data_type [constraint] [COMMENT 'comment']}. */
  final public SqlTableColumn RegularColumn(TableCreationContext context, SqlIdentifier name, SqlDataTypeSpec type) throws ParseException {
    SqlTableConstraint constraint = null;
    SqlNode comment = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTRAINT:
    case PRIMARY:
    case UNIQUE:
      constraint = ColumnConstraint(name);
      break;
    default:
      jj_la1[84] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      jj_consume_token(COMMENT);
      comment = StringLiteral();
      break;
    default:
      jj_la1[85] = jj_gen;
      ;
    }
        SqlTableColumn regularColumn = new SqlTableColumn.SqlRegularColumn(
            getPos(),
            name,
            comment,
            type,
            constraint);
        context.columnList.add(regularColumn);
        {if (true) return regularColumn;}
    throw new Error("Missing return statement in function");
  }

/** Parses {@code ALTER TABLE table_name ADD [IF NOT EXISTS] PARTITION partition_spec [PARTITION partition_spec][...]}. */
  final public void AlterTableAddPartition(AlterTableAddPartitionContext context) throws ParseException {
    List<SqlNodeList> partSpecs = new ArrayList();
    List<SqlNodeList> partProps = new ArrayList();
    SqlNodeList partSpec;
    SqlNodeList partProp;
    context.ifNotExists = IfNotExistsOpt();
    label_11:
    while (true) {
      jj_consume_token(PARTITION);
            partSpec = new SqlNodeList(getPos());
            partProp = null;
            PartitionSpecCommaList(partSpec);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
                   partProp = TableProperties();
        break;
      default:
        jj_la1[86] = jj_gen;
        ;
      }
            partSpecs.add(partSpec);
            partProps.add(partProp);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PARTITION:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_11;
      }
    }
        context.partSpecs = partSpecs;
        context.partProps = partProps;
  }

/** Parses {@code ALTER TABLE table_name ADD/MODIFY [...]}. */
  final public void AlterTableAddOrModify(AlterTableContext context) throws ParseException {
    SqlTableConstraint constraint;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      AddOrModifyColumn(context);
      break;
    case CONSTRAINT:
    case PRIMARY:
    case UNIQUE:
      constraint = TableConstraint();
            context.constraints.add(constraint);
      break;
    case WATERMARK:
      Watermark(context);
      break;
    default:
      jj_la1[88] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** Parses {@code ADD/MODIFY column_name column_data_type [...]}. */
  final public void AddOrModifyColumn(AlterTableContext context) throws ParseException {
    SqlTableColumn column;
    SqlIdentifier referencedColumn = null;
    SqlTableColumnPosition columnPos = null;
    if (jj_2_52(2)) {
      column = TypedColumn(context);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        column = ComputedColumn(context);
        break;
      default:
        jj_la1[89] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AFTER:
    case FIRST:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AFTER:
        jj_consume_token(AFTER);
        referencedColumn = CompoundIdentifier();
                columnPos = new SqlTableColumnPosition(
                    getPos(),
                    column,
                    SqlColumnPosSpec.AFTER.symbol(getPos()),
                    referencedColumn);
        break;
      case FIRST:
        jj_consume_token(FIRST);
                columnPos = new SqlTableColumnPosition(
                    getPos(),
                    column,
                    SqlColumnPosSpec.FIRST.symbol(getPos()),
                    referencedColumn);
        break;
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[91] = jj_gen;
      ;
    }
        if (columnPos == null) {
            columnPos = new SqlTableColumnPosition(
                getPos(),
                column,
                null,
                referencedColumn);
        }
        context.columnPositions.add(columnPos);
  }

/** Parses {@code ALTER TABLE table_name DROP [IF EXISTS] PARTITION partition_spec[, PARTITION partition_spec, ...]}. */
  final public void AlterTableDropPartitions(AlterTableDropPartitionsContext context) throws ParseException {
    List<SqlNodeList> partSpecs = new ArrayList();
    SqlNodeList partSpec;
    context.ifExists = IfExistsOpt();
    jj_consume_token(PARTITION);
        partSpec = new SqlNodeList(getPos());
        PartitionSpecCommaList(partSpec);
        partSpecs.add(partSpec);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[92] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      jj_consume_token(PARTITION);
            partSpec = new SqlNodeList(getPos());
            PartitionSpecCommaList(partSpec);
            partSpecs.add(partSpec);
    }
        context.partSpecs = partSpecs;
  }

/**
* Different with {@link #DataType()}, we support a [ NULL | NOT NULL ] suffix syntax for both the
* collection element data type and the data type itself.
*
* <p>See {@link #SqlDataTypeSpec} for the syntax details of {@link #DataType()}.
*/
  final public SqlDataTypeSpec ExtendedDataType() throws ParseException {
    SqlTypeNameSpec typeName;
    final Span s;
    boolean elementNullable = true;
    boolean nullable = true;
    typeName = TypeName();
        s = span();
    label_13:
    while (true) {
      if (jj_2_53(3)) {
        ;
      } else {
        break label_13;
      }
      elementNullable = NullableOptDefaultTrue();
      typeName = ExtendedCollectionsTypeName(typeName, elementNullable);
    }
    nullable = NullableOptDefaultTrue();
        {if (true) return new SqlDataTypeSpec(typeName, s.end(this)).withNullable(nullable);}
    throw new Error("Missing return statement in function");
  }

/** Parses a column constraint for CREATE TABLE. */
  final public SqlTableConstraint ColumnConstraint(SqlIdentifier column) throws ParseException {
    SqlIdentifier constraintName = null;
    final SqlLiteral uniqueSpec;
    SqlLiteral enforcement = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTRAINT:
      constraintName = ConstraintName();
      break;
    default:
      jj_la1[93] = jj_gen;
      ;
    }
    uniqueSpec = UniqueSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
    case ENFORCED:
      enforcement = ConstraintEnforcement();
      break;
    default:
      jj_la1[94] = jj_gen;
      ;
    }
        {if (true) return new SqlTableConstraint(
                        constraintName,
                        uniqueSpec,
                        SqlNodeList.of(column),
                        enforcement,
                        false,
                        getPos());}
    throw new Error("Missing return statement in function");
  }

/** Parses a table constraint for CREATE TABLE. */
  final public SqlTableConstraint TableConstraint() throws ParseException {
    SqlIdentifier constraintName = null;
    final SqlLiteral uniqueSpec;
    final SqlNodeList columns;
    SqlLiteral enforcement = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONSTRAINT:
      constraintName = ConstraintName();
      break;
    default:
      jj_la1[95] = jj_gen;
      ;
    }
    uniqueSpec = UniqueSpec();
    columns = ParenthesizedSimpleIdentifierList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
    case ENFORCED:
      enforcement = ConstraintEnforcement();
      break;
    default:
      jj_la1[96] = jj_gen;
      ;
    }
        {if (true) return new SqlTableConstraint(
                        constraintName,
                        uniqueSpec,
                        columns,
                        enforcement,
                        true,
                        getPos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlIdentifier ConstraintName() throws ParseException {
    SqlIdentifier constraintName;
    jj_consume_token(CONSTRAINT);
    constraintName = SimpleIdentifier();
        {if (true) return constraintName;}
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral UniqueSpec() throws ParseException {
    SqlLiteral uniqueSpec;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      jj_consume_token(KEY);
            uniqueSpec = SqlUniqueSpec.PRIMARY_KEY.symbol(getPos());
      break;
    case UNIQUE:
      jj_consume_token(UNIQUE);
            uniqueSpec = SqlUniqueSpec.UNIQUE.symbol(getPos());
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return uniqueSpec;}
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral ConstraintEnforcement() throws ParseException {
    SqlLiteral enforcement;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENFORCED:
      jj_consume_token(ENFORCED);
            enforcement = SqlConstraintEnforcement.ENFORCED.symbol(getPos());
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(ENFORCED);
            enforcement = SqlConstraintEnforcement.NOT_ENFORCED.symbol(getPos());
      break;
    default:
      jj_la1[98] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return enforcement;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode TableOption() throws ParseException {
    SqlNode key;
    SqlNode value;
    SqlParserPos pos;
    key = StringLiteral();
      pos = getPos();
    jj_consume_token(EQ);
    value = StringLiteral();
        {if (true) return new SqlTableOption(key, value, getPos());}
    throw new Error("Missing return statement in function");
  }

/** Parse a table properties. */
  final public SqlNodeList TableProperties() throws ParseException {
    SqlNode property;
    final List<SqlNode> proList = new ArrayList<SqlNode>();
    final Span span;
    jj_consume_token(LPAREN);
               span = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      property = TableOption();
            proList.add(property);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[99] = jj_gen;
          break label_14;
        }
        jj_consume_token(COMMA);
        property = TableOption();
                proList.add(property);
      }
      break;
    default:
      jj_la1[100] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
       {if (true) return new SqlNodeList(proList, span.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public SqlCreate SqlCreateTable(Span s, boolean replace, boolean isTemporary) throws ParseException {
    final SqlParserPos startPos = s.pos();
    boolean ifNotExists = false;
    SqlIdentifier tableName;
    List<SqlTableConstraint> constraints = new ArrayList<SqlTableConstraint>();
    SqlWatermark watermark = null;
    SqlNodeList columnList = SqlNodeList.EMPTY;
        SqlCharStringLiteral comment = null;
        SqlTableLike tableLike = null;
    SqlNode asQuery = null;

    SqlNodeList propertyList = SqlNodeList.EMPTY;
    SqlNodeList partitionColumns = SqlNodeList.EMPTY;
    SqlParserPos pos = startPos;
    jj_consume_token(TABLE);
    ifNotExists = IfNotExistsOpt();
    tableName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
                   pos = getPos(); TableCreationContext ctx = new TableCreationContext();
      TableColumn(ctx);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[101] = jj_gen;
          break label_15;
        }
        jj_consume_token(COMMA);
        TableColumn(ctx);
      }
            pos = pos.plus(getPos());
            columnList = new SqlNodeList(ctx.columnList, pos);
            constraints = ctx.constraints;
            watermark = ctx.watermark;
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      jj_consume_token(COMMENT);
      jj_consume_token(QUOTED_STRING);
        String p = SqlParserUtil.parseString(token.image);
        comment = SqlLiteral.createCharString(p, getPos());
      break;
    default:
      jj_la1[103] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITIONED:
      jj_consume_token(PARTITIONED);
      jj_consume_token(BY);
      partitionColumns = ParenthesizedSimpleIdentifierList();
      break;
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      propertyList = TableProperties();
      break;
    default:
      jj_la1[105] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
    case LIKE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LIKE:
        jj_consume_token(LIKE);
        tableLike = SqlTableLike(getPos());
            {if (true) return new SqlCreateTableLike(startPos.plus(getPos()),
                tableName,
                columnList,
                constraints,
                propertyList,
                partitionColumns,
                watermark,
                comment,
                tableLike,
                isTemporary,
                ifNotExists);}
        break;
      case AS:
        jj_consume_token(AS);
        asQuery = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
            if (replace) {
                {if (true) return new SqlReplaceTableAs(startPos.plus(getPos()),
                    tableName,
                    columnList,
                    constraints,
                    propertyList,
                    partitionColumns,
                    watermark,
                    comment,
                    asQuery,
                    isTemporary,
                    ifNotExists,
                    true);}
            } else {
                {if (true) return new SqlCreateTableAs(startPos.plus(getPos()),
                    tableName,
                    columnList,
                    constraints,
                    propertyList,
                    partitionColumns,
                    watermark,
                    comment,
                    asQuery,
                    isTemporary,
                    ifNotExists);}
            }
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[107] = jj_gen;
      ;
    }
        {if (true) return new SqlCreateTable(startPos.plus(getPos()),
            tableName,
            columnList,
            constraints,
            propertyList,
            partitionColumns,
            watermark,
            comment,
            isTemporary,
            ifNotExists);}
    throw new Error("Missing return statement in function");
  }

  final public SqlTableLike SqlTableLike(SqlParserPos startPos) throws ParseException {
    final List<SqlTableLikeOption> likeOptions = new ArrayList<SqlTableLikeOption>();
    SqlIdentifier tableName;
    SqlTableLikeOption likeOption;
    tableName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      label_16:
      while (true) {
        likeOption = SqlTableLikeOption();
                likeOptions.add(likeOption);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXCLUDING:
        case INCLUDING:
        case OVERWRITING:
          ;
          break;
        default:
          jj_la1[108] = jj_gen;
          break label_16;
        }
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[109] = jj_gen;
      ;
    }
        {if (true) return new SqlTableLike(
            startPos.plus(getPos()),
            tableName,
            likeOptions
        );}
    throw new Error("Missing return statement in function");
  }

  final public SqlTableLikeOption SqlTableLikeOption() throws ParseException {
    MergingStrategy mergingStrategy;
    FeatureOption featureOption;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCLUDING:
      jj_consume_token(INCLUDING);
                      mergingStrategy = MergingStrategy.INCLUDING;
      break;
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
                      mergingStrategy = MergingStrategy.EXCLUDING;
      break;
    case OVERWRITING:
      jj_consume_token(OVERWRITING);
                        mergingStrategy = MergingStrategy.OVERWRITING;
      break;
    default:
      jj_la1[110] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
      jj_consume_token(ALL);
                featureOption = FeatureOption.ALL;
      break;
    case CONSTRAINTS:
      jj_consume_token(CONSTRAINTS);
                        featureOption = FeatureOption.CONSTRAINTS;
      break;
    case GENERATED:
      jj_consume_token(GENERATED);
                      featureOption = FeatureOption.GENERATED;
      break;
    case METADATA:
      jj_consume_token(METADATA);
                     featureOption = FeatureOption.METADATA;
      break;
    case OPTIONS:
      jj_consume_token(OPTIONS);
                    featureOption = FeatureOption.OPTIONS;
      break;
    case PARTITIONS:
      jj_consume_token(PARTITIONS);
                       featureOption = FeatureOption.PARTITIONS;
      break;
    case WATERMARKS:
      jj_consume_token(WATERMARKS);
                       featureOption = FeatureOption.WATERMARKS;
      break;
    default:
      jj_la1[111] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlTableLikeOption(mergingStrategy, featureOption);}
    throw new Error("Missing return statement in function");
  }

  final public SqlDrop SqlDropTable(Span s, boolean replace, boolean isTemporary) throws ParseException {
    SqlIdentifier tableName = null;
    boolean ifExists = false;
    jj_consume_token(TABLE);
    ifExists = IfExistsOpt();
    tableName = CompoundIdentifier();
         {if (true) return new SqlDropTable(s.pos(), tableName, ifExists, isTemporary);}
    throw new Error("Missing return statement in function");
  }

/**
* Parser a REPLACE TABLE AS statement
*/
  final public SqlNode SqlReplaceTable() throws ParseException {
    SqlIdentifier tableName;
    SqlCharStringLiteral comment = null;
    SqlNode asQuery = null;
    SqlNodeList propertyList = SqlNodeList.EMPTY;
    SqlParserPos pos;
    boolean isTemporary = false;
    List<SqlTableConstraint> constraints = new ArrayList<SqlTableConstraint>();
    SqlWatermark watermark = null;
    SqlNodeList columnList = SqlNodeList.EMPTY;
    SqlNodeList partitionColumns = SqlNodeList.EMPTY;
    boolean ifNotExists = false;
    jj_consume_token(REPLACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPORARY:
      jj_consume_token(TEMPORARY);
                      isTemporary = true;
      break;
    default:
      jj_la1[112] = jj_gen;
      ;
    }
    jj_consume_token(TABLE);
    ifNotExists = IfNotExistsOpt();
    tableName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
                   pos = getPos(); TableCreationContext ctx = new TableCreationContext();
      TableColumn(ctx);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[113] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
        TableColumn(ctx);
      }
            pos = getPos();
            columnList = new SqlNodeList(ctx.columnList, pos);
            constraints = ctx.constraints;
            watermark = ctx.watermark;
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[114] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      jj_consume_token(COMMENT);
      jj_consume_token(QUOTED_STRING);
        String p = SqlParserUtil.parseString(token.image);
        comment = SqlLiteral.createCharString(p, getPos());
      break;
    default:
      jj_la1[115] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITIONED:
      jj_consume_token(PARTITIONED);
      jj_consume_token(BY);
      partitionColumns = ParenthesizedSimpleIdentifierList();
      break;
    default:
      jj_la1[116] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      propertyList = TableProperties();
      break;
    default:
      jj_la1[117] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    asQuery = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlReplaceTableAs(getPos(),
            tableName,
            columnList,
            constraints,
            propertyList,
            partitionColumns,
            watermark,
            comment,
            asQuery,
            isTemporary,
            ifNotExists,
            false);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an INSERT statement.
*/
  final public SqlNode RichSqlInsert() throws ParseException {
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlNodeList keywordList;
    final List<SqlLiteral> extendedKeywords = new ArrayList<SqlLiteral>();
    final SqlNodeList extendedKeywordList;
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlNodeList extendList;
    SqlNode source;
    final SqlNodeList partitionList = new SqlNodeList(getPos());
    SqlNodeList columnList = null;
    final Span s;
    final Pair<SqlNodeList, SqlNodeList> p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
      break;
    case UPSERT:
      jj_consume_token(UPSERT);
                   keywords.add(SqlInsertKeyword.UPSERT.symbol(getPos()));
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTO:
      jj_consume_token(INTO);
      break;
    case OVERWRITE:
      jj_consume_token(OVERWRITE);
            if (RichSqlInsert.isUpsert(keywords)) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    ParserResource.RESOURCE.overwriteIsOnlyUsedWithInsert());}
            }
            extendedKeywords.add(RichSqlInsertKeyword.OVERWRITE.symbol(getPos()));
      break;
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
        extendedKeywordList = new SqlNodeList(extendedKeywords, s.addAll(extendedKeywords).pos());
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[120] = jj_gen;
                                           tableRef = tableName;
    }
    if (jj_2_54(5)) {
      tableRef = ExtendTable(tableRef);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      PartitionSpecCommaList(partitionList);
      break;
    default:
      jj_la1[121] = jj_gen;
      ;
    }
    if (jj_2_55(2)) {
      p = ParenthesizedCompoundIdentifierList();
            if (p.right.size() > 0) {
                tableRef = extend(tableRef, p.right);
            }
            if (p.left.size() > 0) {
                columnList = p.left;
            } else {
                columnList = null;
            }
    } else {
              columnList = null;
    }
    source = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new RichSqlInsert(s.end(source), keywordList, extendedKeywordList, tableRef, source,
            columnList, partitionList);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a partition specifications statement,
* e.g. insert into tbl1 partition(col1='val1', col2='val2') select col3 from tbl.
*/
  final public void PartitionSpecCommaList(SqlNodeList list) throws ParseException {
    SqlIdentifier key;
    SqlNode value;
    SqlParserPos pos;
    jj_consume_token(LPAREN);
    key = SimpleIdentifier();
      pos = getPos();
    jj_consume_token(EQ);
    value = Literal();
        list.add(new SqlProperty(key, value, pos));
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      key = SimpleIdentifier();
                                           pos = getPos();
      jj_consume_token(EQ);
      value = Literal();
            list.add(new SqlProperty(key, value, pos));
    }
    jj_consume_token(RPAREN);
  }

/**
* Parses a create view or temporary view statement.
*   CREATE [OR REPLACE] [TEMPORARY] VIEW [IF NOT EXISTS] view_name [ (field1, field2 ...) ]
*   AS select_statement
* We only support [IF NOT EXISTS] semantic in Flink although the parser supports [OR REPLACE] grammar.
* See: FLINK-17067
*/
  final public SqlCreate SqlCreateView(Span s, boolean replace, boolean isTemporary) throws ParseException {
    SqlIdentifier viewName;
    SqlCharStringLiteral comment = null;
    SqlNode query;
    SqlNodeList fieldList = SqlNodeList.EMPTY;
    boolean ifNotExists = false;
    jj_consume_token(VIEW);
    ifNotExists = IfNotExistsOpt();
    viewName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      fieldList = ParenthesizedSimpleIdentifierList();
      break;
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMENT:
      jj_consume_token(COMMENT);
      jj_consume_token(QUOTED_STRING);
            String p = SqlParserUtil.parseString(token.image);
            comment = SqlLiteral.createCharString(p, getPos());
      break;
    default:
      jj_la1[124] = jj_gen;
      ;
    }
    jj_consume_token(AS);
    query = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlCreateView(s.pos(), viewName, fieldList, query, replace, isTemporary, ifNotExists, comment, null);}
    throw new Error("Missing return statement in function");
  }

  final public SqlDrop SqlDropView(Span s, boolean replace, boolean isTemporary) throws ParseException {
    SqlIdentifier viewName = null;
    boolean ifExists = false;
    jj_consume_token(VIEW);
    ifExists = IfExistsOpt();
    viewName = CompoundIdentifier();
        {if (true) return new SqlDropView(s.pos(), viewName, ifExists, isTemporary);}
    throw new Error("Missing return statement in function");
  }

  final public SqlAlterView SqlAlterView() throws ParseException {
  SqlParserPos startPos;
  SqlIdentifier viewName;
  SqlIdentifier newViewName;
  SqlNode newQuery;
    jj_consume_token(ALTER);
    jj_consume_token(VIEW);
                   startPos = getPos();
    viewName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RENAME:
      jj_consume_token(RENAME);
      jj_consume_token(TO);
      newViewName = CompoundIdentifier();
        {if (true) return new SqlAlterViewRename(startPos.plus(getPos()), viewName, newViewName);}
      break;
    case AS:
      jj_consume_token(AS);
      newQuery = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlAlterViewAs(startPos.plus(getPos()), viewName, newQuery);}
      break;
    default:
      jj_la1[125] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
* A sql type name extended basic data type, it has a counterpart basic
* sql type name but always represents as a special alias compared with the standard name.
*
* <p>For example:
*  1. STRING is synonym of VARCHAR(INT_MAX),
*  2. BYTES is synonym of VARBINARY(INT_MAX),
*  3. TIMESTAMP_LTZ(precision) is synonym of TIMESTAMP(precision) WITH LOCAL TIME ZONE.
*/
  final public SqlTypeNameSpec ExtendedSqlBasicTypeName() throws ParseException {
    final SqlTypeName typeName;
    final String typeAlias;
    int precision = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      jj_consume_token(STRING);
            typeName = SqlTypeName.VARCHAR;
            typeAlias = token.image;
            precision = Integer.MAX_VALUE;
      break;
    case BYTES:
      jj_consume_token(BYTES);
            typeName = SqlTypeName.VARBINARY;
            typeAlias = token.image;
            precision = Integer.MAX_VALUE;
      break;
    case TIMESTAMP_LTZ:
      jj_consume_token(TIMESTAMP_LTZ);
           typeAlias = token.image;
      precision = PrecisionOpt();
            typeName = SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
            {if (true) return new SqlTimestampLtzTypeNameSpec(typeAlias, typeName, precision, getPos());}
      break;
    default:
      jj_la1[126] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlAlienSystemTypeNameSpec(typeAlias, typeName, precision, getPos());}
    throw new Error("Missing return statement in function");
  }

/*
* Parses collection type name that does not belong to standard SQL, i.e. ARRAY&lt;INT NOT NULL&gt;.
*/
  final public SqlTypeNameSpec CustomizedCollectionsTypeName() throws ParseException {
    final SqlTypeName collectionTypeName;
    final SqlTypeNameSpec elementTypeName;
    boolean elementNullable = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY:
      jj_consume_token(ARRAY);
            collectionTypeName = SqlTypeName.ARRAY;
      break;
    case MULTISET:
      jj_consume_token(MULTISET);
            collectionTypeName = SqlTypeName.MULTISET;
      break;
    default:
      jj_la1[127] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LT);
    elementTypeName = TypeName();
    elementNullable = NullableOptDefaultTrue();
    jj_consume_token(GT);
        {if (true) return new ExtendedSqlCollectionTypeNameSpec(
            elementTypeName,
            elementNullable,
            collectionTypeName,
            false,
            getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a collection type name, the input element type name may
* also be a collection type. Different with #CollectionsTypeName,
* the element type can have a [ NULL | NOT NULL ] suffix, default is NULL(nullable).
*/
  final public SqlTypeNameSpec ExtendedCollectionsTypeName(SqlTypeNameSpec elementTypeName,
        boolean elementNullable) throws ParseException {
    final SqlTypeName collectionTypeName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MULTISET:
      jj_consume_token(MULTISET);
                     collectionTypeName = SqlTypeName.MULTISET;
      break;
    case ARRAY:
      jj_consume_token(ARRAY);
                   collectionTypeName = SqlTypeName.ARRAY;
      break;
    default:
      jj_la1[128] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new ExtendedSqlCollectionTypeNameSpec(
             elementTypeName,
             elementNullable,
             collectionTypeName,
             true,
             getPos());}
    throw new Error("Missing return statement in function");
  }

/** Parses a SQL map type, e.g. MAP&lt;INT NOT NULL, VARCHAR NULL&gt;. */
  final public SqlTypeNameSpec SqlMapTypeName() throws ParseException {
    SqlDataTypeSpec keyType;
    SqlDataTypeSpec valType;
    jj_consume_token(MAP);
    jj_consume_token(LT);
    keyType = ExtendedDataType();
    jj_consume_token(COMMA);
    valType = ExtendedDataType();
    jj_consume_token(GT);
        {if (true) return new SqlMapTypeNameSpec(keyType, valType, getPos());}
    throw new Error("Missing return statement in function");
  }

/** Parses a SQL raw type such as {@code RAW('org.my.Class', 'sW3Djsds...')}. */
  final public SqlTypeNameSpec SqlRawTypeName() throws ParseException {
    SqlNode className;
    SqlNode serializerString;
    jj_consume_token(RAW);
    jj_consume_token(LPAREN);
    className = StringLiteral();
    jj_consume_token(COMMA);
    serializerString = StringLiteral();
    jj_consume_token(RPAREN);
        {if (true) return new SqlRawTypeNameSpec(className, serializerString, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "name1 type1 [ NULL | NOT NULL] [ comment ]
* [, name2 type2 [ NULL | NOT NULL] [ comment ] ]* ..." list.
* The comment and NULL syntax doest not belong to standard SQL.
*/
  final public void ExtendedFieldNameTypeCommaList(List<SqlIdentifier> fieldNames,
        List<SqlDataTypeSpec> fieldTypes,
        List<SqlCharStringLiteral> comments) throws ParseException {
    SqlIdentifier fName;
    SqlDataTypeSpec fType;
    boolean nullable;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      fName = SimpleIdentifier();
      fType = ExtendedDataType();
            fieldNames.add(fName);
            fieldTypes.add(fType);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUOTED_STRING:
        jj_consume_token(QUOTED_STRING);
                String p = SqlParserUtil.parseString(token.image);
                comments.add(SqlLiteral.createCharString(p, getPos()));
        break;
      default:
        jj_la1[129] = jj_gen;
              comments.add(null);
      }
      break;
    default:
      jj_la1[130] = jj_gen;
      ;
    }
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[131] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      fName = SimpleIdentifier();
      fType = ExtendedDataType();
            fieldNames.add(fName);
            fieldTypes.add(fType);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUOTED_STRING:
        jj_consume_token(QUOTED_STRING);
                String p = SqlParserUtil.parseString(token.image);
                comments.add(SqlLiteral.createCharString(p, getPos()));
        break;
      default:
        jj_la1[132] = jj_gen;
              comments.add(null);
      }
    }
  }

/**
* Parse Row type, we support both Row(name1 type1, name2 type2)
* and Row&lt;name1 type1, name2 type2&gt;.
* Every item type can have a suffix of `NULL` or `NOT NULL` to indicate if this type is nullable.
* i.e. Row(f0 int not null, f1 varchar null). Default is nullable.
*
* <p>The difference with {@link #SqlRowTypeName()}:
* <ul>
*   <li>Support comment syntax for every field</li>
*   <li>Field data type default is nullable</li>
*   <li>Support ROW type with empty fields, e.g. ROW()</li>
* </ul>
*/
  final public SqlTypeNameSpec ExtendedSqlRowTypeName() throws ParseException {
    List<SqlIdentifier> fieldNames = new ArrayList<SqlIdentifier>();
    List<SqlDataTypeSpec> fieldTypes = new ArrayList<SqlDataTypeSpec>();
    List<SqlCharStringLiteral> comments = new ArrayList<SqlCharStringLiteral>();
    final boolean unparseAsStandard;
    jj_consume_token(ROW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NE:
      jj_consume_token(NE);
               unparseAsStandard = false;
      break;
    case LT:
      jj_consume_token(LT);
      ExtendedFieldNameTypeCommaList(fieldNames, fieldTypes, comments);
      jj_consume_token(GT);
          unparseAsStandard = false;
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      ExtendedFieldNameTypeCommaList(fieldNames, fieldTypes, comments);
      jj_consume_token(RPAREN);
          unparseAsStandard = true;
      break;
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new ExtendedSqlRowTypeNameSpec(
            getPos(),
            fieldNames,
            fieldTypes,
            comments,
            unparseAsStandard);}
    throw new Error("Missing return statement in function");
  }

/**
 * Those methods should not be used in SQL. They are good for parsing identifiers
 * in Table API. The difference between those identifiers and CompoundIdentifer is
 * that the Table API identifiers ignore any keywords. They are also strictly limited
 * to three part identifiers. The quoting still works the same way.
 */
  final public SqlIdentifier TableApiIdentifier() throws ParseException {
    final List<String> nameList = new ArrayList<String>();
    final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();
    TableApiIdentifierSegment(nameList, posList);
    if (jj_2_56(2)) {
      jj_consume_token(DOT);
      TableApiIdentifierSegment(nameList, posList);
    } else {
      ;
    }
    if (jj_2_57(2)) {
      jj_consume_token(DOT);
      TableApiIdentifierSegment(nameList, posList);
    } else {
      ;
    }
    jj_consume_token(0);
        SqlParserPos pos = SqlParserPos.sum(posList);
        {if (true) return new SqlIdentifier(nameList, null, pos, posList);}
    throw new Error("Missing return statement in function");
  }

  final public void TableApiIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
    final String id;
    char unicodeEscapeChar = BACKSLASH;
    final SqlParserPos pos;
    final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_IDENTIFIER:
      jj_consume_token(QUOTED_IDENTIFIER);
            id = SqlParserUtil.strip(getToken(0).image, DQ, DQ, DQDQ,
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BACK_QUOTED_IDENTIFIER:
      jj_consume_token(BACK_QUOTED_IDENTIFIER);
            id = SqlParserUtil.strip(getToken(0).image, "`", "`", "``",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BRACKET_QUOTED_IDENTIFIER:
      jj_consume_token(BRACKET_QUOTED_IDENTIFIER);
            id = SqlParserUtil.strip(getToken(0).image, "[", "]", "]]",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case UNICODE_QUOTED_IDENTIFIER:
      jj_consume_token(UNICODE_QUOTED_IDENTIFIER);
            span = span();
            String image = getToken(0).image;
            image = image.substring(image.indexOf('"'));
            image = SqlParserUtil.strip(image, DQ, DQ, DQDQ, quotedCasing);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UESCAPE:
        jj_consume_token(UESCAPE);
        jj_consume_token(QUOTED_STRING);
                String s = SqlParserUtil.parseString(token.image);
                unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
            pos = span.end(this).withQuoting(true);
            SqlLiteral lit = SqlLiteral.createCharString(image, "UTF16", pos);
            lit = lit.unescapeUnicode(unicodeEscapeChar);
            id = lit.toValue();
      break;
    default:
      jj_la1[135] = jj_gen;
            id = getNextToken().image;
            pos = getPos();
    }
        if (id.length() > this.identifierMaxLength) {
            {if (true) throw SqlUtil.newContextException(pos,
                RESOURCE.identifierTooLong(id, this.identifierMaxLength));}
        }
        names.add(id);
        if (positions != null) {
            positions.add(pos);
        }
  }

  final public SqlCreate SqlCreateExtended(Span s, boolean replace) throws ParseException {
    final SqlCreate create;
    boolean isTemporary = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPORARY:
      jj_consume_token(TEMPORARY);
                      isTemporary = true;
      break;
    default:
      jj_la1[136] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CATALOG:
      create = SqlCreateCatalog(s, replace);
      break;
    case TABLE:
      create = SqlCreateTable(s, replace, isTemporary);
      break;
    case VIEW:
      create = SqlCreateView(s, replace, isTemporary);
      break;
    case DATABASE:
      create = SqlCreateDatabase(s, replace);
      break;
    case FUNCTION:
    case SYSTEM:
      create = SqlCreateFunction(s, replace, isTemporary);
      break;
    default:
      jj_la1[137] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return create;}
    throw new Error("Missing return statement in function");
  }

  final public SqlDrop SqlDropExtended(Span s, boolean replace) throws ParseException {
    final SqlDrop drop;
    boolean isTemporary = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPORARY:
      jj_consume_token(TEMPORARY);
                      isTemporary = true;
      break;
    default:
      jj_la1[138] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CATALOG:
      drop = SqlDropCatalog(s, replace);
      break;
    case TABLE:
      drop = SqlDropTable(s, replace, isTemporary);
      break;
    case VIEW:
      drop = SqlDropView(s, replace, isTemporary);
      break;
    case DATABASE:
      drop = SqlDropDatabase(s, replace);
      break;
    case FUNCTION:
    case SYSTEM:
      drop = SqlDropFunction(s, replace, isTemporary);
      break;
    default:
      jj_la1[139] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return drop;}
    throw new Error("Missing return statement in function");
  }

/** SHOW PARTITIONS table_name [PARTITION partition_spec]; */
  final public SqlShowPartitions SqlShowPartitions() throws ParseException {
    SqlParserPos pos;
    SqlIdentifier tableIdentifier;
    SqlNodeList partSpec = null;
    jj_consume_token(SHOW);
    jj_consume_token(PARTITIONS);
                          pos = getPos();
    tableIdentifier = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
            partSpec = new SqlNodeList(getPos());
            PartitionSpecCommaList(partSpec);
      break;
    default:
      jj_la1[140] = jj_gen;
      ;
    }
      {if (true) return new SqlShowPartitions(pos, tableIdentifier, partSpec);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a load module statement.
* LOAD MODULE module_name [WITH (property_name=property_value, ...)];
*/
  final public SqlLoadModule SqlLoadModule() throws ParseException {
    SqlParserPos startPos;
    SqlIdentifier moduleName;
    SqlNodeList propertyList = SqlNodeList.EMPTY;
    jj_consume_token(LOAD);
    jj_consume_token(MODULE);
                      startPos = getPos();
    moduleName = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      propertyList = TableProperties();
      break;
    default:
      jj_la1[141] = jj_gen;
      ;
    }
        {if (true) return new SqlLoadModule(startPos.plus(getPos()),
            moduleName,
            propertyList);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an unload module statement.
* UNLOAD MODULE module_name;
*/
  final public SqlUnloadModule SqlUnloadModule() throws ParseException {
    SqlParserPos startPos;
    SqlIdentifier moduleName;
    jj_consume_token(UNLOAD);
    jj_consume_token(MODULE);
                        startPos = getPos();
    moduleName = SimpleIdentifier();
        {if (true) return new SqlUnloadModule(startPos.plus(getPos()), moduleName);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an use modules statement.
* USE MODULES module_name1 [, module_name2, ...];
*/
  final public SqlUseModules SqlUseModules() throws ParseException {
    final Span s;
    SqlIdentifier moduleName;
    final List<SqlIdentifier> moduleNames = new ArrayList<SqlIdentifier>();
    jj_consume_token(USE);
    jj_consume_token(MODULES);
                      s = span();
    moduleName = SimpleIdentifier();
        moduleNames.add(moduleName);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      label_20:
      while (true) {
        jj_consume_token(COMMA);
        moduleName = SimpleIdentifier();
                moduleNames.add(moduleName);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[142] = jj_gen;
          break label_20;
        }
      }
      break;
    default:
      jj_la1[143] = jj_gen;
      ;
    }
        {if (true) return new SqlUseModules(s.end(this), moduleNames);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a show modules statement.
* SHOW [FULL] MODULES;
*/
  final public SqlShowModules SqlShowModules() throws ParseException {
    SqlParserPos startPos;
    boolean requireFull = false;
    jj_consume_token(SHOW);
             startPos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL:
      jj_consume_token(FULL);
               requireFull = true;
      break;
    default:
      jj_la1[144] = jj_gen;
      ;
    }
    jj_consume_token(MODULES);
        {if (true) return new SqlShowModules(startPos.plus(getPos()), requireFull);}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a start statement set statement.
* BEGIN STATEMENT SET;
*/
  final public SqlBeginStatementSet SqlBeginStatementSet() throws ParseException {
    jj_consume_token(BEGIN);
    jj_consume_token(STATEMENT);
    jj_consume_token(SET);
        {if (true) return new SqlBeginStatementSet(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a end statement set statement.
* END;
*/
  final public SqlEndStatementSet SqlEndStatementSet() throws ParseException {
    jj_consume_token(END);
        {if (true) return new SqlEndStatementSet(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a statement set.
*
* STATEMENT SET BEGIN (RichSqlInsert();)+ END
*/
  final public SqlNode SqlStatementSet() throws ParseException {
    SqlParserPos startPos;
    SqlNode insert;
    List<RichSqlInsert> inserts = new ArrayList<RichSqlInsert>();
    jj_consume_token(STATEMENT);
                 startPos = getPos();
    jj_consume_token(SET);
    jj_consume_token(BEGIN);
    label_21:
    while (true) {
      insert = RichSqlInsert();
      jj_consume_token(SEMICOLON);
            inserts.add((RichSqlInsert) insert);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INSERT:
      case UPSERT:
        ;
        break;
      default:
        jj_la1[145] = jj_gen;
        break label_21;
      }
    }
    jj_consume_token(END);
        {if (true) return new SqlStatementSet(inserts, startPos);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an explain module statement.
*/
  final public SqlNode SqlRichExplain() throws ParseException {
    SqlNode stmt;
    Set<String> explainDetails = new HashSet<String>();
    if (jj_2_58(3)) {
      jj_consume_token(EXPLAIN);
      jj_consume_token(PLAN);
      jj_consume_token(FOR);
    } else if (jj_2_59(2)) {
      jj_consume_token(EXPLAIN);
      ParseExplainDetail(explainDetails);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[146] = jj_gen;
          break label_22;
        }
        jj_consume_token(COMMA);
        ParseExplainDetail(explainDetails);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXPLAIN:
        jj_consume_token(EXPLAIN);
        break;
      default:
        jj_la1[147] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATEMENT:
      stmt = SqlStatementSet();
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
      break;
    case INSERT:
    case UPSERT:
      stmt = RichSqlInsert();
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlRichExplain(getPos(), stmt, explainDetails);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an execute statement.
*/
  final public SqlNode SqlExecute() throws ParseException {
    SqlParserPos startPos;
    SqlNode stmt;
    jj_consume_token(EXECUTE);
               startPos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATEMENT:
      stmt = SqlStatementSet();
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
      break;
    case INSERT:
    case UPSERT:
      stmt = RichSqlInsert();
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlExecute(stmt, startPos);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an execute plan statement.
*/
  final public SqlNode SqlExecutePlan() throws ParseException {
    SqlNode filePath;
    jj_consume_token(EXECUTE);
    jj_consume_token(PLAN);
    filePath = StringLiteral();
        {if (true) return new SqlExecutePlan(getPos(), filePath);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a compile plan statement.
*/
  final public SqlNode SqlCompileAndExecutePlan() throws ParseException {
    SqlParserPos startPos;
    SqlNode filePath;
    SqlNode operand;
    jj_consume_token(COMPILE);
    jj_consume_token(AND);
    jj_consume_token(EXECUTE);
    jj_consume_token(PLAN);
                                       startPos = getPos();
    filePath = StringLiteral();
    jj_consume_token(FOR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATEMENT:
      operand = SqlStatementSet();
      break;
    case INSERT:
    case UPSERT:
      operand = RichSqlInsert();
      break;
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlCompileAndExecutePlan(startPos, filePath, operand);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a compile plan statement.
*/
  final public SqlNode SqlCompilePlan() throws ParseException {
    SqlParserPos startPos;
    SqlNode filePath;
    boolean ifNotExists;
    SqlNode operand;
    jj_consume_token(COMPILE);
    jj_consume_token(PLAN);
                       startPos = getPos();
    filePath = StringLiteral();
    ifNotExists = IfNotExistsOpt();
    jj_consume_token(FOR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATEMENT:
      operand = SqlStatementSet();
      break;
    case INSERT:
    case UPSERT:
      operand = RichSqlInsert();
      break;
    default:
      jj_la1[151] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlCompilePlan(startPos, filePath, ifNotExists, operand);}
    throw new Error("Missing return statement in function");
  }

  final public void ParseExplainDetail(Set<String> explainDetails) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ESTIMATED_COST:
      jj_consume_token(ESTIMATED_COST);
      break;
    case CHANGELOG_MODE:
      jj_consume_token(CHANGELOG_MODE);
      break;
    case JSON_EXECUTION_PLAN:
      jj_consume_token(JSON_EXECUTION_PLAN);
      break;
    case PLAN_ADVICE:
      jj_consume_token(PLAN_ADVICE);
      break;
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (explainDetails.contains(token.image.toUpperCase())) {
            {if (true) throw SqlUtil.newContextException(
                getPos(),
                ParserResource.RESOURCE.explainDetailIsDuplicate());}
        } else {
            explainDetails.add(token.image.toUpperCase());
        }
  }

/**
* Parses an ADD JAR statement.
*/
  final public SqlAddJar SqlAddJar() throws ParseException {
    SqlCharStringLiteral jarPath;
    jj_consume_token(ADD);
    jj_consume_token(JAR);
    jj_consume_token(QUOTED_STRING);
        String path = SqlParserUtil.parseString(token.image);
        jarPath = SqlLiteral.createCharString(path, getPos());
        {if (true) return new SqlAddJar(getPos(), jarPath);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a remove jar statement.
* REMOVE JAR jar_path;
*/
  final public SqlRemoveJar SqlRemoveJar() throws ParseException {
    SqlCharStringLiteral jarPath;
    jj_consume_token(REMOVE);
    jj_consume_token(JAR);
    jj_consume_token(QUOTED_STRING);
        String path = SqlParserUtil.parseString(token.image);
        jarPath = SqlLiteral.createCharString(path, getPos());
        {if (true) return new SqlRemoveJar(getPos(), jarPath);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a show jars statement.
* SHOW JARS;
*/
  final public SqlShowJars SqlShowJars() throws ParseException {
    jj_consume_token(SHOW);
    jj_consume_token(JARS);
        {if (true) return new SqlShowJars(getPos());}
    throw new Error("Missing return statement in function");
  }

/*
* Parses a SET statement:
* SET ['key' = 'value'];
*/
  final public SqlNode SqlSet() throws ParseException {
    Span s;
    SqlNode key = null;
    SqlNode value = null;
    jj_consume_token(SET);
            s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      key = StringLiteral();
      jj_consume_token(EQ);
      value = StringLiteral();
      break;
    default:
      jj_la1[153] = jj_gen;
      ;
    }
        if (key == null && value == null) {
            {if (true) return new SqlSet(s.end(this));}
        } else {
            {if (true) return new SqlSet(s.end(this), key, value);}
        }
    throw new Error("Missing return statement in function");
  }

/**
* Parses a RESET statement:
* RESET ['key'];
*/
  final public SqlNode SqlReset() throws ParseException {
    Span span;
    SqlNode key = null;
    jj_consume_token(RESET);
              span = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      key = StringLiteral();
      break;
    default:
      jj_la1[154] = jj_gen;
      ;
    }
        {if (true) return new SqlReset(span.end(this), key);}
    throw new Error("Missing return statement in function");
  }

/** Parses a TRY_CAST invocation. */
  final public SqlNode TryCastFunctionCall() throws ParseException {
    final Span s;
    final SqlOperator operator;
    List<SqlNode> args = null;
    SqlNode e = null;
    jj_consume_token(TRY_CAST);
        s = span();
        operator = new SqlUnresolvedTryCastFunction(s.pos());
    jj_consume_token(LPAREN);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                       args = startList(e);
    jj_consume_token(AS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case ANY:
    case APPLY:
    case ARRAY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BIGINT:
    case BINARY:
    case BOOLEAN:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHARACTER:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DEC:
    case DECADE:
    case DECIMAL:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOUBLE:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FLOAT:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INT:
    case INTEGER:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case NUMERIC:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case REAL:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SMALLINT:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TINYINT:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VARBINARY:
    case VARCHAR:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BYTES:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case RAW:
    case REMOVE:
    case STOP:
    case STRING:
    case UNLOAD:
    case VIRTUAL:
    case TIMESTAMP_LTZ:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = DataType();
                         args.add(e);
      break;
    case INTERVAL:
      jj_consume_token(INTERVAL);
      e = IntervalQualifier();
                                             args.add(e);
      break;
    default:
      jj_la1[155] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
        {if (true) return operator.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a partition key/value,
* e.g. p or p = '10'.
*/
  final public SqlPartitionSpecProperty PartitionSpecProperty() throws ParseException {
    final SqlParserPos pos;
    final SqlIdentifier key;
    SqlNode value = null;
    key = SimpleIdentifier();
                               pos = getPos();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
      value = Literal();
      break;
    default:
      jj_la1[156] = jj_gen;
      ;
    }
        {if (true) return new SqlPartitionSpecProperty(key, value, pos);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a partition specifications statement,
* e.g. ANALYZE TABLE tbl1 partition(col1='val1', col2='val2') xxx
* or
* ANALYZE TABLE tbl1 partition(col1, col2) xxx.
* or
* ANALYZE TABLE tbl1 partition(col1='val1', col2) xxx.
*/
  final public void ExtendedPartitionSpecCommaList(SqlNodeList list) throws ParseException {
    SqlPartitionSpecProperty property;
    jj_consume_token(LPAREN);
    property = PartitionSpecProperty();
       list.add(property);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[157] = jj_gen;
        break label_23;
      }
      jj_consume_token(COMMA);
      property = PartitionSpecProperty();
            list.add(property);
    }
    jj_consume_token(RPAREN);
  }

/** Parses a comma-separated list of simple identifiers with position. */
  final public SqlNodeList SimpleIdentifierCommaListWithPosition() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
      s = span();
    AddSimpleIdentifiers(list);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** Parses an ANALYZE TABLE statement. */
  final public SqlNode SqlAnalyzeTable() throws ParseException {
       final Span s;
       final SqlIdentifier tableName;
       SqlNodeList partitionSpec = SqlNodeList.EMPTY;
       SqlNodeList columns = SqlNodeList.EMPTY;
       boolean allColumns = false;
    jj_consume_token(ANALYZE);
    jj_consume_token(TABLE);
                        s = span();
    tableName = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
            partitionSpec = new SqlNodeList(getPos());
            ExtendedPartitionSpecCommaList(partitionSpec);
      break;
    default:
      jj_la1[158] = jj_gen;
      ;
    }
    jj_consume_token(COMPUTE);
    jj_consume_token(STATISTICS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FOR:
      jj_consume_token(FOR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLUMNS:
        jj_consume_token(COLUMNS);
                       columns = SimpleIdentifierCommaListWithPosition();
        break;
      case ALL:
        jj_consume_token(ALL);
        jj_consume_token(COLUMNS);
                             allColumns = true;
        break;
      default:
        jj_la1[159] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[160] = jj_gen;
      ;
    }
        {if (true) return new SqlAnalyzeTable(s.end(this), tableName, partitionSpec, columns, allColumns);}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "SHOW JOBS" statement.
*/
  final public SqlShowJobs SqlShowJobs() throws ParseException {
    jj_consume_token(SHOW);
    jj_consume_token(JOBS);
        {if (true) return new SqlShowJobs(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a STOP JOB statement:
* STOP JOB <JOB_ID> [<WITH SAVEPOINT>] [<WITH DRAIN>];
*/
  final public SqlStopJob SqlStopJob() throws ParseException {
    SqlCharStringLiteral jobId;
    boolean isWithSavepoint = false;
    boolean isWithDrain = false;
    final Span span;
    jj_consume_token(STOP);
    jj_consume_token(JOB);
    jj_consume_token(QUOTED_STRING);
        String id = SqlParserUtil.parseString(token.image);
        jobId = SqlLiteral.createCharString(id, getPos());
    if (jj_2_60(2)) {
      jj_consume_token(WITH);
      jj_consume_token(SAVEPOINT);
            isWithSavepoint = true;
    } else {
      ;
    }
    if (jj_2_61(2)) {
      jj_consume_token(WITH);
            span = span();
      jj_consume_token(DRAIN);
            span.end(this);
            if (!isWithSavepoint) {
                {if (true) throw SqlUtil.newContextException(span.pos(),
                    ParserResource.RESOURCE.withDrainOnlyUsedWithSavepoint());}
            }
            isWithDrain = true;
    } else {
      ;
    }
        {if (true) return new SqlStopJob(getPos(), jobId, isWithSavepoint, isWithDrain);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a TRUNCATE TABLE statement.
 */
  final public SqlTruncateTable SqlTruncateTable() throws ParseException {
    SqlIdentifier sqlIdentifier;
    jj_consume_token(TRUNCATE);
    jj_consume_token(TABLE);
    sqlIdentifier = CompoundIdentifier();
        {if (true) return new SqlTruncateTable(getPos(), sqlIdentifier);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList ParenthesizedKeyValueOptionCommaList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
      s = span();
    jj_consume_token(LPAREN);
    AddKeyValueOption(list);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[161] = jj_gen;
        break label_24;
      }
      jj_consume_token(COMMA);
      AddKeyValueOption(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
* Parses an option with format key=val whose key is a simple identifier or string literal
* and value is a string literal.
*/
  final public void AddKeyValueOption(List<SqlNode> list) throws ParseException {
    final SqlNode key;
    final SqlNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      key = SimpleIdentifier();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      key = StringLiteral();
      break;
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(EQ);
    value = StringLiteral();
        list.add(key);
        list.add(value);
  }

/** Parses an option value (either a string or a numeric) and adds to a list. */
  final public void AddOptionValue(List<SqlNode> list) throws ParseException {
    final SqlNode value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case PLUS:
    case MINUS:
      value = NumericLiteral();
                                   list.add(value);
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      value = StringLiteral();
                                  list.add(value);
      break;
    default:
      jj_la1[163] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Parses a literal list separated by comma. The literal is either a string or a numeric.
 */
  final public SqlNodeList ParenthesizedLiteralOptionCommaList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
      s = span();
    jj_consume_token(LPAREN);
    AddOptionValue(list);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[164] = jj_gen;
        break label_25;
      }
      jj_consume_token(COMMA);
      AddOptionValue(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void AddHint(List<SqlNode> hints) throws ParseException {
    final SqlIdentifier hintName;
    final SqlNodeList hintOptions;
    final SqlHint.HintOptionFormat optionFormat;
    hintName = SimpleIdentifier();
    if (jj_2_62(5)) {
      hintOptions = ParenthesizedKeyValueOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.KV_LIST;
    } else if (jj_2_63(3)) {
      hintOptions = ParenthesizedSimpleIdentifierList();
            optionFormat = SqlHint.HintOptionFormat.ID_LIST;
    } else if (jj_2_64(3)) {
      hintOptions = ParenthesizedLiteralOptionCommaList();
            optionFormat = SqlHint.HintOptionFormat.LITERAL_LIST;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[165] = jj_gen;
        ;
      }
            hintOptions = SqlNodeList.EMPTY;
            optionFormat = SqlHint.HintOptionFormat.EMPTY;
    }
        hints.add(
           new SqlHint(Span.of(hintOptions).end(this), hintName, hintOptions,
               optionFormat));
  }

/** Parses hints following a table reference,
 * and returns the wrapped table reference. */
  final public SqlNode TableHints(SqlIdentifier tableName) throws ParseException {
    final List<SqlNode> hints = new ArrayList<SqlNode>();
    jj_consume_token(HINT_BEG);
    AddHint(hints);
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[166] = jj_gen;
        break label_26;
      }
      jj_consume_token(COMMA);
      AddHint(hints);
    }
    jj_consume_token(COMMENT_END);
        final SqlParserPos pos = Span.of(tableName).addAll(hints).end(this);
        final SqlNodeList hintList = new SqlNodeList(hints, pos);
        {if (true) return new SqlTableRef(pos, tableName, hintList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a leaf SELECT expression without ORDER BY.
 */
  final public SqlSelect SqlSelect() throws ParseException {
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlLiteral keyword;
    final SqlNodeList keywordList;
    final List<SqlNode> selectList = new ArrayList<SqlNode>();
    final SqlNode fromClause;
    final SqlNode where;
    final SqlNodeList groupBy;
    final SqlNode having;
    final SqlNodeList windowDecls;
    final List<SqlNode> hints = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(SELECT);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      jj_consume_token(HINT_BEG);
      AddHint(hints);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[167] = jj_gen;
          break label_27;
        }
        jj_consume_token(COMMA);
        AddHint(hints);
      }
      jj_consume_token(COMMENT_END);
      break;
    default:
      jj_la1[168] = jj_gen;
      ;
    }
    SqlSelectKeywords(keywords);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STREAM:
      jj_consume_token(STREAM);
            keywords.add(SqlSelectKeyword.STREAM.symbol(getPos()));
      break;
    default:
      jj_la1[169] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      keyword = AllOrDistinct();
                                    keywords.add(keyword);
      break;
    default:
      jj_la1[170] = jj_gen;
      ;
    }
        keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
    AddSelectItem(selectList);
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[171] = jj_gen;
        break label_28;
      }
      jj_consume_token(COMMA);
      AddSelectItem(selectList);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      fromClause = FromClause();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        where = Where();
        break;
      default:
        jj_la1[172] = jj_gen;
                              where = null;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GROUP:
        groupBy = GroupBy();
        break;
      default:
        jj_la1[173] = jj_gen;
                                  groupBy = null;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HAVING:
        having = Having();
        break;
      default:
        jj_la1[174] = jj_gen;
                                having = null;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WINDOW:
        windowDecls = Window();
        break;
      default:
        jj_la1[175] = jj_gen;
                                     windowDecls = null;
      }
      break;
    default:
      jj_la1[176] = jj_gen;
      E();
            fromClause = null;
            where = null;
            groupBy = null;
            having = null;
            windowDecls = null;
    }
        {if (true) return new SqlSelect(s.end(this), keywordList,
            new SqlNodeList(selectList, Span.of(selectList).pos()),
            fromClause, where, groupBy, having, windowDecls, null, null, null,
            new SqlNodeList(hints, getPos()));}
    throw new Error("Missing return statement in function");
  }

/*
 * Abstract production:
 *
 *    void SqlSelectKeywords(List keywords)
 *
 * Parses dialect-specific keywords immediately following the SELECT keyword.
 */

/**
 * Parses an EXPLAIN PLAN statement.
 */
  final public SqlNode SqlExplain() throws ParseException {
    SqlNode stmt;
    SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    SqlExplain.Depth depth;
    final SqlExplainFormat format;
    jj_consume_token(EXPLAIN);
    jj_consume_token(PLAN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLUDING:
    case INCLUDING:
      detailLevel = ExplainDetailLevel();
      break;
    default:
      jj_la1[177] = jj_gen;
      ;
    }
    depth = ExplainDepth();
    if (jj_2_65(2)) {
      jj_consume_token(AS);
      jj_consume_token(XML);
                     format = SqlExplainFormat.XML;
    } else if (jj_2_66(2)) {
      jj_consume_token(AS);
      jj_consume_token(JSON);
                      format = SqlExplainFormat.JSON;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        jj_consume_token(DOT_FORMAT);
                            format = SqlExplainFormat.DOT;
        break;
      default:
        jj_la1[178] = jj_gen;
          format = SqlExplainFormat.TEXT;
      }
    }
    jj_consume_token(FOR);
    stmt = SqlQueryOrDml();
        {if (true) return new SqlExplain(getPos(),
            stmt,
            detailLevel.symbol(SqlParserPos.ZERO),
            depth.symbol(SqlParserPos.ZERO),
            format.symbol(SqlParserPos.ZERO),
            nDynamicParams);}
    throw new Error("Missing return statement in function");
  }

/** Parses a query (SELECT or VALUES)
 * or DML statement (INSERT, UPDATE, DELETE, MERGE). */
  final public SqlNode SqlQueryOrDml() throws ParseException {
    SqlNode stmt;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      stmt = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
      break;
    case INSERT:
    case UPSERT:
      stmt = SqlInsert();
      break;
    case DELETE:
      stmt = SqlDelete();
      break;
    case UPDATE:
      stmt = SqlUpdate();
      break;
    case MERGE:
      stmt = SqlMerge();
      break;
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return stmt;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses WITH TYPE | WITH IMPLEMENTATION | WITHOUT IMPLEMENTATION modifier for
 * EXPLAIN PLAN.
 */
  final public SqlExplain.Depth ExplainDepth() throws ParseException {
    if (jj_2_67(2)) {
      jj_consume_token(WITH);
      jj_consume_token(TYPE);
            {if (true) return SqlExplain.Depth.TYPE;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(IMPLEMENTATION);
            {if (true) return SqlExplain.Depth.PHYSICAL;}
        break;
      case WITHOUT:
        jj_consume_token(WITHOUT);
        jj_consume_token(IMPLEMENTATION);
            {if (true) return SqlExplain.Depth.LOGICAL;}
        break;
      default:
        jj_la1[180] = jj_gen;
            {if (true) return SqlExplain.Depth.PHYSICAL;}
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses INCLUDING ALL ATTRIBUTES modifier for EXPLAIN PLAN.
 */
  final public SqlExplainLevel ExplainDetailLevel() throws ParseException {
    SqlExplainLevel level = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXCLUDING:
      jj_consume_token(EXCLUDING);
      jj_consume_token(ATTRIBUTES);
            level = SqlExplainLevel.NO_ATTRIBUTES;
      break;
    case INCLUDING:
      jj_consume_token(INCLUDING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                  level = SqlExplainLevel.ALL_ATTRIBUTES;
        break;
      default:
        jj_la1[181] = jj_gen;
        ;
      }
      jj_consume_token(ATTRIBUTES);

      break;
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return level;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a DESCRIBE statement.
 */
  final public SqlNode SqlDescribe() throws ParseException {
   final Span s;
   final SqlIdentifier table;
   final SqlIdentifier column;
   final SqlIdentifier id;
   final SqlNode stmt;
    jj_consume_token(DESCRIBE);
                 s = span();
    if (jj_2_68(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATABASE:
        jj_consume_token(DATABASE);
        break;
      case CATALOG:
        jj_consume_token(CATALOG);
        break;
      case SCHEMA:
        jj_consume_token(SCHEMA);
        break;
      default:
        jj_la1[183] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      id = CompoundIdentifier();
            // DESCRIBE DATABASE and DESCRIBE CATALOG currently do the same as
            // DESCRIBE SCHEMA but should be different. See
            //   [CALCITE-1221] Implement DESCRIBE DATABASE, CATALOG, STATEMENT
            {if (true) return new SqlDescribeSchema(s.end(id), id);}
    } else if (jj_2_69(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TABLE:
        jj_consume_token(TABLE);
        break;
      default:
        jj_la1[184] = jj_gen;
        ;
      }
      table = CompoundIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        column = SimpleIdentifier();
        break;
      default:
        jj_la1[185] = jj_gen;
                                          column = null;
      }
            {if (true) return new SqlDescribeTable(s.add(table).addIf(column).pos(),
                table, column);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DELETE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSERT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MERGE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELECT:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STATEMENT:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPDATE:
      case UPPER:
      case UPSERT:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VALUES:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WITH:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STATEMENT:
          jj_consume_token(STATEMENT);
          break;
        default:
          jj_la1[186] = jj_gen;
          ;
        }
        stmt = SqlQueryOrDml();
            // DESCRIBE STATEMENT currently does the same as EXPLAIN. See
            //   [CALCITE-1221] Implement DESCRIBE DATABASE, CATALOG, STATEMENT
            final SqlExplainLevel detailLevel = SqlExplainLevel.EXPPLAN_ATTRIBUTES;
            final SqlExplain.Depth depth = SqlExplain.Depth.PHYSICAL;
            final SqlExplainFormat format = SqlExplainFormat.TEXT;
            {if (true) return new SqlExplain(s.end(stmt),
                stmt,
                detailLevel.symbol(SqlParserPos.ZERO),
                depth.symbol(SqlParserPos.ZERO),
                format.symbol(SqlParserPos.ZERO),
                nDynamicParams);}
        break;
      default:
        jj_la1[187] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CALL statement.
 */
  final public SqlNode SqlProcedureCall() throws ParseException {
    final Span s;
    SqlNode routineCall;
    jj_consume_token(CALL);
        s = span();
    routineCall = NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_PROCEDURE,
            ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.PROCEDURE_CALL.createCall(
            s.end(routineCall), routineCall);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode NamedRoutineCall(SqlFunctionCategory routineType,
    ExprContext exprContext) throws ParseException {
    final SqlIdentifier name;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    name = CompoundIdentifier();
        s = span();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULT_:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELECT:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VALUES:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WITH:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      AddArg0(list, exprContext);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[188] = jj_gen;
          break label_29;
        }
        jj_consume_token(COMMA);
                // a comma-list can't appear where only a query is expected
                checkNonQueryExpression(exprContext);
        AddArg(list, exprContext);
      }
      break;
    default:
      jj_la1[189] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return createCall(name, s.end(this), routineType, null, list);}
    throw new Error("Missing return statement in function");
  }

/**
 * Table parameter of a table function.
 * The input table with set semantics may be partitioned/ordered on one or more columns.
 */
  final public SqlNode TableParam() throws ParseException {
    final Span s;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
    SqlNode tableRef;
      s = span();
    tableRef = ExplicitTable(getPos());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      jj_consume_token(BY);
      partitionList = SimpleIdentifierOrList();
      break;
    default:
      jj_la1[190] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderByOfSetSemanticsTable();
      break;
    default:
      jj_la1[191] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
      {if (true) return CreateSetSemanticsTableIfNeeded(s, tableRef, partitionList, orderList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PartitionedQueryOrQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    e = OrderedQueryOrExpr(exprContext);
    e = PartitionedByAndOrderBy(e);
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PartitionedByAndOrderBy(SqlNode e) throws ParseException {
    final Span s;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
      s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
      jj_consume_token(BY);
      partitionList = SimpleIdentifierOrList();
      break;
    default:
      jj_la1[192] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderByOfSetSemanticsTable();
      break;
    default:
      jj_la1[193] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
      {if (true) return CreateSetSemanticsTableIfNeeded(s, e, partitionList, orderList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList OrderByOfSetSemanticsTable() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(ORDER);
    s = span();
    jj_consume_token(BY);
    if (jj_2_71(2)) {
      jj_consume_token(LPAREN);
      AddOrderItem(list);
      label_30:
      while (true) {
        if (jj_2_70(2)) {
          ;
        } else {
          break label_30;
        }
        jj_consume_token(COMMA);
        AddOrderItem(list);
      }
      jj_consume_token(RPAREN);
          {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        AddOrderItem(list);
          {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
        break;
      default:
        jj_la1[194] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlNode CreateSetSemanticsTableIfNeeded(final Span s,
    final SqlNode e,
    final SqlNodeList partitionList,
    final SqlNodeList orderList) throws ParseException {
        if (partitionList.isEmpty() && orderList.isEmpty()) {
            {if (true) return e;}
        } else {
            {if (true) return SqlStdOperatorTable.SET_SEMANTICS_TABLE.createCall(
                s.pos(), e, partitionList, orderList);}
        }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an INSERT statement.
 */
  final public SqlNode SqlInsert() throws ParseException {
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlNodeList keywordList;
    final SqlIdentifier tableName;
    SqlNode tableRef;
    SqlNode source;
    final SqlNodeList columnList;
    final Span s;
    final Pair<SqlNodeList, SqlNodeList> p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INSERT:
      jj_consume_token(INSERT);
      break;
    case UPSERT:
      jj_consume_token(UPSERT);
                   keywords.add(SqlInsertKeyword.UPSERT.symbol(getPos()));
      break;
    default:
      jj_la1[195] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, s.addAll(keywords).pos());
    jj_consume_token(INTO);
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[196] = jj_gen;
                                           tableRef = tableName;
    }
    if (jj_2_72(5)) {
      tableRef = ExtendTable(tableRef);
    } else {
      ;
    }
    if (jj_2_73(2)) {
      p = ParenthesizedCompoundIdentifierList();
            if (p.right.size() > 0) {
                tableRef = extend(tableRef, p.right);
            }
            if (p.left.size() > 0) {
                columnList = p.left;
            } else {
                columnList = null;
            }
    } else {
          columnList = null;
    }
    source = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
        {if (true) return new SqlInsert(s.end(source), keywordList, tableRef, source,
            columnList);}
    throw new Error("Missing return statement in function");
  }

/*
 * Abstract production:
 *
 *    void SqlInsertKeywords(List keywords)
 *
 * Parses dialect-specific keywords immediately following the INSERT keyword.
 */

/**
 * Parses a DELETE statement.
 */
  final public SqlNode SqlDelete() throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final SqlNode where;
    final Span s;
    jj_consume_token(DELETE);
        s = span();
    jj_consume_token(FROM);
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[197] = jj_gen;
                                           tableRef = tableName;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      tableRef = ExtendTable(tableRef);
      break;
    default:
      jj_la1[198] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[199] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[200] = jj_gen;
                                              alias = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where = Where();
      break;
    default:
      jj_la1[201] = jj_gen;
                          where = null;
    }
        {if (true) return new SqlDelete(s.add(tableRef).addIf(alias).addIf(where).pos(),
            tableRef, where, null, alias);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an UPDATE statement.
 */
  final public SqlNode SqlUpdate() throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final SqlNode where;
    final SqlNodeList sourceExpressionList;
    final SqlNodeList targetColumnList;
    SqlIdentifier id;
    final Span s;
    jj_consume_token(UPDATE);
        s = span();
        targetColumnList = new SqlNodeList(s.pos());
        sourceExpressionList = new SqlNodeList(s.pos());
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[202] = jj_gen;
                                           tableRef = tableName;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      tableRef = ExtendTable(tableRef);
      break;
    default:
      jj_la1[203] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[204] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[205] = jj_gen;
                                              alias = null;
    }
    jj_consume_token(SET);
    id = SimpleIdentifier();
        targetColumnList.add(id);
    jj_consume_token(EQ);
    AddExpression(sourceExpressionList, ExprContext.ACCEPT_SUB_QUERY);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[206] = jj_gen;
        break label_31;
      }
      jj_consume_token(COMMA);
      id = SimpleIdentifier();
                                  targetColumnList.add(id);
      jj_consume_token(EQ);
      AddExpression(sourceExpressionList, ExprContext.ACCEPT_SUB_QUERY);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      where = Where();
      break;
    default:
      jj_la1[207] = jj_gen;
                          where = null;
    }
        final SqlParserPos pos = s.addAll(targetColumnList)
            .addAll(sourceExpressionList).addIf(where).pos();
        {if (true) return new SqlUpdate(pos, tableRef, targetColumnList,
            sourceExpressionList, where, null, alias);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a MERGE statement.
 */
  final public SqlNode SqlMerge() throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final SqlNode sourceTableRef;
    final SqlNode condition;
    final SqlUpdate updateCall;
    final SqlInsert insertCall;
    final Span s;
    jj_consume_token(MERGE);
              s = span();
    jj_consume_token(INTO);
    tableName = CompoundTableIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HINT_BEG:
      tableRef = TableHints(tableName);
      break;
    default:
      jj_la1[208] = jj_gen;
                                           tableRef = tableName;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
    case LPAREN:
      tableRef = ExtendTable(tableRef);
      break;
    default:
      jj_la1[209] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[210] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      break;
    default:
      jj_la1[211] = jj_gen;
                                              alias = null;
    }
    jj_consume_token(USING);
    sourceTableRef = TableRef();
    jj_consume_token(ON);
    condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
    if (jj_2_74(2)) {
      updateCall = WhenMatchedClause(tableRef, alias);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        insertCall = WhenNotMatchedClause(tableRef);
        break;
      default:
        jj_la1[212] = jj_gen;
                                                          insertCall = null;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
          updateCall = null;
        insertCall = WhenNotMatchedClause(tableRef);
        break;
      default:
        jj_la1[213] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        final SqlParserPos pos = s.addIf(updateCall).addIf(insertCall).pos();
        {if (true) return new SqlMerge(pos, tableRef, condition, sourceTableRef,
            updateCall, insertCall, null, alias);}
    throw new Error("Missing return statement in function");
  }

  final public SqlUpdate WhenMatchedClause(SqlNode table, SqlIdentifier alias) throws ParseException {
    SqlIdentifier id;
    final Span s;
    final SqlNodeList updateColumnList = new SqlNodeList(SqlParserPos.ZERO);
    final SqlNodeList updateExprList = new SqlNodeList(SqlParserPos.ZERO);
    jj_consume_token(WHEN);
             s = span();
    jj_consume_token(MATCHED);
    jj_consume_token(THEN);
    jj_consume_token(UPDATE);
    jj_consume_token(SET);
    id = CompoundIdentifier();
        updateColumnList.add(id);
    jj_consume_token(EQ);
    AddExpression(updateExprList, ExprContext.ACCEPT_SUB_QUERY);
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[214] = jj_gen;
        break label_32;
      }
      jj_consume_token(COMMA);
      id = CompoundIdentifier();
            updateColumnList.add(id);
      jj_consume_token(EQ);
      AddExpression(updateExprList, ExprContext.ACCEPT_SUB_QUERY);
    }
        {if (true) return new SqlUpdate(s.addAll(updateExprList).pos(), table,
            updateColumnList, updateExprList, null, null, alias);}
    throw new Error("Missing return statement in function");
  }

  final public SqlInsert WhenNotMatchedClause(SqlNode table) throws ParseException {
    final Span insertSpan, valuesSpan;
    final List<SqlLiteral> keywords = new ArrayList<SqlLiteral>();
    final SqlNodeList keywordList;
    final SqlNodeList insertColumnList;
    SqlNode rowConstructor;
    SqlNode insertValues;
    jj_consume_token(WHEN);
    jj_consume_token(NOT);
    jj_consume_token(MATCHED);
    jj_consume_token(THEN);
    jj_consume_token(INSERT);
        insertSpan = span();
    SqlInsertKeywords(keywords);
        keywordList = new SqlNodeList(keywords, insertSpan.end(this));
    if (jj_2_75(2)) {
      insertColumnList = ParenthesizedSimpleIdentifierList();
    } else {
          insertColumnList = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      jj_consume_token(VALUES);
                   valuesSpan = span();
      rowConstructor = RowConstructor();
      jj_consume_token(RPAREN);
      break;
    case VALUES:
      jj_consume_token(VALUES);
                   valuesSpan = span();
      rowConstructor = RowConstructor();
      break;
    default:
      jj_la1[215] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        // TODO zfong 5/26/06: note that extra parentheses are accepted above
        // around the VALUES clause as a hack for unparse, but this is
        // actually invalid SQL; should fix unparse
        insertValues = SqlStdOperatorTable.VALUES.createCall(
            valuesSpan.end(this), rowConstructor);
        {if (true) return new SqlInsert(insertSpan.end(this), keywordList,
            table, insertValues, insertColumnList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one item in a select list.
 */
  final public void AddSelectItem(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlIdentifier id;
    e = SelectExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case QUOTED_STRING:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[216] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        id = SimpleIdentifier();
        break;
      case QUOTED_STRING:
        id = SimpleIdentifierFromStringLiteral();
        break;
      default:
        jj_la1[217] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          list.add(SqlStdOperatorTable.AS.createCall(span().end(e), e, id));
      break;
    default:
      jj_la1[218] = jj_gen;
          list.add(e);
    }
  }

/**
 * Parses one unaliased expression in a select list.
 */
  final public SqlNode SelectExpression() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
        {if (true) return SqlIdentifier.star(getPos());}
      break;
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return e;}
      break;
    default:
      jj_la1[219] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral Natural() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NATURAL:
      jj_consume_token(NATURAL);
                {if (true) return SqlLiteral.createBoolean(true, getPos());}
      break;
    default:
      jj_la1[220] = jj_gen;
      {if (true) return SqlLiteral.createBoolean(false, getPos());}
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral JoinType() throws ParseException {
    JoinType joinType;
    if (jj_2_76(3)) {
      jj_consume_token(JOIN);
                 joinType = JoinType.INNER;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INNER:
        jj_consume_token(INNER);
        jj_consume_token(JOIN);
                         joinType = JoinType.INNER;
        break;
      case LEFT:
        jj_consume_token(LEFT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[221] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                    joinType = JoinType.LEFT;
        break;
      case RIGHT:
        jj_consume_token(RIGHT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[222] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                     joinType = JoinType.RIGHT;
        break;
      case FULL:
        jj_consume_token(FULL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER:
          jj_consume_token(OUTER);
          break;
        default:
          jj_la1[223] = jj_gen;
          ;
        }
        jj_consume_token(JOIN);
                                    joinType = JoinType.FULL;
        break;
      case CROSS:
        jj_consume_token(CROSS);
        jj_consume_token(JOIN);
                         joinType = JoinType.CROSS;
        break;
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return joinType.symbol(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the FROM clause for a SELECT.
 *
 * <p>FROM is mandatory in standard SQL, optional in dialects such as MySQL,
 * PostgreSQL. The parser allows SELECT without FROM, but the validator fails
 * if conformance is, say, STRICT_2003.
 */
  final public SqlNode FromClause() throws ParseException {
    SqlNode e, e2;
    SqlLiteral joinType;
    e = Join();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[225] = jj_gen;
        break label_33;
      }
      jj_consume_token(COMMA);
                  joinType = JoinType.COMMA.symbol(getPos());
      e2 = Join();
            e = new SqlJoin(joinType.getParserPosition(),
                e,
                SqlLiteral.createBoolean(false, joinType.getParserPosition()),
                joinType,
                e2,
                JoinConditionType.NONE.symbol(SqlParserPos.ZERO),
                null);
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode Join() throws ParseException {
    SqlNode e;
    e = TableRef1(ExprContext.ACCEPT_QUERY_OR_JOIN);
    label_34:
    while (true) {
      if (jj_2_77(2)) {
        ;
      } else {
        break label_34;
      }
      e = JoinTable(e);
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Matches "LEFT JOIN t ON ...", "RIGHT JOIN t USING ...", "JOIN t". */
  final public SqlNode JoinTable(SqlNode e) throws ParseException {
    SqlNode e2, condition;
    final SqlLiteral natural, joinType, on, using;
    SqlNodeList list;
    if (jj_2_78(3)) {
      natural = Natural();
      joinType = JoinType();
      e2 = TableRef1(ExprContext.ACCEPT_QUERY_OR_JOIN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        jj_consume_token(ON);
               on = JoinConditionType.ON.symbol(getPos());
        condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                on,
                condition);}
        break;
      case USING:
        jj_consume_token(USING);
                  using = JoinConditionType.USING.symbol(getPos());
        list = ParenthesizedSimpleIdentifierList();
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                using,
                new SqlNodeList(list, Span.of(using).end(this)));}
        break;
      default:
        jj_la1[226] = jj_gen;
            {if (true) return new SqlJoin(joinType.getParserPosition(),
                e,
                natural,
                joinType,
                e2,
                JoinConditionType.NONE.symbol(joinType.getParserPosition()),
                null);}
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CROSS:
        jj_consume_token(CROSS);
              joinType = JoinType.CROSS.symbol(getPos());
        jj_consume_token(APPLY);
        e2 = TableRef2(true);
        if (!this.conformance.isApplyAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.applyNotAllowed());}
        }
        {if (true) return new SqlJoin(joinType.getParserPosition(),
            e,
            SqlLiteral.createBoolean(false, joinType.getParserPosition()),
            joinType,
            e2,
            JoinConditionType.NONE.symbol(SqlParserPos.ZERO),
            null);}
        break;
      case OUTER:
        jj_consume_token(OUTER);
              joinType = JoinType.LEFT.symbol(getPos());
        jj_consume_token(APPLY);
        e2 = TableRef2(true);
        if (!this.conformance.isApplyAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.applyNotAllowed());}
        }
        {if (true) return new SqlJoin(joinType.getParserPosition(),
            e,
            SqlLiteral.createBoolean(false, joinType.getParserPosition()),
            joinType,
            e2,
            JoinConditionType.ON.symbol(SqlParserPos.ZERO),
            SqlLiteral.createBoolean(true, joinType.getParserPosition()));}
        break;
      default:
        jj_la1[227] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a table reference in a FROM clause, not lateral unless LATERAL
 * is explicitly specified.
 */
  final public SqlNode TableRef() throws ParseException {
    final SqlNode e;
    e = TableRef3(ExprContext.ACCEPT_QUERY, false);
                                                     {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode TableRef1(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    e = TableRef3(exprContext, false);
                                        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a table reference in a FROM clause.
 */
  final public SqlNode TableRef2(boolean lateral) throws ParseException {
    final SqlNode e;
    e = TableRef3(ExprContext.ACCEPT_QUERY, lateral);
                                                       {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode TableRef3(ExprContext exprContext, boolean lateral) throws ParseException {
    final SqlIdentifier tableName;
    SqlNode tableRef;
    final SqlIdentifier alias;
    final Span s;
    SqlNodeList args;
    final SqlNodeList columnAliasList;
    SqlUnnestOperator unnestOp = SqlStdOperatorTable.UNNEST;
    if (jj_2_79(2)) {
      tableName = CompoundTableIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HINT_BEG:
        tableRef = TableHints(tableName);
        break;
      default:
        jj_la1[228] = jj_gen;
                                               tableRef = tableName;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTEND:
      case LPAREN:
        tableRef = ExtendTable(tableRef);
        break;
      default:
        jj_la1[229] = jj_gen;
        ;
      }
      tableRef = Over(tableRef);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        tableRef = Snapshot(tableRef);
        break;
      default:
        jj_la1[230] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH_RECOGNIZE:
        tableRef = MatchRecognize(tableRef);
        break;
      default:
        jj_la1[231] = jj_gen;
        ;
      }
    } else if (jj_2_80(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LATERAL:
        jj_consume_token(LATERAL);
                      lateral = true;
        break;
      default:
        jj_la1[232] = jj_gen;
        ;
      }
      tableRef = ParenthesizedExpression(exprContext);
      tableRef = Over(tableRef);
      tableRef = addLateral(tableRef, lateral);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MATCH_RECOGNIZE:
        tableRef = MatchRecognize(tableRef);
        break;
      default:
        jj_la1[233] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNNEST:
        jj_consume_token(UNNEST);
                   s = span();
        args = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_SUB_QUERY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          jj_consume_token(ORDINALITY);
                unnestOp = SqlStdOperatorTable.UNNEST_WITH_ORDINALITY;
          break;
        default:
          jj_la1[234] = jj_gen;
          ;
        }
            tableRef = unnestOp.createCall(s.end(this), (List<SqlNode>) args);
        break;
      case LATERAL:
      case TABLE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LATERAL:
          jj_consume_token(LATERAL);
                      lateral = true;
          break;
        default:
          jj_la1[235] = jj_gen;
          ;
        }
        tableRef = TableFunctionCall();
        tableRef = addLateral(tableRef, lateral);
        break;
      default:
        jj_la1[236] = jj_gen;
        if (jj_2_81(1)) {
          tableRef = ExtendedTableRef();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    if (jj_2_82(2)) {
      tableRef = Pivot(tableRef);
    } else {
      ;
    }
    if (jj_2_83(2)) {
      tableRef = Unpivot(tableRef);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[237] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        columnAliasList = ParenthesizedSimpleIdentifierList();
        break;
      default:
        jj_la1[238] = jj_gen;
              columnAliasList = null;
      }
            // Standard SQL (and Postgres) allow applying "AS alias" to a JOIN,
            // e.g. "FROM (a CROSS JOIN b) AS c". The new alias obscures the
            // internal aliases, and columns cannot be referenced if they are
            // not unique. TODO: Support this behavior; see
            // [CALCITE-5168] Allow AS after parenthesized JOIN
            checkNotJoin(tableRef);
            if (columnAliasList == null) {
                tableRef = SqlStdOperatorTable.AS.createCall(
                    Span.of(tableRef).end(this), tableRef, alias);
            } else {
                List<SqlNode> idList = new ArrayList<SqlNode>();
                idList.add(tableRef);
                idList.add(alias);
                idList.addAll(columnAliasList.getList());
                tableRef = SqlStdOperatorTable.AS.createCall(
                    Span.of(tableRef).end(this), idList);
            }
      break;
    default:
      jj_la1[239] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TABLESAMPLE:
      tableRef = Tablesample(tableRef);
      break;
    default:
      jj_la1[240] = jj_gen;
      ;
    }
      {if (true) return tableRef;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode Tablesample(SqlNode tableRef) throws ParseException {
    final Span s;
    final SqlNode sample;
    final boolean isBernoulli;
    final SqlNumericLiteral samplePercentage;
    boolean isRepeatable = false;
    int repeatableSeed = 0;
    jj_consume_token(TABLESAMPLE);
                    s = span(); checkNotJoin(tableRef);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBSTITUTE:
      jj_consume_token(SUBSTITUTE);
      jj_consume_token(LPAREN);
      sample = StringLiteral();
      jj_consume_token(RPAREN);
            String sampleName =
                SqlLiteral.unchain(sample).getValueAs(String.class);
            SqlSampleSpec sampleSpec = SqlSampleSpec.createNamed(sampleName);
            final SqlLiteral sampleLiteral =
                SqlLiteral.createSample(sampleSpec, s.end(this));
            tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(
                s.add(tableRef).end(this), tableRef, sampleLiteral);
      break;
    case BERNOULLI:
    case SYSTEM:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BERNOULLI:
        jj_consume_token(BERNOULLI);
                          isBernoulli = true;
        break;
      case SYSTEM:
        jj_consume_token(SYSTEM);
                       isBernoulli = false;
        break;
      default:
        jj_la1[241] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LPAREN);
      samplePercentage = UnsignedNumericLiteral();
      jj_consume_token(RPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REPEATABLE:
        jj_consume_token(REPEATABLE);
        jj_consume_token(LPAREN);
        repeatableSeed = IntLiteral();
        jj_consume_token(RPAREN);
                isRepeatable = true;
        break;
      default:
        jj_la1[242] = jj_gen;
        ;
      }
            final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
            BigDecimal rate = samplePercentage.bigDecimalValue();
            if (rate.compareTo(BigDecimal.ZERO) < 0
                || rate.compareTo(ONE_HUNDRED) > 0)
            {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.invalidSampleSize());}
            }

            // Treat TABLESAMPLE(0) and TABLESAMPLE(100) as no table
            // sampling at all.  Not strictly correct: TABLESAMPLE(0)
            // should produce no output, but it simplifies implementation
            // to know that some amount of sampling will occur.
            // In practice values less than ~1E-43% are treated as 0.0 and
            // values greater than ~99.999997% are treated as 1.0
            float fRate = rate.divide(ONE_HUNDRED).floatValue();
            if (fRate > 0.0f && fRate < 1.0f) {
                SqlSampleSpec tableSampleSpec =
                    isRepeatable
                        ? SqlSampleSpec.createTableSample(
                            isBernoulli, fRate, repeatableSeed)
                        : SqlSampleSpec.createTableSample(isBernoulli, fRate);

                SqlLiteral tableSampleLiteral =
                    SqlLiteral.createSample(tableSampleSpec, s.end(this));
                tableRef = SqlStdOperatorTable.TABLESAMPLE.createCall(
                    s.end(this), tableRef, tableSampleLiteral);
            }
      break;
    default:
      jj_la1[243] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return tableRef;}
    throw new Error("Missing return statement in function");
  }

/** Wraps a table reference in a call to EXTEND if an optional "EXTEND" clause
 * is present. */
  final public SqlNode ExtendTable(SqlNode tableRef) throws ParseException {
    final SqlNodeList extendList;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTEND:
      jj_consume_token(EXTEND);
      break;
    default:
      jj_la1[244] = jj_gen;
      ;
    }
    extendList = ExtendList();
        {if (true) return extend(tableRef, extendList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList ExtendList() throws ParseException {
    final Span s;
    List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    AddColumnType(list);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[245] = jj_gen;
        break label_35;
      }
      jj_consume_token(COMMA);
      AddColumnType(list);
    }
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void AddColumnType(List<SqlNode> list) throws ParseException {
    final SqlIdentifier name;
    final SqlDataTypeSpec type;
    final boolean nullable;
    name = CompoundIdentifier();
    type = DataType();
    nullable = NotNullOpt();
        list.add(name);
        list.add(type.withNullable(nullable, getPos()));
  }

/**
 * Parses a compound identifier with optional type.
 */
  final public void AddCompoundIdentifierType(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
    final SqlIdentifier name;
    final SqlDataTypeSpec type;
    final boolean nullable;
    name = CompoundIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case ANY:
    case APPLY:
    case ARRAY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BIGINT:
    case BINARY:
    case BOOLEAN:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHARACTER:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DEC:
    case DECADE:
    case DECIMAL:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOUBLE:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FLOAT:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INT:
    case INTEGER:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case NUMERIC:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case REAL:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SMALLINT:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TINYINT:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VARBINARY:
    case VARCHAR:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case BYTES:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case RAW:
    case REMOVE:
    case STOP:
    case STRING:
    case UNLOAD:
    case VIRTUAL:
    case TIMESTAMP_LTZ:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      type = DataType();
      nullable = NotNullOpt();
      break;
    default:
      jj_la1[246] = jj_gen;
          type = null; nullable = true;
    }
        if (type != null) {
            if (!this.conformance.allowExtend()) {
                {if (true) throw SqlUtil.newContextException(type.getParserPosition(),
                    RESOURCE.extendNotAllowed());}
            }
            extendList.add(name);
            extendList.add(type.withNullable(nullable, getPos()));
        }
        list.add(name);
  }

  final public SqlNode TableFunctionCall() throws ParseException {
    final Span s;
    final SqlNode call;
    SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION;
    jj_consume_token(TABLE);
              s = span();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPECIFIC:
      jj_consume_token(SPECIFIC);
            funcType = SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION;
      break;
    default:
      jj_la1[247] = jj_gen;
      ;
    }
    call = NamedRoutineCall(funcType, ExprContext.ACCEPT_CURSOR);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.COLLECTION_TABLE.createCall(s.end(this), call);}
    throw new Error("Missing return statement in function");
  }

/**
 * Abstract production:
 *    SqlNode ExtendedTableRef()
 *
 * <p>Allows parser to be extended with new types of table references.  The
 * default implementation of this production is empty.
 */

/*
 * Abstract production:
 *
 *    SqlNode TableOverOpt()
 *
 * Allows an OVER clause following a table expression as an extension to
 * standard SQL syntax. The default implementation of this production is empty.
 */

/**
 * Parses an explicit TABLE t reference.
 */
  final public SqlNode ExplicitTable(SqlParserPos pos) throws ParseException {
    SqlNode tableRef;
    jj_consume_token(TABLE);
    tableRef = CompoundIdentifier();
        {if (true) return SqlStdOperatorTable.EXPLICIT_TABLE.createCall(pos, tableRef);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a VALUES leaf query expression.
 */
  final public SqlNode TableConstructor() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(VALUES);
               s = span();
    AddRowConstructor(list);
    label_36:
    while (true) {
      if (jj_2_84(2)) {
        ;
      } else {
        break label_36;
      }
      jj_consume_token(COMMA);
      AddRowConstructor(list);
    }
        {if (true) return SqlStdOperatorTable.VALUES.createCall(s.end(this), list);}
    throw new Error("Missing return statement in function");
  }

/** Parses a row constructor and adds it to a list. */
  final public void AddRowConstructor(List<SqlNode> list) throws ParseException {
    SqlNode e;
    e = RowConstructor();
                           list.add(e);
  }

/**
 * Parses a row constructor in the context of a VALUES expression.
 */
  final public SqlNode RowConstructor() throws ParseException {
    final SqlNodeList valueList;
    final SqlNode value;
    final Span s;
    if (jj_2_85(3)) {
      jj_consume_token(LPAREN);
                   s = span();
      jj_consume_token(ROW);
      valueList = ParenthesizedQueryOrCommaListWithDefault(ExprContext.ACCEPT_NONCURSOR);
      jj_consume_token(RPAREN);
                   s.add(this);
    } else if (jj_2_86(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        jj_consume_token(ROW);
                    s = span();
        break;
      default:
        jj_la1[248] = jj_gen;
              s = Span.of();
      }
      valueList = ParenthesizedQueryOrCommaListWithDefault(ExprContext.ACCEPT_NONCURSOR);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        value = Expression(ExprContext.ACCEPT_NONCURSOR);
            // NOTE: A bare value here is standard SQL syntax, believe it or
            // not.  Taken together with multi-row table constructors, it leads
            // to very easy mistakes if you forget the parentheses on a
            // single-row constructor.  This is also the reason for the
            // LOOKAHEAD in TableConstructor().  It would be so much more
            // reasonable to require parentheses.  Sigh.
            s = Span.of(value);
            valueList = new SqlNodeList(ImmutableList.of(value),
                value.getParserPosition());
        break;
      default:
        jj_la1[249] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        // REVIEW jvs 8-Feb-2004: Should we discriminate between scalar
        // sub-queries inside of ROW and row sub-queries?  The standard does,
        // but the distinction seems to be purely syntactic.
        {if (true) return SqlStdOperatorTable.ROW.createCall(s.end(valueList),
            (List<SqlNode>) valueList);}
    throw new Error("Missing return statement in function");
  }

/** Parses a WHERE clause for SELECT, DELETE, and UPDATE. */
  final public SqlNode Where() throws ParseException {
    SqlNode condition;
    jj_consume_token(WHERE);
    condition = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return condition;}
    throw new Error("Missing return statement in function");
  }

/** Parses a GROUP BY clause for SELECT. */
  final public SqlNodeList GroupBy() throws ParseException {
    final List<SqlNode> list;
    final boolean distinct;
    final Span s;
    jj_consume_token(GROUP);
              s = span();
    jj_consume_token(BY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                     distinct = true;
      break;
    case ALL:
      jj_consume_token(ALL);
                distinct = false;
      break;
    default:
      jj_la1[250] = jj_gen;
          distinct = false;
    }
    list = GroupingElementList();
        final SqlParserPos pos = s.end(this);
        final List<SqlNode> list2 = distinct
            ? ImmutableList.of(
                SqlInternalOperators.GROUP_BY_DISTINCT.createCall(pos, list))
            : list;
        {if (true) return new SqlNodeList(list2, pos);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> GroupingElementList() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddGroupingElement(list);
    label_37:
    while (true) {
      if (jj_2_87(2)) {
        ;
      } else {
        break label_37;
      }
      jj_consume_token(COMMA);
      AddGroupingElement(list);
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public void AddGroupingElement(List<SqlNode> list) throws ParseException {
    final List<SqlNode> subList;
    final SqlNodeList nodes;
    final Span s;
    if (jj_2_88(2)) {
      jj_consume_token(GROUPING);
                 s = span();
      jj_consume_token(SETS);
      jj_consume_token(LPAREN);
      subList = GroupingElementList();
      jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.GROUPING_SETS.createCall(s.end(this), subList));
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROLLUP:
        jj_consume_token(ROLLUP);
               s = span();
        jj_consume_token(LPAREN);
        nodes = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.ROLLUP.createCall(s.end(this), nodes.getList()));
        break;
      case CUBE:
        jj_consume_token(CUBE);
             s = span();
        jj_consume_token(LPAREN);
        nodes = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.CUBE.createCall(s.end(this), nodes.getList()));
        break;
      default:
        jj_la1[251] = jj_gen;
        if (jj_2_89(3)) {
          jj_consume_token(LPAREN);
               s = span();
          jj_consume_token(RPAREN);
        list.add(new SqlNodeList(s.end(this)));
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case A:
          case ABS:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ARRAY:
          case ARRAY_AGG:
          case ARRAY_CONCAT_AGG:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case AVG:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CARDINALITY:
          case CASCADE:
          case CASE:
          case CAST:
          case CATALOG:
          case CATALOG_NAME:
          case CEIL:
          case CEILING:
          case CENTURY:
          case CHAIN:
          case CHAR:
          case CHAR_LENGTH:
          case CHARACTER_LENGTH:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASSIFIER:
          case CLASS_ORIGIN:
          case COALESCE:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLLECT:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CONVERT:
          case COUNT:
          case COVAR_POP:
          case COVAR_SAMP:
          case CUME_DIST:
          case CURRENT:
          case CURRENT_CATALOG:
          case CURRENT_DATE:
          case CURRENT_DEFAULT_TRANSFORM_GROUP:
          case CURRENT_PATH:
          case CURRENT_ROLE:
          case CURRENT_SCHEMA:
          case CURRENT_TIME:
          case CURRENT_TIMESTAMP:
          case CURRENT_USER:
          case CURSOR:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATE:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DENSE_RANK:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ELEMENT:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EVERY:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case EXISTS:
          case EXP:
          case EXTRACT:
          case FALSE:
          case FINAL:
          case FIRST:
          case FIRST_VALUE:
          case FLOOR:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case FUSION:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case GROUP_CONCAT:
          case GROUPING:
          case HIERARCHY:
          case HOP:
          case HOUR:
          case HOURS:
          case IGNORE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INTERSECTION:
          case INTERVAL:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case JSON_ARRAY:
          case JSON_ARRAYAGG:
          case JSON_EXISTS:
          case JSON_OBJECT:
          case JSON_OBJECTAGG:
          case JSON_QUERY:
          case JSON_VALUE:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAG:
          case LAST:
          case LAST_VALUE:
          case LEAD:
          case LEFT:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LN:
          case LOCALTIME:
          case LOCALTIMESTAMP:
          case LOCATOR:
          case LOWER:
          case M:
          case MAP:
          case MATCHED:
          case MATCH_NUMBER:
          case MAX:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MIN:
          case MINUTE:
          case MINUTES:
          case MINVALUE:
          case MOD:
          case MONTH:
          case MONTHS:
          case MORE_:
          case MULTISET:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NEW:
          case NEXT:
          case NORMALIZED:
          case NOT:
          case NTH_VALUE:
          case NTILE:
          case NULL:
          case NULLABLE:
          case NULLIF:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTET_LENGTH:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERLAY:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PERCENTILE_CONT:
          case PERCENTILE_DISC:
          case PERCENT_RANK:
          case PERIOD:
          case PLACING:
          case PLAN:
          case PLI:
          case POSITION:
          case POWER:
          case PRECEDING:
          case PRESERVE:
          case PREV:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case RANK:
          case READ:
          case REGR_COUNT:
          case REGR_SXX:
          case REGR_SYY:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case RIGHT:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW:
          case ROW_COUNT:
          case ROW_NUMBER:
          case RUNNING:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECOND:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SESSION_USER:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOME:
          case SOURCE:
          case SPACE:
          case SPECIFIC:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case SQRT:
          case STATE:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case STRING_AGG:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case SUBSTRING:
          case SUM:
          case SYSTEM_USER:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIME:
          case TIMESTAMP:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRANSLATE:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TRIM:
          case TRUE:
          case TRUNCATE:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNIQUE:
          case UNKNOWN:
          case UNNAMED:
          case UPPER:
          case USAGE:
          case USER:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VAR_POP:
          case VAR_SAMP:
          case VERSION:
          case VIEW:
          case WEEK:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEAR:
          case YEARS:
          case ZONE:
          case CHANGELOG_MODE:
          case COMPACT:
          case COMPILE:
          case COLUMNS:
          case DRAIN:
          case ENFORCED:
          case ESTIMATED_COST:
          case IF:
          case JSON_EXECUTION_PLAN:
          case PLAN_ADVICE:
          case JAR:
          case JARS:
          case JOB:
          case JOBS:
          case LOAD:
          case METADATA:
          case OVERWRITE:
          case OVERWRITING:
          case PARTITIONED:
          case PARTITIONS:
          case PYTHON:
          case REMOVE:
          case STOP:
          case UNLOAD:
          case VIRTUAL:
          case TRY_CAST:
          case ANALYZE:
          case COMPUTE:
          case STATISTICS:
          case UNSIGNED_INTEGER_LITERAL:
          case APPROX_NUMERIC_LITERAL:
          case DECIMAL_NUMERIC_LITERAL:
          case BINARY_STRING_LITERAL:
          case QUOTED_STRING:
          case PREFIXED_STRING_LITERAL:
          case UNICODE_STRING_LITERAL:
          case BIG_QUERY_DOUBLE_QUOTED_STRING:
          case BIG_QUERY_QUOTED_STRING:
          case LPAREN:
          case LBRACE_D:
          case LBRACE_T:
          case LBRACE_TS:
          case LBRACE_FN:
          case HOOK:
          case PLUS:
          case MINUS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            AddExpression(list, ExprContext.ACCEPT_SUB_QUERY);
            break;
          default:
            jj_la1[252] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

/**
 * Parses a list of expressions separated by commas.
 */
  final public SqlNodeList ExpressionCommaList(final Span s,
    ExprContext exprContext) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddExpressions(list, exprContext);
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a list of expressions separated by commas,
 * appending expressions to a given list.
 */
  final public void AddExpressions(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    AddExpression(list, exprContext);
    label_38:
    while (true) {
      if (jj_2_90(2)) {
        ;
      } else {
        break label_38;
      }
      jj_consume_token(COMMA);
      AddExpression(list, ExprContext.ACCEPT_SUB_QUERY);
    }
  }

/** Parses a HAVING clause for SELECT. */
  final public SqlNode Having() throws ParseException {
    SqlNode e;
    jj_consume_token(HAVING);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
                                                            {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a WINDOW clause for SELECT. */
  final public SqlNodeList Window() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(WINDOW);
               s = span();
    AddWindowSpec(list);
    label_39:
    while (true) {
      if (jj_2_91(2)) {
        ;
      } else {
        break label_39;
      }
      jj_consume_token(COMMA);
      AddWindowSpec(list);
    }
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

  final public void AddWindowSpec(List<SqlNode> list) throws ParseException {
    final SqlIdentifier id;
    final SqlWindow e;
    id = SimpleIdentifier();
    jj_consume_token(AS);
    e = WindowSpecification();
        e.setDeclName(id);
        list.add(e);
  }

/**
 * Parses a window specification.
 */
  final public SqlWindow WindowSpecification() throws ParseException {
    final SqlIdentifier id;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
    final SqlLiteral isRows;
    final SqlNode lowerBound, upperBound;
    final Span s, s1, s2;
    final SqlLiteral allowPartial;
    jj_consume_token(LPAREN);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      id = SimpleIdentifier();
      break;
    default:
      jj_la1[253] = jj_gen;
          id = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
                      s1 = span();
      jj_consume_token(BY);
      partitionList = ExpressionCommaList(s1, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[254] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderBy(true);
      break;
    default:
      jj_la1[255] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RANGE:
    case ROWS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROWS:
        jj_consume_token(ROWS);
                     isRows = SqlLiteral.createBoolean(true, getPos());
        break;
      case RANGE:
        jj_consume_token(RANGE);
                      isRows = SqlLiteral.createBoolean(false, getPos());
        break;
      default:
        jj_la1[256] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BETWEEN:
        jj_consume_token(BETWEEN);
        lowerBound = WindowRange();
        jj_consume_token(AND);
        upperBound = WindowRange();
        break;
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        lowerBound = WindowRange();
              upperBound = null;
        break;
      default:
        jj_la1[257] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[258] = jj_gen;
            isRows = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
            lowerBound = upperBound = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALLOW:
      jj_consume_token(ALLOW);
                  s2 = span();
      jj_consume_token(PARTIAL);
            allowPartial = SqlLiteral.createBoolean(true, s2.end(this));
      break;
    case DISALLOW:
      jj_consume_token(DISALLOW);
                     s2 = span();
      jj_consume_token(PARTIAL);
            allowPartial = SqlLiteral.createBoolean(false, s2.end(this));
      break;
    default:
      jj_la1[259] = jj_gen;
          allowPartial = null;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlWindow.create(null, id, partitionList, orderList,
            isRows, lowerBound, upperBound, allowPartial, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode WindowRange() throws ParseException {
    final SqlNode e;
    final Span s;
    if (jj_2_92(2)) {
      jj_consume_token(CURRENT);
                s = span();
      jj_consume_token(ROW);
        {if (true) return SqlWindow.createCurrentRow(s.end(this));}
    } else if (jj_2_93(2)) {
      jj_consume_token(UNBOUNDED);
                  s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECEDING:
        jj_consume_token(PRECEDING);
            {if (true) return SqlWindow.createUnboundedPreceding(s.end(this));}
        break;
      case FOLLOWING:
        jj_consume_token(FOLLOWING);
            {if (true) return SqlWindow.createUnboundedFollowing(s.end(this));}
        break;
      default:
        jj_la1[260] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = Expression(ExprContext.ACCEPT_NON_QUERY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRECEDING:
          jj_consume_token(PRECEDING);
            {if (true) return SqlWindow.createPreceding(e, getPos());}
          break;
        case FOLLOWING:
          jj_consume_token(FOLLOWING);
            {if (true) return SqlWindow.createFollowing(e, getPos());}
          break;
        default:
          jj_la1[261] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[262] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an ORDER BY clause.
 */
  final public SqlNodeList OrderBy(boolean accept) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(ORDER);
        s = span();
        if (!accept) {
            // Someone told us ORDER BY wasn't allowed here.  So why
            // did they bother calling us?  To get the correct
            // parser position for error reporting.
            {if (true) throw SqlUtil.newContextException(s.pos(), RESOURCE.illegalOrderBy());}
        }
    jj_consume_token(BY);
    AddOrderItem(list);
    label_40:
    while (true) {
      if (jj_2_94(2)) {
        ;
      } else {
        break label_40;
      }
      jj_consume_token(COMMA);
      AddOrderItem(list);
    }
        {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one item in an ORDER BY clause, and adds it to a list.
 */
  final public void AddOrderItem(List<SqlNode> list) throws ParseException {
    SqlNode e;
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASC:
    case DESC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASC:
        jj_consume_token(ASC);
        break;
      case DESC:
        jj_consume_token(DESC);
            e = SqlStdOperatorTable.DESC.createCall(getPos(), e);
        break;
      default:
        jj_la1[263] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[264] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULLS:
      if (jj_2_95(2)) {
        jj_consume_token(NULLS);
        jj_consume_token(FIRST);
            e = SqlStdOperatorTable.NULLS_FIRST.createCall(getPos(), e);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULLS:
          jj_consume_token(NULLS);
          jj_consume_token(LAST);
            e = SqlStdOperatorTable.NULLS_LAST.createCall(getPos(), e);
          break;
        default:
          jj_la1[265] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[266] = jj_gen;
      ;
    }
        list.add(e);
  }

/** Wraps a table reference in a call to OVER if an optional "OVER" clause
 * is present (if the dialect supports OVER for table expressions). */
  final public SqlNode Over(SqlNode tableRef) throws ParseException {
    final SqlNode over;
    over = TableOverOpt();
        if (over != null) {
            {if (true) return SqlStdOperatorTable.OVER.createCall(
                getPos(), checkNotJoin(tableRef), over);}
        } else {
            {if (true) return tableRef;}
        }
    throw new Error("Missing return statement in function");
  }

  SqlNode addLateral(SqlNode tableRef, boolean lateral) throws ParseException {
    return lateral
        ? SqlStdOperatorTable.LATERAL.createCall(getPos(),
            checkNotJoin(tableRef))
        : tableRef;
  }

/**
 * Parses a FOR SYSTEM_TIME clause following a table expression.
 */
  final public SqlSnapshot Snapshot(SqlNode tableRef) throws ParseException {
    final Span s;
    final SqlNode e;
      s = span();
    jj_consume_token(FOR);
    jj_consume_token(SYSTEM_TIME);
    jj_consume_token(AS);
    jj_consume_token(OF);
    // Syntax for temporal table in
        // standard SQL 2011 IWD 9075-2:201?(E) 7.6 <table reference>
        // supports grammar as following:
        // 1. datetime literal
        // 2. datetime value function, i.e. CURRENT_TIMESTAMP
        // 3. datetime term in 1 or 2 +(or -) interval term
    
        // We extend to support column reference, use Expression
        // to simplify the parsing code.
        e = Expression(ExprContext.ACCEPT_NON_QUERY);
        {if (true) return new SqlSnapshot(s.end(this), tableRef, e);}
    throw new Error("Missing return statement in function");
  }

/** Parses a PIVOT clause following a table expression. */
  final public SqlNode Pivot(SqlNode tableRef) throws ParseException {
    final Span s;
    final Span s2;
    final List<SqlNode> aggList = new ArrayList<SqlNode>();
    final List<SqlNode> valueList = new ArrayList<SqlNode>();
    final SqlNodeList axisList;
    final SqlNodeList inList;
    jj_consume_token(PIVOT);
              s = span(); checkNotJoin(tableRef);
    jj_consume_token(LPAREN);
    AddPivotAgg(aggList);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[267] = jj_gen;
        break label_41;
      }
      jj_consume_token(COMMA);
      AddPivotAgg(aggList);
    }
    jj_consume_token(FOR);
    axisList = SimpleIdentifierOrList();
    jj_consume_token(IN);
    jj_consume_token(LPAREN);
                    s2 = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      AddPivotValue(valueList);
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[268] = jj_gen;
          break label_42;
        }
        jj_consume_token(COMMA);
        AddPivotValue(valueList);
      }
      break;
    default:
      jj_la1[269] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        inList = new SqlNodeList(valueList, s2.end(this));
    jj_consume_token(RPAREN);
        {if (true) return new SqlPivot(s.end(this), tableRef,
            new SqlNodeList(aggList, SqlParserPos.sum(aggList)),
            axisList, inList);}
    throw new Error("Missing return statement in function");
  }

  final public void AddPivotAgg(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlIdentifier alias;
    e = NamedFunctionCall();
    if (getToken(1).kind != COMMA && getToken(1).kind != FOR) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[270] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e,
                    alias));
    } else {
          list.add(e);
    }
  }

  final public void AddPivotValue(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlNodeList tuple;
    final SqlIdentifier alias;
    e = RowConstructor();
                           tuple = SqlParserUtil.stripRow(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case AS:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        jj_consume_token(AS);
        break;
      default:
        jj_la1[271] = jj_gen;
        ;
      }
      alias = SimpleIdentifier();
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(tuple).end(this),
                    tuple, alias));
      break;
    default:
      jj_la1[272] = jj_gen;
          list.add(tuple);
    }
  }

/** Parses an UNPIVOT clause following a table expression. */
  final public SqlNode Unpivot(SqlNode tableRef) throws ParseException {
    final Span s;
    final boolean includeNulls;
    final SqlNodeList measureList;
    final SqlNodeList axisList;
    final Span s2;
    final List<SqlNode> values = new ArrayList<SqlNode>();
    final SqlNodeList inList;
    jj_consume_token(UNPIVOT);
                s = span(); checkNotJoin(tableRef);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INCLUDE:
      jj_consume_token(INCLUDE);
      jj_consume_token(NULLS);
                            includeNulls = true;
      break;
    case EXCLUDE:
      jj_consume_token(EXCLUDE);
      jj_consume_token(NULLS);
                            includeNulls = false;
      break;
    default:
      jj_la1[273] = jj_gen;
          includeNulls = false;
    }
    jj_consume_token(LPAREN);
    measureList = SimpleIdentifierOrList();
    jj_consume_token(FOR);
    axisList = SimpleIdentifierOrList();
    jj_consume_token(IN);
    jj_consume_token(LPAREN);
               s2 = span();
    AddUnpivotValue(values);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[274] = jj_gen;
        break label_43;
      }
      jj_consume_token(COMMA);
      AddUnpivotValue(values);
    }
    jj_consume_token(RPAREN);
      inList = new SqlNodeList(values, s2.end(this));
    jj_consume_token(RPAREN);
        {if (true) return new SqlUnpivot(s.end(this), tableRef, includeNulls, measureList,
            axisList, inList);}
    throw new Error("Missing return statement in function");
  }

  final public void AddUnpivotValue(List<SqlNode> list) throws ParseException {
    final SqlNodeList columnList;
    final SqlNode values;
    columnList = SimpleIdentifierOrList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      values = RowConstructor();
            final SqlNodeList valueList = SqlParserUtil.stripRow(values);
            list.add(
                SqlStdOperatorTable.AS.createCall(Span.of(columnList).end(this),
                    columnList, valueList));
      break;
    default:
      jj_la1[275] = jj_gen;
          list.add(columnList);
    }
  }

/**
 * Parses a MATCH_RECOGNIZE clause following a table expression.
 */
  final public SqlMatchRecognize MatchRecognize(SqlNode tableRef) throws ParseException {
    final Span s, s0, s1, s2;
    final SqlNodeList measureList;
    final SqlNodeList partitionList;
    final SqlNodeList orderList;
    final SqlNode pattern;
    final SqlLiteral interval;
    final SqlNodeList patternDefList;
    final SqlNode after;
    final SqlNode var;
    final SqlLiteral rowsPerMatch;
    final SqlNodeList subsetList;
    final SqlLiteral isStrictStarts;
    final SqlLiteral isStrictEnds;
    jj_consume_token(MATCH_RECOGNIZE);
                        s = span(); checkNotJoin(tableRef);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARTITION:
      jj_consume_token(PARTITION);
                      s2 = span();
      jj_consume_token(BY);
      partitionList = ExpressionCommaList(s2, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[276] = jj_gen;
          partitionList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = OrderBy(true);
      break;
    default:
      jj_la1[277] = jj_gen;
          orderList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MEASURES:
      jj_consume_token(MEASURES);
      measureList = MeasureColumnCommaList(span());
      break;
    default:
      jj_la1[278] = jj_gen;
          measureList = SqlNodeList.EMPTY;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ONE:
      jj_consume_token(ONE);
                s0 = span();
      jj_consume_token(ROW);
      jj_consume_token(PER);
      jj_consume_token(MATCH);
            rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ONE_ROW.symbol(s0.end(this));
      break;
    case ALL:
      jj_consume_token(ALL);
                s0 = span();
      jj_consume_token(ROWS);
      jj_consume_token(PER);
      jj_consume_token(MATCH);
            rowsPerMatch = SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS.symbol(s0.end(this));
      break;
    default:
      jj_la1[279] = jj_gen;
          rowsPerMatch = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AFTER:
      jj_consume_token(AFTER);
                  s1 = span();
      jj_consume_token(MATCH);
      jj_consume_token(SKIP_);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TO:
        jj_consume_token(TO);
        if (jj_2_97(2)) {
          jj_consume_token(NEXT);
          jj_consume_token(ROW);
                    after = SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW
                        .symbol(s1.end(this));
        } else if (jj_2_98(2)) {
          jj_consume_token(FIRST);
          var = SimpleIdentifier();
                    after = SqlMatchRecognize.SKIP_TO_FIRST.createCall(
                        s1.end(var), var);
        } else if (true) {
          if (jj_2_96(2)) {
            jj_consume_token(LAST);
          } else {
            ;
          }
          var = SimpleIdentifier();
                    after = SqlMatchRecognize.SKIP_TO_LAST.createCall(
                        s1.end(var), var);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case PAST:
        jj_consume_token(PAST);
        jj_consume_token(LAST);
        jj_consume_token(ROW);
                 after = SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW
                     .symbol(s1.end(this));
        break;
      default:
        jj_la1[280] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[281] = jj_gen;
          after = null;
    }
    jj_consume_token(PATTERN);
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CARET:
      jj_consume_token(CARET);
                  isStrictStarts = SqlLiteral.createBoolean(true, getPos());
      break;
    default:
      jj_la1[282] = jj_gen;
          isStrictStarts = SqlLiteral.createBoolean(false, getPos());
    }
    pattern = PatternExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      jj_consume_token(DOLLAR);
                   isStrictEnds = SqlLiteral.createBoolean(true, getPos());
      break;
    default:
      jj_la1[283] = jj_gen;
          isStrictEnds = SqlLiteral.createBoolean(false, getPos());
    }
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      jj_consume_token(WITHIN);
      interval = IntervalLiteral();
      break;
    default:
      jj_la1[284] = jj_gen;
          interval = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBSET:
      jj_consume_token(SUBSET);
      subsetList = SubsetDefinitionCommaList(span());
      break;
    default:
      jj_la1[285] = jj_gen;
          subsetList = SqlNodeList.EMPTY;
    }
    jj_consume_token(DEFINE);
    patternDefList = PatternDefinitionCommaList(span());
    jj_consume_token(RPAREN);
        {if (true) return new SqlMatchRecognize(s.end(this), tableRef,
            pattern, isStrictStarts, isStrictEnds, patternDefList, measureList,
            after, subsetList, rowsPerMatch, partitionList, orderList, interval);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList MeasureColumnCommaList(Span s) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddMeasureColumn(list);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[286] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
      AddMeasureColumn(list);
    }
      {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

  final public void AddMeasureColumn(List<SqlNode> list) throws ParseException {
    final SqlNode e;
    final SqlIdentifier alias;
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(AS);
    alias = SimpleIdentifier();
        list.add(SqlStdOperatorTable.AS.createCall(Span.of(e).end(this), e, alias));
  }

  final public SqlNode PatternExpression() throws ParseException {
    SqlNode left;
    SqlNode right;
    left = PatternTerm();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VERTICAL_BAR:
        ;
        break;
      default:
        jj_la1[287] = jj_gen;
        break label_45;
      }
      jj_consume_token(VERTICAL_BAR);
      right = PatternTerm();
            left = SqlStdOperatorTable.PATTERN_ALTER.createCall(
                Span.of(left).end(right), left, right);
    }
        {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternTerm() throws ParseException {
    SqlNode left;
    SqlNode right;
    left = PatternFactor();
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERMUTE:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case LPAREN:
      case LBRACE:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        ;
        break;
      default:
        jj_la1[288] = jj_gen;
        break label_46;
      }
      right = PatternFactor();
            left = SqlStdOperatorTable.PATTERN_CONCAT.createCall(
                Span.of(left).end(right), left, right);
    }
        {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternFactor() throws ParseException {
    final SqlNode e;
    final SqlNode extra;
    final SqlLiteral startNum;
    final SqlLiteral endNum;
    final SqlLiteral reluctant;
    e = PatternPrimary();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case HOOK:
    case PLUS:
    case STAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
                startNum = LITERAL_ZERO;
                endNum = LITERAL_MINUS_ONE;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                startNum = LITERAL_ONE;
                endNum = LITERAL_MINUS_ONE;
        break;
      case HOOK:
        jj_consume_token(HOOK);
                startNum = LITERAL_ZERO;
                endNum = LITERAL_ONE;
        break;
      case LBRACE:
        jj_consume_token(LBRACE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
          startNum = UnsignedNumericLiteral();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case UNSIGNED_INTEGER_LITERAL:
            case APPROX_NUMERIC_LITERAL:
            case DECIMAL_NUMERIC_LITERAL:
              endNum = UnsignedNumericLiteral();
              break;
            default:
              jj_la1[289] = jj_gen;
                          endNum = LITERAL_MINUS_ONE;
            }
            break;
          default:
            jj_la1[290] = jj_gen;
                       endNum = startNum;
          }
          jj_consume_token(RBRACE);
          break;
        case COMMA:
          jj_consume_token(COMMA);
          endNum = UnsignedNumericLiteral();
          jj_consume_token(RBRACE);
                  startNum = LITERAL_MINUS_ONE;
          break;
        case MINUS:
          jj_consume_token(MINUS);
          extra = PatternExpression();
          jj_consume_token(MINUS);
          jj_consume_token(RBRACE);
                    {if (true) return SqlStdOperatorTable.PATTERN_CONCAT.createCall(
                        Span.of(e).end(this), e,
                        SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(
                            Span.of(extra).end(this), extra));}
          break;
        default:
          jj_la1[291] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[292] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOOK:
        jj_consume_token(HOOK);
                reluctant = SqlLiteral.createBoolean(
                    startNum.intValue(true) != endNum.intValue(true),
                    SqlParserPos.ZERO);
        break;
      default:
        jj_la1[293] = jj_gen;
              reluctant = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
      }
      break;
    default:
      jj_la1[294] = jj_gen;
          {if (true) return e;}
    }
        {if (true) return SqlStdOperatorTable.PATTERN_QUANTIFIER.createCall(
            span().end(e), e, startNum, endNum, reluctant);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternPrimary() throws ParseException {
    final Span s;
    SqlNode e;
    final List<SqlNode> list;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = SimpleIdentifier();
                             {if (true) return e;}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      e = PatternExpression();
      jj_consume_token(RPAREN);
                                                {if (true) return e;}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
               s = span();
      jj_consume_token(MINUS);
      e = PatternExpression();
      jj_consume_token(MINUS);
      jj_consume_token(RBRACE);
        {if (true) return SqlStdOperatorTable.PATTERN_EXCLUDE.createCall(s.end(this), e);}
      break;
    case PERMUTE:
      jj_consume_token(PERMUTE);
                    s = span(); list = new ArrayList<SqlNode>();
      jj_consume_token(LPAREN);
      e = PatternExpression();
                                  list.add(e);
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[295] = jj_gen;
          break label_47;
        }
        jj_consume_token(COMMA);
        e = PatternExpression();
                                            list.add(e);
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.PATTERN_PERMUTE.createCall(
                s.end(this), list);}
      break;
    default:
      jj_la1[296] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList SubsetDefinitionCommaList(Span s) throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    AddSubsetDefinition(list);
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[297] = jj_gen;
        break label_48;
      }
      jj_consume_token(COMMA);
      AddSubsetDefinition(list);
    }
      {if (true) return new SqlNodeList(list, s.addAll(list).pos());}
    throw new Error("Missing return statement in function");
  }

  final public void AddSubsetDefinition(List<SqlNode> list) throws ParseException {
    final SqlNode var;
    final SqlNodeList varList;
    var = SimpleIdentifier();
    jj_consume_token(EQ);
    jj_consume_token(LPAREN);
    varList = ExpressionCommaList(span(), ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(RPAREN);
        list.add(
            SqlStdOperatorTable.EQUALS.createCall(span().end(var), var,
                varList));
  }

  final public SqlNodeList PatternDefinitionCommaList(Span s) throws ParseException {
    SqlNode e;
    final List<SqlNode> eList = new ArrayList<SqlNode>();
    e = PatternDefinition();
        eList.add(e);
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[298] = jj_gen;
        break label_49;
      }
      jj_consume_token(COMMA);
      e = PatternDefinition();
            eList.add(e);
    }
        {if (true) return new SqlNodeList(eList, s.addAll(eList).pos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode PatternDefinition() throws ParseException {
    final SqlNode var;
    final SqlNode e;
    var = SimpleIdentifier();
    jj_consume_token(AS);
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.AS.createCall(Span.of(var, e).pos(), e, var);}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// Expressions

/**
 * Parses a SQL expression (such as might occur in a WHERE clause) followed by
 * the end-of-file symbol.
 */
  final public SqlNode SqlExpressionEof() throws ParseException {
    SqlNode e;
    e = Expression(ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(0);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses either a row expression or a query expression without ORDER BY.
 *
 * <p>Examples of valid queries:
 * <ul>
 * <li>{@code SELECT c FROM t}
 * <li>{@code SELECT c} (valid in some dialects)
 * <li>{@code SELECT c FROM t UNION SELECT c2 FROM t2}
 * <li>{@code WITH q AS (SELECT 1) SELECT * FROM q}
 * <li>{@code VALUES (1, 2)}
 * <li>{@code TABLE t}
 * </ul>
 *
 * <p>Non-examples:
 * <ul>
 * <li>{@code emp CROSS JOIN dept}
 * <li>{@code SELECT c FROM t ORDER BY c}
 * <li>{@code (SELECT c FROM t)}
 * </ul>
 */
  final public SqlNode QueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNodeList withList = null;
    final SqlNode e;
    final List<Object> list = new ArrayList<Object>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      withList = WithList();
      break;
    default:
      jj_la1[299] = jj_gen;
      ;
    }
    e = LeafQueryOrExpr(exprContext);
                                       list.add(e);
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
      case INTERSECT:
      case SET_MINUS:
      case UNION:
        ;
        break;
      default:
        jj_la1[300] = jj_gen;
        break label_50;
      }
      AddSetOpQuery(list, exprContext);
    }
      {if (true) return addWith(withList, SqlParserUtil.toTree(list));}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode Query(ExprContext exprContext) throws ParseException {
    SqlNodeList withList = null;
    final SqlNode e;
    final List<Object> list = new ArrayList<Object>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      withList = WithList();
      break;
    default:
      jj_la1[301] = jj_gen;
      ;
    }
    e = LeafQuery(exprContext);
                                 list.add(e);
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
      case INTERSECT:
      case SET_MINUS:
      case UNION:
        ;
        break;
      default:
        jj_la1[302] = jj_gen;
        break label_51;
      }
      AddSetOpQuery(list, exprContext);
    }
      {if (true) return addWith(withList, SqlParserUtil.toTree(list));}
    throw new Error("Missing return statement in function");
  }

  SqlNode addWith(SqlNodeList withList, SqlNode e) throws ParseException {
    return withList == null
        ? e
        : new SqlWith(withList.getParserPosition(), withList, e);
  }

/** Parses a set operator (e.g. UNION or INTERSECT)
 * followed by a query or expression,
 * and adds both to {@code list}. */
  final public void AddSetOpQueryOrExpr(List<Object> list, ExprContext exprContext) throws ParseException {
    final SqlOperator op;
    final SqlParserPos pos;
    final SqlNode e;
        if (list.size() == 1 && !((SqlNode) list.get(0)).isA(SqlKind.QUERY)) {
            // whoops, expression we just parsed wasn't a query,
            // but we're about to see something like UNION, so
            // force an exception retroactively
            checkNonQueryExpression(ExprContext.ACCEPT_QUERY);
        }
    op = BinaryQueryOperator();
        // ensure a query is legal in this context
        pos = getPos();
        checkQueryExpression(exprContext);
    e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
  }

/** Parses a set operator (e.g. UNION or INTERSECT)
 * followed by a query,
 * and adds both to {@code list}. */
  final public void AddSetOpQuery(List<Object> list, ExprContext exprContext) throws ParseException {
    final SqlOperator op;
    final SqlParserPos pos;
    final SqlNode e;
        if (list.size() == 1 && !((SqlNode) list.get(0)).isA(SqlKind.QUERY)) {
            // whoops, expression we just parsed wasn't a query,
            // but we're about to see something like UNION, so
            // force an exception retroactively
            checkNonQueryExpression(ExprContext.ACCEPT_QUERY);
        }
    op = BinaryQueryOperator();
        // ensure a query is legal in this context
        pos = getPos();
        checkQueryExpression(exprContext);
    e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
        list.add(new SqlParserUtil.ToTreeListItem(op, pos));
        list.add(e);
  }

  final public SqlNodeList WithList() throws ParseException {
    final Span s;
    final List<SqlWithItem> list = new ArrayList<SqlWithItem>();
    jj_consume_token(WITH);
             s = span();
    AddWithItem(list);
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[303] = jj_gen;
        break label_52;
      }
      jj_consume_token(COMMA);
      AddWithItem(list);
    }
      {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

  final public void AddWithItem(List<SqlWithItem> list) throws ParseException {
    final SqlIdentifier id;
    final SqlNodeList columnList;
    final SqlNode definition;
    id = SimpleIdentifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      columnList = ParenthesizedSimpleIdentifierList();
      break;
    default:
      jj_la1[304] = jj_gen;
                                                           columnList = null;
    }
    jj_consume_token(AS);
    definition = ParenthesizedExpression(ExprContext.ACCEPT_QUERY);
      list.add(new SqlWithItem(id.getParserPosition(), id, columnList, definition));
  }

/**
 * Parses either a row expression, a leaf query expression, or
 * a parenthesized expression of any kind.
 */
  final public SqlNode LeafQueryOrExpr(ExprContext exprContext) throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      e = Expression(exprContext);
                                  {if (true) return e;}
      break;
    case SELECT:
    case TABLE:
    case VALUES:
      e = LeafQuery(exprContext);
                                 {if (true) return e;}
      break;
    default:
      jj_la1[305] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** As {@link #Expression} but appends to a list. */
  final public void AddExpression(List<SqlNode> list, ExprContext exprContext) throws ParseException {
    final SqlNode e;
    e = Expression(exprContext);
                                  list.add(e);
  }

/**
 * Parses a row expression or a parenthesized expression of any kind.
 */
  final public SqlNode Expression(ExprContext exprContext) throws ParseException {
    final List<Object> list;
    list = Expression2(exprContext);
                                      {if (true) return SqlParserUtil.toTree(list);}
    throw new Error("Missing return statement in function");
  }

  final public void AddExpression2b(List<Object> list, ExprContext exprContext) throws ParseException {
    SqlNode e;
    SqlOperator op;
    SqlNode ext;
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXISTS:
      case NOT:
      case UNIQUE:
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[306] = jj_gen;
        break label_53;
      }
      op = PrefixRowOperator();
            checkNonQueryExpression(exprContext);
            list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
    }
    e = Expression3(exprContext);
        list.add(e);
    label_54:
    while (true) {
      if (jj_2_99(2)) {
        ;
      } else {
        break label_54;
      }
      jj_consume_token(DOT);
      ext = RowExpressionExtension();
            list.add(
                new SqlParserUtil.ToTreeListItem(
                    SqlStdOperatorTable.DOT, getPos()));
            list.add(ext);
    }
  }

/**
 * Parses a binary row expression, or a parenthesized expression of any
 * kind.
 *
 * <p>The result is as a flat list of operators and operands. The top-level
 * call to get an expression should call {@link #Expression}, but lower-level
 * calls should call this, to give the parser the opportunity to associate
 * operator calls.
 *
 * <p>For example 'a = b like c = d' should come out '((a = b) like c) = d'
 * because LIKE and '=' have the same precedence, but tends to come out as '(a
 * = b) like (c = d)' because (a = b) and (c = d) are parsed as separate
 * expressions.
 */
  final public List<Object> Expression2(ExprContext exprContext) throws ParseException {
    final List<Object> list = new ArrayList();
    List<Object> list2;
    final List<Object> list3 = new ArrayList();
    SqlNodeList nodeList;
    SqlNode e;
    SqlOperator op;
    SqlIdentifier p;
    final Span s = span();
    AddExpression2b(list, exprContext);
    if (jj_2_107(2)) {
      label_55:
      while (true) {
        if (jj_2_102(2)) {
                    checkNonQueryExpression(exprContext);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            jj_consume_token(IN);
                                 op = SqlStdOperatorTable.NOT_IN;
            break;
          case IN:
            jj_consume_token(IN);
                           op = SqlStdOperatorTable.IN;
            break;
          case EQ:
          case GT:
          case LT:
          case LE:
          case GE:
          case NE:
          case NE2:
                      final SqlKind k;
            k = comp();
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SOME:
              jj_consume_token(SOME);
                                 op = SqlStdOperatorTable.some(k);
              break;
            case ANY:
              jj_consume_token(ANY);
                                op = SqlStdOperatorTable.some(k);
              break;
            case ALL:
              jj_consume_token(ALL);
                                op = SqlStdOperatorTable.all(k);
              break;
            default:
              jj_la1[307] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[308] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                  s.clear().add(this);
          nodeList = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_NONCURSOR);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    s.add(nodeList);
                    // special case for stuff like IN (s1 UNION s2)
                    if (nodeList.size() == 1) {
                        SqlNode item = nodeList.get(0);
                        if (item.isA(SqlKind.QUERY)) {
                            list.add(item);
                        } else {
                            list.add(nodeList);
                        }
                    } else {
                        list.add(nodeList);
                    }
        } else if (jj_2_103(2)) {
                    checkNonQueryExpression(exprContext);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            jj_consume_token(BETWEEN);
                        op = SqlStdOperatorTable.NOT_BETWEEN;
                        s.clear().add(this);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASYMMETRIC:
            case SYMMETRIC:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SYMMETRIC:
                jj_consume_token(SYMMETRIC);
                                      op = SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN;
                break;
              case ASYMMETRIC:
                jj_consume_token(ASYMMETRIC);
                break;
              default:
                jj_la1[309] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              jj_la1[310] = jj_gen;
              ;
            }
            break;
          case BETWEEN:
            jj_consume_token(BETWEEN);
                        op = SqlStdOperatorTable.BETWEEN;
                        s.clear().add(this);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ASYMMETRIC:
            case SYMMETRIC:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SYMMETRIC:
                jj_consume_token(SYMMETRIC);
                                      op = SqlStdOperatorTable.SYMMETRIC_BETWEEN;
                break;
              case ASYMMETRIC:
                jj_consume_token(ASYMMETRIC);
                break;
              default:
                jj_la1[311] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
            default:
              jj_la1[312] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[313] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          AddExpression2b(list3, ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list3);
                    list3.clear();
        } else if (jj_2_104(2)) {
                    checkNonQueryExpression(exprContext);
                    s.clear().add(this);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case NOT:
            jj_consume_token(NOT);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LIKE:
              jj_consume_token(LIKE);
                                     op = SqlStdOperatorTable.NOT_LIKE;
              break;
            case ILIKE:
              jj_consume_token(ILIKE);
                                      op = SqlLibraryOperators.NOT_ILIKE;
              break;
            case RLIKE:
              jj_consume_token(RLIKE);
                                      op = SqlLibraryOperators.NOT_RLIKE;
              break;
            case SIMILAR:
              jj_consume_token(SIMILAR);
              jj_consume_token(TO);
                                             op = SqlStdOperatorTable.NOT_SIMILAR_TO;
              break;
            default:
              jj_la1[314] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          case LIKE:
            jj_consume_token(LIKE);
                                 op = SqlStdOperatorTable.LIKE;
            break;
          case ILIKE:
            jj_consume_token(ILIKE);
                                  op = SqlLibraryOperators.ILIKE;
            break;
          case RLIKE:
            jj_consume_token(RLIKE);
                                  op = SqlLibraryOperators.RLIKE;
            break;
          case SIMILAR:
            jj_consume_token(SIMILAR);
            jj_consume_token(TO);
                                         op = SqlStdOperatorTable.SIMILAR_TO;
            break;
          default:
            jj_la1[315] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          list2 = Expression2(ExprContext.ACCEPT_SUB_QUERY);
                    list.add(new SqlParserUtil.ToTreeListItem(op, s.pos()));
                    list.addAll(list2);
          if (jj_2_100(2)) {
            jj_consume_token(ESCAPE);
            e = Expression3(ExprContext.ACCEPT_SUB_QUERY);
                        s.clear().add(this);
                        list.add(
                            new SqlParserUtil.ToTreeListItem(
                                SqlStdOperatorTable.ESCAPE, s.pos()));
                        list.add(e);
          } else {
            ;
          }
        } else if (jj_2_105(3)) {
          op = BinaryRowOperator();
                    checkNonQueryExpression(exprContext);
                    list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
          AddExpression2b(list, ExprContext.ACCEPT_SUB_QUERY);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LBRACKET:
            jj_consume_token(LBRACKET);
            e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            jj_consume_token(RBRACKET);
                    list.add(
                        new SqlParserUtil.ToTreeListItem(
                            SqlStdOperatorTable.ITEM, getPos()));
                    list.add(e);
            label_56:
            while (true) {
              if (jj_2_101(2)) {
                ;
              } else {
                break label_56;
              }
              jj_consume_token(DOT);
              p = SimpleIdentifier();
                        list.add(
                            new SqlParserUtil.ToTreeListItem(
                                SqlStdOperatorTable.DOT, getPos()));
                        list.add(p);
            }
            break;
          case FORMAT:
          case IS:
                    checkNonQueryExpression(exprContext);
            op = PostfixRowOperator();
                    list.add(new SqlParserUtil.ToTreeListItem(op, getPos()));
            break;
          default:
            jj_la1[316] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        if (jj_2_106(2)) {
          ;
        } else {
          break label_55;
        }
      }
            {if (true) return list;}
    } else {
            {if (true) return list;}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a comparison operator inside a SOME / ALL predicate. */
  final public SqlKind comp() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      jj_consume_token(LT);
           {if (true) return SqlKind.LESS_THAN;}
      break;
    case LE:
      jj_consume_token(LE);
           {if (true) return SqlKind.LESS_THAN_OR_EQUAL;}
      break;
    case GT:
      jj_consume_token(GT);
           {if (true) return SqlKind.GREATER_THAN;}
      break;
    case GE:
      jj_consume_token(GE);
           {if (true) return SqlKind.GREATER_THAN_OR_EQUAL;}
      break;
    case EQ:
      jj_consume_token(EQ);
           {if (true) return SqlKind.EQUALS;}
      break;
    case NE:
      jj_consume_token(NE);
           {if (true) return SqlKind.NOT_EQUALS;}
      break;
    case NE2:
      jj_consume_token(NE2);
        if (!this.conformance.isBangEqualAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.bangEqualNotAllowed());}
        }
        {if (true) return SqlKind.NOT_EQUALS;}
      break;
    default:
      jj_la1[317] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a unary row expression, or a parenthesized expression of any
 * kind.
 */
  final public SqlNode Expression3(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    final SqlNodeList list;
    final SqlNodeList list1;
    final Span s;
    final Span rowSpan;
    if (jj_2_109(2)) {
      e = AtomicRowExpression();
        checkNonQueryExpression(exprContext);
        {if (true) return e;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CURSOR:
        e = CursorExpression(exprContext);
                                        {if (true) return e;}
        break;
      default:
        jj_la1[319] = jj_gen;
        if (jj_2_110(3)) {
          jj_consume_token(ROW);
        s = span();
          list = ParenthesizedQueryOrCommaList(exprContext);
        if (exprContext != ExprContext.ACCEPT_ALL
            && exprContext != ExprContext.ACCEPT_CURSOR
            && !this.conformance.allowExplicitRowValueConstructor())
        {
            {if (true) throw SqlUtil.newContextException(s.end(list),
                RESOURCE.illegalRowExpression());}
        }
        {if (true) return SqlStdOperatorTable.ROW.createCall(list);}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ROW:
          case LPAREN:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ROW:
              jj_consume_token(ROW);
                rowSpan = span();
              break;
            default:
              jj_la1[318] = jj_gen;
          rowSpan = null;
            }
            list1 = ParenthesizedQueryOrCommaList(exprContext);
        if (rowSpan != null) {
            // interpret as row constructor
            {if (true) return SqlStdOperatorTable.ROW.createCall(rowSpan.end(list1),
                (List<SqlNode>) list1);}
        }
            if (jj_2_108(2)) {
              e = IntervalQualifier();
                if ((list1.size() == 1)
                    && list1.get(0) instanceof SqlCall)
                {
                    final SqlCall call = (SqlCall) list1.get(0);
                    if (call.getKind() == SqlKind.MINUS
                            && call.operandCount() == 2) {
                        {if (true) return SqlStdOperatorTable.MINUS_DATE.createCall(
                            Span.of(list1).end(this), call.operand(0),
                            call.operand(1), e);}
                     }
                }
                {if (true) throw SqlUtil.newContextException(span().end(list1),
                    RESOURCE.illegalMinusDate());}
            } else {
              ;
            }
        if (list1.size() == 1) {
            // interpret as single value or query
            {if (true) return list1.get(0);}
        } else {
            // interpret as row constructor
            {if (true) return SqlStdOperatorTable.ROW.createCall(span().end(list1),
                (List<SqlNode>) list1);}
        }
            break;
          default:
            jj_la1[320] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlOperator periodOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVERLAPS:
      jj_consume_token(OVERLAPS);
                  {if (true) return SqlStdOperatorTable.OVERLAPS;}
      break;
    default:
      jj_la1[321] = jj_gen;
      if (jj_2_111(2)) {
        jj_consume_token(IMMEDIATELY);
        jj_consume_token(PRECEDES);
                                {if (true) return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRECEDES:
          jj_consume_token(PRECEDES);
                  {if (true) return SqlStdOperatorTable.PRECEDES;}
          break;
        case IMMEDIATELY:
          jj_consume_token(IMMEDIATELY);
          jj_consume_token(SUCCEEDS);
                                {if (true) return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;}
          break;
        case SUCCEEDS:
          jj_consume_token(SUCCEEDS);
                  {if (true) return SqlStdOperatorTable.SUCCEEDS;}
          break;
        case EQUALS:
          jj_consume_token(EQUALS);
                {if (true) return SqlStdOperatorTable.PERIOD_EQUALS;}
          break;
        default:
          jj_la1[322] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a COLLATE clause
 */
  final public SqlCollation CollateClause() throws ParseException {
    jj_consume_token(COLLATE);
    jj_consume_token(COLLATION_ID);
        {if (true) return new SqlCollation(
            getToken(0).image, SqlCollation.Coercibility.EXPLICIT);}
    throw new Error("Missing return statement in function");
  }

/**
 * Numeric literal or parameter; used in LIMIT, OFFSET and FETCH clauses.
 */
  final public SqlNode UnsignedNumericLiteralOrParam() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      e = UnsignedNumericLiteral();
      break;
    case HOOK:
      e = DynamicParam();
      break;
    default:
      jj_la1[323] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a row expression extension, it can be either an identifier,
 * or a call to a named function.
 */
  final public SqlNode RowExpressionExtension() throws ParseException {
    final SqlFunctionCategory funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
    final SqlIdentifier p;
    final Span s;
    final List<SqlNode> args;
    final SqlLiteral quantifier;
    p = SimpleIdentifier();
    if (jj_2_114(2147483647)) {
                                s = span();
      if (jj_2_112(2)) {
        jj_consume_token(LPAREN);
        jj_consume_token(STAR);
                quantifier = null;
                args = ImmutableList.of(SqlIdentifier.star(getPos()));
        jj_consume_token(RPAREN);
      } else if (jj_2_113(2)) {
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
                quantifier = null;
                args = ImmutableList.of();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          args = FunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
                quantifier = (SqlLiteral) args.get(0);
                args.remove(0);
          break;
        default:
          jj_la1[324] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
          {if (true) return createCall(p, s.end(this), funcType, quantifier, args);}
    } else {
          {if (true) return p;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to the STRING_AGG aggregate function (or to an aggregate
 * function with similar syntax: ARRAY_AGG, ARRAY_CONCAT_AGG, GROUP_CONCAT).
 */
  final public SqlCall StringAggFunctionCall() throws ParseException {
    final Span s, s2;
    final SqlOperator op;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final SqlLiteral qualifier;
    final SqlNodeList orderBy;
    final Pair<SqlParserPos, SqlOperator> nullTreatment;
    final SqlNode separator;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ARRAY_AGG:
      jj_consume_token(ARRAY_AGG);
                      s = span(); op = SqlLibraryOperators.ARRAY_AGG;
      break;
    case ARRAY_CONCAT_AGG:
      jj_consume_token(ARRAY_CONCAT_AGG);
                             s = span(); op = SqlLibraryOperators.ARRAY_CONCAT_AGG;
      break;
    case GROUP_CONCAT:
      jj_consume_token(GROUP_CONCAT);
                         s = span(); op = SqlLibraryOperators.GROUP_CONCAT;
      break;
    case STRING_AGG:
      jj_consume_token(STRING_AGG);
                       s = span(); op = SqlLibraryOperators.STRING_AGG;
      break;
    default:
      jj_la1[325] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
    case DISTINCT:
      qualifier = AllOrDistinct();
      break;
    default:
      jj_la1[326] = jj_gen;
          qualifier = null;
    }
    AddArg(args, ExprContext.ACCEPT_SUB_QUERY);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[327] = jj_gen;
        break label_57;
      }
      jj_consume_token(COMMA);
            // a comma-list can't appear where only a query is expected
            // TODO: the following line is a no-op; remove it?
            checkNonQueryExpression(ExprContext.ACCEPT_SUB_QUERY);
      AddArg(args, ExprContext.ACCEPT_SUB_QUERY);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IGNORE:
    case RESPECT:
      nullTreatment = NullTreatment();
      break;
    default:
      jj_la1[328] = jj_gen;
          nullTreatment = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderBy = OrderBy(true);
            args.add(orderBy);
      break;
    default:
      jj_la1[329] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEPARATOR:
      jj_consume_token(SEPARATOR);
                      s2 = span();
      separator = StringLiteral();
            args.add(SqlInternalOperators.SEPARATOR.createCall(s2.end(this), separator));
      break;
    default:
      jj_la1[330] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        SqlCall call = op.createCall(qualifier, s.end(this), args);
        if (nullTreatment != null) {
            // Wrap in RESPECT_NULLS or IGNORE_NULLS.
            call = nullTreatment.right.createCall(nullTreatment.left, call);
        }
        {if (true) return call;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an atomic row expression.
 */
  final public SqlNode AtomicRowExpression() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case FALSE:
    case INTERVAL:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = LiteralOrIntervalExpression();
      break;
    case HOOK:
      e = DynamicParam();
      break;
    default:
      jj_la1[331] = jj_gen;
      if (jj_2_115(2)) {
        e = BuiltinFunctionCall();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE_FN:
          e = JdbcFunctionCall();
          break;
        case MULTISET:
          e = MultisetConstructor();
          break;
        case ARRAY:
          e = ArrayConstructor();
          break;
        default:
          jj_la1[332] = jj_gen;
          if (jj_2_116(3)) {
            e = MapConstructor();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PERIOD:
              e = PeriodConstructor();
              break;
            default:
              jj_la1[333] = jj_gen;
              if (jj_2_117(2147483647)) {
                e = NamedFunctionCall();
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case CURRENT_CATALOG:
                case CURRENT_DATE:
                case CURRENT_DEFAULT_TRANSFORM_GROUP:
                case CURRENT_PATH:
                case CURRENT_ROLE:
                case CURRENT_SCHEMA:
                case CURRENT_TIME:
                case CURRENT_TIMESTAMP:
                case CURRENT_USER:
                case LOCALTIME:
                case LOCALTIMESTAMP:
                case SESSION_USER:
                case SYSTEM_USER:
                case USER:
                  e = ContextVariable();
                  break;
                case A:
                case ABSENT:
                case ABSOLUTE:
                case ACTION:
                case ADA:
                case ADD:
                case ADMIN:
                case AFTER:
                case ALWAYS:
                case APPLY:
                case ASC:
                case ASSERTION:
                case ASSIGNMENT:
                case ATTRIBUTE:
                case ATTRIBUTES:
                case BEFORE:
                case BERNOULLI:
                case BREADTH:
                case C:
                case CASCADE:
                case CATALOG:
                case CATALOG_NAME:
                case CENTURY:
                case CHAIN:
                case CHARACTER_SET_CATALOG:
                case CHARACTER_SET_NAME:
                case CHARACTER_SET_SCHEMA:
                case CHARACTERISTICS:
                case CHARACTERS:
                case CLASS_ORIGIN:
                case COBOL:
                case COLLATION:
                case COLLATION_CATALOG:
                case COLLATION_NAME:
                case COLLATION_SCHEMA:
                case COLUMN_NAME:
                case COMMAND_FUNCTION:
                case COMMAND_FUNCTION_CODE:
                case COMMITTED:
                case CONDITIONAL:
                case CONDITION_NUMBER:
                case CONNECTION:
                case CONNECTION_NAME:
                case CONSTRAINT_CATALOG:
                case CONSTRAINT_NAME:
                case CONSTRAINT_SCHEMA:
                case CONSTRAINTS:
                case CONSTRUCTOR:
                case CONTINUE:
                case CURSOR_NAME:
                case DATA:
                case DATABASE:
                case DATETIME_INTERVAL_CODE:
                case DATETIME_INTERVAL_PRECISION:
                case DAYS:
                case DECADE:
                case DEFAULTS:
                case DEFERRABLE:
                case DEFERRED:
                case DEFINED:
                case DEFINER:
                case DEGREE:
                case DEPTH:
                case DERIVED:
                case DESC:
                case DESCRIPTION:
                case DESCRIPTOR:
                case DIAGNOSTICS:
                case DISPATCH:
                case DOMAIN:
                case DOW:
                case DOY:
                case DYNAMIC_FUNCTION:
                case DYNAMIC_FUNCTION_CODE:
                case ENCODING:
                case EPOCH:
                case ERROR:
                case EXCEPTION:
                case EXCLUDE:
                case EXCLUDING:
                case FINAL:
                case FIRST:
                case FOLLOWING:
                case FORMAT:
                case FORTRAN:
                case FOUND:
                case FRAC_SECOND:
                case G:
                case GENERAL:
                case GENERATED:
                case GEOMETRY:
                case GO:
                case GOTO:
                case GRANTED:
                case HIERARCHY:
                case HOP:
                case HOURS:
                case IGNORE:
                case IMMEDIATE:
                case IMMEDIATELY:
                case IMPLEMENTATION:
                case INCLUDING:
                case INCREMENT:
                case INITIALLY:
                case INPUT:
                case INSTANCE:
                case INSTANTIABLE:
                case INVOKER:
                case ISODOW:
                case ISOYEAR:
                case ISOLATION:
                case JAVA:
                case JSON:
                case K:
                case KEY:
                case KEY_MEMBER:
                case KEY_TYPE:
                case LABEL:
                case LAST:
                case LENGTH:
                case LEVEL:
                case LIBRARY:
                case LOCATOR:
                case M:
                case MAP:
                case MATCHED:
                case MAXVALUE:
                case MESSAGE_LENGTH:
                case MESSAGE_OCTET_LENGTH:
                case MESSAGE_TEXT:
                case MICROSECOND:
                case MILLISECOND:
                case MILLENNIUM:
                case MINUTES:
                case MINVALUE:
                case MONTHS:
                case MORE_:
                case MUMPS:
                case NAME:
                case NAMES:
                case NANOSECOND:
                case NESTING:
                case NORMALIZED:
                case NULLABLE:
                case NULLS:
                case NUMBER:
                case OBJECT:
                case OCTETS:
                case OPTION:
                case OPTIONS:
                case ORDERING:
                case ORDINALITY:
                case OTHERS:
                case OUTPUT:
                case OVERRIDING:
                case PAD:
                case PARAMETER_MODE:
                case PARAMETER_NAME:
                case PARAMETER_ORDINAL_POSITION:
                case PARAMETER_SPECIFIC_CATALOG:
                case PARAMETER_SPECIFIC_NAME:
                case PARAMETER_SPECIFIC_SCHEMA:
                case PARTIAL:
                case PASCAL:
                case PASSING:
                case PASSTHROUGH:
                case PAST:
                case PATH:
                case PLACING:
                case PLAN:
                case PLI:
                case PRECEDING:
                case PRESERVE:
                case PRIOR:
                case PRIVILEGES:
                case PUBLIC:
                case QUARTER:
                case READ:
                case RELATIVE:
                case REPEATABLE:
                case REPLACE:
                case RESPECT:
                case RESTART:
                case RESTRICT:
                case RETURNED_CARDINALITY:
                case RETURNED_LENGTH:
                case RETURNED_OCTET_LENGTH:
                case RETURNED_SQLSTATE:
                case RETURNING:
                case ROLE:
                case ROUTINE:
                case ROUTINE_CATALOG:
                case ROUTINE_NAME:
                case ROUTINE_SCHEMA:
                case ROW_COUNT:
                case SCALAR:
                case SCALE:
                case SCHEMA:
                case SCHEMA_NAME:
                case SCOPE_CATALOGS:
                case SCOPE_NAME:
                case SCOPE_SCHEMA:
                case SECONDS:
                case SECTION:
                case SECURITY:
                case SELF:
                case SEQUENCE:
                case SERIALIZABLE:
                case SERVER:
                case SERVER_NAME:
                case SESSION:
                case SETS:
                case SIMPLE:
                case SIZE:
                case SOURCE:
                case SPACE:
                case SPECIFIC_NAME:
                case SQL_BIGINT:
                case SQL_BINARY:
                case SQL_BIT:
                case SQL_BLOB:
                case SQL_BOOLEAN:
                case SQL_CHAR:
                case SQL_CLOB:
                case SQL_DATE:
                case SQL_DECIMAL:
                case SQL_DOUBLE:
                case SQL_FLOAT:
                case SQL_INTEGER:
                case SQL_INTERVAL_DAY:
                case SQL_INTERVAL_DAY_TO_HOUR:
                case SQL_INTERVAL_DAY_TO_MINUTE:
                case SQL_INTERVAL_DAY_TO_SECOND:
                case SQL_INTERVAL_HOUR:
                case SQL_INTERVAL_HOUR_TO_MINUTE:
                case SQL_INTERVAL_HOUR_TO_SECOND:
                case SQL_INTERVAL_MINUTE:
                case SQL_INTERVAL_MINUTE_TO_SECOND:
                case SQL_INTERVAL_MONTH:
                case SQL_INTERVAL_SECOND:
                case SQL_INTERVAL_YEAR:
                case SQL_INTERVAL_YEAR_TO_MONTH:
                case SQL_LONGVARBINARY:
                case SQL_LONGVARCHAR:
                case SQL_LONGVARNCHAR:
                case SQL_NCHAR:
                case SQL_NCLOB:
                case SQL_NUMERIC:
                case SQL_NVARCHAR:
                case SQL_REAL:
                case SQL_SMALLINT:
                case SQL_TIME:
                case SQL_TIMESTAMP:
                case SQL_TINYINT:
                case SQL_TSI_DAY:
                case SQL_TSI_FRAC_SECOND:
                case SQL_TSI_HOUR:
                case SQL_TSI_MICROSECOND:
                case SQL_TSI_MINUTE:
                case SQL_TSI_MONTH:
                case SQL_TSI_QUARTER:
                case SQL_TSI_SECOND:
                case SQL_TSI_WEEK:
                case SQL_TSI_YEAR:
                case SQL_VARBINARY:
                case SQL_VARCHAR:
                case STATE:
                case STRUCTURE:
                case STYLE:
                case SUBCLASS_ORIGIN:
                case SUBSTITUTE:
                case TABLE_NAME:
                case TEMPORARY:
                case TIES:
                case TIMESTAMPADD:
                case TIMESTAMPDIFF:
                case TOP_LEVEL_COUNT:
                case TRANSACTION:
                case TRANSACTIONS_ACTIVE:
                case TRANSACTIONS_COMMITTED:
                case TRANSACTIONS_ROLLED_BACK:
                case TRANSFORM:
                case TRANSFORMS:
                case TRIGGER_CATALOG:
                case TRIGGER_NAME:
                case TRIGGER_SCHEMA:
                case TUMBLE:
                case TYPE:
                case UNBOUNDED:
                case UNCOMMITTED:
                case UNCONDITIONAL:
                case UNDER:
                case UNNAMED:
                case USAGE:
                case USER_DEFINED_TYPE_CATALOG:
                case USER_DEFINED_TYPE_CODE:
                case USER_DEFINED_TYPE_NAME:
                case USER_DEFINED_TYPE_SCHEMA:
                case UTF8:
                case UTF16:
                case UTF32:
                case VERSION:
                case VIEW:
                case WEEK:
                case WORK:
                case WRAPPER:
                case WRITE:
                case XML:
                case YEARS:
                case ZONE:
                case CHANGELOG_MODE:
                case COMPACT:
                case COMPILE:
                case COLUMNS:
                case DRAIN:
                case ENFORCED:
                case ESTIMATED_COST:
                case IF:
                case JSON_EXECUTION_PLAN:
                case PLAN_ADVICE:
                case JAR:
                case JARS:
                case JOB:
                case JOBS:
                case LOAD:
                case METADATA:
                case OVERWRITE:
                case OVERWRITING:
                case PARTITIONED:
                case PARTITIONS:
                case PYTHON:
                case REMOVE:
                case STOP:
                case UNLOAD:
                case VIRTUAL:
                case TRY_CAST:
                case ANALYZE:
                case COMPUTE:
                case STATISTICS:
                case BRACKET_QUOTED_IDENTIFIER:
                case QUOTED_IDENTIFIER:
                case BACK_QUOTED_IDENTIFIER:
                case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
                case HYPHENATED_IDENTIFIER:
                case IDENTIFIER:
                case UNICODE_QUOTED_IDENTIFIER:
                  e = CompoundIdentifier();
                  break;
                case NEW:
                  e = NewSpecification();
                  break;
                case CASE:
                  e = CaseExpression();
                  break;
                case CURRENT:
                case NEXT:
                  e = SequenceExpression();
                  break;
                default:
                  jj_la1[334] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode CaseExpression() throws ParseException {
    final Span whenSpan = Span.of();
    final Span thenSpan = Span.of();
    final Span s;
    SqlNode e;
    final SqlNode caseIdentifier;
    final SqlNode elseClause;
    final List<SqlNode> whenList = new ArrayList<SqlNode>();
    final List<SqlNode> thenList = new ArrayList<SqlNode>();
    jj_consume_token(CASE);
             s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABS:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ARRAY:
    case ARRAY_AGG:
    case ARRAY_CONCAT_AGG:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case AVG:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CARDINALITY:
    case CASCADE:
    case CASE:
    case CAST:
    case CATALOG:
    case CATALOG_NAME:
    case CEIL:
    case CEILING:
    case CENTURY:
    case CHAIN:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASSIFIER:
    case CLASS_ORIGIN:
    case COALESCE:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLLECT:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CONVERT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT:
    case CURRENT_CATALOG:
    case CURRENT_DATE:
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
    case CURRENT_PATH:
    case CURRENT_ROLE:
    case CURRENT_SCHEMA:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case CURRENT_USER:
    case CURSOR:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DENSE_RANK:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ELEMENT:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EVERY:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case EXISTS:
    case EXP:
    case EXTRACT:
    case FALSE:
    case FINAL:
    case FIRST:
    case FIRST_VALUE:
    case FLOOR:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case FUSION:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case GROUP_CONCAT:
    case GROUPING:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INTERSECTION:
    case INTERVAL:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case JSON_ARRAY:
    case JSON_ARRAYAGG:
    case JSON_EXISTS:
    case JSON_OBJECT:
    case JSON_OBJECTAGG:
    case JSON_QUERY:
    case JSON_VALUE:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAG:
    case LAST:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOCATOR:
    case LOWER:
    case M:
    case MAP:
    case MATCHED:
    case MATCH_NUMBER:
    case MAX:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MIN:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MOD:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MULTISET:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NEW:
    case NEXT:
    case NORMALIZED:
    case NOT:
    case NTH_VALUE:
    case NTILE:
    case NULL:
    case NULLABLE:
    case NULLIF:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTET_LENGTH:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERLAY:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case PERIOD:
    case PLACING:
    case PLAN:
    case PLI:
    case POSITION:
    case POWER:
    case PRECEDING:
    case PRESERVE:
    case PREV:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case RANK:
    case READ:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case RIGHT:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW:
    case ROW_COUNT:
    case ROW_NUMBER:
    case RUNNING:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SESSION_USER:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOME:
    case SOURCE:
    case SPACE:
    case SPECIFIC:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case SQRT:
    case STATE:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case STRING_AGG:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case SUBSTRING:
    case SUM:
    case SYSTEM_USER:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIME:
    case TIMESTAMP:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRANSLATE:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TRIM:
    case TRUE:
    case TRUNCATE:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNIQUE:
    case UNKNOWN:
    case UNNAMED:
    case UPPER:
    case USAGE:
    case USER:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VAR_POP:
    case VAR_SAMP:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LPAREN:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case LBRACE_FN:
    case HOOK:
    case PLUS:
    case MINUS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      caseIdentifier = Expression(ExprContext.ACCEPT_SUB_QUERY);
      break;
    default:
      jj_la1[335] = jj_gen;
          caseIdentifier = null;
    }
    label_58:
    while (true) {
      jj_consume_token(WHEN);
                 whenSpan.add(this);
      e = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
            if (((SqlNodeList) e).size() == 1) {
                e = ((SqlNodeList) e).get(0);
            }
            whenList.add(e);
      jj_consume_token(THEN);
                 thenSpan.add(this);
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            thenList.add(e);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[336] = jj_gen;
        break label_58;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      elseClause = Expression(ExprContext.ACCEPT_SUB_QUERY);
      break;
    default:
      jj_la1[337] = jj_gen;
          elseClause = null;
    }
    jj_consume_token(END);
        {if (true) return SqlCase.createSwitched(s.end(this), caseIdentifier,
            new SqlNodeList(whenList, whenSpan.addAll(whenList).pos()),
            new SqlNodeList(thenList, thenSpan.addAll(thenList).pos()),
            elseClause);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall SequenceExpression() throws ParseException {
    final Span s;
    final SqlOperator f;
    final SqlNode sequenceRef;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEXT:
      jj_consume_token(NEXT);
                 f = SqlStdOperatorTable.NEXT_VALUE; s = span();
      break;
    default:
      jj_la1[338] = jj_gen;
      if (jj_2_118(3)) {
        jj_consume_token(CURRENT);
                    f = SqlStdOperatorTable.CURRENT_VALUE; s = span();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(VALUE);
    jj_consume_token(FOR);
    sequenceRef = CompoundIdentifier();
        {if (true) return f.createCall(s.end(sequenceRef), sequenceRef);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses "SET &lt;NAME&gt; = VALUE" or "RESET &lt;NAME&gt;", without a leading
 * "ALTER &lt;SCOPE&gt;".
 */
  final public SqlSetOption SqlSetOption(Span s, String scope) throws ParseException {
    SqlIdentifier name;
    final SqlNode val;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SET:
      jj_consume_token(SET);
            s.add(this);
      name = CompoundIdentifier();
      jj_consume_token(EQ);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DATE:
      case FALSE:
      case INTERVAL:
      case NULL:
      case TIME:
      case TIMESTAMP:
      case TRUE:
      case UNKNOWN:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case PLUS:
      case MINUS:
        val = Literal();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        val = SimpleIdentifier();
        break;
      case ON:
        jj_consume_token(ON);
                // OFF is handled by SimpleIdentifier, ON handled here.
                val = new SqlIdentifier(token.image.toUpperCase(Locale.ROOT),
                    getPos());
        break;
      default:
        jj_la1[339] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return new SqlSetOption(s.end(val), scope, name, val);}
      break;
    case RESET:
      jj_consume_token(RESET);
            s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        name = CompoundIdentifier();
        break;
      case ALL:
        jj_consume_token(ALL);
                name = new SqlIdentifier(token.image.toUpperCase(Locale.ROOT),
                    getPos());
        break;
      default:
        jj_la1[340] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return new SqlSetOption(s.end(name), scope, name, null);}
      break;
    default:
      jj_la1[341] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an expression for setting or resetting an option in SQL, such as QUOTED_IDENTIFIERS,
 * or explain plan level (physical/logical).
 */
  final public SqlAlter SqlAlter() throws ParseException {
    final Span s;
    final String scope;
    final SqlAlter alterNode;
    jj_consume_token(ALTER);
              s = span();
    scope = Scope();
    alterNode = SqlSetOption(s, scope);
        {if (true) return alterNode;}
    throw new Error("Missing return statement in function");
  }

  final public String Scope() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SYSTEM:
      jj_consume_token(SYSTEM);
      break;
    case SESSION:
      jj_consume_token(SESSION);
      break;
    default:
      jj_la1[342] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                               {if (true) return token.image.toUpperCase(Locale.ROOT);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CREATE statement.
 */
  final public SqlCreate SqlCreate() throws ParseException {
    final Span s;
    boolean replace = false;
    final SqlCreate create;
    jj_consume_token(CREATE);
               s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OR:
      jj_consume_token(OR);
      jj_consume_token(REPLACE);
            replace = true;
      break;
    default:
      jj_la1[343] = jj_gen;
      ;
    }
    create = SqlCreateExtended(s, replace);
        {if (true) return create;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a DROP statement.
 */
  final public SqlDrop SqlDrop() throws ParseException {
    final Span s;
    boolean replace = false;
    final SqlDrop drop;
    jj_consume_token(DROP);
             s = span();
    drop = SqlDropExtended(s, replace);
        {if (true) return drop;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a literal expression, allowing continued string literals.
 * Usually returns an SqlLiteral, but a continued string literal
 * is an SqlCall expression, which concatenates 2 or more string
 * literals; the validator reduces this.
 *
 * <p>If the context allows both literals and expressions,
 * use {@link #LiteralOrIntervalExpression}, which requires less
 * lookahead.
 */
  final public SqlNode Literal() throws ParseException {
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
    case FALSE:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = NonIntervalLiteral();
      break;
    case INTERVAL:
      e = IntervalLiteral();
      break;
    default:
      jj_la1[344] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal that is not an interval literal. */
  final public SqlNode NonIntervalLiteral() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case PLUS:
    case MINUS:
      e = NumericLiteral();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      e = StringLiteral();
      break;
    case FALSE:
    case NULL:
    case TRUE:
    case UNKNOWN:
      e = SpecialLiteral();
      break;
    case DATE:
    case TIME:
    case TIMESTAMP:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
      e = DateTimeLiteral();
      break;
    default:
      jj_la1[345] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a literal or an interval expression.
 *
 * <p>We include them in the same production because it is difficult to
 * distinguish interval literals from interval expression (both of which
 * start with the {@code INTERVAL} keyword); this way, we can use less
 * LOOKAHEAD. */
  final public SqlNode LiteralOrIntervalExpression() throws ParseException {
    final SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERVAL:
      e = IntervalLiteralOrExpression();
      break;
    case DATE:
    case FALSE:
    case NULL:
    case TIME:
    case TIMESTAMP:
    case TRUE:
    case UNKNOWN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
    case LBRACE_D:
    case LBRACE_T:
    case LBRACE_TS:
    case PLUS:
    case MINUS:
      e = NonIntervalLiteral();
      break;
    default:
      jj_la1[346] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

/** Parses a unsigned numeric literal */
  final public SqlNumericLiteral UnsignedNumericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        {if (true) return SqlLiteral.createExactNumeric(token.image, getPos());}
      break;
    case DECIMAL_NUMERIC_LITERAL:
      jj_consume_token(DECIMAL_NUMERIC_LITERAL);
        {if (true) return SqlLiteral.createExactNumeric(token.image, getPos());}
      break;
    case APPROX_NUMERIC_LITERAL:
      jj_consume_token(APPROX_NUMERIC_LITERAL);
        {if (true) return SqlLiteral.createApproxNumeric(token.image, getPos());}
      break;
    default:
      jj_la1[347] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a numeric literal (can be signed) */
  final public SqlLiteral NumericLiteral() throws ParseException {
    final SqlNumericLiteral num;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
      num = UnsignedNumericLiteral();
        {if (true) return num;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              s = span();
      num = UnsignedNumericLiteral();
        {if (true) return SqlLiteral.createNegative(num, s.end(this));}
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      num = UnsignedNumericLiteral();
        {if (true) return num;}
      break;
    default:
      jj_la1[348] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parse a special literal keyword */
  final public SqlLiteral SpecialLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             {if (true) return SqlLiteral.createBoolean(true, getPos());}
      break;
    case FALSE:
      jj_consume_token(FALSE);
              {if (true) return SqlLiteral.createBoolean(false, getPos());}
      break;
    case UNKNOWN:
      jj_consume_token(UNKNOWN);
                {if (true) return SqlLiteral.createUnknown(getPos());}
      break;
    case NULL:
      jj_consume_token(NULL);
             {if (true) return SqlLiteral.createNull(getPos());}
      break;
    default:
      jj_la1[349] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a string literal. The literal may be continued onto several
 * lines.  For a simple literal, the result is an SqlLiteral.  For a continued
 * literal, the result is an SqlCall expression, which concatenates 2 or more
 * string literals; the validator reduces this.
 *
 * @see SqlLiteral#unchain(SqlNode)
 * @see SqlLiteral#stringValue(SqlNode)
 *
 * @return a literal expression
 */
  final public SqlNode StringLiteral() throws ParseException {
    String p;
    final List<SqlLiteral> frags;
    char unicodeEscapeChar = 0;
    String charSet = null;
    SqlCharStringLiteral literal;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
      jj_consume_token(BINARY_STRING_LITERAL);
        frags = new ArrayList<SqlLiteral>();
        try {
            p = SqlParserUtil.trim(token.image, "xX'");
            frags.add(SqlLiteral.createBinaryString(p, getPos()));
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.illegalBinaryString(token.image));}
        }
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case QUOTED_STRING:
          ;
          break;
        default:
          jj_la1[350] = jj_gen;
          break label_59;
        }
        jj_consume_token(QUOTED_STRING);
            try {
                p = SqlParserUtil.trim(token.image, "'"); // no embedded quotes
                frags.add(SqlLiteral.createBinaryString(p, getPos()));
            } catch (NumberFormatException ex) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.illegalBinaryString(token.image));}
            }
      }
        assert !frags.isEmpty();
        if (frags.size() == 1) {
            {if (true) return frags.get(0);} // just the head fragment
        } else {
            SqlParserPos pos2 = SqlParserPos.sum(frags);
            {if (true) return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, frags);}
        }
      break;
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PREFIXED_STRING_LITERAL:
        jj_consume_token(PREFIXED_STRING_LITERAL);
          charSet = SqlParserUtil.getCharacterSet(token.image);
        break;
      case QUOTED_STRING:
        jj_consume_token(QUOTED_STRING);
        break;
      case UNICODE_STRING_LITERAL:
        jj_consume_token(UNICODE_STRING_LITERAL);
            // TODO jvs 2-Feb-2009:  support the explicit specification of
            // a character set for Unicode string literals, per SQL:2003
            unicodeEscapeChar = BACKSLASH;
            charSet = "UTF16";
        break;
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        frags = new ArrayList<SqlLiteral>();
        p = SqlParserUtil.parseString(token.image);
        try {
            literal = SqlLiteral.createCharString(p, charSet, getPos());
            frags.add(literal);
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      label_60:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case QUOTED_STRING:
          ;
          break;
        default:
          jj_la1[352] = jj_gen;
          break label_60;
        }
        jj_consume_token(QUOTED_STRING);
            p = SqlParserUtil.parseString(token.image);
            try {
                literal = SqlLiteral.createCharString(p, charSet, getPos());
                frags.add(literal);
            } catch (java.nio.charset.UnsupportedCharsetException e) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.unknownCharacterSet(charSet));}
            }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UESCAPE:
        jj_consume_token(UESCAPE);
        jj_consume_token(QUOTED_STRING);
            if (unicodeEscapeChar == 0) {
                {if (true) throw SqlUtil.newContextException(getPos(),
                    RESOURCE.unicodeEscapeUnexpected());}
            }
            String s = SqlParserUtil.parseString(token.image);
            unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
        break;
      default:
        jj_la1[353] = jj_gen;
        ;
      }
        assert !frags.isEmpty();
        if (frags.size() == 1) {
            // just the head fragment
            SqlLiteral lit = (SqlLiteral) frags.get(0);
            {if (true) return lit.unescapeUnicode(unicodeEscapeChar);}
        } else {
            SqlNode[] rands = (SqlNode[]) frags.toArray(new SqlNode[0]);
            for (int i = 0; i < rands.length; ++i) {
                rands[i] = ((SqlLiteral) rands[i]).unescapeUnicode(
                    unicodeEscapeChar);
            }
            SqlParserPos pos2 = SqlParserPos.sum(rands);
            {if (true) return SqlStdOperatorTable.LITERAL_CHAIN.createCall(pos2, rands);}
        }
      break;
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_DOUBLE_QUOTED_STRING);
        p = SqlParserUtil.stripQuotes(getToken(0).image, DQ, DQ, "\\\"",
            Casing.UNCHANGED);
        try {
            {if (true) return SqlLiteral.createCharString(p, charSet, getPos());}
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      break;
    case BIG_QUERY_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_QUOTED_STRING);
        p = SqlParserUtil.stripQuotes(getToken(0).image, "'", "'", "\\'",
            Casing.UNCHANGED);
        try {
            {if (true) return SqlLiteral.createCharString(p, charSet, getPos());}
        } catch (java.nio.charset.UnsupportedCharsetException e) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.unknownCharacterSet(charSet));}
        }
      break;
    default:
      jj_la1[354] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a character literal.
 * Matches a single-quoted string, such as 'foo';
 * on BigQuery also matches a double-quoted string, such as "foo".
 * Returns the value of the string with quotes removed. */
  final public String SimpleStringLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
        {if (true) return SqlParserUtil.parseString(token.image);}
      break;
    case BIG_QUERY_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_QUOTED_STRING);
        {if (true) return SqlParserUtil.stripQuotes(token.image, "'", "'", "\\'", Casing.UNCHANGED);}
      break;
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
      jj_consume_token(BIG_QUERY_DOUBLE_QUOTED_STRING);
        {if (true) return SqlParserUtil.stripQuotes(token.image, DQ, DQ, "\\\"", Casing.UNCHANGED);}
      break;
    default:
      jj_la1[355] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a date/time literal.
 */
  final public SqlLiteral DateTimeLiteral() throws ParseException {
    final String p;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE_D:
      jj_consume_token(LBRACE_D);
      jj_consume_token(QUOTED_STRING);
        p = SqlParserUtil.parseString(token.image);
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseDateLiteral(p, getPos());}
      break;
    case LBRACE_T:
      jj_consume_token(LBRACE_T);
      jj_consume_token(QUOTED_STRING);
        p = SqlParserUtil.parseString(token.image);
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseTimeLiteral(p, getPos());}
      break;
    case LBRACE_TS:
      jj_consume_token(LBRACE_TS);
                  s = span();
      jj_consume_token(QUOTED_STRING);
        p = SqlParserUtil.parseString(token.image);
      jj_consume_token(RBRACE);
        {if (true) return SqlParserUtil.parseTimestampLiteral(p, s.end(this));}
      break;
    case DATE:
      jj_consume_token(DATE);
             s = span();
      p = SimpleStringLiteral();
      {if (true) return SqlParserUtil.parseDateLiteral(p, s.end(this));}
      break;
    case TIME:
      jj_consume_token(TIME);
             s = span();
      p = SimpleStringLiteral();
        {if (true) return SqlParserUtil.parseTimeLiteral(p, s.end(this));}
      break;
    case TIMESTAMP:
      jj_consume_token(TIMESTAMP);
                  s = span();
      p = SimpleStringLiteral();
        {if (true) return SqlParserUtil.parseTimestampLiteral(p, s.end(this));}
      break;
    default:
      jj_la1[356] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a MULTISET constructor */
  final public SqlNode MultisetConstructor() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    final Span s;
    jj_consume_token(MULTISET);
                 s = span();
    if (jj_2_119(2)) {
      jj_consume_token(LPAREN);
      // by sub query "MULTISET(SELECT * FROM T)"
              e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.MULTISET_QUERY.createCall(
                s.end(this), e);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
        label_61:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[357] = jj_gen;
            break label_61;
          }
          jj_consume_token(COMMA);
          AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
        }
        jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.MULTISET_VALUE.createCall(
                s.end(this), args);}
        break;
      default:
        jj_la1[358] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

/** Parses an ARRAY constructor */
  final public SqlNode ArrayConstructor() throws ParseException {
    SqlNodeList args;
    SqlNode e;
    final Span s;
    jj_consume_token(ARRAY);
              s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      // by sub query "MULTISET(SELECT * FROM T)"
              e = OrderedQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.ARRAY_QUERY.createCall(
                s.end(this), e);}
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        args = ExpressionCommaList(s, ExprContext.ACCEPT_NON_QUERY);
        break;
      default:
        jj_la1[359] = jj_gen;
              args = SqlNodeList.EMPTY;
      }
      jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(
                s.end(this), args.getList());}
      break;
    default:
      jj_la1[360] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a MAP constructor */
  final public SqlNode MapConstructor() throws ParseException {
    SqlNodeList args;
    SqlNode e;
    final Span s;
    jj_consume_token(MAP);
            s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      // by sub query "MAP (SELECT empno, deptno FROM emp)"
              e = LeafQueryOrExpr(ExprContext.ACCEPT_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.MAP_QUERY.createCall(
                s.end(this), e);}
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ARRAY:
      case ARRAY_AGG:
      case ARRAY_CONCAT_AGG:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CASE:
      case CAST:
      case CATALOG:
      case CATALOG_NAME:
      case CEIL:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASSIFIER:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CONVERT:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT:
      case CURRENT_CATALOG:
      case CURRENT_DATE:
      case CURRENT_DEFAULT_TRANSFORM_GROUP:
      case CURRENT_PATH:
      case CURRENT_ROLE:
      case CURRENT_SCHEMA:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURRENT_USER:
      case CURSOR:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXISTS:
      case EXP:
      case EXTRACT:
      case FALSE:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUP_CONCAT:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INTERVAL:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case JSON_ARRAY:
      case JSON_ARRAYAGG:
      case JSON_EXISTS:
      case JSON_OBJECT:
      case JSON_OBJECTAGG:
      case JSON_QUERY:
      case JSON_VALUE:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MATCH_NUMBER:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NEW:
      case NEXT:
      case NORMALIZED:
      case NOT:
      case NTH_VALUE:
      case NTILE:
      case NULL:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERLAY:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PERIOD:
      case PLACING:
      case PLAN:
      case PLI:
      case POSITION:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PREV:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case ROW_NUMBER:
      case RUNNING:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SESSION_USER:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRING_AGG:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUBSTRING:
      case SUM:
      case SYSTEM_USER:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRANSLATE:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRIM:
      case TRUE:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNIQUE:
      case UNKNOWN:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case BIG_QUERY_DOUBLE_QUOTED_STRING:
      case BIG_QUERY_QUOTED_STRING:
      case LPAREN:
      case LBRACE_D:
      case LBRACE_T:
      case LBRACE_TS:
      case LBRACE_FN:
      case HOOK:
      case PLUS:
      case MINUS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        args = ExpressionCommaList(s, ExprContext.ACCEPT_NON_QUERY);
        break;
      default:
        jj_la1[361] = jj_gen;
              args = SqlNodeList.EMPTY;
      }
      jj_consume_token(RBRACKET);
            {if (true) return SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR.createCall(
                s.end(this), args.getList());}
      break;
    default:
      jj_la1[362] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/** Parses a PERIOD constructor */
  final public SqlNode PeriodConstructor() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    jj_consume_token(PERIOD);
               s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.ROW.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses an interval literal.
 */
  final public SqlLiteral IntervalLiteral() throws ParseException {
    final String p;
    final SqlIntervalQualifier intervalQualifier;
    int sign = 1;
    final Span s;
    jj_consume_token(INTERVAL);
                 s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
                  sign = -1;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                 sign = 1;
        break;
      default:
        jj_la1[363] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[364] = jj_gen;
      ;
    }
    p = SimpleStringLiteral();
    intervalQualifier = IntervalQualifier();
        {if (true) return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier),
            sign, p, intervalQualifier);}
    throw new Error("Missing return statement in function");
  }

/** Parses an interval literal (e.g. {@code INTERVAL '2:3' HOUR TO MINUTE})
 * or an interval expression (e.g. {@code INTERVAL emp.empno MINUTE}
 * or {@code INTERVAL 3 MONTHS}). */
  final public SqlNode IntervalLiteralOrExpression() throws ParseException {
    final String p;
    final SqlIntervalQualifier intervalQualifier;
    int sign = 1;
    final Span s;
    SqlNode e;
    jj_consume_token(INTERVAL);
                 s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
        jj_consume_token(MINUS);
                  sign = -1;
        break;
      case PLUS:
        jj_consume_token(PLUS);
                 sign = 1;
        break;
      default:
        jj_la1[365] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[366] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
    case BIG_QUERY_DOUBLE_QUOTED_STRING:
    case BIG_QUERY_QUOTED_STRING:
      // literal (with quoted string)
              p = SimpleStringLiteral();
      intervalQualifier = IntervalQualifier();
            {if (true) return SqlParserUtil.parseIntervalLiteral(s.end(intervalQualifier),
                sign, p, intervalQualifier);}
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case LPAREN:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        e = Expression(ExprContext.ACCEPT_SUB_QUERY);
        jj_consume_token(RPAREN);
        break;
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
        e = UnsignedNumericLiteral();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = CompoundIdentifier();
        break;
      default:
        jj_la1[367] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      intervalQualifier = IntervalQualifierStart();
            if (sign == -1) {
                e = SqlStdOperatorTable.UNARY_MINUS.createCall(e.getParserPosition(), e);
            }
            {if (true) return SqlStdOperatorTable.INTERVAL.createCall(s.end(this), e,
                intervalQualifier);}
      break;
    default:
      jj_la1[368] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Year() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YEAR:
      jj_consume_token(YEAR);
             {if (true) return TimeUnit.YEAR;}
      break;
    case YEARS:
      jj_consume_token(YEARS);
              {if (true) return warn(TimeUnit.YEAR);}
      break;
    default:
      jj_la1[369] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Month() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MONTH:
      jj_consume_token(MONTH);
              {if (true) return TimeUnit.MONTH;}
      break;
    case MONTHS:
      jj_consume_token(MONTHS);
               {if (true) return warn(TimeUnit.MONTH);}
      break;
    default:
      jj_la1[370] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Day() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DAY:
      jj_consume_token(DAY);
            {if (true) return TimeUnit.DAY;}
      break;
    case DAYS:
      jj_consume_token(DAYS);
             {if (true) return warn(TimeUnit.DAY);}
      break;
    default:
      jj_la1[371] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Hour() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOUR:
      jj_consume_token(HOUR);
             {if (true) return TimeUnit.HOUR;}
      break;
    case HOURS:
      jj_consume_token(HOURS);
              {if (true) return warn(TimeUnit.HOUR);}
      break;
    default:
      jj_la1[372] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Minute() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUTE:
      jj_consume_token(MINUTE);
               {if (true) return TimeUnit.MINUTE;}
      break;
    case MINUTES:
      jj_consume_token(MINUTES);
                {if (true) return warn(TimeUnit.MINUTE);}
      break;
    default:
      jj_la1[373] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit Second() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SECOND:
      jj_consume_token(SECOND);
               {if (true) return TimeUnit.SECOND;}
      break;
    case SECONDS:
      jj_consume_token(SECONDS);
                {if (true) return warn(TimeUnit.SECOND);}
      break;
    default:
      jj_la1[374] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlIntervalQualifier IntervalQualifier() throws ParseException {
    final Span s;
    final TimeUnit start;
    final TimeUnit end;
    final int startPrec;
    int secondFracPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case YEAR:
    case YEARS:
      start = Year();
                         s = span();
      startPrec = PrecisionOpt();
      if (jj_2_120(2)) {
        jj_consume_token(TO);
        end = Month();
      } else {
              end = null;
      }
      break;
    case MONTH:
    case MONTHS:
      start = Month();
                          s = span();
      startPrec = PrecisionOpt();
          end = null;
      break;
    case DAY:
    case DAYS:
      start = Day();
                        s = span();
      startPrec = PrecisionOpt();
      if (jj_2_121(2)) {
        jj_consume_token(TO);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HOUR:
        case HOURS:
          end = Hour();
          break;
        case MINUTE:
        case MINUTES:
          end = Minute();
          break;
        case SECOND:
        case SECONDS:
          end = Second();
          secondFracPrec = PrecisionOpt();
          break;
        default:
          jj_la1[375] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
              end = null;
      }
      break;
    case HOUR:
    case HOURS:
      start = Hour();
                         s = span();
      startPrec = PrecisionOpt();
      if (jj_2_122(2)) {
        jj_consume_token(TO);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUTE:
        case MINUTES:
          end = Minute();
          break;
        case SECOND:
        case SECONDS:
          end = Second();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPAREN:
            jj_consume_token(LPAREN);
            secondFracPrec = UnsignedIntLiteral();
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[376] = jj_gen;
            ;
          }
          break;
        default:
          jj_la1[377] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
              end = null;
      }
      break;
    case MINUTE:
    case MINUTES:
      start = Minute();
                           s = span();
      startPrec = PrecisionOpt();
      if (jj_2_123(2)) {
        jj_consume_token(TO);
        end = Second();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LPAREN:
          jj_consume_token(LPAREN);
          secondFracPrec = UnsignedIntLiteral();
          jj_consume_token(RPAREN);
          break;
        default:
          jj_la1[378] = jj_gen;
          ;
        }
      } else {
              end = null;
      }
      break;
    case SECOND:
    case SECONDS:
      start = Second();
                           s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        startPrec = UnsignedIntLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          secondFracPrec = UnsignedIntLiteral();
          break;
        default:
          jj_la1[379] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[380] = jj_gen;
              startPrec = -1;
      }
          end = null;
      break;
    default:
      jj_la1[381] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIntervalQualifier(start, startPrec, end, secondFracPrec,
            s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** Interval qualifier without 'TO unit'. */
  final public SqlIntervalQualifier IntervalQualifierStart() throws ParseException {
    final Span s;
    final TimeUnit start;
    int startPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    int secondFracPrec = RelDataType.PRECISION_NOT_SPECIFIED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DAY:
    case DAYS:
    case HOUR:
    case HOURS:
    case MINUTE:
    case MINUTES:
    case MONTH:
    case MONTHS:
    case YEAR:
    case YEARS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case YEAR:
      case YEARS:
        start = Year();
        break;
      case MONTH:
      case MONTHS:
        start = Month();
        break;
      case DAY:
      case DAYS:
        start = Day();
        break;
      case HOUR:
      case HOURS:
        start = Hour();
        break;
      case MINUTE:
      case MINUTES:
        start = Minute();
        break;
      default:
        jj_la1[382] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          s = span();
      startPrec = PrecisionOpt();
      break;
    case SECOND:
    case SECONDS:
      start = Second();
                           s = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        startPrec = UnsignedIntLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          secondFracPrec = UnsignedIntLiteral();
          break;
        default:
          jj_la1[383] = jj_gen;
          ;
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[384] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[385] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIntervalQualifier(start, startPrec, null, secondFracPrec,
            s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses time unit for CEIL and FLOOR functions.
 */
  final public TimeUnit TimeUnit() throws ParseException {
    final TimeUnit unit;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CENTURY:
    case DAY:
    case DECADE:
    case DOW:
    case DOY:
    case EPOCH:
    case HOUR:
    case ISODOW:
    case ISOYEAR:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTE:
    case MONTH:
    case QUARTER:
    case SECOND:
    case WEEK:
    case YEAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MILLISECOND:
        jj_consume_token(MILLISECOND);
                        {if (true) return TimeUnit.MILLISECOND;}
        break;
      case SECOND:
        jj_consume_token(SECOND);
                   {if (true) return TimeUnit.SECOND;}
        break;
      case MINUTE:
        jj_consume_token(MINUTE);
                   {if (true) return TimeUnit.MINUTE;}
        break;
      case HOUR:
        jj_consume_token(HOUR);
                 {if (true) return TimeUnit.HOUR;}
        break;
      case DAY:
        jj_consume_token(DAY);
                {if (true) return TimeUnit.DAY;}
        break;
      case DOW:
        jj_consume_token(DOW);
                {if (true) return TimeUnit.DOW;}
        break;
      case DOY:
        jj_consume_token(DOY);
                {if (true) return TimeUnit.DOY;}
        break;
      case ISODOW:
        jj_consume_token(ISODOW);
                   {if (true) return TimeUnit.ISODOW;}
        break;
      case ISOYEAR:
        jj_consume_token(ISOYEAR);
                    {if (true) return TimeUnit.ISOYEAR;}
        break;
      case WEEK:
        jj_consume_token(WEEK);
                 {if (true) return TimeUnit.WEEK;}
        break;
      case MONTH:
        jj_consume_token(MONTH);
                  {if (true) return TimeUnit.MONTH;}
        break;
      case QUARTER:
        jj_consume_token(QUARTER);
                    {if (true) return TimeUnit.QUARTER;}
        break;
      case YEAR:
        jj_consume_token(YEAR);
                 {if (true) return TimeUnit.YEAR;}
        break;
      case EPOCH:
        jj_consume_token(EPOCH);
                  {if (true) return TimeUnit.EPOCH;}
        break;
      case DECADE:
        jj_consume_token(DECADE);
                   {if (true) return TimeUnit.DECADE;}
        break;
      case CENTURY:
        jj_consume_token(CENTURY);
                    {if (true) return TimeUnit.CENTURY;}
        break;
      case MILLENNIUM:
        jj_consume_token(MILLENNIUM);
                       {if (true) return TimeUnit.MILLENNIUM;}
        break;
      default:
        jj_la1[386] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      unit = TimeUnitIdentifier();
                                  {if (true) return unit;}
      break;
    default:
      jj_la1[387] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses time unit for the EXTRACT function.
 * As for FLOOR and CEIL, but also includes NANOSECOND and MICROSECOND.
 */
  final public TimeUnit TimeUnitForExtract() throws ParseException {
    final TimeUnit unit;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MICROSECOND:
    case NANOSECOND:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NANOSECOND:
        jj_consume_token(NANOSECOND);
                       {if (true) return TimeUnit.NANOSECOND;}
        break;
      case MICROSECOND:
        jj_consume_token(MICROSECOND);
                        {if (true) return TimeUnit.MICROSECOND;}
        break;
      default:
        jj_la1[388] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAY:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOUR:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTE:
    case MINUTES:
    case MINVALUE:
    case MONTH:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECOND:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEAR:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      unit = TimeUnit();
                        {if (true) return unit;}
      break;
    default:
      jj_la1[389] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a simple identifier as a TimeUnit.
 */
  final public TimeUnit TimeUnitIdentifier() throws ParseException {
    final List<String> names = new ArrayList<String>();
    final List<SqlParserPos> positions = new ArrayList<SqlParserPos>();
    AddIdentifierSegment(names, positions);
        TimeUnit unit = timeUnitCodes.get(names.get(0));
        if (unit != null) {
          {if (true) return unit;}
        }
        {if (true) throw SqlUtil.newContextException(positions.get(0),
            RESOURCE.invalidDatetimeFormat(SqlIdentifier.getString(names)));}
    throw new Error("Missing return statement in function");
  }

  final public TimeUnit TimestampInterval() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FRAC_SECOND:
      jj_consume_token(FRAC_SECOND);
                    {if (true) return TimeUnit.MICROSECOND;}
      break;
    case MICROSECOND:
      jj_consume_token(MICROSECOND);
                    {if (true) return TimeUnit.MICROSECOND;}
      break;
    case NANOSECOND:
      jj_consume_token(NANOSECOND);
                   {if (true) return TimeUnit.NANOSECOND;}
      break;
    case SQL_TSI_FRAC_SECOND:
      jj_consume_token(SQL_TSI_FRAC_SECOND);
                            {if (true) return TimeUnit.NANOSECOND;}
      break;
    case SQL_TSI_MICROSECOND:
      jj_consume_token(SQL_TSI_MICROSECOND);
                            {if (true) return TimeUnit.MICROSECOND;}
      break;
    case SECOND:
      jj_consume_token(SECOND);
               {if (true) return TimeUnit.SECOND;}
      break;
    case SQL_TSI_SECOND:
      jj_consume_token(SQL_TSI_SECOND);
                       {if (true) return TimeUnit.SECOND;}
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
               {if (true) return TimeUnit.MINUTE;}
      break;
    case SQL_TSI_MINUTE:
      jj_consume_token(SQL_TSI_MINUTE);
                       {if (true) return TimeUnit.MINUTE;}
      break;
    case HOUR:
      jj_consume_token(HOUR);
             {if (true) return TimeUnit.HOUR;}
      break;
    case SQL_TSI_HOUR:
      jj_consume_token(SQL_TSI_HOUR);
                     {if (true) return TimeUnit.HOUR;}
      break;
    case DAY:
      jj_consume_token(DAY);
            {if (true) return TimeUnit.DAY;}
      break;
    case SQL_TSI_DAY:
      jj_consume_token(SQL_TSI_DAY);
                    {if (true) return TimeUnit.DAY;}
      break;
    case WEEK:
      jj_consume_token(WEEK);
             {if (true) return TimeUnit.WEEK;}
      break;
    case SQL_TSI_WEEK:
      jj_consume_token(SQL_TSI_WEEK);
                     {if (true) return TimeUnit.WEEK;}
      break;
    case MONTH:
      jj_consume_token(MONTH);
              {if (true) return TimeUnit.MONTH;}
      break;
    case SQL_TSI_MONTH:
      jj_consume_token(SQL_TSI_MONTH);
                      {if (true) return TimeUnit.MONTH;}
      break;
    case QUARTER:
      jj_consume_token(QUARTER);
                {if (true) return TimeUnit.QUARTER;}
      break;
    case SQL_TSI_QUARTER:
      jj_consume_token(SQL_TSI_QUARTER);
                        {if (true) return TimeUnit.QUARTER;}
      break;
    case YEAR:
      jj_consume_token(YEAR);
             {if (true) return TimeUnit.YEAR;}
      break;
    case SQL_TSI_YEAR:
      jj_consume_token(SQL_TSI_YEAR);
                     {if (true) return TimeUnit.YEAR;}
      break;
    default:
      jj_la1[390] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a dynamic parameter marker.
 */
  final public SqlDynamicParam DynamicParam() throws ParseException {
    jj_consume_token(HOOK);
        {if (true) return new SqlDynamicParam(nDynamicParams++, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses one segment of an identifier that may be composite.
 *
 * <p>Each time it reads an identifier it writes one element to each list;
 * the entry in {@code positions} records its position and whether the
 * segment was quoted.
 */
  final public void AddIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
    final String id;
    char unicodeEscapeChar = BACKSLASH;
    final SqlParserPos pos;
    final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
            id = unquotedIdentifier();
            pos = getPos();
      break;
    case HYPHENATED_IDENTIFIER:
      jj_consume_token(HYPHENATED_IDENTIFIER);
            id = unquotedIdentifier();
            pos = getPos();
      break;
    case QUOTED_IDENTIFIER:
      jj_consume_token(QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, DQ, DQ, DQDQ,
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BACK_QUOTED_IDENTIFIER:
      jj_consume_token(BACK_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "`", "`", "``",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      jj_consume_token(BIG_QUERY_BACK_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "`", "`", "\\`",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case BRACKET_QUOTED_IDENTIFIER:
      jj_consume_token(BRACKET_QUOTED_IDENTIFIER);
            id = SqlParserUtil.stripQuotes(getToken(0).image, "[", "]", "]]",
                quotedCasing);
            pos = getPos().withQuoting(true);
      break;
    case UNICODE_QUOTED_IDENTIFIER:
      jj_consume_token(UNICODE_QUOTED_IDENTIFIER);
            span = span();
            String image = getToken(0).image;
            image = image.substring(image.indexOf('"'));
            image = SqlParserUtil.stripQuotes(image, DQ, DQ, DQDQ, quotedCasing);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UESCAPE:
        jj_consume_token(UESCAPE);
        jj_consume_token(QUOTED_STRING);
                String s = SqlParserUtil.parseString(token.image);
                unicodeEscapeChar = SqlParserUtil.checkUnicodeEscapeChar(s);
        break;
      default:
        jj_la1[391] = jj_gen;
        ;
      }
            pos = span.end(this).withQuoting(true);
            SqlLiteral lit = SqlLiteral.createCharString(image, "UTF16", pos);
            lit = lit.unescapeUnicode(unicodeEscapeChar);
            id = lit.toValue();
      break;
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
      id = NonReservedKeyWord();
            pos = getPos();
      break;
    default:
      jj_la1[392] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (id.length() > this.identifierMaxLength) {
            {if (true) throw SqlUtil.newContextException(pos,
                RESOURCE.identifierTooLong(id, this.identifierMaxLength));}
        }
        names.add(id);
        if (positions != null) {
            positions.add(pos);
        }
  }

/** As {@link #AddIdentifierSegment} but part of a table name (for example,
 * following {@code FROM}, {@code INSERT} or {@code UPDATE}).
 *
 * <p>In some dialects the lexical rules for table names are different from
 * for other identifiers. For example, in BigQuery, table names may contain
 * hyphens. */
  final public void AddTableIdentifierSegment(List<String> names, List<SqlParserPos> positions) throws ParseException {
    AddIdentifierSegment(names, positions);
        final int n = names.size();
        if (n > 0
                && positions.size() == n
                && names.get(n - 1).contains(".")
                && positions.get(n - 1).isQuoted()
                && this.conformance.splitQuotedTableName()) {
            final String name = names.remove(n - 1);
            final SqlParserPos pos = positions.remove(n - 1);
            final String[] splitNames = name.split("\\.");
            for (String splitName : splitNames) {
                names.add(splitName);
                positions.add(pos);
            }
        }
  }

/**
 * Parses a simple identifier as a String.
 */
  final public String Identifier() throws ParseException {
    final List<String> names = new ArrayList<String>();
    AddIdentifierSegment(names, null);
        {if (true) return names.get(0);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a simple identifier as an SqlIdentifier.
 */
  final public SqlIdentifier SimpleIdentifier() throws ParseException {
    final List<String> names = new ArrayList<String>();
    final List<SqlParserPos> positions = new ArrayList<SqlParserPos>();
    AddIdentifierSegment(names, positions);
        {if (true) return new SqlIdentifier(names.get(0), positions.get(0));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a character literal as an SqlIdentifier.
 * Only valid for column aliases in certain dialects.
 */
  final public SqlIdentifier SimpleIdentifierFromStringLiteral() throws ParseException {
    jj_consume_token(QUOTED_STRING);
        if (!this.conformance.allowCharLiteralAlias()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.charLiteralAliasNotValid());}
        }
        final String s = SqlParserUtil.parseString(token.image);
        {if (true) return new SqlIdentifier(s, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a comma-separated list of simple identifiers.
 */
  final public void AddSimpleIdentifiers(List<SqlNode> list) throws ParseException {
    SqlIdentifier id;
    id = SimpleIdentifier();
                             list.add(id);
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[393] = jj_gen;
        break label_62;
      }
      jj_consume_token(COMMA);
      id = SimpleIdentifier();
            list.add(id);
    }
  }

/**
  * List of simple identifiers in parentheses. The position extends from the
  * open parenthesis to the close parenthesis.
  */
  final public SqlNodeList ParenthesizedSimpleIdentifierList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    AddSimpleIdentifiers(list);
    jj_consume_token(RPAREN);
        {if (true) return new SqlNodeList(list, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/** List of simple identifiers in parentheses or one simple identifier.
 *
 * <ul>Examples:
 * <li>{@code DEPTNO}
 * <li>{@code (EMPNO, DEPTNO)}
 * </ul>
 */
  final public SqlNodeList SimpleIdentifierOrList() throws ParseException {
    SqlIdentifier id;
    SqlNodeList list;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      id = SimpleIdentifier();
        {if (true) return new SqlNodeList(Collections.singletonList(id), id.getParserPosition());}
      break;
    case LPAREN:
      list = ParenthesizedSimpleIdentifierList();
        {if (true) return list;}
      break;
    default:
      jj_la1[394] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a compound identifier.
 */
  final public SqlIdentifier CompoundIdentifier() throws ParseException {
    final List<String> nameList = new ArrayList<String>();
    final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();
    boolean star = false;
    AddIdentifierSegment(nameList, posList);
    label_63:
    while (true) {
      if (jj_2_124(2)) {
        ;
      } else {
        break label_63;
      }
      jj_consume_token(DOT);
      AddIdentifierSegment(nameList, posList);
    }
    if (jj_2_125(2)) {
      jj_consume_token(DOT);
      jj_consume_token(STAR);
            star = true;
            nameList.add("");
            posList.add(getPos());
    } else {
      ;
    }
        SqlParserPos pos = SqlParserPos.sum(posList);
        if (star) {
            {if (true) return SqlIdentifier.star(nameList, pos, posList);}
        }
        {if (true) return new SqlIdentifier(nameList, null, pos, posList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a compound identifier in the FROM clause.
 */
  final public SqlIdentifier CompoundTableIdentifier() throws ParseException {
    final List<String> nameList = new ArrayList<String>();
    final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();
    AddTableIdentifierSegment(nameList, posList);
    label_64:
    while (true) {
      if (jj_2_126(2)) {
        ;
      } else {
        break label_64;
      }
      jj_consume_token(DOT);
      AddTableIdentifierSegment(nameList, posList);
    }
        SqlParserPos pos = SqlParserPos.sum(posList);
        {if (true) return new SqlIdentifier(nameList, null, pos, posList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a comma-separated list of compound identifiers.
 */
  final public void AddCompoundIdentifierTypes(List<SqlNode> list, List<SqlNode> extendList) throws ParseException {
    AddCompoundIdentifierType(list, extendList);
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[395] = jj_gen;
        break label_65;
      }
      jj_consume_token(COMMA);
      AddCompoundIdentifierType(list, extendList);
    }
  }

/**
 * List of compound identifiers in parentheses. The position extends from the
 * open parenthesis to the close parenthesis.
 */
  final public Pair<SqlNodeList, SqlNodeList> ParenthesizedCompoundIdentifierList() throws ParseException {
    final Span s;
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final List<SqlNode> extendList = new ArrayList<SqlNode>();
    jj_consume_token(LPAREN);
               s = span();
    AddCompoundIdentifierTypes(list, extendList);
    jj_consume_token(RPAREN);
        {if (true) return Pair.of(new SqlNodeList(list, s.end(this)), new SqlNodeList(extendList, s.end(this)));}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a NEW UDT(...) expression.
 */
  final public SqlNode NewSpecification() throws ParseException {
    final Span s;
    final SqlNode routineCall;
    jj_consume_token(NEW);
            s = span();
    routineCall = NamedRoutineCall(SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR,
                ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return SqlStdOperatorTable.NEW.createCall(s.end(routineCall), routineCall);}
    throw new Error("Missing return statement in function");
  }

//TODO: real parse errors.
  final public int UnsignedIntLiteral() throws ParseException {
    Token t;
    t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        try {
            {if (true) return Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
    throw new Error("Missing return statement in function");
  }

  final public int IntLiteral() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
    case PLUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNED_INTEGER_LITERAL:
        t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        break;
      case PLUS:
        jj_consume_token(PLUS);
        t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        break;
      default:
        jj_la1[396] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        try {
            {if (true) return Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
      break;
    case MINUS:
      jj_consume_token(MINUS);
      t = jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        try {
            {if (true) return -Integer.parseInt(t.image);}
        } catch (NumberFormatException ex) {
            {if (true) throw SqlUtil.newContextException(getPos(),
                RESOURCE.invalidLiteral(t.image, Integer.class.getCanonicalName()));}
        }
      break;
    default:
      jj_la1[397] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Type name with optional scale and precision.
  final public SqlDataTypeSpec DataType() throws ParseException {
    SqlTypeNameSpec typeName;
    final Span s;
    typeName = TypeName();
        s = Span.of(typeName.getParserPos());
    label_66:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
      case MULTISET:
        ;
        break;
      default:
        jj_la1[398] = jj_gen;
        break label_66;
      }
      typeName = CollectionsTypeName(typeName);
    }
        {if (true) return new SqlDataTypeSpec(typeName, s.add(typeName.getParserPos()).pos());}
    throw new Error("Missing return statement in function");
  }

// Some SQL type names need special handling due to the fact that they have
// spaces in them but are not quoted.
  final public SqlTypeNameSpec TypeName() throws ParseException {
    final SqlTypeNameSpec typeNameSpec;
    final SqlIdentifier typeName;
    final Span s = Span.of();
    if (jj_2_127(2)) {
      typeNameSpec = ExtendedSqlBasicTypeName();
    } else if (jj_2_128(2)) {
      typeNameSpec = CustomizedCollectionsTypeName();
    } else if (jj_2_129(2)) {
      typeNameSpec = SqlMapTypeName();
    } else if (jj_2_130(2)) {
      typeNameSpec = SqlRawTypeName();
    } else if (jj_2_131(2)) {
      typeNameSpec = ExtendedSqlRowTypeName();
    } else if (jj_2_132(2)) {
      typeNameSpec = SqlTypeName(s);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ROW:
        typeNameSpec = RowTypeName();
        break;
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        typeName = CompoundIdentifier();
            typeNameSpec = new SqlUserDefinedTypeNameSpec(typeName, s.end(this));
        break;
      default:
        jj_la1[399] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return typeNameSpec;}
    throw new Error("Missing return statement in function");
  }

// Types used for JDBC and ODBC scalar conversion function
  final public SqlTypeNameSpec SqlTypeName(Span s) throws ParseException {
    final SqlTypeNameSpec sqlTypeNameSpec;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BIGINT:
    case BOOLEAN:
    case DOUBLE:
    case FLOAT:
    case GEOMETRY:
    case INT:
    case INTEGER:
    case REAL:
    case SMALLINT:
    case TINYINT:
      sqlTypeNameSpec = SqlTypeName1(s);
      break;
    case BINARY:
    case VARBINARY:
      sqlTypeNameSpec = SqlTypeName2(s);
      break;
    case ANY:
    case DEC:
    case DECIMAL:
    case NUMERIC:
      sqlTypeNameSpec = SqlTypeName3(s);
      break;
    case CHAR:
    case CHARACTER:
    case VARCHAR:
      sqlTypeNameSpec = CharacterTypeName(s);
      break;
    case DATE:
    case TIME:
    case TIMESTAMP:
      sqlTypeNameSpec = DateTimeTypeName();
      break;
    default:
      jj_la1[400] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return sqlTypeNameSpec;}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that don't allow any extra specifications except the type name.
// For extra specification, we mean precision, scale, charSet, etc.
  final public SqlTypeNameSpec SqlTypeName1(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GEOMETRY:
      jj_consume_token(GEOMETRY);
            if (!this.conformance.allowGeometry()) {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.geometryDisabled());}
            }
            s.add(this);
            sqlTypeName = SqlTypeName.GEOMETRY;
      break;
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
                    s.add(this); sqlTypeName = SqlTypeName.BOOLEAN;
      break;
    case INT:
    case INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      case INT:
        jj_consume_token(INT);
        break;
      default:
        jj_la1[401] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                s.add(this); sqlTypeName = SqlTypeName.INTEGER;
      break;
    case TINYINT:
      jj_consume_token(TINYINT);
                    s.add(this); sqlTypeName = SqlTypeName.TINYINT;
      break;
    case SMALLINT:
      jj_consume_token(SMALLINT);
                     s.add(this); sqlTypeName = SqlTypeName.SMALLINT;
      break;
    case BIGINT:
      jj_consume_token(BIGINT);
                   s.add(this); sqlTypeName = SqlTypeName.BIGINT;
      break;
    case REAL:
      jj_consume_token(REAL);
                 s.add(this); sqlTypeName = SqlTypeName.REAL;
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
                   s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRECISION:
        jj_consume_token(PRECISION);
        break;
      default:
        jj_la1[402] = jj_gen;
        ;
      }
                          sqlTypeName = SqlTypeName.DOUBLE;
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
                  s.add(this); sqlTypeName = SqlTypeName.FLOAT;
      break;
    default:
      jj_la1[403] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that allows precision specification.
  final public SqlTypeNameSpec SqlTypeName2(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    int precision = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY:
      jj_consume_token(BINARY);
                   s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VARYING:
        jj_consume_token(VARYING);
                        sqlTypeName = SqlTypeName.VARBINARY;
        break;
      default:
        jj_la1[404] = jj_gen;
              sqlTypeName = SqlTypeName.BINARY;
      }
      break;
    case VARBINARY:
      jj_consume_token(VARBINARY);
                      s.add(this); sqlTypeName = SqlTypeName.VARBINARY;
      break;
    default:
      jj_la1[405] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    precision = PrecisionOpt();
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Parse sql type name that allows precision and scale specifications.
  final public SqlTypeNameSpec SqlTypeName3(Span s) throws ParseException {
    final SqlTypeName sqlTypeName;
    int precision = -1;
    int scale = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEC:
    case DECIMAL:
    case NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      case DEC:
        jj_consume_token(DEC);
        break;
      case NUMERIC:
        jj_consume_token(NUMERIC);
        break;
      default:
        jj_la1[406] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                          s.add(this); sqlTypeName = SqlTypeName.DECIMAL;
      break;
    case ANY:
      jj_consume_token(ANY);
                s.add(this); sqlTypeName = SqlTypeName.ANY;
      break;
    default:
      jj_la1[407] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      precision = UnsignedIntLiteral();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        scale = UnsignedIntLiteral();
        break;
      default:
        jj_la1[408] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[409] = jj_gen;
      ;
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, scale, s.end(this));}
    throw new Error("Missing return statement in function");
  }

// Types used for for JDBC and ODBC scalar conversion function
  final public SqlJdbcDataTypeName JdbcOdbcDataTypeName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case SQL_CHAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_CHAR:
        jj_consume_token(SQL_CHAR);
        break;
      case CHAR:
        jj_consume_token(CHAR);
        break;
      default:
        jj_la1[410] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_CHAR;}
      break;
    case SQL_VARCHAR:
    case VARCHAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_VARCHAR:
        jj_consume_token(SQL_VARCHAR);
        break;
      case VARCHAR:
        jj_consume_token(VARCHAR);
        break;
      default:
        jj_la1[411] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_VARCHAR;}
      break;
    case DATE:
    case SQL_DATE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DATE:
        jj_consume_token(SQL_DATE);
        break;
      case DATE:
        jj_consume_token(DATE);
        break;
      default:
        jj_la1[412] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_DATE;}
      break;
    case SQL_TIME:
    case TIME:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TIME:
        jj_consume_token(SQL_TIME);
        break;
      case TIME:
        jj_consume_token(TIME);
        break;
      default:
        jj_la1[413] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                            {if (true) return SqlJdbcDataTypeName.SQL_TIME;}
      break;
    case SQL_TIMESTAMP:
    case TIMESTAMP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TIMESTAMP:
        jj_consume_token(SQL_TIMESTAMP);
        break;
      case TIMESTAMP:
        jj_consume_token(TIMESTAMP);
        break;
      default:
        jj_la1[414] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                      {if (true) return SqlJdbcDataTypeName.SQL_TIMESTAMP;}
      break;
    case DECIMAL:
    case SQL_DECIMAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DECIMAL:
        jj_consume_token(SQL_DECIMAL);
        break;
      case DECIMAL:
        jj_consume_token(DECIMAL);
        break;
      default:
        jj_la1[415] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_DECIMAL;}
      break;
    case NUMERIC:
    case SQL_NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_NUMERIC:
        jj_consume_token(SQL_NUMERIC);
        break;
      case NUMERIC:
        jj_consume_token(NUMERIC);
        break;
      default:
        jj_la1[416] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_NUMERIC;}
      break;
    case BOOLEAN:
    case SQL_BOOLEAN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BOOLEAN:
        jj_consume_token(SQL_BOOLEAN);
        break;
      case BOOLEAN:
        jj_consume_token(BOOLEAN);
        break;
      default:
        jj_la1[417] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_BOOLEAN;}
      break;
    case INTEGER:
    case SQL_INTEGER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_INTEGER:
        jj_consume_token(SQL_INTEGER);
        break;
      case INTEGER:
        jj_consume_token(INTEGER);
        break;
      default:
        jj_la1[418] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_INTEGER;}
      break;
    case BINARY:
    case SQL_BINARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BINARY:
        jj_consume_token(SQL_BINARY);
        break;
      case BINARY:
        jj_consume_token(BINARY);
        break;
      default:
        jj_la1[419] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_BINARY;}
      break;
    case SQL_VARBINARY:
    case VARBINARY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_VARBINARY:
        jj_consume_token(SQL_VARBINARY);
        break;
      case VARBINARY:
        jj_consume_token(VARBINARY);
        break;
      default:
        jj_la1[420] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                      {if (true) return SqlJdbcDataTypeName.SQL_VARBINARY;}
      break;
    case SQL_TINYINT:
    case TINYINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_TINYINT:
        jj_consume_token(SQL_TINYINT);
        break;
      case TINYINT:
        jj_consume_token(TINYINT);
        break;
      default:
        jj_la1[421] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                  {if (true) return SqlJdbcDataTypeName.SQL_TINYINT;}
      break;
    case SMALLINT:
    case SQL_SMALLINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_SMALLINT:
        jj_consume_token(SQL_SMALLINT);
        break;
      case SMALLINT:
        jj_consume_token(SMALLINT);
        break;
      default:
        jj_la1[422] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                    {if (true) return SqlJdbcDataTypeName.SQL_SMALLINT;}
      break;
    case BIGINT:
    case SQL_BIGINT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_BIGINT:
        jj_consume_token(SQL_BIGINT);
        break;
      case BIGINT:
        jj_consume_token(BIGINT);
        break;
      default:
        jj_la1[423] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_BIGINT;}
      break;
    case REAL:
    case SQL_REAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_REAL:
        jj_consume_token(SQL_REAL);
        break;
      case REAL:
        jj_consume_token(REAL);
        break;
      default:
        jj_la1[424] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                           {if (true) return SqlJdbcDataTypeName.SQL_REAL;}
      break;
    case DOUBLE:
    case SQL_DOUBLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_DOUBLE:
        jj_consume_token(SQL_DOUBLE);
        break;
      case DOUBLE:
        jj_consume_token(DOUBLE);
        break;
      default:
        jj_la1[425] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                {if (true) return SqlJdbcDataTypeName.SQL_DOUBLE;}
      break;
    case FLOAT:
    case SQL_FLOAT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SQL_FLOAT:
        jj_consume_token(SQL_FLOAT);
        break;
      case FLOAT:
        jj_consume_token(FLOAT);
        break;
      default:
        jj_la1[426] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                              {if (true) return SqlJdbcDataTypeName.SQL_FLOAT;}
      break;
    case SQL_INTERVAL_YEAR:
      jj_consume_token(SQL_INTERVAL_YEAR);
                          {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR;}
      break;
    case SQL_INTERVAL_YEAR_TO_MONTH:
      jj_consume_token(SQL_INTERVAL_YEAR_TO_MONTH);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_YEAR_TO_MONTH;}
      break;
    case SQL_INTERVAL_MONTH:
      jj_consume_token(SQL_INTERVAL_MONTH);
                           {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MONTH;}
      break;
    case SQL_INTERVAL_DAY:
      jj_consume_token(SQL_INTERVAL_DAY);
                         {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY;}
      break;
    case SQL_INTERVAL_DAY_TO_HOUR:
      jj_consume_token(SQL_INTERVAL_DAY_TO_HOUR);
                                 {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_HOUR;}
      break;
    case SQL_INTERVAL_DAY_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_DAY_TO_MINUTE);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_MINUTE;}
      break;
    case SQL_INTERVAL_DAY_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_DAY_TO_SECOND);
                                   {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_DAY_TO_SECOND;}
      break;
    case SQL_INTERVAL_HOUR:
      jj_consume_token(SQL_INTERVAL_HOUR);
                          {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR;}
      break;
    case SQL_INTERVAL_HOUR_TO_MINUTE:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_MINUTE);
                                    {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_MINUTE;}
      break;
    case SQL_INTERVAL_HOUR_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_HOUR_TO_SECOND);
                                    {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_HOUR_TO_SECOND;}
      break;
    case SQL_INTERVAL_MINUTE:
      jj_consume_token(SQL_INTERVAL_MINUTE);
                            {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE;}
      break;
    case SQL_INTERVAL_MINUTE_TO_SECOND:
      jj_consume_token(SQL_INTERVAL_MINUTE_TO_SECOND);
                                      {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_MINUTE_TO_SECOND;}
      break;
    case SQL_INTERVAL_SECOND:
      jj_consume_token(SQL_INTERVAL_SECOND);
                            {if (true) return SqlJdbcDataTypeName.SQL_INTERVAL_SECOND;}
      break;
    default:
      jj_la1[427] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlLiteral JdbcOdbcDataType() throws ParseException {
    SqlJdbcDataTypeName typeName;
    typeName = JdbcOdbcDataTypeName();
        {if (true) return typeName.symbol(getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a collection type name, the input element type name may
* also be a collection type.
*/
  final public SqlTypeNameSpec CollectionsTypeName(SqlTypeNameSpec elementTypeName) throws ParseException {
    final SqlTypeName collectionTypeName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MULTISET:
      jj_consume_token(MULTISET);
                     collectionTypeName = SqlTypeName.MULTISET;
      break;
    case ARRAY:
      jj_consume_token(ARRAY);
                  collectionTypeName = SqlTypeName.ARRAY;
      break;
    default:
      jj_la1[428] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlCollectionTypeNameSpec(elementTypeName,
                collectionTypeName, getPos());}
    throw new Error("Missing return statement in function");
  }

/**
* Parse a nullable option, default is true.
*/
  final public boolean NullableOptDefaultTrue() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
             {if (true) return true;}
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[429] = jj_gen;
      {if (true) return true;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a nullable option, default is false.
*/
  final public boolean NullableOptDefaultFalse() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
             {if (true) return true;}
      break;
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[430] = jj_gen;
      {if (true) return false;}
    }
    throw new Error("Missing return statement in function");
  }

/** Parses NOT NULL and returns false, or parses nothing and returns true. */
  final public boolean NotNullOpt() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      jj_consume_token(NOT);
      jj_consume_token(NULL);
                   {if (true) return false;}
      break;
    default:
      jj_la1[431] = jj_gen;
      {if (true) return true;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a "name1 type1 [NULL | NOT NULL], name2 type2 [NULL | NOT NULL] ..." list,
* the field type default is not nullable.
*/
  final public void AddFieldNameTypes(List<SqlIdentifier> fieldNames,
    List<SqlDataTypeSpec> fieldTypes) throws ParseException {
    AddFieldNameType(fieldNames, fieldTypes);
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[432] = jj_gen;
        break label_67;
      }
      jj_consume_token(COMMA);
      AddFieldNameType(fieldNames, fieldTypes);
    }
  }

  final public void AddFieldNameType(List<SqlIdentifier> fieldNames,
    List<SqlDataTypeSpec> fieldTypes) throws ParseException {
    final SqlIdentifier fName;
    final SqlDataTypeSpec fType;
    final boolean nullable;
    fName = SimpleIdentifier();
    fType = DataType();
    nullable = NullableOptDefaultFalse();
        fieldNames.add(fName);
        fieldTypes.add(fType.withNullable(nullable, getPos()));
  }

/**
* Parse Row type with format: Row(name1 type1, name2 type2).
* Every field type can have suffix of `NULL` or `NOT NULL` to indicate if this type is nullable.
* i.e. Row(f0 int not null, f1 varchar null).
*/
  final public SqlTypeNameSpec RowTypeName() throws ParseException {
    List<SqlIdentifier> fieldNames = new ArrayList<SqlIdentifier>();
    List<SqlDataTypeSpec> fieldTypes = new ArrayList<SqlDataTypeSpec>();
    jj_consume_token(ROW);
    jj_consume_token(LPAREN);
    AddFieldNameTypes(fieldNames, fieldTypes);
    jj_consume_token(RPAREN);
        {if (true) return new SqlRowTypeNameSpec(getPos(), fieldNames, fieldTypes);}
    throw new Error("Missing return statement in function");
  }

/**
* Parse character types: char, varchar.
*/
  final public SqlTypeNameSpec CharacterTypeName(Span s) throws ParseException {
    int precision = -1;
    final SqlTypeName sqlTypeName;
    String charSetName = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case CHARACTER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHARACTER:
        jj_consume_token(CHARACTER);
        break;
      case CHAR:
        jj_consume_token(CHAR);
        break;
      default:
        jj_la1[433] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                 s.add(this);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VARYING:
        jj_consume_token(VARYING);
                        sqlTypeName = SqlTypeName.VARCHAR;
        break;
      default:
        jj_la1[434] = jj_gen;
              sqlTypeName = SqlTypeName.CHAR;
      }
      break;
    case VARCHAR:
      jj_consume_token(VARCHAR);
                    s.add(this); sqlTypeName = SqlTypeName.VARCHAR;
      break;
    default:
      jj_la1[435] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    precision = PrecisionOpt();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARACTER:
      jj_consume_token(CHARACTER);
      jj_consume_token(SET);
      charSetName = Identifier();
      break;
    default:
      jj_la1[436] = jj_gen;
      ;
    }
        {if (true) return new SqlBasicTypeNameSpec(sqlTypeName, precision, charSetName, s.end(this));}
    throw new Error("Missing return statement in function");
  }

/**
* Parse datetime types: date, time, timestamp.
*/
  final public SqlTypeNameSpec DateTimeTypeName() throws ParseException {
    int precision = -1;
    SqlTypeName typeName;
    boolean withLocalTimeZone = false;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
      jj_consume_token(DATE);
        typeName = SqlTypeName.DATE;
        {if (true) return new SqlBasicTypeNameSpec(typeName, getPos());}
      break;
    default:
      jj_la1[437] = jj_gen;
      if (jj_2_133(2)) {
        jj_consume_token(TIME);
             s = span();
        precision = PrecisionOpt();
        withLocalTimeZone = TimeZoneOpt();
        if (withLocalTimeZone) {
            typeName = SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE;
        } else {
            typeName = SqlTypeName.TIME;
        }
        {if (true) return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TIMESTAMP:
          jj_consume_token(TIMESTAMP);
                  s = span();
          precision = PrecisionOpt();
          withLocalTimeZone = TimeZoneOpt();
        if (withLocalTimeZone) {
            typeName = SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
        } else {
            typeName = SqlTypeName.TIMESTAMP;
        }
        {if (true) return new SqlBasicTypeNameSpec(typeName, precision, s.end(this));}
          break;
        default:
          jj_la1[438] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

// Parse an optional data type precision, default is -1.
  final public int PrecisionOpt() throws ParseException {
    int precision = -1;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      precision = UnsignedIntLiteral();
      jj_consume_token(RPAREN);
      {if (true) return precision;}
      break;
    default:
      jj_la1[439] = jj_gen;
      {if (true) return -1;}
    }
    throw new Error("Missing return statement in function");
  }

/**
* Parse a time zone suffix for DateTime types. According to SQL-2011,
* "with time zone" and "without time zone" belong to standard SQL but we
* only implement the "without time zone".
*
* <p>We also support "with local time zone".
*
* @return true if this is "with local time zone".
*/
  final public boolean TimeZoneOpt() throws ParseException {
    if (jj_2_134(3)) {
      jj_consume_token(WITHOUT);
      jj_consume_token(TIME);
      jj_consume_token(ZONE);
                              {if (true) return false;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WITH:
        jj_consume_token(WITH);
        jj_consume_token(LOCAL);
        jj_consume_token(TIME);
        jj_consume_token(ZONE);
                                   {if (true) return true;}
        break;
      default:
        jj_la1[440] = jj_gen;
      {if (true) return false;}
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a CURSOR(query) expression.  The parser allows these
 * anywhere, but the validator restricts them to appear only as
 * arguments to table functions.
 */
  final public SqlNode CursorExpression(ExprContext exprContext) throws ParseException {
    final SqlNode e;
    final Span s;
    jj_consume_token(CURSOR);
        s = span();
        if (exprContext != ExprContext.ACCEPT_ALL
                && exprContext != ExprContext.ACCEPT_CURSOR) {
            {if (true) throw SqlUtil.newContextException(s.end(this),
                RESOURCE.illegalCursorExpression());}
        }
    e = Expression(ExprContext.ACCEPT_QUERY);
        {if (true) return SqlStdOperatorTable.CURSOR.createCall(s.end(e), e);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a builtin function with special syntax.
 */
  final public SqlNode BuiltinFunctionCall() throws ParseException {
    final SqlIdentifier name;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    final Span s;
    SqlDataTypeSpec dt;
    final TimeUnit unit;
    final SqlNode node;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CAST:
      jj_consume_token(CAST);
                 s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(AS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case ANY:
      case APPLY:
      case ARRAY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BIGINT:
      case BINARY:
      case BOOLEAN:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHARACTER:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DEC:
      case DECADE:
      case DECIMAL:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOUBLE:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FLOAT:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INT:
      case INTEGER:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MULTISET:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case NUMERIC:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case REAL:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SMALLINT:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIME:
      case TIMESTAMP:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TINYINT:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VARBINARY:
      case VARCHAR:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case BYTES:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case RAW:
      case REMOVE:
      case STOP:
      case STRING:
      case UNLOAD:
      case VIRTUAL:
      case TIMESTAMP_LTZ:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        dt = DataType();
                              args.add(dt);
        break;
      case INTERVAL:
        jj_consume_token(INTERVAL);
        e = IntervalQualifier();
                                                 args.add(e);
        break;
      default:
        jj_la1[441] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.CAST.createCall(s.end(this), args);}
      break;
    case EXTRACT:
      jj_consume_token(EXTRACT);
                    s = span();
      jj_consume_token(LPAREN);
      unit = TimeUnitForExtract();
            args.add(new SqlIntervalQualifier(unit, null, getPos()));
      jj_consume_token(FROM);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.EXTRACT.createCall(s.end(this), args);}
      break;
    case POSITION:
      jj_consume_token(POSITION);
                     s = span();
      jj_consume_token(LPAREN);
      // FIXME jvs 31-Aug-2006:  FRG-192:  This should be
              // Expression(ExprContext.ACCEPT_SUB_QUERY), but that doesn't work
              // because it matches the other kind of IN.
              e = AtomicRowExpression();
                                    args.add(e);
      jj_consume_token(IN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        break;
      default:
        jj_la1[442] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.POSITION.createCall(s.end(this), args);}
      break;
    case CONVERT:
      jj_consume_token(CONVERT);
                    s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(USING);
      name = SimpleIdentifier();
                                            args.add(name);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.CONVERT.createCall(s.end(this), args);}
      break;
    case TRANSLATE:
      jj_consume_token(TRANSLATE);
                      s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USING:
        jj_consume_token(USING);
        name = SimpleIdentifier();
                                                args.add(name);
        jj_consume_token(RPAREN);
                {if (true) return SqlStdOperatorTable.TRANSLATE.createCall(s.end(this),
                    args);}
        break;
      case RPAREN:
      case COMMA:
        label_68:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[443] = jj_gen;
            break label_68;
          }
          jj_consume_token(COMMA);
          AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        }
        jj_consume_token(RPAREN);
                {if (true) return SqlLibraryOperators.TRANSLATE3.createCall(s.end(this),
                    args);}
        break;
      default:
        jj_la1[444] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case OVERLAY:
      jj_consume_token(OVERLAY);
                    s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(PLACING);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(FROM);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        break;
      default:
        jj_la1[445] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.OVERLAY.createCall(s.end(this), args);}
      break;
    case FLOOR:
      jj_consume_token(FLOOR);
                  s = span();
      e = FloorCeilOptions(s, true);
            {if (true) return e;}
      break;
    case CEIL:
    case CEILING:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CEIL:
        jj_consume_token(CEIL);
        break;
      case CEILING:
        jj_consume_token(CEILING);
        break;
      default:
        jj_la1[446] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                s = span();
      e = FloorCeilOptions(s, false);
            {if (true) return e;}
      break;
    case SUBSTRING:
      jj_consume_token(SUBSTRING);
                      s = span();
      jj_consume_token(LPAREN);
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        jj_consume_token(FROM);
        break;
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[447] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
      case COMMA:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FOR:
          jj_consume_token(FOR);
          break;
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[448] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
        break;
      default:
        jj_la1[449] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.SUBSTRING.createCall(
                s.end(this), args);}
      break;
    case TRIM:
      jj_consume_token(TRIM);
            SqlLiteral flag = null;
            SqlNode trimChars = null;
            s = span();
      jj_consume_token(LPAREN);
      if (jj_2_135(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BOTH:
        case LEADING:
        case TRAILING:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BOTH:
            jj_consume_token(BOTH);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.BOTH.symbol(getPos());
            break;
          case TRAILING:
            jj_consume_token(TRAILING);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.TRAILING.symbol(getPos());
            break;
          case LEADING:
            jj_consume_token(LEADING);
                    s.add(this);
                    flag = SqlTrimFunction.Flag.LEADING.symbol(getPos());
            break;
          default:
            jj_la1[450] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[451] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ARRAY:
        case ARRAY_AGG:
        case ARRAY_CONCAT_AGG:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CASE:
        case CAST:
        case CATALOG:
        case CATALOG_NAME:
        case CEIL:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASSIFIER:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case CONVERT:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT:
        case CURRENT_CATALOG:
        case CURRENT_DATE:
        case CURRENT_DEFAULT_TRANSFORM_GROUP:
        case CURRENT_PATH:
        case CURRENT_ROLE:
        case CURRENT_SCHEMA:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURRENT_USER:
        case CURSOR:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXISTS:
        case EXP:
        case EXTRACT:
        case FALSE:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUP_CONCAT:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INTERVAL:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case JSON_ARRAY:
        case JSON_ARRAYAGG:
        case JSON_EXISTS:
        case JSON_OBJECT:
        case JSON_OBJECTAGG:
        case JSON_QUERY:
        case JSON_VALUE:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MATCH_NUMBER:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MULTISET:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NEW:
        case NEXT:
        case NORMALIZED:
        case NOT:
        case NTH_VALUE:
        case NTILE:
        case NULL:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERLAY:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENTILE_CONT:
        case PERCENTILE_DISC:
        case PERCENT_RANK:
        case PERIOD:
        case PLACING:
        case PLAN:
        case PLI:
        case POSITION:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PREV:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW:
        case ROW_COUNT:
        case ROW_NUMBER:
        case RUNNING:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SESSION_USER:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRING_AGG:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case SYSTEM_USER:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIME:
        case TIMESTAMP:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRANSLATE:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRIM:
        case TRUE:
        case TRUNCATE:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNIQUE:
        case UNKNOWN:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case CHANGELOG_MODE:
        case COMPACT:
        case COMPILE:
        case COLUMNS:
        case DRAIN:
        case ENFORCED:
        case ESTIMATED_COST:
        case IF:
        case JSON_EXECUTION_PLAN:
        case PLAN_ADVICE:
        case JAR:
        case JARS:
        case JOB:
        case JOBS:
        case LOAD:
        case METADATA:
        case OVERWRITE:
        case OVERWRITING:
        case PARTITIONED:
        case PARTITIONS:
        case PYTHON:
        case REMOVE:
        case STOP:
        case UNLOAD:
        case VIRTUAL:
        case TRY_CAST:
        case ANALYZE:
        case COMPUTE:
        case STATISTICS:
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
        case BINARY_STRING_LITERAL:
        case QUOTED_STRING:
        case PREFIXED_STRING_LITERAL:
        case UNICODE_STRING_LITERAL:
        case BIG_QUERY_DOUBLE_QUOTED_STRING:
        case BIG_QUERY_QUOTED_STRING:
        case LPAREN:
        case LBRACE_D:
        case LBRACE_T:
        case LBRACE_TS:
        case LBRACE_FN:
        case HOOK:
        case PLUS:
        case MINUS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          trimChars = Expression(ExprContext.ACCEPT_SUB_QUERY);
          break;
        default:
          jj_la1[452] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          jj_consume_token(FROM);
                    if (null == flag && null == trimChars) {
                        {if (true) throw SqlUtil.newContextException(getPos(),
                            RESOURCE.illegalFromEmpty());}
                    }
          break;
        case RPAREN:
          jj_consume_token(RPAREN);
                    // This is to handle the case of TRIM(x)
                    // (FRG-191).
                    if (flag == null) {
                        flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
                    }
                    args.add(flag);
                    args.add(null); // no trim chars
                    args.add(trimChars); // reinterpret trimChars as source
                    {if (true) return SqlStdOperatorTable.TRIM.createCall(s.end(this),
                        args);}
          break;
        default:
          jj_la1[453] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            if (flag == null) {
                flag = SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO);
            }
            args.add(flag);
            args.add(trimChars);
            args.add(e);
      jj_consume_token(RPAREN);
            {if (true) return SqlStdOperatorTable.TRIM.createCall(s.end(this), args);}
      break;
    case TIMESTAMPADD:
      node = TimestampAddFunctionCall();
                                            {if (true) return node;}
      break;
    case TIMESTAMPDIFF:
      node = TimestampDiffFunctionCall();
                                             {if (true) return node;}
      break;
    case TRY_CAST:
      node = TryCastFunctionCall();
                                       {if (true) return node;}
      break;
    case CLASSIFIER:
    case FINAL:
    case FIRST:
    case LAST:
    case MATCH_NUMBER:
    case NEXT:
    case PREV:
    case RUNNING:
      node = MatchRecognizeFunctionCall();
                                              {if (true) return node;}
      break;
    case JSON_EXISTS:
      node = JsonExistsFunctionCall();
                                          {if (true) return node;}
      break;
    case JSON_VALUE:
      node = JsonValueFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_QUERY:
      node = JsonQueryFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_OBJECT:
      node = JsonObjectFunctionCall();
                                          {if (true) return node;}
      break;
    case JSON_OBJECTAGG:
      node = JsonObjectAggFunctionCall();
                                             {if (true) return node;}
      break;
    case JSON_ARRAY:
      node = JsonArrayFunctionCall();
                                         {if (true) return node;}
      break;
    case JSON_ARRAYAGG:
      node = JsonArrayAggFunctionCall();
                                            {if (true) return node;}
      break;
    case HOP:
    case SESSION:
    case TUMBLE:
      node = GroupByWindowingCall();
                                        {if (true) return node;}
      break;
    default:
      jj_la1[454] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlJsonEncoding JsonRepresentation() throws ParseException {
    jj_consume_token(JSON);
    if (jj_2_136(2)) {
      jj_consume_token(ENCODING);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UTF8:
        jj_consume_token(UTF8);
                     {if (true) return SqlJsonEncoding.UTF8;}
        break;
      case UTF16:
        jj_consume_token(UTF16);
                      {if (true) return SqlJsonEncoding.UTF16;}
        break;
      case UTF32:
        jj_consume_token(UTF32);
                      {if (true) return SqlJsonEncoding.UTF32;}
        break;
      default:
        jj_la1[455] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
        {if (true) return SqlJsonEncoding.UTF8;}
    throw new Error("Missing return statement in function");
  }

  final public void JsonInputClause() throws ParseException {
    jj_consume_token(FORMAT);
    JsonRepresentation();
  }

  final public SqlDataTypeSpec JsonReturningClause() throws ParseException {
    SqlDataTypeSpec dt;
    jj_consume_token(RETURNING);
    dt = DataType();
                                  {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public SqlDataTypeSpec JsonOutputClause() throws ParseException {
    SqlDataTypeSpec dataType;
    dataType = JsonReturningClause();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FORMAT:
      jj_consume_token(FORMAT);
      JsonRepresentation();
      break;
    default:
      jj_la1[456] = jj_gen;
      ;
    }
        {if (true) return dataType;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonPathSpec() throws ParseException {
    SqlNode e;
    e = StringLiteral();
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonApiCommonSyntax() throws ParseException {
    SqlNode e;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_NON_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PASSING:
      jj_consume_token(PASSING);
      e = Expression(ExprContext.ACCEPT_NON_QUERY);

      jj_consume_token(AS);
      e = SimpleIdentifier();

      label_69:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[457] = jj_gen;
          break label_69;
        }
        jj_consume_token(COMMA);
        e = Expression(ExprContext.ACCEPT_NON_QUERY);

        jj_consume_token(AS);
        e = SimpleIdentifier();

      }
      break;
    default:
      jj_la1[458] = jj_gen;
      ;
    }
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public SqlJsonExistsErrorBehavior JsonExistsErrorBehavior() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             {if (true) return SqlJsonExistsErrorBehavior.TRUE;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
              {if (true) return SqlJsonExistsErrorBehavior.FALSE;}
      break;
    case UNKNOWN:
      jj_consume_token(UNKNOWN);
                {if (true) return SqlJsonExistsErrorBehavior.UNKNOWN;}
      break;
    case ERROR:
      jj_consume_token(ERROR);
              {if (true) return SqlJsonExistsErrorBehavior.ERROR;}
      break;
    default:
      jj_la1[459] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonExistsFunctionCall() throws ParseException {
    List<SqlNode> args = new ArrayList<SqlNode>();
    List<SqlNode> commonSyntax;
    final Span span;
    SqlJsonExistsErrorBehavior errorBehavior;
    jj_consume_token(JSON_EXISTS);
                    span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args.addAll(commonSyntax);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
    case FALSE:
    case TRUE:
    case UNKNOWN:
      errorBehavior = JsonExistsErrorBehavior();
                                                    args.add(errorBehavior.symbol(getPos()));
      jj_consume_token(ON);
      jj_consume_token(ERROR);
      break;
    default:
      jj_la1[460] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_EXISTS.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonValueEmptyOrErrorBehavior() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlJsonValueEmptyOrErrorBehavior.ERROR.symbol(getPos()));
      break;
    case NULL:
      jj_consume_token(NULL);
            list.add(SqlJsonValueEmptyOrErrorBehavior.NULL.symbol(getPos()));
      break;
    case DEFAULT_:
      jj_consume_token(DEFAULT_);
            list.add(SqlJsonValueEmptyOrErrorBehavior.DEFAULT.symbol(getPos()));
      AddExpression(list, ExprContext.ACCEPT_NON_QUERY);
      break;
    default:
      jj_la1[461] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMPTY:
      jj_consume_token(EMPTY);
            list.add(SqlJsonEmptyOrError.EMPTY.symbol(getPos()));
      break;
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlJsonEmptyOrError.ERROR.symbol(getPos()));
      break;
    default:
      jj_la1[462] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonValueFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>(7);
    SqlNode e;
    List<SqlNode> commonSyntax;
    final Span span;
    List<SqlNode> behavior;
    jj_consume_token(JSON_VALUE);
                   span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args.addAll(commonSyntax);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURNING:
      e = JsonReturningClause();
            args.add(SqlJsonValueReturning.RETURNING.symbol(getPos()));
            args.add(e);
      break;
    default:
      jj_la1[463] = jj_gen;
      ;
    }
    label_70:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_:
      case ERROR:
      case NULL:
        ;
        break;
      default:
        jj_la1[464] = jj_gen;
        break label_70;
      }
      behavior = JsonValueEmptyOrErrorBehavior();
            args.addAll(behavior);
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_VALUE.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonQueryEmptyOrErrorBehavior() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.ERROR, getPos()));
      break;
    case NULL:
      jj_consume_token(NULL);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.NULL, getPos()));
      break;
    default:
      jj_la1[465] = jj_gen;
      if (jj_2_137(2)) {
        jj_consume_token(EMPTY);
        jj_consume_token(ARRAY);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY, getPos()));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EMPTY:
          jj_consume_token(EMPTY);
          jj_consume_token(OBJECT);
            list.add(SqlLiteral.createSymbol(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT, getPos()));
          break;
        default:
          jj_la1[466] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(ON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMPTY:
      jj_consume_token(EMPTY);
            list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.EMPTY, getPos()));
      break;
    case ERROR:
      jj_consume_token(ERROR);
            list.add(SqlLiteral.createSymbol(SqlJsonEmptyOrError.ERROR, getPos()));
      break;
    default:
      jj_la1[467] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonQueryWrapperBehavior() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHOUT:
      jj_consume_token(WITHOUT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARRAY:
        jj_consume_token(ARRAY);
        break;
      default:
        jj_la1[468] = jj_gen;
        ;
      }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY, getPos());}
      break;
    default:
      jj_la1[472] = jj_gen;
      if (jj_2_138(2)) {
        jj_consume_token(WITH);
        jj_consume_token(CONDITIONAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ARRAY:
          jj_consume_token(ARRAY);
          break;
        default:
          jj_la1[469] = jj_gen;
          ;
        }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY, getPos());}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case WITH:
          jj_consume_token(WITH);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UNCONDITIONAL:
            jj_consume_token(UNCONDITIONAL);
            break;
          default:
            jj_la1[470] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case ARRAY:
            jj_consume_token(ARRAY);
            break;
          default:
            jj_la1[471] = jj_gen;
            ;
          }
        {if (true) return SqlLiteral.createSymbol(SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY, getPos());}
          break;
        default:
          jj_la1[473] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonQueryFunctionCall() throws ParseException {
    final SqlNode[] args = new SqlNode[5];
    SqlNode e;
    List<SqlNode> commonSyntax;
    final Span span;
    List<SqlNode> behavior;
    jj_consume_token(JSON_QUERY);
                   span = span();
    jj_consume_token(LPAREN);
    commonSyntax = JsonApiCommonSyntax();
        args[0] = commonSyntax.get(0);
        args[1] = commonSyntax.get(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
    case WITHOUT:
      e = JsonQueryWrapperBehavior();
      jj_consume_token(WRAPPER);
            args[2] = e;
      break;
    default:
      jj_la1[474] = jj_gen;
      ;
    }
    label_71:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EMPTY:
      case ERROR:
      case NULL:
        ;
        break;
      default:
        jj_la1[475] = jj_gen;
        break label_71;
      }
      behavior = JsonQueryEmptyOrErrorBehavior();
            final SqlJsonEmptyOrError symbol =
                ((SqlLiteral) behavior.get(1)).getValueAs(SqlJsonEmptyOrError.class);
            switch (symbol) {
            case EMPTY:
                args[3] = behavior.get(0);
                break;
            case ERROR:
                args[4] = behavior.get(0);
                break;
            }
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_QUERY.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonName() throws ParseException {
    final SqlNode e;
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public List<SqlNode> JsonNameAndValue() throws ParseException {
    final List<SqlNode> list = new ArrayList<SqlNode>();
    final SqlNode e;
    boolean kvMode = false;
    if (jj_2_139(2)) {
      jj_consume_token(KEY);
                kvMode = true;
    } else {
      ;
    }
    e = JsonName();
        list.add(e);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUE:
      jj_consume_token(VALUE);
      break;
    case COLON:
      jj_consume_token(COLON);
            if (kvMode) {
                {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.illegalColon());}
            }
      break;
    default:
      jj_la1[476] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    AddExpression(list, ExprContext.ACCEPT_NON_QUERY);
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public SqlNode JsonConstructorNullClause() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
      jj_consume_token(ON);
      jj_consume_token(NULL);
        {if (true) return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.NULL_ON_NULL, getPos());}
      break;
    case ABSENT:
      jj_consume_token(ABSENT);
      jj_consume_token(ON);
      jj_consume_token(NULL);
        {if (true) return SqlLiteral.createSymbol(SqlJsonConstructorNullClause.ABSENT_ON_NULL, getPos());}
      break;
    default:
      jj_la1[477] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonObjectFunctionCall() throws ParseException {
    final List<SqlNode> nvArgs = new ArrayList<SqlNode>();
    final SqlNode[] otherArgs = new SqlNode[1];
    SqlNode e;
    List<SqlNode> list;
    final Span span;
    jj_consume_token(JSON_OBJECT);
                    span = span();
    jj_consume_token(LPAREN);
    if (jj_2_140(2)) {
      list = JsonNameAndValue();
            nvArgs.addAll(list);
      label_72:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[478] = jj_gen;
          break label_72;
        }
        jj_consume_token(COMMA);
        list = JsonNameAndValue();
                nvArgs.addAll(list);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            otherArgs[0] = e;
      break;
    default:
      jj_la1[479] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        final List<SqlNode> args = new ArrayList();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(nvArgs);
        {if (true) return SqlStdOperatorTable.JSON_OBJECT.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonObjectAggFunctionCall() throws ParseException {
    final SqlNode[] args = new SqlNode[2];
    List<SqlNode> list;
    final Span span;
    SqlJsonConstructorNullClause nullClause =
        SqlJsonConstructorNullClause.NULL_ON_NULL;
    final SqlNode e;
    jj_consume_token(JSON_OBJECTAGG);
                       span = span();
    jj_consume_token(LPAREN);
    list = JsonNameAndValue();
        args[0] = list.get(0);
        args[1] = list.get(1);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            nullClause = (SqlJsonConstructorNullClause) ((SqlLiteral) e).getValue();
      break;
    default:
      jj_la1[480] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.JSON_OBJECTAGG.with(nullClause)
            .createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonArrayFunctionCall() throws ParseException {
    final List<SqlNode> elements = new ArrayList<SqlNode>();
    final SqlNode[] otherArgs = new SqlNode[1];
    SqlNode e;
    final Span span;
    jj_consume_token(JSON_ARRAY);
                   span = span();
    jj_consume_token(LPAREN);
    if (jj_2_141(2)) {
      AddExpression(elements, ExprContext.ACCEPT_NON_QUERY);
      label_73:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[481] = jj_gen;
          break label_73;
        }
        jj_consume_token(COMMA);
        AddExpression(elements, ExprContext.ACCEPT_NON_QUERY);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            otherArgs[0] = e;
      break;
    default:
      jj_la1[482] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        final List<SqlNode> args = new ArrayList();
        args.addAll(Arrays.asList(otherArgs));
        args.addAll(elements);
        {if (true) return SqlStdOperatorTable.JSON_ARRAY.createCall(span.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlNodeList JsonArrayAggOrderByClause() throws ParseException {
    final SqlNodeList orderList;
    orderList = OrderBy(true);
      {if (true) return orderList;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall JsonArrayAggFunctionCall() throws ParseException {
    final SqlNode valueExpr;
    final SqlNodeList orderList;
    final Span span;
    final SqlJsonConstructorNullClause nullClause;
    SqlNode e;
    final SqlNode aggCall;
    jj_consume_token(JSON_ARRAYAGG);
                      span = span();
    jj_consume_token(LPAREN);
    e = Expression(ExprContext.ACCEPT_NON_QUERY);
        valueExpr = e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ORDER:
      orderList = JsonArrayAggOrderByClause();
      break;
    default:
      jj_la1[483] = jj_gen;
                                                  orderList = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABSENT:
    case NULL:
      e = JsonConstructorNullClause();
            nullClause = (SqlJsonConstructorNullClause) ((SqlLiteral) e).getValue();
      break;
    default:
      jj_la1[484] = jj_gen;
          nullClause = SqlJsonConstructorNullClause.ABSENT_ON_NULL;
    }
    jj_consume_token(RPAREN);
        aggCall = SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
            .createCall(span.end(this), valueExpr, orderList);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      e = withinGroup(aggCall);
            if (orderList != null) {
                {if (true) throw SqlUtil.newContextException(span.pos().plus(e.getParserPosition()),
                    RESOURCE.ambiguousSortOrderInJsonArrayAggFunc());}
            }
            {if (true) return (SqlCall) e;}
      break;
    default:
      jj_la1[485] = jj_gen;
      ;
    }
        if (orderList == null) {
            {if (true) return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
                .createCall(span.end(this), valueExpr);}
        }
        {if (true) return SqlStdOperatorTable.JSON_ARRAYAGG.with(nullClause)
            .createCall(span.end(this), valueExpr, orderList);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIMESTAMPADD.
 */
  final public SqlCall TimestampAddFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final TimeUnit interval;
    jj_consume_token(TIMESTAMPADD);
                     s = span();
    jj_consume_token(LPAREN);
    interval = TimestampInterval();
        args.add(SqlLiteral.createSymbol(interval, getPos()));
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.TIMESTAMP_ADD.createCall(
            s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to TIMESTAMPDIFF.
 */
  final public SqlCall TimestampDiffFunctionCall() throws ParseException {
    final List<SqlNode> args = new ArrayList<SqlNode>();
    final Span s;
    final TimeUnit interval;
    jj_consume_token(TIMESTAMPDIFF);
                      s = span();
    jj_consume_token(LPAREN);
    interval = TimestampInterval();
        args.add(SqlLiteral.createSymbol(interval, getPos()));
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(COMMA);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.TIMESTAMP_DIFF.createCall(
            s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a grouping function inside the GROUP BY clause,
 * for example {@code TUMBLE(rowtime, INTERVAL '1' MINUTE)}.
 */
  final public SqlCall GroupByWindowingCall() throws ParseException {
    final Span s;
    final List<SqlNode> args;
    final SqlOperator op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TUMBLE:
      jj_consume_token(TUMBLE);
                   op = SqlStdOperatorTable.TUMBLE_OLD;
      break;
    case HOP:
      jj_consume_token(HOP);
                op = SqlStdOperatorTable.HOP_OLD;
      break;
    case SESSION:
      jj_consume_token(SESSION);
                    op = SqlStdOperatorTable.SESSION_OLD;
      break;
    default:
      jj_la1[486] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    args = UnquantifiedFunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
        {if (true) return op.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeFunctionCall() throws ParseException {
    final SqlCall func;
    final Span s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASSIFIER:
      jj_consume_token(CLASSIFIER);
                       s = span();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            func = SqlStdOperatorTable.CLASSIFIER.createCall(s.end(this));
      break;
    case MATCH_NUMBER:
      jj_consume_token(MATCH_NUMBER);
                         s = span();
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            func = SqlStdOperatorTable.MATCH_NUMBER.createCall(s.end(this));
      break;
    default:
      jj_la1[487] = jj_gen;
      if (jj_2_142(3)) {
        func = MatchRecognizeNavigationLogical();
      } else if (jj_2_143(2)) {
        func = MatchRecognizeNavigationPhysical();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FINAL:
        case RUNNING:
          func = MatchRecognizeCallWithModifier();
          break;
        default:
          jj_la1[488] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
      {if (true) return func;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeCallWithModifier() throws ParseException {
    final Span s;
    final SqlOperator runningOp;
    final SqlNode func;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RUNNING:
      jj_consume_token(RUNNING);
                    runningOp = SqlStdOperatorTable.RUNNING;
      break;
    case FINAL:
      jj_consume_token(FINAL);
                  runningOp = SqlStdOperatorTable.FINAL;
      break;
    default:
      jj_la1[489] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    func = NamedFunctionCall();
        {if (true) return runningOp.createCall(s.end(func), func);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeNavigationLogical() throws ParseException {
    final Span s = Span.of();
    SqlCall func;
    final SqlOperator funcOp;
    final SqlOperator runningOp;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RUNNING:
      jj_consume_token(RUNNING);
                    runningOp = SqlStdOperatorTable.RUNNING; s.add(this);
      break;
    case FINAL:
      jj_consume_token(FINAL);
                  runningOp = SqlStdOperatorTable.FINAL; s.add(this);
      break;
    default:
      jj_la1[490] = jj_gen;
          runningOp = null;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRST:
      jj_consume_token(FIRST);
                  funcOp = SqlStdOperatorTable.FIRST;
      break;
    case LAST:
      jj_consume_token(LAST);
                 funcOp = SqlStdOperatorTable.LAST;
      break;
    default:
      jj_la1[491] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s.add(this);
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      e = NumericLiteral();
                                       args.add(e);
      break;
    default:
      jj_la1[492] = jj_gen;
          args.add(LITERAL_ZERO);
    }
    jj_consume_token(RPAREN);
        func = funcOp.createCall(s.end(this), args);
        if (runningOp != null) {
            {if (true) return runningOp.createCall(s.end(this), func);}
        } else {
            {if (true) return func;}
        }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall MatchRecognizeNavigationPhysical() throws ParseException {
    final Span s;
    final SqlOperator funcOp;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    SqlNode e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PREV:
      jj_consume_token(PREV);
                 funcOp = SqlStdOperatorTable.PREV;
      break;
    case NEXT:
      jj_consume_token(NEXT);
                 funcOp = SqlStdOperatorTable.NEXT;
      break;
    default:
      jj_la1[493] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      s = span();
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      e = NumericLiteral();
                                       args.add(e);
      break;
    default:
      jj_la1[494] = jj_gen;
          args.add(LITERAL_ONE);
    }
    jj_consume_token(RPAREN);
        {if (true) return funcOp.createCall(s.end(this), args);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall withinDistinct(SqlNode arg) throws ParseException {
    final Span s;
    final SqlNodeList distinctList;
    jj_consume_token(WITHIN);
               s = span();
    jj_consume_token(DISTINCT);
    jj_consume_token(LPAREN);
    distinctList = ExpressionCommaList(s, ExprContext.ACCEPT_SUB_QUERY);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.WITHIN_DISTINCT.createCall(
            s.end(this), arg, distinctList);}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall withinGroup(SqlNode arg) throws ParseException {
    final Span s;
    final SqlNodeList orderList;
    jj_consume_token(WITHIN);
               s = span();
    jj_consume_token(GROUP);
    jj_consume_token(LPAREN);
    orderList = OrderBy(true);
    jj_consume_token(RPAREN);
        {if (true) return SqlStdOperatorTable.WITHIN_GROUP.createCall(
            s.end(this), arg, orderList);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<SqlParserPos, SqlOperator> NullTreatment() throws ParseException {
    final Span span;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IGNORE:
      jj_consume_token(IGNORE);
               span = span();
      jj_consume_token(NULLS);
        {if (true) return Pair.of(span.end(this), SqlStdOperatorTable.IGNORE_NULLS);}
      break;
    case RESPECT:
      jj_consume_token(RESPECT);
                span = span();
      jj_consume_token(NULLS);
        {if (true) return Pair.of(span.end(this), SqlStdOperatorTable.RESPECT_NULLS);}
      break;
    default:
      jj_la1[495] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SqlCall nullTreatment(SqlCall arg) throws ParseException {
    final Pair<SqlParserPos, SqlOperator> pair;
    pair = NullTreatment();
                             {if (true) return pair.right.createCall(pair.left, arg);}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a call to a named function (could be a builtin with regular
 * syntax, or else a UDF).
 *
 * <p>NOTE: every UDF has two names: an <em>invocation name</em> and a
 * <em>specific name</em>.  Normally, function calls are resolved via overload
 * resolution and invocation names.  The SPECIFIC prefix allows overload
 * resolution to be bypassed.  Note that usage of the SPECIFIC prefix in
 * queries is non-standard; it is used internally by Farrago, e.g. in stored
 * view definitions to permanently bind references to a particular function
 * after the overload resolution performed by view creation.
 *
 * <p>TODO jvs 25-Mar-2005:  Once we have SQL-Flagger support, flag SPECIFIC
 * as non-standard.
 */
  final public SqlNode NamedFunctionCall() throws ParseException {
    SqlCall call;
    final Span filterSpan;
    final SqlNode filter;
    final Span overSpan;
    final SqlNode over;
    if (jj_2_144(2)) {
      call = StringAggFunctionCall();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABS:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case AVG:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CARDINALITY:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CEILING:
      case CENTURY:
      case CHAIN:
      case CHAR:
      case CHAR_LENGTH:
      case CHARACTER_LENGTH:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COALESCE:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLLECT:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case COUNT:
      case COVAR_POP:
      case COVAR_SAMP:
      case CUME_DIST:
      case CURRENT_DATE:
      case CURRENT_TIME:
      case CURRENT_TIMESTAMP:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DENSE_RANK:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ELEMENT:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EVERY:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case EXP:
      case FINAL:
      case FIRST:
      case FIRST_VALUE:
      case FLOOR:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case FUSION:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case GROUPING:
      case HIERARCHY:
      case HOP:
      case HOUR:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INTERSECTION:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAG:
      case LAST:
      case LAST_VALUE:
      case LEAD:
      case LEFT:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LN:
      case LOCALTIME:
      case LOCALTIMESTAMP:
      case LOCATOR:
      case LOWER:
      case M:
      case MAP:
      case MATCHED:
      case MAX:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MIN:
      case MINUTE:
      case MINUTES:
      case MINVALUE:
      case MOD:
      case MONTH:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NTH_VALUE:
      case NTILE:
      case NULLABLE:
      case NULLIF:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTET_LENGTH:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PERCENTILE_CONT:
      case PERCENTILE_DISC:
      case PERCENT_RANK:
      case PLACING:
      case PLAN:
      case PLI:
      case POWER:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case RANK:
      case READ:
      case REGR_COUNT:
      case REGR_SXX:
      case REGR_SYY:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case RIGHT:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case ROW_NUMBER:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECOND:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOME:
      case SOURCE:
      case SPACE:
      case SPECIFIC:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case SQRT:
      case STATE:
      case STDDEV_POP:
      case STDDEV_SAMP:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case SUM:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TRUNCATE:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case UPPER:
      case USAGE:
      case USER:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VAR_POP:
      case VAR_SAMP:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEAR:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        call = NamedCall();
        break;
      default:
        jj_la1[496] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_145(2)) {
      call = nullTreatment(call);
    } else {
      ;
    }
    if (jj_2_146(2)) {
      // decide between WITHIN DISTINCT and WITHIN GROUP
              call = withinDistinct(call);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITHIN:
      call = withinGroup(call);
      break;
    default:
      jj_la1[497] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FILTER:
      jj_consume_token(FILTER);
                   filterSpan = span();
      jj_consume_token(LPAREN);
      jj_consume_token(WHERE);
      filter = Expression(ExprContext.ACCEPT_SUB_QUERY);
      jj_consume_token(RPAREN);
            call = SqlStdOperatorTable.FILTER.createCall(
                filterSpan.end(this), call, filter);
      break;
    default:
      jj_la1[498] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVER:
      jj_consume_token(OVER);
                 overSpan = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        over = SimpleIdentifier();
        break;
      case LPAREN:
        over = WindowSpecification();
        break;
      default:
        jj_la1[499] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            call = SqlStdOperatorTable.OVER.createCall(overSpan.end(over), call, over);
      break;
    default:
      jj_la1[500] = jj_gen;
      ;
    }
        {if (true) return call;}
    throw new Error("Missing return statement in function");
  }

  final public SqlCall NamedCall() throws ParseException {
    final SqlFunctionCategory funcType;
    final SqlIdentifier qualifiedName;
    final Span s;
    final List<SqlNode> args;
    SqlLiteral quantifier = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPECIFIC:
      jj_consume_token(SPECIFIC);
            funcType = SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION;
      break;
    default:
      jj_la1[501] = jj_gen;
          funcType = SqlFunctionCategory.USER_DEFINED_FUNCTION;
    }
    qualifiedName = FunctionName();
        s = span();
    if (jj_2_147(2)) {
      jj_consume_token(LPAREN);
      jj_consume_token(STAR);
            args = ImmutableList.of(SqlIdentifier.star(getPos()));
      jj_consume_token(RPAREN);
    } else if (jj_2_148(2)) {
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
            args = ImmutableList.of();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        args = FunctionParameterList(ExprContext.ACCEPT_SUB_QUERY);
            quantifier = (SqlLiteral) args.get(0);
            args.remove(0);
        break;
      default:
        jj_la1[502] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return createCall(qualifiedName, s.end(this), funcType, quantifier, args);}
    throw new Error("Missing return statement in function");
  }

/*
* Parse Floor/Ceil function parameters
*/
  final public SqlNode StandardFloorCeilOptions(Span s, boolean floorFlag) throws ParseException {
    SqlNode e;
    final List<SqlNode> args = new ArrayList<SqlNode>();
    TimeUnit unit;
    SqlCall function;
    final Span s1;
    jj_consume_token(LPAREN);
    AddExpression(args, ExprContext.ACCEPT_SUB_QUERY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TO:
      jj_consume_token(TO);
      unit = TimeUnit();
            args.add(new SqlIntervalQualifier(unit, null, getPos()));
      break;
    default:
      jj_la1[503] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        SqlOperator op = floorFlag
            ? SqlStdOperatorTable.FLOOR
            : SqlStdOperatorTable.CEIL;
        function =  op.createCall(s.end(this), args);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OVER:
      jj_consume_token(OVER);
                 s1 = span();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
      case ABSENT:
      case ABSOLUTE:
      case ACTION:
      case ADA:
      case ADD:
      case ADMIN:
      case AFTER:
      case ALWAYS:
      case APPLY:
      case ASC:
      case ASSERTION:
      case ASSIGNMENT:
      case ATTRIBUTE:
      case ATTRIBUTES:
      case BEFORE:
      case BERNOULLI:
      case BREADTH:
      case C:
      case CASCADE:
      case CATALOG:
      case CATALOG_NAME:
      case CENTURY:
      case CHAIN:
      case CHARACTER_SET_CATALOG:
      case CHARACTER_SET_NAME:
      case CHARACTER_SET_SCHEMA:
      case CHARACTERISTICS:
      case CHARACTERS:
      case CLASS_ORIGIN:
      case COBOL:
      case COLLATION:
      case COLLATION_CATALOG:
      case COLLATION_NAME:
      case COLLATION_SCHEMA:
      case COLUMN_NAME:
      case COMMAND_FUNCTION:
      case COMMAND_FUNCTION_CODE:
      case COMMITTED:
      case CONDITIONAL:
      case CONDITION_NUMBER:
      case CONNECTION:
      case CONNECTION_NAME:
      case CONSTRAINT_CATALOG:
      case CONSTRAINT_NAME:
      case CONSTRAINT_SCHEMA:
      case CONSTRAINTS:
      case CONSTRUCTOR:
      case CONTINUE:
      case CURSOR_NAME:
      case DATA:
      case DATABASE:
      case DATETIME_INTERVAL_CODE:
      case DATETIME_INTERVAL_PRECISION:
      case DAYS:
      case DECADE:
      case DEFAULTS:
      case DEFERRABLE:
      case DEFERRED:
      case DEFINED:
      case DEFINER:
      case DEGREE:
      case DEPTH:
      case DERIVED:
      case DESC:
      case DESCRIPTION:
      case DESCRIPTOR:
      case DIAGNOSTICS:
      case DISPATCH:
      case DOMAIN:
      case DOW:
      case DOY:
      case DYNAMIC_FUNCTION:
      case DYNAMIC_FUNCTION_CODE:
      case ENCODING:
      case EPOCH:
      case ERROR:
      case EXCEPTION:
      case EXCLUDE:
      case EXCLUDING:
      case FINAL:
      case FIRST:
      case FOLLOWING:
      case FORMAT:
      case FORTRAN:
      case FOUND:
      case FRAC_SECOND:
      case G:
      case GENERAL:
      case GENERATED:
      case GEOMETRY:
      case GO:
      case GOTO:
      case GRANTED:
      case HIERARCHY:
      case HOP:
      case HOURS:
      case IGNORE:
      case IMMEDIATE:
      case IMMEDIATELY:
      case IMPLEMENTATION:
      case INCLUDING:
      case INCREMENT:
      case INITIALLY:
      case INPUT:
      case INSTANCE:
      case INSTANTIABLE:
      case INVOKER:
      case ISODOW:
      case ISOYEAR:
      case ISOLATION:
      case JAVA:
      case JSON:
      case K:
      case KEY:
      case KEY_MEMBER:
      case KEY_TYPE:
      case LABEL:
      case LAST:
      case LENGTH:
      case LEVEL:
      case LIBRARY:
      case LOCATOR:
      case M:
      case MAP:
      case MATCHED:
      case MAXVALUE:
      case MESSAGE_LENGTH:
      case MESSAGE_OCTET_LENGTH:
      case MESSAGE_TEXT:
      case MICROSECOND:
      case MILLISECOND:
      case MILLENNIUM:
      case MINUTES:
      case MINVALUE:
      case MONTHS:
      case MORE_:
      case MUMPS:
      case NAME:
      case NAMES:
      case NANOSECOND:
      case NESTING:
      case NORMALIZED:
      case NULLABLE:
      case NULLS:
      case NUMBER:
      case OBJECT:
      case OCTETS:
      case OPTION:
      case OPTIONS:
      case ORDERING:
      case ORDINALITY:
      case OTHERS:
      case OUTPUT:
      case OVERRIDING:
      case PAD:
      case PARAMETER_MODE:
      case PARAMETER_NAME:
      case PARAMETER_ORDINAL_POSITION:
      case PARAMETER_SPECIFIC_CATALOG:
      case PARAMETER_SPECIFIC_NAME:
      case PARAMETER_SPECIFIC_SCHEMA:
      case PARTIAL:
      case PASCAL:
      case PASSING:
      case PASSTHROUGH:
      case PAST:
      case PATH:
      case PLACING:
      case PLAN:
      case PLI:
      case PRECEDING:
      case PRESERVE:
      case PRIOR:
      case PRIVILEGES:
      case PUBLIC:
      case QUARTER:
      case READ:
      case RELATIVE:
      case REPEATABLE:
      case REPLACE:
      case RESPECT:
      case RESTART:
      case RESTRICT:
      case RETURNED_CARDINALITY:
      case RETURNED_LENGTH:
      case RETURNED_OCTET_LENGTH:
      case RETURNED_SQLSTATE:
      case RETURNING:
      case ROLE:
      case ROUTINE:
      case ROUTINE_CATALOG:
      case ROUTINE_NAME:
      case ROUTINE_SCHEMA:
      case ROW_COUNT:
      case SCALAR:
      case SCALE:
      case SCHEMA:
      case SCHEMA_NAME:
      case SCOPE_CATALOGS:
      case SCOPE_NAME:
      case SCOPE_SCHEMA:
      case SECONDS:
      case SECTION:
      case SECURITY:
      case SELF:
      case SEQUENCE:
      case SERIALIZABLE:
      case SERVER:
      case SERVER_NAME:
      case SESSION:
      case SETS:
      case SIMPLE:
      case SIZE:
      case SOURCE:
      case SPACE:
      case SPECIFIC_NAME:
      case SQL_BIGINT:
      case SQL_BINARY:
      case SQL_BIT:
      case SQL_BLOB:
      case SQL_BOOLEAN:
      case SQL_CHAR:
      case SQL_CLOB:
      case SQL_DATE:
      case SQL_DECIMAL:
      case SQL_DOUBLE:
      case SQL_FLOAT:
      case SQL_INTEGER:
      case SQL_INTERVAL_DAY:
      case SQL_INTERVAL_DAY_TO_HOUR:
      case SQL_INTERVAL_DAY_TO_MINUTE:
      case SQL_INTERVAL_DAY_TO_SECOND:
      case SQL_INTERVAL_HOUR:
      case SQL_INTERVAL_HOUR_TO_MINUTE:
      case SQL_INTERVAL_HOUR_TO_SECOND:
      case SQL_INTERVAL_MINUTE:
      case SQL_INTERVAL_MINUTE_TO_SECOND:
      case SQL_INTERVAL_MONTH:
      case SQL_INTERVAL_SECOND:
      case SQL_INTERVAL_YEAR:
      case SQL_INTERVAL_YEAR_TO_MONTH:
      case SQL_LONGVARBINARY:
      case SQL_LONGVARCHAR:
      case SQL_LONGVARNCHAR:
      case SQL_NCHAR:
      case SQL_NCLOB:
      case SQL_NUMERIC:
      case SQL_NVARCHAR:
      case SQL_REAL:
      case SQL_SMALLINT:
      case SQL_TIME:
      case SQL_TIMESTAMP:
      case SQL_TINYINT:
      case SQL_TSI_DAY:
      case SQL_TSI_FRAC_SECOND:
      case SQL_TSI_HOUR:
      case SQL_TSI_MICROSECOND:
      case SQL_TSI_MINUTE:
      case SQL_TSI_MONTH:
      case SQL_TSI_QUARTER:
      case SQL_TSI_SECOND:
      case SQL_TSI_WEEK:
      case SQL_TSI_YEAR:
      case SQL_VARBINARY:
      case SQL_VARCHAR:
      case STATE:
      case STRUCTURE:
      case STYLE:
      case SUBCLASS_ORIGIN:
      case SUBSTITUTE:
      case TABLE_NAME:
      case TEMPORARY:
      case TIES:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case TOP_LEVEL_COUNT:
      case TRANSACTION:
      case TRANSACTIONS_ACTIVE:
      case TRANSACTIONS_COMMITTED:
      case TRANSACTIONS_ROLLED_BACK:
      case TRANSFORM:
      case TRANSFORMS:
      case TRIGGER_CATALOG:
      case TRIGGER_NAME:
      case TRIGGER_SCHEMA:
      case TUMBLE:
      case TYPE:
      case UNBOUNDED:
      case UNCOMMITTED:
      case UNCONDITIONAL:
      case UNDER:
      case UNNAMED:
      case USAGE:
      case USER_DEFINED_TYPE_CATALOG:
      case USER_DEFINED_TYPE_CODE:
      case USER_DEFINED_TYPE_NAME:
      case USER_DEFINED_TYPE_SCHEMA:
      case UTF8:
      case UTF16:
      case UTF32:
      case VERSION:
      case VIEW:
      case WEEK:
      case WORK:
      case WRAPPER:
      case WRITE:
      case XML:
      case YEARS:
      case ZONE:
      case CHANGELOG_MODE:
      case COMPACT:
      case COMPILE:
      case COLUMNS:
      case DRAIN:
      case ENFORCED:
      case ESTIMATED_COST:
      case IF:
      case JSON_EXECUTION_PLAN:
      case PLAN_ADVICE:
      case JAR:
      case JARS:
      case JOB:
      case JOBS:
      case LOAD:
      case METADATA:
      case OVERWRITE:
      case OVERWRITING:
      case PARTITIONED:
      case PARTITIONS:
      case PYTHON:
      case REMOVE:
      case STOP:
      case UNLOAD:
      case VIRTUAL:
      case TRY_CAST:
      case ANALYZE:
      case COMPUTE:
      case STATISTICS:
      case BRACKET_QUOTED_IDENTIFIER:
      case QUOTED_IDENTIFIER:
      case BACK_QUOTED_IDENTIFIER:
      case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
      case HYPHENATED_IDENTIFIER:
      case IDENTIFIER:
      case UNICODE_QUOTED_IDENTIFIER:
        e = SimpleIdentifier();
        break;
      case LPAREN:
        e = WindowSpecification();
        break;
      default:
        jj_la1[504] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            {if (true) return SqlStdOperatorTable.OVER.createCall(s1.end(this), function, e);}
      break;
    default:
      jj_la1[505] = jj_gen;
          {if (true) return function;}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the name of a JDBC function that is a token but is not reserved.
 */
  final public String NonReservedJdbcFunctionName() throws ParseException {
    jj_consume_token(SUBSTRING);
        {if (true) return unquotedIdentifier();}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses the name of a function (either a compound identifier or
 * a reserved word which can be used as a function name).
 */
  final public SqlIdentifier FunctionName() throws ParseException {
    SqlIdentifier qualifiedName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case A:
    case ABSENT:
    case ABSOLUTE:
    case ACTION:
    case ADA:
    case ADD:
    case ADMIN:
    case AFTER:
    case ALWAYS:
    case APPLY:
    case ASC:
    case ASSERTION:
    case ASSIGNMENT:
    case ATTRIBUTE:
    case ATTRIBUTES:
    case BEFORE:
    case BERNOULLI:
    case BREADTH:
    case C:
    case CASCADE:
    case CATALOG:
    case CATALOG_NAME:
    case CENTURY:
    case CHAIN:
    case CHARACTER_SET_CATALOG:
    case CHARACTER_SET_NAME:
    case CHARACTER_SET_SCHEMA:
    case CHARACTERISTICS:
    case CHARACTERS:
    case CLASS_ORIGIN:
    case COBOL:
    case COLLATION:
    case COLLATION_CATALOG:
    case COLLATION_NAME:
    case COLLATION_SCHEMA:
    case COLUMN_NAME:
    case COMMAND_FUNCTION:
    case COMMAND_FUNCTION_CODE:
    case COMMITTED:
    case CONDITIONAL:
    case CONDITION_NUMBER:
    case CONNECTION:
    case CONNECTION_NAME:
    case CONSTRAINT_CATALOG:
    case CONSTRAINT_NAME:
    case CONSTRAINT_SCHEMA:
    case CONSTRAINTS:
    case CONSTRUCTOR:
    case CONTINUE:
    case CURSOR_NAME:
    case DATA:
    case DATABASE:
    case DATETIME_INTERVAL_CODE:
    case DATETIME_INTERVAL_PRECISION:
    case DAYS:
    case DECADE:
    case DEFAULTS:
    case DEFERRABLE:
    case DEFERRED:
    case DEFINED:
    case DEFINER:
    case DEGREE:
    case DEPTH:
    case DERIVED:
    case DESC:
    case DESCRIPTION:
    case DESCRIPTOR:
    case DIAGNOSTICS:
    case DISPATCH:
    case DOMAIN:
    case DOW:
    case DOY:
    case DYNAMIC_FUNCTION:
    case DYNAMIC_FUNCTION_CODE:
    case ENCODING:
    case EPOCH:
    case ERROR:
    case EXCEPTION:
    case EXCLUDE:
    case EXCLUDING:
    case FINAL:
    case FIRST:
    case FOLLOWING:
    case FORMAT:
    case FORTRAN:
    case FOUND:
    case FRAC_SECOND:
    case G:
    case GENERAL:
    case GENERATED:
    case GEOMETRY:
    case GO:
    case GOTO:
    case GRANTED:
    case HIERARCHY:
    case HOP:
    case HOURS:
    case IGNORE:
    case IMMEDIATE:
    case IMMEDIATELY:
    case IMPLEMENTATION:
    case INCLUDING:
    case INCREMENT:
    case INITIALLY:
    case INPUT:
    case INSTANCE:
    case INSTANTIABLE:
    case INVOKER:
    case ISODOW:
    case ISOYEAR:
    case ISOLATION:
    case JAVA:
    case JSON:
    case K:
    case KEY:
    case KEY_MEMBER:
    case KEY_TYPE:
    case LABEL:
    case LAST:
    case LENGTH:
    case LEVEL:
    case LIBRARY:
    case LOCATOR:
    case M:
    case MAP:
    case MATCHED:
    case MAXVALUE:
    case MESSAGE_LENGTH:
    case MESSAGE_OCTET_LENGTH:
    case MESSAGE_TEXT:
    case MICROSECOND:
    case MILLISECOND:
    case MILLENNIUM:
    case MINUTES:
    case MINVALUE:
    case MONTHS:
    case MORE_:
    case MUMPS:
    case NAME:
    case NAMES:
    case NANOSECOND:
    case NESTING:
    case NORMALIZED:
    case NULLABLE:
    case NULLS:
    case NUMBER:
    case OBJECT:
    case OCTETS:
    case OPTION:
    case OPTIONS:
    case ORDERING:
    case ORDINALITY:
    case OTHERS:
    case OUTPUT:
    case OVERRIDING:
    case PAD:
    case PARAMETER_MODE:
    case PARAMETER_NAME:
    case PARAMETER_ORDINAL_POSITION:
    case PARAMETER_SPECIFIC_CATALOG:
    case PARAMETER_SPECIFIC_NAME:
    case PARAMETER_SPECIFIC_SCHEMA:
    case PARTIAL:
    case PASCAL:
    case PASSING:
    case PASSTHROUGH:
    case PAST:
    case PATH:
    case PLACING:
    case PLAN:
    case PLI:
    case PRECEDING:
    case PRESERVE:
    case PRIOR:
    case PRIVILEGES:
    case PUBLIC:
    case QUARTER:
    case READ:
    case RELATIVE:
    case REPEATABLE:
    case REPLACE:
    case RESPECT:
    case RESTART:
    case RESTRICT:
    case RETURNED_CARDINALITY:
    case RETURNED_LENGTH:
    case RETURNED_OCTET_LENGTH:
    case RETURNED_SQLSTATE:
    case RETURNING:
    case ROLE:
    case ROUTINE:
    case ROUTINE_CATALOG:
    case ROUTINE_NAME:
    case ROUTINE_SCHEMA:
    case ROW_COUNT:
    case SCALAR:
    case SCALE:
    case SCHEMA:
    case SCHEMA_NAME:
    case SCOPE_CATALOGS:
    case SCOPE_NAME:
    case SCOPE_SCHEMA:
    case SECONDS:
    case SECTION:
    case SECURITY:
    case SELF:
    case SEQUENCE:
    case SERIALIZABLE:
    case SERVER:
    case SERVER_NAME:
    case SESSION:
    case SETS:
    case SIMPLE:
    case SIZE:
    case SOURCE:
    case SPACE:
    case SPECIFIC_NAME:
    case SQL_BIGINT:
    case SQL_BINARY:
    case SQL_BIT:
    case SQL_BLOB:
    case SQL_BOOLEAN:
    case SQL_CHAR:
    case SQL_CLOB:
    case SQL_DATE:
    case SQL_DECIMAL:
    case SQL_DOUBLE:
    case SQL_FLOAT:
    case SQL_INTEGER:
    case SQL_INTERVAL_DAY:
    case SQL_INTERVAL_DAY_TO_HOUR:
    case SQL_INTERVAL_DAY_TO_MINUTE:
    case SQL_INTERVAL_DAY_TO_SECOND:
    case SQL_INTERVAL_HOUR:
    case SQL_INTERVAL_HOUR_TO_MINUTE:
    case SQL_INTERVAL_HOUR_TO_SECOND:
    case SQL_INTERVAL_MINUTE:
    case SQL_INTERVAL_MINUTE_TO_SECOND:
    case SQL_INTERVAL_MONTH:
    case SQL_INTERVAL_SECOND:
    case SQL_INTERVAL_YEAR:
    case SQL_INTERVAL_YEAR_TO_MONTH:
    case SQL_LONGVARBINARY:
    case SQL_LONGVARCHAR:
    case SQL_LONGVARNCHAR:
    case SQL_NCHAR:
    case SQL_NCLOB:
    case SQL_NUMERIC:
    case SQL_NVARCHAR:
    case SQL_REAL:
    case SQL_SMALLINT:
    case SQL_TIME:
    case SQL_TIMESTAMP:
    case SQL_TINYINT:
    case SQL_TSI_DAY:
    case SQL_TSI_FRAC_SECOND:
    case SQL_TSI_HOUR:
    case SQL_TSI_MICROSECOND:
    case SQL_TSI_MINUTE:
    case SQL_TSI_MONTH:
    case SQL_TSI_QUARTER:
    case SQL_TSI_SECOND:
    case SQL_TSI_WEEK:
    case SQL_TSI_YEAR:
    case SQL_VARBINARY:
    case SQL_VARCHAR:
    case STATE:
    case STRUCTURE:
    case STYLE:
    case SUBCLASS_ORIGIN:
    case SUBSTITUTE:
    case TABLE_NAME:
    case TEMPORARY:
    case TIES:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case TOP_LEVEL_COUNT:
    case TRANSACTION:
    case TRANSACTIONS_ACTIVE:
    case TRANSACTIONS_COMMITTED:
    case TRANSACTIONS_ROLLED_BACK:
    case TRANSFORM:
    case TRANSFORMS:
    case TRIGGER_CATALOG:
    case TRIGGER_NAME:
    case TRIGGER_SCHEMA:
    case TUMBLE:
    case TYPE:
    case UNBOUNDED:
    case UNCOMMITTED:
    case UNCONDITIONAL:
    case UNDER:
    case UNNAMED:
    case USAGE:
    case USER_DEFINED_TYPE_CATALOG:
    case USER_DEFINED_TYPE_CODE:
    case USER_DEFINED_TYPE_NAME:
    case USER_DEFINED_TYPE_SCHEMA:
    case UTF8:
    case UTF16:
    case UTF32:
    case VERSION:
    case VIEW:
    case WEEK:
    case WORK:
    case WRAPPER:
    case WRITE:
    case XML:
    case YEARS:
    case ZONE:
    case CHANGELOG_MODE:
    case COMPACT:
    case COMPILE:
    case COLUMNS:
    case DRAIN:
    case ENFORCED:
    case ESTIMATED_COST:
    case IF:
    case JSON_EXECUTION_PLAN:
    case PLAN_ADVICE:
    case JAR:
    case JARS:
    case JOB:
    case JOBS:
    case LOAD:
    case METADATA:
    case OVERWRITE:
    case OVERWRITING:
    case PARTITIONED:
    case PARTITIONS:
    case PYTHON:
    case REMOVE:
    case STOP:
    case UNLOAD:
    case VIRTUAL:
    case TRY_CAST:
    case ANALYZE:
    case COMPUTE:
    case STATISTICS:
    case BRACKET_QUOTED_IDENTIFIER:
    case QUOTED_IDENTIFIER:
    case BACK_QUOTED_IDENTIFIER:
    case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
    case HYPHENATED_IDENTIFIER:
    case IDENTIFIER:
    case UNICODE_QUOTED_IDENTIFIER:
      qualifiedName = CompoundIdentifier();
      break;
    case ABS:
    case AVG:
    case CARDINALITY:
    case CEILING:
    case CHAR:
    case CHAR_LENGTH:
    case CHARACTER_LENGTH:
    case COALESCE:
    case COLLECT:
    case COUNT:
    case COVAR_POP:
    case COVAR_SAMP:
    case CUME_DIST:
    case CURRENT_DATE:
    case CURRENT_TIME:
    case CURRENT_TIMESTAMP:
    case DENSE_RANK:
    case ELEMENT:
    case EVERY:
    case EXP:
    case FIRST_VALUE:
    case FLOOR:
    case FUSION:
    case GROUPING:
    case HOUR:
    case INTERSECTION:
    case LAG:
    case LAST_VALUE:
    case LEAD:
    case LEFT:
    case LN:
    case LOCALTIME:
    case LOCALTIMESTAMP:
    case LOWER:
    case MAX:
    case MIN:
    case MINUTE:
    case MOD:
    case MONTH:
    case NTH_VALUE:
    case NTILE:
    case NULLIF:
    case OCTET_LENGTH:
    case PERCENTILE_CONT:
    case PERCENTILE_DISC:
    case PERCENT_RANK:
    case POWER:
    case RANK:
    case REGR_COUNT:
    case REGR_SXX:
    case REGR_SYY:
    case RIGHT:
    case ROW_NUMBER:
    case SECOND:
    case SOME:
    case SQRT:
    case STDDEV_POP:
    case STDDEV_SAMP:
    case SUM:
    case TRUNCATE:
    case UPPER:
    case USER:
    case VAR_POP:
    case VAR_SAMP:
    case YEAR:
      qualifiedName = ReservedFunctionName();
      break;
    default:
      jj_la1[506] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return qualifiedName;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a reserved word which is used as the name of a function.
 */
  final public SqlIdentifier ReservedFunctionName() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ABS:
      jj_consume_token(ABS);
      break;
    case AVG:
      jj_consume_token(AVG);
      break;
    case CARDINALITY:
      jj_consume_token(CARDINALITY);
      break;
    case CEILING:
      jj_consume_token(CEILING);
      break;
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case CHAR_LENGTH:
      jj_consume_token(CHAR_LENGTH);
      break;
    case CHARACTER_LENGTH:
      jj_consume_token(CHARACTER_LENGTH);
      break;
    case COALESCE:
      jj_consume_token(COALESCE);
      break;
    case COLLECT:
      jj_consume_token(COLLECT);
      break;
    case COVAR_POP:
      jj_consume_token(COVAR_POP);
      break;
    case COVAR_SAMP:
      jj_consume_token(COVAR_SAMP);
      break;
    case CUME_DIST:
      jj_consume_token(CUME_DIST);
      break;
    case COUNT:
      jj_consume_token(COUNT);
      break;
    case CURRENT_DATE:
      jj_consume_token(CURRENT_DATE);
      break;
    case CURRENT_TIME:
      jj_consume_token(CURRENT_TIME);
      break;
    case CURRENT_TIMESTAMP:
      jj_consume_token(CURRENT_TIMESTAMP);
      break;
    case DENSE_RANK:
      jj_consume_token(DENSE_RANK);
      break;
    case ELEMENT:
      jj_consume_token(ELEMENT);
      break;
    case EVERY:
      jj_consume_token(EVERY);
      break;
    case EXP:
      jj_consume_token(EXP);
      break;
    case FIRST_VALUE:
      jj_consume_token(FIRST_VALUE);
      break;
    case FLOOR:
      jj_consume_token(FLOOR);
      break;
    case FUSION:
      jj_consume_token(FUSION);
      break;
    case INTERSECTION:
      jj_consume_token(INTERSECTION);
      break;
    case GROUPING:
      jj_consume_token(GROUPING);
      break;
    case HOUR:
      jj_consume_token(HOUR);
      break;
    case LAG:
      jj_consume_token(LAG);
      break;
    case LEAD:
      jj_consume_token(LEAD);
      break;
    case LEFT:
      jj_consume_token(LEFT);
      break;
    case LAST_VALUE:
      jj_consume_token(LAST_VALUE);
      break;
    case LN:
      jj_consume_token(LN);
      break;
    case LOCALTIME:
      jj_consume_token(LOCALTIME);
      break;
    case LOCALTIMESTAMP:
      jj_consume_token(LOCALTIMESTAMP);
      break;
    case LOWER:
      jj_consume_token(LOWER);
      break;
    case MAX:
      jj_consume_token(MAX);
      break;
    case MIN:
      jj_consume_token(MIN);
      break;
    case MINUTE:
      jj_consume_token(MINUTE);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    case MONTH:
      jj_consume_token(MONTH);
      break;
    case NTH_VALUE:
      jj_consume_token(NTH_VALUE);
      break;
    case NTILE:
      jj_consume_token(NTILE);
      break;
    case NULLIF:
      jj_consume_token(NULLIF);
      break;
    case OCTET_LENGTH:
      jj_consume_token(OCTET_LENGTH);
      break;
    case PERCENT_RANK:
      jj_consume_token(PERCENT_RANK);
      break;
    case PERCENTILE_CONT:
      jj_consume_token(PERCENTILE_CONT);
      break;
    case PERCENTILE_DISC:
      jj_consume_token(PERCENTILE_DISC);
      break;
    case POWER:
      jj_consume_token(POWER);
      break;
    case RANK:
      jj_consume_token(RANK);
      break;
    case REGR_COUNT:
      jj_consume_token(REGR_COUNT);
      break;
    case REGR_SXX:
      jj_consume_token(REGR_SXX);
      break;
    case REGR_SYY:
      jj_consume_token(REGR_SYY);
      break;
    case RIGHT:
      jj_consume_token(RIGHT);
      break;
    case ROW_NUMBER:
      jj_consume_token(ROW_NUMBER);
      break;
    case SECOND:
      jj_consume_token(SECOND);
      break;
    case SOME:
      jj_consume_token(SOME);
      break;
    case SQRT:
      jj_consume_token(SQRT);
      break;
    case STDDEV_POP:
      jj_consume_token(STDDEV_POP);
      break;
    case STDDEV_SAMP:
      jj_consume_token(STDDEV_SAMP);
      break;
    case SUM:
      jj_consume_token(SUM);
      break;
    case UPPER:
      jj_consume_token(UPPER);
      break;
    case TRUNCATE:
      jj_consume_token(TRUNCATE);
      break;
    case USER:
      jj_consume_token(USER);
      break;
    case VAR_POP:
      jj_consume_token(VAR_POP);
      break;
    case VAR_SAMP:
      jj_consume_token(VAR_SAMP);
      break;
    case YEAR:
      jj_consume_token(YEAR);
      break;
    default:
      jj_la1[507] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIdentifier(unquotedIdentifier(), getPos());}
    throw new Error("Missing return statement in function");
  }

  final public SqlIdentifier ContextVariable() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CURRENT_CATALOG:
      jj_consume_token(CURRENT_CATALOG);
      break;
    case CURRENT_DATE:
      jj_consume_token(CURRENT_DATE);
      break;
    case CURRENT_DEFAULT_TRANSFORM_GROUP:
      jj_consume_token(CURRENT_DEFAULT_TRANSFORM_GROUP);
      break;
    case CURRENT_PATH:
      jj_consume_token(CURRENT_PATH);
      break;
    case CURRENT_ROLE:
      jj_consume_token(CURRENT_ROLE);
      break;
    case CURRENT_SCHEMA:
      jj_consume_token(CURRENT_SCHEMA);
      break;
    case CURRENT_TIME:
      jj_consume_token(CURRENT_TIME);
      break;
    case CURRENT_TIMESTAMP:
      jj_consume_token(CURRENT_TIMESTAMP);
      break;
    case CURRENT_USER:
      jj_consume_token(CURRENT_USER);
      break;
    case LOCALTIME:
      jj_consume_token(LOCALTIME);
      break;
    case LOCALTIMESTAMP:
      jj_consume_token(LOCALTIMESTAMP);
      break;
    case SESSION_USER:
      jj_consume_token(SESSION_USER);
      break;
    case SYSTEM_USER:
      jj_consume_token(SYSTEM_USER);
      break;
    case USER:
      jj_consume_token(USER);
      break;
    default:
      jj_la1[508] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new SqlIdentifier(unquotedIdentifier(), getPos());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a function call expression with JDBC syntax.
 */
  final public SqlNode JdbcFunctionCall() throws ParseException {
    String name;
    SqlIdentifier id;
    SqlNode e;
    SqlLiteral tl;
    SqlNodeList args;
    SqlCall call;
    final Span s, s1;
    jj_consume_token(LBRACE_FN);
        s = span();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIMESTAMPADD:
      call = TimestampAddFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      break;
    default:
      jj_la1[512] = jj_gen;
      if (jj_2_151(3)) {
        call = TimestampDiffFunctionCall();
            name = call.getOperator().getName();
            args = new SqlNodeList(call.getOperandList(), getPos());
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CONVERT:
          jj_consume_token(CONVERT);
                    name = unquotedIdentifier();
          jj_consume_token(LPAREN);
          e = Expression(ExprContext.ACCEPT_SUB_QUERY);
            args = new SqlNodeList(getPos());
            args.add(e);
          jj_consume_token(COMMA);
          tl = JdbcOdbcDataType();
                                  args.add(tl);
          jj_consume_token(RPAREN);
          break;
        case A:
        case ABS:
        case ABSENT:
        case ABSOLUTE:
        case ACTION:
        case ADA:
        case ADD:
        case ADMIN:
        case AFTER:
        case ALWAYS:
        case APPLY:
        case ASC:
        case ASSERTION:
        case ASSIGNMENT:
        case ATTRIBUTE:
        case ATTRIBUTES:
        case AVG:
        case BEFORE:
        case BERNOULLI:
        case BREADTH:
        case C:
        case CARDINALITY:
        case CASCADE:
        case CATALOG:
        case CATALOG_NAME:
        case CEILING:
        case CENTURY:
        case CHAIN:
        case CHAR:
        case CHAR_LENGTH:
        case CHARACTER_LENGTH:
        case CHARACTER_SET_CATALOG:
        case CHARACTER_SET_NAME:
        case CHARACTER_SET_SCHEMA:
        case CHARACTERISTICS:
        case CHARACTERS:
        case CLASS_ORIGIN:
        case COALESCE:
        case COBOL:
        case COLLATION:
        case COLLATION_CATALOG:
        case COLLATION_NAME:
        case COLLATION_SCHEMA:
        case COLLECT:
        case COLUMN_NAME:
        case COMMAND_FUNCTION:
        case COMMAND_FUNCTION_CODE:
        case COMMITTED:
        case CONDITIONAL:
        case CONDITION_NUMBER:
        case CONNECTION:
        case CONNECTION_NAME:
        case CONSTRAINT_CATALOG:
        case CONSTRAINT_NAME:
        case CONSTRAINT_SCHEMA:
        case CONSTRAINTS:
        case CONSTRUCTOR:
        case CONTINUE:
        case COUNT:
        case COVAR_POP:
        case COVAR_SAMP:
        case CUME_DIST:
        case CURRENT_DATE:
        case CURRENT_TIME:
        case CURRENT_TIMESTAMP:
        case CURSOR_NAME:
        case DATA:
        case DATABASE:
        case DATETIME_INTERVAL_CODE:
        case DATETIME_INTERVAL_PRECISION:
        case DAYS:
        case DECADE:
        case DEFAULTS:
        case DEFERRABLE:
        case DEFERRED:
        case DEFINED:
        case DEFINER:
        case DEGREE:
        case DENSE_RANK:
        case DEPTH:
        case DERIVED:
        case DESC:
        case DESCRIPTION:
        case DESCRIPTOR:
        case DIAGNOSTICS:
        case DISPATCH:
        case DOMAIN:
        case DOW:
        case DOY:
        case DYNAMIC_FUNCTION:
        case DYNAMIC_FUNCTION_CODE:
        case ELEMENT:
        case ENCODING:
        case EPOCH:
        case ERROR:
        case EVERY:
        case EXCEPTION:
        case EXCLUDE:
        case EXCLUDING:
        case EXP:
        case FINAL:
        case FIRST:
        case FIRST_VALUE:
        case FLOOR:
        case FOLLOWING:
        case FORMAT:
        case FORTRAN:
        case FOUND:
        case FRAC_SECOND:
        case FUSION:
        case G:
        case GENERAL:
        case GENERATED:
        case GEOMETRY:
        case GO:
        case GOTO:
        case GRANTED:
        case GROUPING:
        case HIERARCHY:
        case HOP:
        case HOUR:
        case HOURS:
        case IGNORE:
        case IMMEDIATE:
        case IMMEDIATELY:
        case IMPLEMENTATION:
        case INCLUDING:
        case INCREMENT:
        case INITIALLY:
        case INPUT:
        case INSERT:
        case INSTANCE:
        case INSTANTIABLE:
        case INTERSECTION:
        case INVOKER:
        case ISODOW:
        case ISOYEAR:
        case ISOLATION:
        case JAVA:
        case JSON:
        case K:
        case KEY:
        case KEY_MEMBER:
        case KEY_TYPE:
        case LABEL:
        case LAG:
        case LAST:
        case LAST_VALUE:
        case LEAD:
        case LEFT:
        case LENGTH:
        case LEVEL:
        case LIBRARY:
        case LN:
        case LOCALTIME:
        case LOCALTIMESTAMP:
        case LOCATOR:
        case LOWER:
        case M:
        case MAP:
        case MATCHED:
        case MAX:
        case MAXVALUE:
        case MESSAGE_LENGTH:
        case MESSAGE_OCTET_LENGTH:
        case MESSAGE_TEXT:
        case MICROSECOND:
        case MILLISECOND:
        case MILLENNIUM:
        case MIN:
        case MINUTE:
        case MINUTES:
        case MINVALUE:
        case MOD:
        case MONTH:
        case MONTHS:
        case MORE_:
        case MUMPS:
        case NAME:
        case NAMES:
        case NANOSECOND:
        case NESTING:
        case NORMALIZED:
        case NTH_VALUE:
        case NTILE:
        case NULLABLE:
        case NULLIF:
        case NULLS:
        case NUMBER:
        case OBJECT:
        case OCTET_LENGTH:
        case OCTETS:
        case OPTION:
        case OPTIONS:
        case ORDERING:
        case ORDINALITY:
        case OTHERS:
        case OUTPUT:
        case OVERRIDING:
        case PAD:
        case PARAMETER_MODE:
        case PARAMETER_NAME:
        case PARAMETER_ORDINAL_POSITION:
        case PARAMETER_SPECIFIC_CATALOG:
        case PARAMETER_SPECIFIC_NAME:
        case PARAMETER_SPECIFIC_SCHEMA:
        case PARTIAL:
        case PASCAL:
        case PASSING:
        case PASSTHROUGH:
        case PAST:
        case PATH:
        case PERCENTILE_CONT:
        case PERCENTILE_DISC:
        case PERCENT_RANK:
        case PLACING:
        case PLAN:
        case PLI:
        case POWER:
        case PRECEDING:
        case PRESERVE:
        case PRIOR:
        case PRIVILEGES:
        case PUBLIC:
        case QUARTER:
        case RANK:
        case READ:
        case REGR_COUNT:
        case REGR_SXX:
        case REGR_SYY:
        case RELATIVE:
        case REPEATABLE:
        case REPLACE:
        case RESPECT:
        case RESTART:
        case RESTRICT:
        case RETURNED_CARDINALITY:
        case RETURNED_LENGTH:
        case RETURNED_OCTET_LENGTH:
        case RETURNED_SQLSTATE:
        case RETURNING:
        case RIGHT:
        case ROLE:
        case ROUTINE:
        case ROUTINE_CATALOG:
        case ROUTINE_NAME:
        case ROUTINE_SCHEMA:
        case ROW_COUNT:
        case ROW_NUMBER:
        case SCALAR:
        case SCALE:
        case SCHEMA:
        case SCHEMA_NAME:
        case SCOPE_CATALOGS:
        case SCOPE_NAME:
        case SCOPE_SCHEMA:
        case SECOND:
        case SECONDS:
        case SECTION:
        case SECURITY:
        case SELF:
        case SEQUENCE:
        case SERIALIZABLE:
        case SERVER:
        case SERVER_NAME:
        case SESSION:
        case SETS:
        case SIMPLE:
        case SIZE:
        case SOME:
        case SOURCE:
        case SPACE:
        case SPECIFIC_NAME:
        case SQL_BIGINT:
        case SQL_BINARY:
        case SQL_BIT:
        case SQL_BLOB:
        case SQL_BOOLEAN:
        case SQL_CHAR:
        case SQL_CLOB:
        case SQL_DATE:
        case SQL_DECIMAL:
        case SQL_DOUBLE:
        case SQL_FLOAT:
        case SQL_INTEGER:
        case SQL_INTERVAL_DAY:
        case SQL_INTERVAL_DAY_TO_HOUR:
        case SQL_INTERVAL_DAY_TO_MINUTE:
        case SQL_INTERVAL_DAY_TO_SECOND:
        case SQL_INTERVAL_HOUR:
        case SQL_INTERVAL_HOUR_TO_MINUTE:
        case SQL_INTERVAL_HOUR_TO_SECOND:
        case SQL_INTERVAL_MINUTE:
        case SQL_INTERVAL_MINUTE_TO_SECOND:
        case SQL_INTERVAL_MONTH:
        case SQL_INTERVAL_SECOND:
        case SQL_INTERVAL_YEAR:
        case SQL_INTERVAL_YEAR_TO_MONTH:
        case SQL_LONGVARBINARY:
        case SQL_LONGVARCHAR:
        case SQL_LONGVARNCHAR:
        case SQL_NCHAR:
        case SQL_NCLOB:
        case SQL_NUMERIC:
        case SQL_NVARCHAR:
        case SQL_REAL:
        case SQL_SMALLINT:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TINYINT:
        case SQL_TSI_DAY:
        case SQL_TSI_FRAC_SECOND:
        case SQL_TSI_HOUR:
        case SQL_TSI_MICROSECOND:
        case SQL_TSI_MINUTE:
        case SQL_TSI_MONTH:
        case SQL_TSI_QUARTER:
        case SQL_TSI_SECOND:
        case SQL_TSI_WEEK:
        case SQL_TSI_YEAR:
        case SQL_VARBINARY:
        case SQL_VARCHAR:
        case SQRT:
        case STATE:
        case STDDEV_POP:
        case STDDEV_SAMP:
        case STRUCTURE:
        case STYLE:
        case SUBCLASS_ORIGIN:
        case SUBSTITUTE:
        case SUBSTRING:
        case SUM:
        case TABLE_NAME:
        case TEMPORARY:
        case TIES:
        case TIMESTAMPADD:
        case TIMESTAMPDIFF:
        case TOP_LEVEL_COUNT:
        case TRANSACTION:
        case TRANSACTIONS_ACTIVE:
        case TRANSACTIONS_COMMITTED:
        case TRANSACTIONS_ROLLED_BACK:
        case TRANSFORM:
        case TRANSFORMS:
        case TRIGGER_CATALOG:
        case TRIGGER_NAME:
        case TRIGGER_SCHEMA:
        case TRUNCATE:
        case TUMBLE:
        case TYPE:
        case UNBOUNDED:
        case UNCOMMITTED:
        case UNCONDITIONAL:
        case UNDER:
        case UNNAMED:
        case UPPER:
        case USAGE:
        case USER:
        case USER_DEFINED_TYPE_CATALOG:
        case USER_DEFINED_TYPE_CODE:
        case USER_DEFINED_TYPE_NAME:
        case USER_DEFINED_TYPE_SCHEMA:
        case UTF8:
        case UTF16:
        case UTF32:
        case VAR_POP:
        case VAR_SAMP:
        case VERSION:
        case VIEW:
        case WEEK:
        case WORK:
        case WRAPPER:
        case WRITE:
        case XML:
        case YEAR:
        case YEARS:
        case ZONE:
        case CHANGELOG_MODE:
        case COMPACT:
        case COMPILE:
        case COLUMNS:
        case DRAIN:
        case ENFORCED:
        case ESTIMATED_COST:
        case IF:
        case JSON_EXECUTION_PLAN:
        case PLAN_ADVICE:
        case JAR:
        case JARS:
        case JOB:
        case JOBS:
        case LOAD:
        case METADATA:
        case OVERWRITE:
        case OVERWRITING:
        case PARTITIONED:
        case PARTITIONS:
        case PYTHON:
        case REMOVE:
        case STOP:
        case UNLOAD:
        case VIRTUAL:
        case TRY_CAST:
        case ANALYZE:
        case COMPUTE:
        case STATISTICS:
        case BRACKET_QUOTED_IDENTIFIER:
        case QUOTED_IDENTIFIER:
        case BACK_QUOTED_IDENTIFIER:
        case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
        case HYPHENATED_IDENTIFIER:
        case IDENTIFIER:
        case UNICODE_QUOTED_IDENTIFIER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INSERT:
          case LEFT:
          case RIGHT:
          case TRUNCATE:
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case INSERT:
              jj_consume_token(INSERT);
              break;
            case LEFT:
              jj_consume_token(LEFT);
              break;
            case RIGHT:
              jj_consume_token(RIGHT);
              break;
            case TRUNCATE:
              jj_consume_token(TRUNCATE);
              break;
            default:
              jj_la1[509] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
                                                           name = unquotedIdentifier();
            break;
          case ABS:
          case AVG:
          case CARDINALITY:
          case CEILING:
          case CHAR:
          case CHAR_LENGTH:
          case CHARACTER_LENGTH:
          case COALESCE:
          case COLLECT:
          case COUNT:
          case COVAR_POP:
          case COVAR_SAMP:
          case CUME_DIST:
          case CURRENT_DATE:
          case CURRENT_TIME:
          case CURRENT_TIMESTAMP:
          case DENSE_RANK:
          case ELEMENT:
          case EVERY:
          case EXP:
          case FIRST_VALUE:
          case FLOOR:
          case FUSION:
          case GROUPING:
          case HOUR:
          case INTERSECTION:
          case LAG:
          case LAST_VALUE:
          case LEAD:
          case LN:
          case LOCALTIME:
          case LOCALTIMESTAMP:
          case LOWER:
          case MAX:
          case MIN:
          case MINUTE:
          case MOD:
          case MONTH:
          case NTH_VALUE:
          case NTILE:
          case NULLIF:
          case OCTET_LENGTH:
          case PERCENTILE_CONT:
          case PERCENTILE_DISC:
          case PERCENT_RANK:
          case POWER:
          case RANK:
          case REGR_COUNT:
          case REGR_SXX:
          case REGR_SYY:
          case ROW_NUMBER:
          case SECOND:
          case SOME:
          case SQRT:
          case STDDEV_POP:
          case STDDEV_SAMP:
          case SUM:
          case UPPER:
          case USER:
          case VAR_POP:
          case VAR_SAMP:
          case YEAR:
            // For cases like {fn power(1,2)} and {fn lower('a')}
                        id = ReservedFunctionName();
                                          name = id.getSimple();
            break;
          case SUBSTRING:
            // For cases like {fn substring('foo', 1,2)}
                        name = NonReservedJdbcFunctionName();
            break;
          case A:
          case ABSENT:
          case ABSOLUTE:
          case ACTION:
          case ADA:
          case ADD:
          case ADMIN:
          case AFTER:
          case ALWAYS:
          case APPLY:
          case ASC:
          case ASSERTION:
          case ASSIGNMENT:
          case ATTRIBUTE:
          case ATTRIBUTES:
          case BEFORE:
          case BERNOULLI:
          case BREADTH:
          case C:
          case CASCADE:
          case CATALOG:
          case CATALOG_NAME:
          case CENTURY:
          case CHAIN:
          case CHARACTER_SET_CATALOG:
          case CHARACTER_SET_NAME:
          case CHARACTER_SET_SCHEMA:
          case CHARACTERISTICS:
          case CHARACTERS:
          case CLASS_ORIGIN:
          case COBOL:
          case COLLATION:
          case COLLATION_CATALOG:
          case COLLATION_NAME:
          case COLLATION_SCHEMA:
          case COLUMN_NAME:
          case COMMAND_FUNCTION:
          case COMMAND_FUNCTION_CODE:
          case COMMITTED:
          case CONDITIONAL:
          case CONDITION_NUMBER:
          case CONNECTION:
          case CONNECTION_NAME:
          case CONSTRAINT_CATALOG:
          case CONSTRAINT_NAME:
          case CONSTRAINT_SCHEMA:
          case CONSTRAINTS:
          case CONSTRUCTOR:
          case CONTINUE:
          case CURSOR_NAME:
          case DATA:
          case DATABASE:
          case DATETIME_INTERVAL_CODE:
          case DATETIME_INTERVAL_PRECISION:
          case DAYS:
          case DECADE:
          case DEFAULTS:
          case DEFERRABLE:
          case DEFERRED:
          case DEFINED:
          case DEFINER:
          case DEGREE:
          case DEPTH:
          case DERIVED:
          case DESC:
          case DESCRIPTION:
          case DESCRIPTOR:
          case DIAGNOSTICS:
          case DISPATCH:
          case DOMAIN:
          case DOW:
          case DOY:
          case DYNAMIC_FUNCTION:
          case DYNAMIC_FUNCTION_CODE:
          case ENCODING:
          case EPOCH:
          case ERROR:
          case EXCEPTION:
          case EXCLUDE:
          case EXCLUDING:
          case FINAL:
          case FIRST:
          case FOLLOWING:
          case FORMAT:
          case FORTRAN:
          case FOUND:
          case FRAC_SECOND:
          case G:
          case GENERAL:
          case GENERATED:
          case GEOMETRY:
          case GO:
          case GOTO:
          case GRANTED:
          case HIERARCHY:
          case HOP:
          case HOURS:
          case IGNORE:
          case IMMEDIATE:
          case IMMEDIATELY:
          case IMPLEMENTATION:
          case INCLUDING:
          case INCREMENT:
          case INITIALLY:
          case INPUT:
          case INSTANCE:
          case INSTANTIABLE:
          case INVOKER:
          case ISODOW:
          case ISOYEAR:
          case ISOLATION:
          case JAVA:
          case JSON:
          case K:
          case KEY:
          case KEY_MEMBER:
          case KEY_TYPE:
          case LABEL:
          case LAST:
          case LENGTH:
          case LEVEL:
          case LIBRARY:
          case LOCATOR:
          case M:
          case MAP:
          case MATCHED:
          case MAXVALUE:
          case MESSAGE_LENGTH:
          case MESSAGE_OCTET_LENGTH:
          case MESSAGE_TEXT:
          case MICROSECOND:
          case MILLISECOND:
          case MILLENNIUM:
          case MINUTES:
          case MINVALUE:
          case MONTHS:
          case MORE_:
          case MUMPS:
          case NAME:
          case NAMES:
          case NANOSECOND:
          case NESTING:
          case NORMALIZED:
          case NULLABLE:
          case NULLS:
          case NUMBER:
          case OBJECT:
          case OCTETS:
          case OPTION:
          case OPTIONS:
          case ORDERING:
          case ORDINALITY:
          case OTHERS:
          case OUTPUT:
          case OVERRIDING:
          case PAD:
          case PARAMETER_MODE:
          case PARAMETER_NAME:
          case PARAMETER_ORDINAL_POSITION:
          case PARAMETER_SPECIFIC_CATALOG:
          case PARAMETER_SPECIFIC_NAME:
          case PARAMETER_SPECIFIC_SCHEMA:
          case PARTIAL:
          case PASCAL:
          case PASSING:
          case PASSTHROUGH:
          case PAST:
          case PATH:
          case PLACING:
          case PLAN:
          case PLI:
          case PRECEDING:
          case PRESERVE:
          case PRIOR:
          case PRIVILEGES:
          case PUBLIC:
          case QUARTER:
          case READ:
          case RELATIVE:
          case REPEATABLE:
          case REPLACE:
          case RESPECT:
          case RESTART:
          case RESTRICT:
          case RETURNED_CARDINALITY:
          case RETURNED_LENGTH:
          case RETURNED_OCTET_LENGTH:
          case RETURNED_SQLSTATE:
          case RETURNING:
          case ROLE:
          case ROUTINE:
          case ROUTINE_CATALOG:
          case ROUTINE_NAME:
          case ROUTINE_SCHEMA:
          case ROW_COUNT:
          case SCALAR:
          case SCALE:
          case SCHEMA:
          case SCHEMA_NAME:
          case SCOPE_CATALOGS:
          case SCOPE_NAME:
          case SCOPE_SCHEMA:
          case SECONDS:
          case SECTION:
          case SECURITY:
          case SELF:
          case SEQUENCE:
          case SERIALIZABLE:
          case SERVER:
          case SERVER_NAME:
          case SESSION:
          case SETS:
          case SIMPLE:
          case SIZE:
          case SOURCE:
          case SPACE:
          case SPECIFIC_NAME:
          case SQL_BIGINT:
          case SQL_BINARY:
          case SQL_BIT:
          case SQL_BLOB:
          case SQL_BOOLEAN:
          case SQL_CHAR:
          case SQL_CLOB:
          case SQL_DATE:
          case SQL_DECIMAL:
          case SQL_DOUBLE:
          case SQL_FLOAT:
          case SQL_INTEGER:
          case SQL_INTERVAL_DAY:
          case SQL_INTERVAL_DAY_TO_HOUR:
          case SQL_INTERVAL_DAY_TO_MINUTE:
          case SQL_INTERVAL_DAY_TO_SECOND:
          case SQL_INTERVAL_HOUR:
          case SQL_INTERVAL_HOUR_TO_MINUTE:
          case SQL_INTERVAL_HOUR_TO_SECOND:
          case SQL_INTERVAL_MINUTE:
          case SQL_INTERVAL_MINUTE_TO_SECOND:
          case SQL_INTERVAL_MONTH:
          case SQL_INTERVAL_SECOND:
          case SQL_INTERVAL_YEAR:
          case SQL_INTERVAL_YEAR_TO_MONTH:
          case SQL_LONGVARBINARY:
          case SQL_LONGVARCHAR:
          case SQL_LONGVARNCHAR:
          case SQL_NCHAR:
          case SQL_NCLOB:
          case SQL_NUMERIC:
          case SQL_NVARCHAR:
          case SQL_REAL:
          case SQL_SMALLINT:
          case SQL_TIME:
          case SQL_TIMESTAMP:
          case SQL_TINYINT:
          case SQL_TSI_DAY:
          case SQL_TSI_FRAC_SECOND:
          case SQL_TSI_HOUR:
          case SQL_TSI_MICROSECOND:
          case SQL_TSI_MINUTE:
          case SQL_TSI_MONTH:
          case SQL_TSI_QUARTER:
          case SQL_TSI_SECOND:
          case SQL_TSI_WEEK:
          case SQL_TSI_YEAR:
          case SQL_VARBINARY:
          case SQL_VARCHAR:
          case STATE:
          case STRUCTURE:
          case STYLE:
          case SUBCLASS_ORIGIN:
          case SUBSTITUTE:
          case TABLE_NAME:
          case TEMPORARY:
          case TIES:
          case TIMESTAMPADD:
          case TIMESTAMPDIFF:
          case TOP_LEVEL_COUNT:
          case TRANSACTION:
          case TRANSACTIONS_ACTIVE:
          case TRANSACTIONS_COMMITTED:
          case TRANSACTIONS_ROLLED_BACK:
          case TRANSFORM:
          case TRANSFORMS:
          case TRIGGER_CATALOG:
          case TRIGGER_NAME:
          case TRIGGER_SCHEMA:
          case TUMBLE:
          case TYPE:
          case UNBOUNDED:
          case UNCOMMITTED:
          case UNCONDITIONAL:
          case UNDER:
          case UNNAMED:
          case USAGE:
          case USER_DEFINED_TYPE_CATALOG:
          case USER_DEFINED_TYPE_CODE:
          case USER_DEFINED_TYPE_NAME:
          case USER_DEFINED_TYPE_SCHEMA:
          case UTF8:
          case UTF16:
          case UTF32:
          case VERSION:
          case VIEW:
          case WEEK:
          case WORK:
          case WRAPPER:
          case WRITE:
          case XML:
          case YEARS:
          case ZONE:
          case CHANGELOG_MODE:
          case COMPACT:
          case COMPILE:
          case COLUMNS:
          case DRAIN:
          case ENFORCED:
          case ESTIMATED_COST:
          case IF:
          case JSON_EXECUTION_PLAN:
          case PLAN_ADVICE:
          case JAR:
          case JARS:
          case JOB:
          case JOBS:
          case LOAD:
          case METADATA:
          case OVERWRITE:
          case OVERWRITING:
          case PARTITIONED:
          case PARTITIONS:
          case PYTHON:
          case REMOVE:
          case STOP:
          case UNLOAD:
          case VIRTUAL:
          case TRY_CAST:
          case ANALYZE:
          case COMPUTE:
          case STATISTICS:
          case BRACKET_QUOTED_IDENTIFIER:
          case QUOTED_IDENTIFIER:
          case BACK_QUOTED_IDENTIFIER:
          case BIG_QUERY_BACK_QUOTED_IDENTIFIER:
          case HYPHENATED_IDENTIFIER:
          case IDENTIFIER:
          case UNICODE_QUOTED_IDENTIFIER:
            name = Identifier();
            break;
          default:
            jj_la1[510] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_149(2)) {
            jj_consume_token(LPAREN);
            jj_consume_token(STAR);
                                           s1 = span();
            jj_consume_token(RPAREN);
                args = new SqlNodeList(s1.pos());
                args.add(SqlIdentifier.star(s1.pos()));
          } else if (jj_2_150(2)) {
            jj_consume_token(LPAREN);
            jj_consume_token(RPAREN);
                                             args = SqlNodeList.EMPTY;
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case LPAREN:
              args = ParenthesizedQueryOrCommaList(ExprContext.ACCEPT_SUB_QUERY);
              break;
            default:
              jj_la1[511] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
        default:
          jj_la1[513] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(RBRACE);
        {if (true) return new SqlJdbcFunctionCall(name).createCall(s.end(this),
            args.getList());}
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary query operator like UNION.
 */
  final public SqlBinaryOperator BinaryQueryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      jj_consume_token(UNION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.UNION_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.UNION;}
        break;
      default:
        jj_la1[514] = jj_gen;
              {if (true) return SqlStdOperatorTable.UNION;}
      }
      break;
    case INTERSECT:
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.INTERSECT_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.INTERSECT;}
        break;
      default:
        jj_la1[515] = jj_gen;
              {if (true) return SqlStdOperatorTable.INTERSECT;}
      }
      break;
    case EXCEPT:
    case SET_MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXCEPT:
        jj_consume_token(EXCEPT);
        break;
      case SET_MINUS:
        jj_consume_token(SET_MINUS);
                if (!this.conformance.isMinusAllowed()) {
                    {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.minusNotAllowed());}
                }
        break;
      default:
        jj_la1[516] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
        jj_consume_token(ALL);
                    {if (true) return SqlStdOperatorTable.EXCEPT_ALL;}
        break;
      case DISTINCT:
        jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.EXCEPT;}
        break;
      default:
        jj_la1[517] = jj_gen;
              {if (true) return SqlStdOperatorTable.EXCEPT;}
      }
      break;
    default:
      jj_la1[518] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary multiset operator.
 */
  final public SqlBinaryOperator BinaryMultisetOperator() throws ParseException {
    jj_consume_token(MULTISET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      jj_consume_token(UNION);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_UNION_DISTINCT;}
          break;
        default:
          jj_la1[519] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[520] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_UNION;}
      break;
    case INTERSECT:
      jj_consume_token(INTERSECT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_INTERSECT_DISTINCT;}
          break;
        default:
          jj_la1[521] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[522] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_INTERSECT;}
      break;
    case EXCEPT:
      jj_consume_token(EXCEPT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALL:
      case DISTINCT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
          break;
        case DISTINCT:
          jj_consume_token(DISTINCT);
                         {if (true) return SqlStdOperatorTable.MULTISET_EXCEPT_DISTINCT;}
          break;
        default:
          jj_la1[523] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[524] = jj_gen;
        ;
      }
          {if (true) return SqlStdOperatorTable.MULTISET_EXCEPT;}
      break;
    default:
      jj_la1[525] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a binary row operator like AND.
 */
  final public SqlBinaryOperator BinaryRowOperator() throws ParseException {
    SqlBinaryOperator op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
           {if (true) return SqlStdOperatorTable.EQUALS;}
      break;
    case GT:
      jj_consume_token(GT);
           {if (true) return SqlStdOperatorTable.GREATER_THAN;}
      break;
    case LT:
      jj_consume_token(LT);
           {if (true) return SqlStdOperatorTable.LESS_THAN;}
      break;
    case LE:
      jj_consume_token(LE);
           {if (true) return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;}
      break;
    case GE:
      jj_consume_token(GE);
           {if (true) return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;}
      break;
    case NE:
      jj_consume_token(NE);
           {if (true) return SqlStdOperatorTable.NOT_EQUALS;}
      break;
    case NE2:
      jj_consume_token(NE2);
        if (!this.conformance.isBangEqualAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.bangEqualNotAllowed());}
        }
        {if (true) return SqlStdOperatorTable.NOT_EQUALS;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
             {if (true) return SqlStdOperatorTable.PLUS;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return SqlStdOperatorTable.MINUS;}
      break;
    case STAR:
      jj_consume_token(STAR);
             {if (true) return SqlStdOperatorTable.MULTIPLY;}
      break;
    case SLASH:
      jj_consume_token(SLASH);
              {if (true) return SqlStdOperatorTable.DIVIDE;}
      break;
    case PERCENT_REMAINDER:
      jj_consume_token(PERCENT_REMAINDER);
        if (!this.conformance.isPercentRemainderAllowed()) {
            {if (true) throw SqlUtil.newContextException(getPos(), RESOURCE.percentRemainderNotAllowed());}
        }
        {if (true) return SqlStdOperatorTable.PERCENT_REMAINDER;}
      break;
    case CONCAT:
      jj_consume_token(CONCAT);
               {if (true) return SqlStdOperatorTable.CONCAT;}
      break;
    case AND:
      jj_consume_token(AND);
            {if (true) return SqlStdOperatorTable.AND;}
      break;
    case OR:
      jj_consume_token(OR);
           {if (true) return SqlStdOperatorTable.OR;}
      break;
    default:
      jj_la1[526] = jj_gen;
      if (jj_2_152(2)) {
        jj_consume_token(IS);
        jj_consume_token(DISTINCT);
        jj_consume_token(FROM);
                                          {if (true) return SqlStdOperatorTable.IS_DISTINCT_FROM;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IS:
          jj_consume_token(IS);
          jj_consume_token(NOT);
          jj_consume_token(DISTINCT);
          jj_consume_token(FROM);
                                   {if (true) return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;}
          break;
        case MEMBER:
          jj_consume_token(MEMBER);
          jj_consume_token(OF);
                    {if (true) return SqlStdOperatorTable.MEMBER_OF;}
          break;
        default:
          jj_la1[527] = jj_gen;
          if (jj_2_153(2)) {
            jj_consume_token(SUBMULTISET);
            jj_consume_token(OF);
                                      {if (true) return SqlStdOperatorTable.SUBMULTISET_OF;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case NOT:
              jj_consume_token(NOT);
              jj_consume_token(SUBMULTISET);
              jj_consume_token(OF);
                               {if (true) return SqlStdOperatorTable.NOT_SUBMULTISET_OF;}
              break;
            case CONTAINS:
              jj_consume_token(CONTAINS);
                 {if (true) return SqlStdOperatorTable.CONTAINS;}
              break;
            case OVERLAPS:
              jj_consume_token(OVERLAPS);
                 {if (true) return SqlStdOperatorTable.OVERLAPS;}
              break;
            case EQUALS:
              jj_consume_token(EQUALS);
               {if (true) return SqlStdOperatorTable.PERIOD_EQUALS;}
              break;
            case PRECEDES:
              jj_consume_token(PRECEDES);
                 {if (true) return SqlStdOperatorTable.PRECEDES;}
              break;
            case SUCCEEDS:
              jj_consume_token(SUCCEEDS);
                 {if (true) return SqlStdOperatorTable.SUCCEEDS;}
              break;
            default:
              jj_la1[528] = jj_gen;
              if (jj_2_154(2)) {
                jj_consume_token(IMMEDIATELY);
                jj_consume_token(PRECEDES);
                                            {if (true) return SqlStdOperatorTable.IMMEDIATELY_PRECEDES;}
              } else {
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case IMMEDIATELY:
                  jj_consume_token(IMMEDIATELY);
                  jj_consume_token(SUCCEEDS);
                               {if (true) return SqlStdOperatorTable.IMMEDIATELY_SUCCEEDS;}
                  break;
                case MULTISET:
                  op = BinaryMultisetOperator();
                                    {if (true) return op;}
                  break;
                default:
                  jj_la1[529] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a prefix row operator like NOT.
 */
  final public SqlPrefixOperator PrefixRowOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
             {if (true) return SqlStdOperatorTable.UNARY_PLUS;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return SqlStdOperatorTable.UNARY_MINUS;}
      break;
    case NOT:
      jj_consume_token(NOT);
            {if (true) return SqlStdOperatorTable.NOT;}
      break;
    case EXISTS:
      jj_consume_token(EXISTS);
               {if (true) return SqlStdOperatorTable.EXISTS;}
      break;
    case UNIQUE:
      jj_consume_token(UNIQUE);
               {if (true) return SqlStdOperatorTable.UNIQUE;}
      break;
    default:
      jj_la1[530] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Parses a postfix row operator like IS NOT NULL.
 */
  final public SqlPostfixOperator PostfixRowOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      jj_consume_token(IS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case A:
        jj_consume_token(A);
        jj_consume_token(SET);
                    {if (true) return SqlStdOperatorTable.IS_A_SET;}
        break;
      case NOT:
        jj_consume_token(NOT);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                     {if (true) return SqlStdOperatorTable.IS_NOT_NULL;}
          break;
        case TRUE:
          jj_consume_token(TRUE);
                     {if (true) return SqlStdOperatorTable.IS_NOT_TRUE;}
          break;
        case FALSE:
          jj_consume_token(FALSE);
                      {if (true) return SqlStdOperatorTable.IS_NOT_FALSE;}
          break;
        case UNKNOWN:
          jj_consume_token(UNKNOWN);
                        {if (true) return SqlStdOperatorTable.IS_NOT_UNKNOWN;}
          break;
        case A:
          jj_consume_token(A);
          jj_consume_token(SET);
                        {if (true) return SqlStdOperatorTable.IS_NOT_A_SET;}
          break;
        case EMPTY:
          jj_consume_token(EMPTY);
                      {if (true) return SqlStdOperatorTable.IS_NOT_EMPTY;}
          break;
        default:
          jj_la1[531] = jj_gen;
          if (jj_2_155(2)) {
            jj_consume_token(JSON);
            jj_consume_token(VALUE);
                                          {if (true) return SqlStdOperatorTable.IS_NOT_JSON_VALUE;}
          } else if (jj_2_156(2)) {
            jj_consume_token(JSON);
            jj_consume_token(OBJECT);
                                           {if (true) return SqlStdOperatorTable.IS_NOT_JSON_OBJECT;}
          } else if (jj_2_157(2)) {
            jj_consume_token(JSON);
            jj_consume_token(ARRAY);
                                          {if (true) return SqlStdOperatorTable.IS_NOT_JSON_ARRAY;}
          } else if (jj_2_158(2)) {
            jj_consume_token(JSON);
            jj_consume_token(SCALAR);
                                           {if (true) return SqlStdOperatorTable.IS_NOT_JSON_SCALAR;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case JSON:
              jj_consume_token(JSON);
                     {if (true) return SqlStdOperatorTable.IS_NOT_JSON_VALUE;}
              break;
            default:
              jj_la1[532] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
      case EMPTY:
      case FALSE:
      case JSON:
      case NULL:
      case TRUE:
      case UNKNOWN:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NULL:
          jj_consume_token(NULL);
                     {if (true) retu