/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlAlterTableOptions
extends SqlAlterTable {
    private final SqlNodeList propertyList;

    public SqlAlterTableOptions(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList propertyList) {
        this(pos, tableName, null, propertyList);
    }

    public SqlAlterTableOptions(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList partitionSpec, SqlNodeList propertyList) {
        super(pos, tableName, partitionSpec);
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tableIdentifier, (Object)this.propertyList);
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : this.propertyList) {
            SqlUnparseUtils.printIndent(writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }

    @Override
    public String[] fullTableName() {
        return (String[])this.tableIdentifier.names.toArray((Object[])new String[0]);
    }
}

