/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.sql.parser.hive.impl.ParseException;

public class SqlAlterHiveTableProps
extends SqlAlterHiveTable {
    private final SqlNodeList origProps;

    public SqlAlterHiveTableProps(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList propertyList) throws ParseException {
        super(SqlAlterHiveTable.AlterTableOp.CHANGE_TBL_PROPS, pos, tableName, null, HiveDDLUtils.checkReservedTableProperties(propertyList));
        HiveDDLUtils.unescapeProperties(propertyList);
        this.origProps = new SqlNodeList(propertyList.getList().subList(0, propertyList.size() - 1), propertyList.getParserPosition());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("SET TBLPROPERTIES");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : this.origProps) {
            SqlUnparseUtils.printIndent((SqlWriter)writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }
}

