/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveDatabase;
import org.apache.flink.sql.parser.hive.impl.ParseException;

public class SqlAlterHiveDatabaseProps
extends SqlAlterHiveDatabase {
    public SqlAlterHiveDatabaseProps(SqlParserPos pos, SqlIdentifier databaseName, SqlNodeList propertyList) throws ParseException {
        super(pos, databaseName, HiveDDLUtils.checkReservedDBProperties(propertyList));
        HiveDDLUtils.unescapeProperties(this.getPropertyList());
    }

    @Override
    protected SqlAlterHiveDatabase.AlterHiveDatabaseOp getAlterOp() {
        return SqlAlterHiveDatabase.AlterHiveDatabaseOp.CHANGE_PROPS;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("DBPROPERTIES");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode property : this.originPropList) {
            SqlUnparseUtils.printIndent((SqlWriter)writer);
            property.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }
}

