/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.NlsString;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.flink.sql.parser.SqlProperty;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.hive.ddl.SqlHiveConstraintTrait;
import org.apache.flink.sql.parser.hive.impl.ParseException;
import org.apache.flink.sql.parser.type.ExtendedSqlCollectionTypeNameSpec;
import org.apache.flink.sql.parser.type.ExtendedSqlRowTypeNameSpec;
import org.apache.flink.sql.parser.type.SqlMapTypeNameSpec;

public class HiveDDLUtils {
    public static final String COL_DELIMITER = ";";
    private static final byte HIVE_CONSTRAINT_ENABLE = 4;
    private static final byte HIVE_CONSTRAINT_VALIDATE = 2;
    private static final byte HIVE_CONSTRAINT_RELY = 1;
    private static final Set<String> RESERVED_DB_PROPERTIES = new HashSet<String>();
    private static final Set<String> RESERVED_TABLE_PROPERTIES = new HashSet<String>();
    private static final List<String> RESERVED_TABLE_PROP_PREFIX = new ArrayList<String>();
    private static final UnescapeStringLiteralShuttle UNESCAPE_SHUTTLE = new UnescapeStringLiteralShuttle();

    private HiveDDLUtils() {
    }

    public static SqlNodeList checkReservedDBProperties(SqlNodeList props) throws ParseException {
        return HiveDDLUtils.checkReservedProperties(RESERVED_DB_PROPERTIES, props, "Databases");
    }

    public static SqlNodeList checkReservedTableProperties(SqlNodeList props) throws ParseException {
        props = HiveDDLUtils.checkReservedProperties(RESERVED_TABLE_PROPERTIES, props, "Tables");
        props = HiveDDLUtils.checkReservedPrefix(RESERVED_TABLE_PROP_PREFIX, props, "Tables");
        return props;
    }

    public static SqlNodeList ensureNonGeneric(SqlNodeList props) throws ParseException {
        for (SqlNode node : props) {
            if (!(node instanceof SqlTableOption) || !((SqlTableOption)node).getKeyString().equalsIgnoreCase("is_generic") || ((SqlTableOption)node).getValueString().equalsIgnoreCase("false")) continue;
            throw new ParseException("Creating generic object with Hive dialect is not allowed");
        }
        return props;
    }

    private static SqlNodeList checkReservedPrefix(List<String> reserved, SqlNodeList properties, String metaType) throws ParseException {
        if (properties == null) {
            return null;
        }
        HashSet<String> match = new HashSet<String>();
        for (SqlNode node : properties) {
            if (!(node instanceof SqlTableOption)) continue;
            String key = ((SqlTableOption)node).getKeyString();
            for (String prefix : reserved) {
                if (!key.startsWith(prefix)) continue;
                match.add(key);
            }
        }
        if (!match.isEmpty()) {
            throw new ParseException(String.format("Properties %s have reserved prefix and shouldn't be used for Hive %s", match, metaType));
        }
        return properties;
    }

    private static SqlNodeList checkReservedProperties(Set<String> reservedProperties, SqlNodeList properties, String metaType) throws ParseException {
        if (properties == null) {
            return null;
        }
        HashSet<String> match = new HashSet<String>();
        for (SqlNode node : properties) {
            String key;
            if (!(node instanceof SqlTableOption) || !reservedProperties.contains(key = ((SqlTableOption)node).getKeyString())) continue;
            match.add(key);
        }
        if (!match.isEmpty()) {
            throw new ParseException(String.format("Properties %s are reserved and shouldn't be used for Hive %s", match, metaType));
        }
        return properties;
    }

    public static SqlTableOption toTableOption(String key, SqlNode value, SqlParserPos pos) {
        return new SqlTableOption((SqlNode)SqlLiteral.createCharString((String)key, (SqlParserPos)pos), value, pos);
    }

    public static SqlTableOption toTableOption(String key, String value, SqlParserPos pos) {
        return new SqlTableOption((SqlNode)SqlLiteral.createCharString((String)key, (SqlParserPos)pos), (SqlNode)SqlLiteral.createCharString((String)value, (SqlParserPos)pos), pos);
    }

    public static void convertDataTypes(SqlNodeList columns) throws ParseException {
        if (columns != null) {
            for (SqlNode node : columns) {
                HiveDDLUtils.convertDataTypes((SqlTableColumn.SqlRegularColumn)node);
            }
        }
    }

    public static void convertDataTypes(SqlTableColumn.SqlRegularColumn column) throws ParseException {
        column.setType(HiveDDLUtils.convertDataTypes(column.getType()));
    }

    private static SqlDataTypeSpec convertDataTypes(SqlDataTypeSpec typeSpec) throws ParseException {
        SqlTypeNameSpec convertedNameSpec;
        SqlTypeNameSpec nameSpec = typeSpec.getTypeNameSpec();
        if (nameSpec != (convertedNameSpec = HiveDDLUtils.convertDataTypes(nameSpec))) {
            boolean nullable = typeSpec.getNullable() == null ? true : typeSpec.getNullable();
            typeSpec = new SqlDataTypeSpec(convertedNameSpec, typeSpec.getTimeZone(), Boolean.valueOf(nullable), typeSpec.getParserPosition());
        }
        return typeSpec;
    }

    private static SqlTypeNameSpec convertDataTypes(SqlTypeNameSpec nameSpec) throws ParseException {
        if (nameSpec instanceof SqlBasicTypeNameSpec) {
            SqlBasicTypeNameSpec basicNameSpec = (SqlBasicTypeNameSpec)nameSpec;
            if (basicNameSpec.getTypeName().getSimple().equalsIgnoreCase(SqlTypeName.TIMESTAMP.name())) {
                if (basicNameSpec.getPrecision() < 0) {
                    nameSpec = new SqlBasicTypeNameSpec(SqlTypeName.TIMESTAMP, 9, basicNameSpec.getScale(), basicNameSpec.getCharSetName(), basicNameSpec.getParserPos());
                }
            } else if (basicNameSpec.getTypeName().getSimple().equalsIgnoreCase(SqlTypeName.BINARY.name())) {
                if (basicNameSpec.getPrecision() < 0) {
                    nameSpec = new SqlBasicTypeNameSpec(SqlTypeName.VARBINARY, Integer.MAX_VALUE, basicNameSpec.getScale(), basicNameSpec.getCharSetName(), basicNameSpec.getParserPos());
                }
            } else if (basicNameSpec.getTypeName().getSimple().equalsIgnoreCase(SqlTypeName.VARCHAR.name()) && basicNameSpec.getPrecision() < 0) {
                throw new ParseException("VARCHAR precision is mandatory");
            }
        } else if (nameSpec instanceof ExtendedSqlCollectionTypeNameSpec) {
            ExtendedSqlCollectionTypeNameSpec collectionNameSpec = (ExtendedSqlCollectionTypeNameSpec)nameSpec;
            SqlTypeNameSpec elementNameSpec = collectionNameSpec.getElementTypeName();
            SqlTypeNameSpec convertedElementNameSpec = HiveDDLUtils.convertDataTypes(elementNameSpec);
            if (convertedElementNameSpec != elementNameSpec) {
                nameSpec = new ExtendedSqlCollectionTypeNameSpec(convertedElementNameSpec, collectionNameSpec.elementNullable(), collectionNameSpec.getCollectionTypeName(), collectionNameSpec.unparseAsStandard(), collectionNameSpec.getParserPos());
            }
        } else if (nameSpec instanceof SqlMapTypeNameSpec) {
            SqlMapTypeNameSpec mapNameSpec = (SqlMapTypeNameSpec)nameSpec;
            SqlDataTypeSpec keyTypeSpec = mapNameSpec.getKeyType();
            SqlDataTypeSpec valTypeSpec = mapNameSpec.getValType();
            SqlDataTypeSpec convertedKeyTypeSpec = HiveDDLUtils.convertDataTypes(keyTypeSpec);
            SqlDataTypeSpec convertedValTypeSpec = HiveDDLUtils.convertDataTypes(valTypeSpec);
            if (keyTypeSpec != convertedKeyTypeSpec || valTypeSpec != convertedValTypeSpec) {
                nameSpec = new SqlMapTypeNameSpec(convertedKeyTypeSpec, convertedValTypeSpec, nameSpec.getParserPos());
            }
        } else if (nameSpec instanceof ExtendedSqlRowTypeNameSpec) {
            ExtendedSqlRowTypeNameSpec rowNameSpec = (ExtendedSqlRowTypeNameSpec)nameSpec;
            List fieldTypeSpecs = rowNameSpec.getFieldTypes();
            ArrayList<SqlDataTypeSpec> convertedFieldTypeSpecs = new ArrayList<SqlDataTypeSpec>(fieldTypeSpecs.size());
            boolean updated = false;
            for (SqlDataTypeSpec fieldTypeSpec : fieldTypeSpecs) {
                SqlDataTypeSpec convertedFieldTypeSpec;
                if (fieldTypeSpec != (convertedFieldTypeSpec = HiveDDLUtils.convertDataTypes(fieldTypeSpec))) {
                    updated = true;
                }
                convertedFieldTypeSpecs.add(convertedFieldTypeSpec);
            }
            if (updated) {
                nameSpec = new ExtendedSqlRowTypeNameSpec(nameSpec.getParserPos(), rowNameSpec.getFieldNames(), convertedFieldTypeSpecs, rowNameSpec.getComments(), rowNameSpec.unparseAsStandard());
            }
        }
        return nameSpec;
    }

    public static byte defaultTrait() {
        byte res = HiveDDLUtils.enableConstraint((byte)0);
        res = HiveDDLUtils.relyConstraint(res);
        return res;
    }

    public static byte enableConstraint(byte trait) {
        return (byte)(trait | 4);
    }

    public static byte disableConstraint(byte trait) {
        return (byte)(trait & 0xFFFFFFFB);
    }

    public static byte validateConstraint(byte trait) {
        return (byte)(trait | 2);
    }

    public static byte noValidateConstraint(byte trait) {
        return (byte)(trait & 0xFFFFFFFD);
    }

    public static byte relyConstraint(byte trait) {
        return (byte)(trait | 1);
    }

    public static byte noRelyConstraint(byte trait) {
        return (byte)(trait & 0xFFFFFFFE);
    }

    public static boolean requireEnableConstraint(byte trait) {
        return (trait & 4) != 0;
    }

    public static boolean requireValidateConstraint(byte trait) {
        return (trait & 2) != 0;
    }

    public static boolean requireRelyConstraint(byte trait) {
        return (trait & 1) != 0;
    }

    public static byte encodeConstraintTrait(SqlHiveConstraintTrait trait) {
        byte res = 0;
        if (trait.isEnable()) {
            res = HiveDDLUtils.enableConstraint(res);
        }
        if (trait.isValidate()) {
            res = HiveDDLUtils.validateConstraint(res);
        }
        if (trait.isRely()) {
            res = HiveDDLUtils.relyConstraint(res);
        }
        return res;
    }

    public static SqlNodeList deepCopyColList(SqlNodeList colList) {
        SqlNodeList res = new SqlNodeList(colList.getParserPosition());
        for (SqlNode node : colList) {
            res.add((SqlNode)HiveDDLUtils.deepCopyTableColumn((SqlTableColumn.SqlRegularColumn)node));
        }
        return res;
    }

    public static SqlTableColumn.SqlRegularColumn deepCopyTableColumn(SqlTableColumn.SqlRegularColumn column) {
        return new SqlTableColumn.SqlRegularColumn(column.getParserPosition(), column.getName(), (SqlNode)column.getComment().orElse(null), column.getType(), (SqlTableConstraint)column.getConstraint().orElse(null));
    }

    public static void unescapeProperties(SqlNodeList properties) {
        if (properties != null) {
            properties.accept((SqlVisitor)UNESCAPE_SHUTTLE);
        }
    }

    public static SqlCharStringLiteral unescapeStringLiteral(SqlCharStringLiteral literal) {
        if (literal != null) {
            return (SqlCharStringLiteral)literal.accept((SqlVisitor)UNESCAPE_SHUTTLE);
        }
        return null;
    }

    public static void unescapePartitionSpec(SqlNodeList partSpec) {
        if (partSpec != null) {
            partSpec.accept((SqlVisitor)UNESCAPE_SHUTTLE);
        }
    }

    static {
        RESERVED_DB_PROPERTIES.addAll(Arrays.asList("hive.alter.database.op", "hive.database.location-uri"));
        RESERVED_TABLE_PROPERTIES.addAll(Arrays.asList("alter.table.op", "hive.location-uri", "hive.is-external", "hive.pk.constraint.trait", "hive.not.null.constraint.traits", "hive.storage.file-format", "hive.stored.as.input.format", "hive.stored.as.output.format", "hive.serde.lib.class.name"));
        RESERVED_TABLE_PROP_PREFIX.add("hive.serde.info.prop.");
    }

    private static class UnescapeStringLiteralShuttle
    extends SqlShuttle {
        private UnescapeStringLiteralShuttle() {
        }

        public SqlNode visit(SqlNodeList nodeList) {
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode unescaped = (SqlNode)nodeList.get(i).accept((SqlVisitor)this);
                nodeList.set(i, unescaped);
            }
            return nodeList;
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlProperty) {
                SqlProperty property = (SqlProperty)call;
                Comparable comparable = SqlLiteral.value((SqlNode)property.getValue());
                if (comparable instanceof NlsString) {
                    String val = StringEscapeUtils.unescapeJava((String)((NlsString)comparable).getValue());
                    return new SqlProperty(property.getKey(), (SqlNode)SqlLiteral.createCharString((String)val, (SqlParserPos)property.getValue().getParserPosition()), property.getParserPosition());
                }
            } else if (call instanceof SqlTableOption) {
                SqlTableOption option = (SqlTableOption)call;
                String key = StringEscapeUtils.unescapeJava((String)option.getKeyString());
                String val = StringEscapeUtils.unescapeJava((String)option.getValueString());
                SqlCharStringLiteral keyNode = SqlLiteral.createCharString((String)key, (SqlParserPos)option.getKey().getParserPosition());
                SqlCharStringLiteral valNode = SqlLiteral.createCharString((String)val, (SqlParserPos)option.getValue().getParserPosition());
                return new SqlTableOption((SqlNode)keyNode, (SqlNode)valNode, option.getParserPosition());
            }
            return call;
        }

        public SqlNode visit(SqlLiteral literal) {
            if (literal instanceof SqlCharStringLiteral) {
                SqlCharStringLiteral stringLiteral = (SqlCharStringLiteral)literal;
                String unescaped = StringEscapeUtils.unescapeJava((String)((NlsString)stringLiteral.getValueAs(NlsString.class)).getValue());
                return SqlLiteral.createCharString((String)unescaped, (SqlParserPos)stringLiteral.getParserPosition());
            }
            return literal;
        }
    }
}

