/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.type;

import java.util.List;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Pair;
import org.apache.flink.sql.parser.hive.impl.ParseException;
import org.apache.flink.sql.parser.type.ExtendedSqlRowTypeNameSpec;

public class ExtendedHiveStructTypeNameSpec
extends ExtendedSqlRowTypeNameSpec {
    public ExtendedHiveStructTypeNameSpec(SqlParserPos pos, List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes, List<SqlCharStringLiteral> comments) throws ParseException {
        super(pos, fieldNames, fieldTypes, comments, false);
        if (fieldNames.isEmpty()) {
            throw new ParseException("STRUCT with no fields is not allowed");
        }
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.print("STRUCT");
        SqlWriter.Frame frame = writer.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.FUN_CALL, "<", ">");
        int i = 0;
        for (Pair p : Pair.zip((List)this.getFieldNames(), (List)this.getFieldTypes())) {
            writer.sep(",", false);
            ((SqlIdentifier)p.left).unparse(writer, 0, 0);
            ((SqlDataTypeSpec)p.right).unparse(writer, leftPrec, rightPrec);
            if (!((SqlDataTypeSpec)p.right).getNullable().booleanValue()) {
                writer.keyword("NOT NULL");
            }
            if (this.getComments().get(i) != null) {
                ((SqlCharStringLiteral)this.getComments().get(i)).unparse(writer, leftPrec, rightPrec);
            }
            ++i;
        }
        writer.endList(frame);
    }
}

