/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.hive.ddl;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.ddl.SqlChangeColumn;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.hive.ddl.HiveDDLUtils;
import org.apache.flink.sql.parser.hive.ddl.SqlAlterHiveTable;
import org.apache.flink.sql.parser.hive.impl.ParseException;

public class SqlAlterHiveTableChangeColumn
extends SqlChangeColumn {
    private final SqlTableColumn origNewColumn;
    private final boolean cascade;

    public SqlAlterHiveTableChangeColumn(SqlParserPos pos, SqlIdentifier tableName, boolean cascade, SqlIdentifier oldName, SqlTableColumn newColumn, boolean first, SqlIdentifier after) throws ParseException {
        super(pos, tableName, oldName, newColumn, after, first, new SqlNodeList(pos));
        this.origNewColumn = HiveDDLUtils.deepCopyTableColumn(newColumn);
        HiveDDLUtils.convertDataTypes(newColumn);
        this.cascade = cascade;
        this.getProperties().add((SqlNode)HiveDDLUtils.toTableOption("alter.table.op", SqlAlterHiveTable.AlterTableOp.ALTER_COLUMNS.name(), pos));
        if (cascade) {
            this.getProperties().add((SqlNode)HiveDDLUtils.toTableOption("alter.column.cascade", "true", pos));
        }
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("ALTER TABLE");
        this.tableIdentifier.unparse(writer, leftPrec, rightPrec);
        SqlNodeList partitionSpec = this.getPartitionSpec();
        if (partitionSpec != null && partitionSpec.size() > 0) {
            writer.keyword("PARTITION");
            partitionSpec.unparse(writer, this.getOperator().getLeftPrec(), this.getOperator().getRightPrec());
        }
        writer.keyword("CHANGE COLUMN");
        this.getOldName().unparse(writer, leftPrec, rightPrec);
        this.origNewColumn.unparse(writer, leftPrec, rightPrec);
        if (this.isFirst()) {
            writer.keyword("FIRST");
        }
        if (this.getAfter() != null) {
            writer.keyword("AFTER");
            this.getAfter().unparse(writer, leftPrec, rightPrec);
        }
        if (this.cascade) {
            writer.keyword("CASCADE");
        } else {
            writer.keyword("RESTRICT");
        }
    }
}

