/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc.utils;

import javax.annotation.Nullable;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

public interface ArrayFieldGetter {
    @Nullable
    public Object getObjectOrNull(ArrayData var1, int var2);

    public static ArrayFieldGetter createFieldGetter(LogicalType type) {
        ArrayFieldGetter fieldGetter;
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                fieldGetter = ArrayData::getString;
                break;
            }
            case BOOLEAN: {
                fieldGetter = ArrayData::getBoolean;
                break;
            }
            case BINARY: 
            case VARBINARY: {
                fieldGetter = ArrayData::getBinary;
                break;
            }
            case DECIMAL: {
                int decimalPrecision = LogicalTypeChecks.getPrecision((LogicalType)type);
                int decimalScale = LogicalTypeChecks.getScale((LogicalType)type);
                fieldGetter = (array, index) -> array.getDecimal(index, decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                fieldGetter = ArrayData::getByte;
                break;
            }
            case SMALLINT: {
                fieldGetter = ArrayData::getShort;
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                fieldGetter = ArrayData::getInt;
                break;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                fieldGetter = ArrayData::getLong;
                break;
            }
            case FLOAT: {
                fieldGetter = ArrayData::getFloat;
                break;
            }
            case DOUBLE: {
                fieldGetter = ArrayData::getDouble;
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = LogicalTypeChecks.getPrecision((LogicalType)type);
                fieldGetter = (array, index) -> array.getTimestamp(index, timestampPrecision);
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new UnsupportedOperationException();
            }
            case ARRAY: {
                fieldGetter = ArrayData::getArray;
                break;
            }
            case MULTISET: 
            case MAP: {
                fieldGetter = ArrayData::getMap;
                break;
            }
            case ROW: 
            case STRUCTURED_TYPE: {
                int arrayFieldCount = LogicalTypeChecks.getFieldCount((LogicalType)type);
                fieldGetter = (array, index) -> array.getRow(index, arrayFieldCount);
                break;
            }
            case DISTINCT_TYPE: {
                fieldGetter = ArrayFieldGetter.createFieldGetter(((DistinctType)type).getSourceType());
                break;
            }
            case RAW: {
                fieldGetter = ArrayData::getRawValue;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (!type.isNullable()) {
            return fieldGetter;
        }
        return (array, index) -> {
            if (array.isNullAt(index)) {
                return null;
            }
            return fieldGetter.getObjectOrNull(array, index);
        };
    }
}

