/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.gateway.service.utils.SqlExecutionException;
import org.apache.flink.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultStore {
    private static final Logger LOG = LoggerFactory.getLogger(ResultStore.class);
    public static final ResultStore DUMMY_RESULT_STORE = new ResultStore(CloseableIterator.adapterForIterator(Collections.emptyIterator()), 0);
    private final CloseableIterator<RowData> result;
    private final List<RowData> recordsBuffer = new ArrayList<RowData>();
    private final int maxBufferSize;
    private final Object resultLock = new Object();
    private final AtomicReference<SqlExecutionException> executionException = new AtomicReference();
    private final ResultRetrievalThread retrievalThread = new ResultRetrievalThread();

    public ResultStore(CloseableIterator<RowData> result, int maxBufferSize) {
        this.result = result;
        this.maxBufferSize = maxBufferSize;
        this.retrievalThread.start();
    }

    public void close() {
        this.retrievalThread.isRunning = false;
        this.retrievalThread.interrupt();
        try {
            this.result.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close the ResultStore. Ignore the error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<List<RowData>> retrieveRecords() {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.isRetrieving() && this.executionException.get() == null) {
                if (this.recordsBuffer.isEmpty()) {
                    return Optional.of(Collections.emptyList());
                }
                ArrayList<RowData> change = new ArrayList<RowData>(this.recordsBuffer);
                this.recordsBuffer.clear();
                this.resultLock.notifyAll();
                return Optional.of(change);
            }
            if (!this.isRetrieving() && !this.recordsBuffer.isEmpty()) {
                ArrayList<RowData> change = new ArrayList<RowData>(this.recordsBuffer);
                this.recordsBuffer.clear();
                return Optional.of(change);
            }
            return this.handleMissingResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferedRecordSize() {
        Object object = this.resultLock;
        synchronized (object) {
            return this.recordsBuffer.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHasData() {
        Object object = this.resultLock;
        synchronized (object) {
            while (this.isRetrieving() && this.recordsBuffer.isEmpty()) {
                try {
                    this.resultLock.wait();
                }
                catch (InterruptedException e) {
                    throw new SqlExecutionException("Failed to wait the result is ready.", e);
                }
            }
        }
    }

    public boolean isRetrieving() {
        return this.retrievalThread.isRunning;
    }

    private Optional<List<RowData>> handleMissingResult() {
        if (this.executionException.get() != null) {
            throw this.executionException.get();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecord(RowData row) {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.recordsBuffer.size() >= this.maxBufferSize) {
                try {
                    this.resultLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.recordsBuffer.add(row);
            this.resultLock.notifyAll();
        }
    }

    static {
        DUMMY_RESULT_STORE.close();
    }

    private class ResultRetrievalThread
    extends Thread {
        public volatile boolean isRunning = true;

        private ResultRetrievalThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.isRunning && ResultStore.this.result.hasNext()) {
                    ResultStore.this.processRecord((RowData)ResultStore.this.result.next());
                }
            }
            catch (RuntimeException e) {
                ResultStore.this.executionException.compareAndSet(null, new SqlExecutionException("Error while retrieving result.", e));
            }
            this.isRunning = false;
            Object object = ResultStore.this.resultLock;
            synchronized (object) {
                ResultStore.this.resultLock.notify();
            }
        }
    }
}

