/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.util;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class SqlGatewayRestOptions {
    public static final ConfigOption<String> ADDRESS = ConfigOptions.key("address").stringType().noDefaultValue().withDescription("The address that should be used by clients to connect to the sql gateway server.");
    public static final ConfigOption<String> BIND_ADDRESS = ConfigOptions.key("bind-address").stringType().noDefaultValue().withDescription("The address that the sql gateway server binds itself.");
    public static final ConfigOption<String> BIND_PORT = ConfigOptions.key("bind-port").stringType().defaultValue("8083").withDescription("The port that the sql gateway server binds itself. Accepts a list of ports (\u201c50100,50101\u201d), ranges (\u201c50100-50200\u201d) or a combination of both. It is recommended to set a range of ports to avoid collisions when multiple sql gateway servers are running on the same machine.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key("port").intType().defaultValue(8083).withDescription(String.format("The port that the client connects to. If %s has not been specified, then the sql gateway server will bind to this port.", BIND_PORT.key()));
}

