/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.util;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.DateTimeUtils;

public class RowDataLocalTimeZoneConverter {
    private final List<RowData.FieldGetter> fieldGetterList;
    private final List<LogicalType> logicalTypeList;
    private final boolean hasTimeZoneData;
    private final TimeZone timeZone;

    public RowDataLocalTimeZoneConverter(List<LogicalType> logicalTypeList, ReadableConfig config) {
        this(logicalTypeList, TimeZone.getTimeZone(RowDataLocalTimeZoneConverter.getSessionTimeZone(config)));
    }

    public RowDataLocalTimeZoneConverter(List<LogicalType> logicalTypeList, TimeZone timeZone) {
        this.logicalTypeList = logicalTypeList;
        this.timeZone = timeZone;
        this.fieldGetterList = new ArrayList<RowData.FieldGetter>(logicalTypeList.size());
        for (int i = 0; i < logicalTypeList.size(); ++i) {
            this.fieldGetterList.add(RowData.createFieldGetter(logicalTypeList.get(i), i));
        }
        this.hasTimeZoneData = this.checkTimeZoneType(logicalTypeList);
    }

    private boolean checkTimeZoneType(List<LogicalType> logicalTypeList) {
        for (LogicalType logicalType : logicalTypeList) {
            RowType rowType;
            MultisetType multisetType;
            ArrayType arrayType;
            MapType mapType;
            if (logicalType.getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
                return true;
            }
            if (!(logicalType.getTypeRoot() == LogicalTypeRoot.MAP ? this.checkTimeZoneType(Arrays.asList((mapType = (MapType)logicalType).getKeyType(), mapType.getValueType())) : (logicalType.getTypeRoot() == LogicalTypeRoot.ARRAY ? this.checkTimeZoneType(Collections.singletonList((arrayType = (ArrayType)logicalType).getElementType())) : (logicalType.getTypeRoot() == LogicalTypeRoot.MULTISET ? this.checkTimeZoneType(Collections.singletonList((multisetType = (MultisetType)logicalType).getElementType())) : logicalType.getTypeRoot() == LogicalTypeRoot.ROW && this.checkTimeZoneType((rowType = (RowType)logicalType).getFields().stream().map(RowType.RowField::getType).collect(Collectors.toList())))))) continue;
            return true;
        }
        return false;
    }

    public RowData convertTimeZoneRowData(RowData rowData) {
        if (!this.hasTimeZoneData()) {
            return rowData;
        }
        GenericRowData result = new GenericRowData(rowData.getRowKind(), rowData.getArity());
        for (int i = 0; i < this.fieldGetterList.size(); ++i) {
            result.setField(i, this.convertLocalTimeZoneValue(this.fieldGetterList.get(i).getFieldOrNull(rowData), this.logicalTypeList.get(i)));
        }
        return result;
    }

    private Object convertLocalTimeZoneValue(Object object, LogicalType dataType) {
        if (object == null) {
            return null;
        }
        switch (dataType.getTypeRoot()) {
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DateTimeUtils.timestampWithLocalZoneToTimestamp((TimestampData)object, this.timeZone);
            }
            case MAP: {
                MapType mapType = (MapType)dataType;
                MapData mapData = (MapData)object;
                ArrayData keyArray = mapData.keyArray();
                ArrayData valueArray = mapData.valueArray();
                ArrayData.ElementGetter keyGetter = ArrayData.createElementGetter(mapType.getKeyType());
                ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter(mapType.getValueType());
                HashMap<Object, Object> mapValue = new HashMap<Object, Object>();
                for (int j = 0; j < keyArray.size(); ++j) {
                    mapValue.put(this.convertLocalTimeZoneValue(keyGetter.getElementOrNull(keyArray, j), mapType.getKeyType()), this.convertLocalTimeZoneValue(valueGetter.getElementOrNull(valueArray, j), mapType.getValueType()));
                }
                return new GenericMapData(mapValue);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                ArrayData arrayData = (ArrayData)object;
                ArrayData.ElementGetter dataGetter = ArrayData.createElementGetter(arrayType.getElementType());
                ArrayList<Object> arrayValues = new ArrayList<Object>(arrayData.size());
                for (int i = 0; i < arrayData.size(); ++i) {
                    arrayValues.add(this.convertLocalTimeZoneValue(dataGetter.getElementOrNull(arrayData, i), arrayType.getElementType()));
                }
                return new GenericArrayData(arrayValues.toArray());
            }
        }
        return object;
    }

    public boolean hasTimeZoneData() {
        return this.hasTimeZoneData;
    }

    private static ZoneId getSessionTimeZone(ReadableConfig sessionConfig) {
        String zone = sessionConfig.get(TableConfigOptions.LOCAL_TIME_ZONE);
        return TableConfigOptions.LOCAL_TIME_ZONE.defaultValue().equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
    }
}

