/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.message.statement;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.message.operation.OperationHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsRowFormatQueryParameter;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsTokenPathParameter;
import org.apache.flink.table.gateway.rest.util.RowFormat;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class FetchResultsMessageParameters
extends MessageParameters {
    private final SessionHandleIdPathParameter sessionHandleIdPathParameter = new SessionHandleIdPathParameter();
    private final OperationHandleIdPathParameter operationHandleIdPathParameter = new OperationHandleIdPathParameter();
    private final FetchResultsTokenPathParameter fetchResultsTokenPathParameter = new FetchResultsTokenPathParameter();
    private final FetchResultsRowFormatQueryParameter fetchResultsRowFormatQueryParameter = new FetchResultsRowFormatQueryParameter();
    private final SqlGatewayRestAPIVersion version;

    public FetchResultsMessageParameters(SqlGatewayRestAPIVersion version) {
        this.version = version;
    }

    public FetchResultsMessageParameters(SessionHandle sessionHandle, OperationHandle operationHandle, Long token, RowFormat rowFormat) {
        this.version = SqlGatewayRestAPIVersion.getDefaultVersion();
        this.sessionHandleIdPathParameter.resolve(sessionHandle);
        this.operationHandleIdPathParameter.resolve(operationHandle);
        this.fetchResultsTokenPathParameter.resolve(token);
        this.fetchResultsRowFormatQueryParameter.resolve(Collections.singletonList(rowFormat));
    }

    @Override
    public Collection<MessagePathParameter<?>> getPathParameters() {
        return Arrays.asList(this.sessionHandleIdPathParameter, this.operationHandleIdPathParameter, this.fetchResultsTokenPathParameter);
    }

    @Override
    public Collection<MessageQueryParameter<?>> getQueryParameters() {
        if (this.version == SqlGatewayRestAPIVersion.V1) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.fetchResultsRowFormatQueryParameter);
    }
}

