/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.materializedtable;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.materializedtable.MaterializedTableIdentifierPathParameter;
import org.apache.flink.table.gateway.rest.message.materializedtable.RefreshMaterializedTableParameters;
import org.apache.flink.table.gateway.rest.message.materializedtable.RefreshMaterializedTableRequestBody;
import org.apache.flink.table.gateway.rest.message.materializedtable.RefreshMaterializedTableResponseBody;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class RefreshMaterializedTableHandler
extends AbstractSqlGatewayRestHandler<RefreshMaterializedTableRequestBody, RefreshMaterializedTableResponseBody, RefreshMaterializedTableParameters> {
    public RefreshMaterializedTableHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<RefreshMaterializedTableRequestBody, RefreshMaterializedTableResponseBody, RefreshMaterializedTableParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<RefreshMaterializedTableResponseBody> handleRequest(@Nullable SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<RefreshMaterializedTableRequestBody> request) throws RestHandlerException {
        try {
            SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
            String materializedTableIdentifier = (String)request.getPathParameter(MaterializedTableIdentifierPathParameter.class);
            boolean isPeriodic = request.getRequestBody().isPeriodic();
            String scheduleTime = request.getRequestBody().getScheduleTime();
            Map<String, String> dynamicOptions = request.getRequestBody().getDynamicOptions();
            Map<String, String> staticPartitions = request.getRequestBody().getStaticPartitions();
            Map<String, String> executionConfig = request.getRequestBody().getExecutionConfig();
            OperationHandle operationHandle = this.service.refreshMaterializedTable(sessionHandle, materializedTableIdentifier, isPeriodic, scheduleTime, dynamicOptions == null ? Collections.emptyMap() : dynamicOptions, staticPartitions == null ? Collections.emptyMap() : staticPartitions, executionConfig == null ? Collections.emptyMap() : executionConfig);
            return CompletableFuture.completedFuture(new RefreshMaterializedTableResponseBody(operationHandle.getIdentifier().toString()));
        }
        catch (Exception e) {
            throw new RestHandlerException(e.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR, e);
        }
    }
}

