/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.client.util.ClientClassloaderUtil;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@Internal
public class ClientWrapperClassLoader
extends FlinkUserCodeClassLoaders.SafetyNetWrapperClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ClientWrapperClassLoader.class);
    private final Configuration configuration;
    private final List<FlinkUserCodeClassLoader> originClassLoaders;

    public ClientWrapperClassLoader(FlinkUserCodeClassLoader inner, Configuration configuration) {
        super(inner, inner.getParent());
        this.configuration = new Configuration(configuration);
        this.originClassLoaders = new ArrayList<FlinkUserCodeClassLoader>();
    }

    public void removeURL(URL url) {
        Set registeredUrls = Stream.of(this.inner.getURLs()).collect(Collectors.toSet());
        if (!registeredUrls.contains(url)) {
            LOG.warn(String.format("Could not remove the specified jar because the jar path [%s] is not found in classloader.", url));
            return;
        }
        this.originClassLoaders.add(this.inner);
        registeredUrls.remove(url);
        this.inner = ClientClassloaderUtil.buildUserClassLoader(new ArrayList<URL>(registeredUrls), ClientWrapperClassLoader.class.getClassLoader(), this.configuration);
    }

    @Override
    public void close() {
        super.close();
        for (FlinkUserCodeClassLoader classLoader : this.originClassLoaders) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close the origin classloader.", (Throwable)e);
            }
        }
        this.originClassLoaders.clear();
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

