/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.time.Duration;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.guava31.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava31.com.google.common.cache.CacheStats;
import org.apache.flink.table.api.internal.CachedPlan;
import org.apache.flink.util.Preconditions;

@Internal
public class PlanCacheManager {
    private final Cache<String, CachedPlan> planCache;

    public PlanCacheManager(long maximumCapacity, Duration ttl) {
        this.planCache = CacheBuilder.newBuilder().maximumSize(maximumCapacity).expireAfterWrite(ttl).recordStats().build();
    }

    public Optional<CachedPlan> getPlan(String query) {
        CachedPlan cachedPlan = this.planCache.getIfPresent(query);
        return Optional.ofNullable(cachedPlan);
    }

    public void putPlan(String query, CachedPlan cachedPlan) {
        Preconditions.checkNotNull(query, "query can not be null");
        Preconditions.checkNotNull(cachedPlan, "cachedPlan can not be null");
        this.planCache.put(query, cachedPlan);
    }

    public void invalidateAll() {
        this.planCache.invalidateAll();
    }

    @VisibleForTesting
    public CacheStats getCacheStats() {
        return this.planCache.stats();
    }
}

