/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.Map;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.InternalKeyedState;
import org.apache.flink.runtime.state.v2.MapStateDescriptor;

public class InternalMapState<K, UK, V>
extends InternalKeyedState<K, V>
implements MapState<UK, V> {
    public InternalMapState(StateRequestHandler stateRequestHandler, MapStateDescriptor<UK, V> stateDescriptor) {
        super(stateRequestHandler, stateDescriptor);
    }

    @Override
    public StateFuture<V> asyncGet(UK key) {
        return this.handleRequest(StateRequestType.MAP_GET, key);
    }

    @Override
    public StateFuture<Void> asyncPut(UK key, V value) {
        return this.handleRequest(StateRequestType.MAP_PUT, Tuple2.of(key, value));
    }

    @Override
    public StateFuture<Void> asyncPutAll(Map<UK, V> map) {
        return this.handleRequest(StateRequestType.MAP_PUT_ALL, map);
    }

    @Override
    public StateFuture<Void> asyncRemove(UK key) {
        return this.handleRequest(StateRequestType.MAP_REMOVE, key);
    }

    @Override
    public StateFuture<Boolean> asyncContains(UK key) {
        return this.handleRequest(StateRequestType.MAP_CONTAINS, key);
    }

    @Override
    public StateFuture<StateIterator<Map.Entry<UK, V>>> asyncEntries() {
        return this.handleRequest(StateRequestType.MAP_ITER, null);
    }

    @Override
    public StateFuture<StateIterator<UK>> asyncKeys() {
        return this.handleRequest(StateRequestType.MAP_ITER_KEY, null);
    }

    @Override
    public StateFuture<StateIterator<V>> asyncValues() {
        return this.handleRequest(StateRequestType.MAP_ITER_VALUE, null);
    }

    @Override
    public StateFuture<Boolean> asyncIsEmpty() {
        return this.handleRequest(StateRequestType.MAP_IS_EMPTY, null);
    }
}

