/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class StateChange
implements Serializable {
    public static final int META_KEY_GROUP = -1;
    private static final long serialVersionUID = 1L;
    private final int keyGroup;
    private final byte[] change;

    StateChange(byte[] change) {
        this.keyGroup = -1;
        this.change = Preconditions.checkNotNull(change);
    }

    StateChange(int keyGroup, byte[] change) {
        Preconditions.checkArgument(keyGroup >= 0);
        this.keyGroup = keyGroup;
        this.change = Preconditions.checkNotNull(change);
    }

    public static StateChange ofMetadataChange(byte[] change) {
        return new StateChange(change);
    }

    public static StateChange ofDataChange(int keyGroup, byte[] change) {
        return new StateChange(keyGroup, change);
    }

    public String toString() {
        return String.format("keyGroup=%d, dataSize=%d", this.keyGroup, this.change.length);
    }

    public int getKeyGroup() {
        return this.keyGroup;
    }

    public byte[] getChange() {
        return this.change;
    }
}

