/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.ResourceListener;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.apache.flink.runtime.scheduler.adaptive.StateWithoutExecutionGraph;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.slf4j.Logger;

class WaitingForResources
extends StateWithoutExecutionGraph
implements ResourceListener {
    private final Context context;
    private final Clock clock;
    @Nullable
    private Deadline resourceStabilizationDeadline;
    private final Duration resourceStabilizationTimeout;
    @Nullable
    private ScheduledFuture<?> resourceTimeoutFuture;
    @Nullable
    private final ExecutionGraph previousExecutionGraph;

    @VisibleForTesting
    WaitingForResources(Context context, Logger log, Duration initialResourceAllocationTimeout, Duration resourceStabilizationTimeout) {
        this(context, log, initialResourceAllocationTimeout, resourceStabilizationTimeout, SystemClock.getInstance(), null);
    }

    WaitingForResources(Context context, Logger log, Duration initialResourceAllocationTimeout, Duration resourceStabilizationTimeout, Clock clock, @Nullable ExecutionGraph previousExecutionGraph) {
        super(context, log);
        this.context = Preconditions.checkNotNull(context);
        this.resourceStabilizationTimeout = Preconditions.checkNotNull(resourceStabilizationTimeout);
        this.clock = clock;
        Preconditions.checkNotNull(initialResourceAllocationTimeout);
        Preconditions.checkArgument(!resourceStabilizationTimeout.isNegative(), "Resource stabilization timeout must not be negative");
        if (!initialResourceAllocationTimeout.isNegative()) {
            this.resourceTimeoutFuture = context.runIfState(this, this::resourceTimeout, initialResourceAllocationTimeout);
        }
        this.previousExecutionGraph = previousExecutionGraph;
        context.runIfState(this, this::checkDesiredOrSufficientResourcesAvailable, Duration.ZERO);
    }

    @Override
    public void onLeave(Class<? extends State> newState) {
        if (this.resourceTimeoutFuture != null) {
            this.resourceTimeoutFuture.cancel(false);
        }
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.CREATED;
    }

    @Override
    public void onNewResourcesAvailable() {
        this.checkDesiredOrSufficientResourcesAvailable();
    }

    @Override
    public void onNewResourceRequirements() {
        this.checkDesiredOrSufficientResourcesAvailable();
    }

    private void checkDesiredOrSufficientResourcesAvailable() {
        if (this.context.hasDesiredResources()) {
            this.createExecutionGraphWithAvailableResources();
            return;
        }
        if (this.context.hasSufficientResources()) {
            if (this.resourceStabilizationDeadline == null) {
                this.resourceStabilizationDeadline = Deadline.fromNowWithClock(this.resourceStabilizationTimeout, this.clock);
            }
            if (this.resourceStabilizationDeadline.isOverdue()) {
                this.createExecutionGraphWithAvailableResources();
            } else {
                this.context.runIfState(this, this::checkDesiredOrSufficientResourcesAvailable, this.resourceStabilizationDeadline.timeLeft());
            }
        } else {
            this.resourceStabilizationDeadline = null;
        }
    }

    private void resourceTimeout() {
        this.getLogger().debug("Initial resource allocation timeout triggered: Creating ExecutionGraph with available resources.");
        this.createExecutionGraphWithAvailableResources();
    }

    private void createExecutionGraphWithAvailableResources() {
        this.context.goToCreatingExecutionGraph(this.previousExecutionGraph);
    }

    static class Factory
    implements StateFactory<WaitingForResources> {
        private final Context context;
        private final Logger log;
        private final Duration initialResourceAllocationTimeout;
        private final Duration resourceStabilizationTimeout;
        @Nullable
        private final ExecutionGraph previousExecutionGraph;

        public Factory(Context context, Logger log, Duration initialResourceAllocationTimeout, Duration resourceStabilizationTimeout, @Nullable ExecutionGraph previousExecutionGraph) {
            this.context = context;
            this.log = log;
            this.initialResourceAllocationTimeout = initialResourceAllocationTimeout;
            this.resourceStabilizationTimeout = resourceStabilizationTimeout;
            this.previousExecutionGraph = previousExecutionGraph;
        }

        @Override
        public Class<WaitingForResources> getStateClass() {
            return WaitingForResources.class;
        }

        @Override
        public WaitingForResources getState() {
            return new WaitingForResources(this.context, this.log, this.initialResourceAllocationTimeout, this.resourceStabilizationTimeout, SystemClock.getInstance(), this.previousExecutionGraph);
        }
    }

    static interface Context
    extends StateWithoutExecutionGraph.Context,
    StateTransitions.ToCreatingExecutionGraph {
        public boolean hasDesiredResources();

        public boolean hasSufficientResources();

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);
    }
}

