/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.apache.flink.shaded.guava31.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerMergedPartitionFileWriter
implements PartitionFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerMergedPartitionFileWriter.class);
    private final ExecutorService ioExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Producer merge partition file flush thread").setUncaughtExceptionHandler(FatalExitExceptionHandler.INSTANCE).build());
    private final FileChannel dataFileChannel;
    private final ProducerMergedPartitionFileIndex partitionFileIndex;
    private long totalBytesWritten;

    ProducerMergedPartitionFileWriter(Path dataFilePath, ProducerMergedPartitionFileIndex partitionFileIndex) {
        LOG.info("Creating partition file " + dataFilePath);
        try {
            this.dataFileChannel = FileChannel.open(dataFilePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file channel.", e);
        }
        this.partitionFileIndex = partitionFileIndex;
    }

    @Override
    public CompletableFuture<Void> write(TieredStoragePartitionId partitionId, List<PartitionFileWriter.SubpartitionBufferContext> buffersToWrite) {
        CompletableFuture<Void> flushSuccessNotifier = new CompletableFuture<Void>();
        this.ioExecutor.execute(() -> this.flush(buffersToWrite, flushSuccessNotifier));
        return flushSuccessNotifier;
    }

    @Override
    public void release() {
        try {
            this.ioExecutor.shutdown();
            if (!this.ioExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                throw new TimeoutException("Timeout to shutdown the flush thread.");
            }
            this.dataFileChannel.close();
        }
        catch (Exception e) {
            ExceptionUtils.rethrow(e);
        }
        this.partitionFileIndex.release();
    }

    private void flush(List<PartitionFileWriter.SubpartitionBufferContext> toWrite, CompletableFuture<Void> flushSuccessNotifier) {
        try {
            ArrayList<ProducerMergedPartitionFileIndex.FlushedBuffer> buffers = new ArrayList<ProducerMergedPartitionFileIndex.FlushedBuffer>();
            this.calculateSizeAndFlushBuffers(toWrite, buffers);
            this.partitionFileIndex.addBuffers(buffers);
            flushSuccessNotifier.complete(null);
        }
        catch (IOException exception) {
            ExceptionUtils.rethrow(exception);
        }
    }

    private void calculateSizeAndFlushBuffers(List<PartitionFileWriter.SubpartitionBufferContext> toWrite, List<ProducerMergedPartitionFileIndex.FlushedBuffer> buffers) throws IOException {
        ArrayList<Tuple2<Buffer, Integer>> buffersToFlush = new ArrayList<Tuple2<Buffer, Integer>>();
        long expectedBytes = 0L;
        for (PartitionFileWriter.SubpartitionBufferContext subpartitionBufferContext : toWrite) {
            int subpartitionId = subpartitionBufferContext.getSubpartitionId();
            for (PartitionFileWriter.SegmentBufferContext segmentBufferContext : subpartitionBufferContext.getSegmentBufferContexts()) {
                List<Tuple2<Buffer, Integer>> bufferAndIndexes = segmentBufferContext.getBufferAndIndexes();
                buffersToFlush.addAll(bufferAndIndexes);
                for (Tuple2<Buffer, Integer> bufferWithIndex2 : segmentBufferContext.getBufferAndIndexes()) {
                    Buffer buffer = (Buffer)bufferWithIndex2.f0;
                    buffers.add(new ProducerMergedPartitionFileIndex.FlushedBuffer(subpartitionId, (Integer)bufferWithIndex2.f1, this.totalBytesWritten + expectedBytes, buffer.readableBytes() + 8));
                    expectedBytes += (long)(buffer.readableBytes() + 8);
                }
            }
        }
        this.flushBuffers(buffersToFlush, expectedBytes);
        buffersToFlush.forEach(bufferWithIndex -> ((Buffer)bufferWithIndex.f0).recycleBuffer());
    }

    private void flushBuffers(List<Tuple2<Buffer, Integer>> bufferAndIndexes, long expectedBytes) throws IOException {
        if (bufferAndIndexes.isEmpty()) {
            return;
        }
        ByteBuffer[] bufferWithHeaders = TieredStorageUtils.generateBufferWithHeaders(bufferAndIndexes);
        BufferReaderWriterUtil.writeBuffers(this.dataFileChannel, expectedBytes, bufferWithHeaders);
        this.totalBytesWritten += expectedBytes;
    }
}

