/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.DefaultHeartbeatMonitor;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatMonitor;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

class HeartbeatManagerSenderImpl<I, O>
extends HeartbeatManagerImpl<I, O>
implements Runnable {
    private final long heartbeatPeriod;

    HeartbeatManagerSenderImpl(long heartbeatPeriod, long heartbeatTimeout, int failedRpcRequestsUntilUnreachable, ResourceID ownResourceID, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        this(heartbeatPeriod, heartbeatTimeout, failedRpcRequestsUntilUnreachable, ownResourceID, heartbeatListener, mainThreadExecutor, log, new DefaultHeartbeatMonitor.Factory());
    }

    HeartbeatManagerSenderImpl(long heartbeatPeriod, long heartbeatTimeout, int failedRpcRequestsUntilUnreachable, ResourceID ownResourceID, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log, HeartbeatMonitor.Factory<O> heartbeatMonitorFactory) {
        super(heartbeatTimeout, failedRpcRequestsUntilUnreachable, ownResourceID, heartbeatListener, mainThreadExecutor, log, heartbeatMonitorFactory);
        this.heartbeatPeriod = heartbeatPeriod;
        mainThreadExecutor.schedule(this, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (!this.stopped) {
            this.log.debug("Trigger heartbeat request.");
            for (HeartbeatMonitor heartbeatMonitor : this.getHeartbeatTargets().values()) {
                this.requestHeartbeat(heartbeatMonitor);
            }
            this.getMainThreadExecutor().schedule(this, this.heartbeatPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private void requestHeartbeat(HeartbeatMonitor<O> heartbeatMonitor) {
        Object payload = this.getHeartbeatListener().retrievePayload(heartbeatMonitor.getHeartbeatTargetId());
        HeartbeatTarget<O> heartbeatTarget = heartbeatMonitor.getHeartbeatTarget();
        heartbeatTarget.requestHeartbeat(this.getOwnResourceID(), payload).whenCompleteAsync((BiConsumer)this.handleHeartbeatRpc(heartbeatMonitor.getHeartbeatTargetId()), (Executor)this.getMainThreadExecutor());
    }
}

