/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.cleanup;

import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.CleanupOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.concurrent.ExponentialBackoffRetryStrategy;
import org.apache.flink.util.concurrent.FixedRetryStrategy;
import org.apache.flink.util.concurrent.RetryStrategy;

public enum CleanupRetryStrategyFactory {
    INSTANCE;


    public RetryStrategy createRetryStrategy(Configuration configuration) {
        String configuredRetryStrategy = configuration.get(CleanupOptions.CLEANUP_STRATEGY);
        if (CleanupRetryStrategyFactory.isRetryStrategy("fixed-delay", configuration.get(CleanupOptions.CLEANUP_STRATEGY))) {
            return CleanupRetryStrategyFactory.createFixedRetryStrategy(configuration);
        }
        if (CleanupRetryStrategyFactory.isRetryStrategy("exponential-delay", configuration.get(CleanupOptions.CLEANUP_STRATEGY))) {
            return CleanupRetryStrategyFactory.createExponentialBackoffRetryStrategy(configuration);
        }
        if (CleanupRetryStrategyFactory.retryingDisabled(configuredRetryStrategy)) {
            return CleanupRetryStrategyFactory.createNoRetryStrategy();
        }
        throw new IllegalArgumentException(CleanupRetryStrategyFactory.createInvalidCleanupStrategyErrorMessage(configuredRetryStrategy));
    }

    private static RetryStrategy createNoRetryStrategy() {
        return new FixedRetryStrategy(0, Duration.ZERO);
    }

    private static FixedRetryStrategy createFixedRetryStrategy(Configuration configuration) {
        Duration delay = configuration.get(CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_DELAY);
        int maxAttempts = configuration.get(CleanupOptions.CLEANUP_STRATEGY_FIXED_DELAY_ATTEMPTS);
        return new FixedRetryStrategy(maxAttempts, delay);
    }

    private static ExponentialBackoffRetryStrategy createExponentialBackoffRetryStrategy(Configuration configuration) {
        Duration minDelay = configuration.get(CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF);
        Duration maxDelay = configuration.get(CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF);
        int maxAttempts = configuration.get(CleanupOptions.CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS);
        return new ExponentialBackoffRetryStrategy(maxAttempts, minDelay, maxDelay);
    }

    private static String createInvalidCleanupStrategyErrorMessage(String configuredRetryStrategy) {
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append("Unknown cleanup retry strategy '").append(configuredRetryStrategy).append("'. Valid strategies are ");
        String validOptionsStr = Stream.concat(Stream.of("exponential-delay", "fixed-delay"), CleanupOptions.NONE_PARAM_VALUES.stream()).collect(Collectors.joining(", "));
        return msgBuilder.append(validOptionsStr).toString();
    }

    private static boolean retryingDisabled(String configuredRetryStrategy) {
        String retryStrategy = configuredRetryStrategy.toLowerCase();
        return CleanupOptions.NONE_PARAM_VALUES.contains(retryStrategy);
    }

    private static boolean isRetryStrategy(String retryStrategyLabel, String configuredRetryStrategy) {
        String retryStrategy = configuredRetryStrategy.toLowerCase();
        return retryStrategy.equals(retryStrategyLabel) || retryStrategy.equals(CleanupOptions.extractAlphaNumericCharacters(retryStrategyLabel));
    }
}

