/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBudgetManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBudgetManager.class);
    private final ResourceProfile totalBudget;
    private ResourceProfile availableBudget;

    public ResourceBudgetManager(ResourceProfile totalBudget) {
        ResourceBudgetManager.checkResourceProfileNotNullOrUnknown(totalBudget);
        this.totalBudget = totalBudget;
        this.availableBudget = totalBudget;
    }

    public ResourceProfile getTotalBudget() {
        return this.totalBudget;
    }

    public ResourceProfile getAvailableBudget() {
        return this.availableBudget;
    }

    public boolean reserve(ResourceProfile reservation) {
        ResourceBudgetManager.checkResourceProfileNotNullOrUnknown(reservation);
        if (!this.availableBudget.allFieldsNoLessThan(reservation)) {
            return false;
        }
        this.availableBudget = this.availableBudget.subtract(reservation);
        LOG.debug("Resource budget reduced to {}.", (Object)this.availableBudget);
        return true;
    }

    public boolean release(ResourceProfile reservation) {
        ResourceBudgetManager.checkResourceProfileNotNullOrUnknown(reservation);
        ResourceProfile newAvailableBudget = this.availableBudget.merge(reservation);
        if (!this.totalBudget.allFieldsNoLessThan(newAvailableBudget)) {
            return false;
        }
        this.availableBudget = newAvailableBudget;
        LOG.debug("Resource budget increased to {}.", (Object)this.availableBudget);
        return true;
    }

    private static void checkResourceProfileNotNullOrUnknown(ResourceProfile resourceProfile) {
        Preconditions.checkNotNull(resourceProfile);
        Preconditions.checkArgument(!resourceProfile.equals(ResourceProfile.UNKNOWN));
    }
}

