/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.RestoreMode;
import org.apache.flink.runtime.checkpoint.AbstractCompleteCheckpointStore;
import org.apache.flink.runtime.checkpoint.CheckpointSubsumeHelper;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.Executors;

public class EmbeddedCompletedCheckpointStore
extends AbstractCompleteCheckpointStore {
    private final ArrayDeque<CompletedCheckpoint> checkpoints = new ArrayDeque(2);
    private final AtomicReference<JobStatus> shutdownStatus = new AtomicReference();
    private final int maxRetainedCheckpoints;
    private final Executor ioExecutor = Executors.directExecutor();

    private static void throwAlreadyShutdownException(JobStatus status) {
        throw new IllegalStateException(String.format("Store has been already shutdown with %s.", new Object[]{status}));
    }

    @VisibleForTesting
    public EmbeddedCompletedCheckpointStore() {
        this(1);
    }

    @VisibleForTesting
    public EmbeddedCompletedCheckpointStore(int maxRetainedCheckpoints) {
        this(maxRetainedCheckpoints, Collections.emptyList(), RestoreMode.DEFAULT);
    }

    public EmbeddedCompletedCheckpointStore(int maxRetainedCheckpoints, Collection<CompletedCheckpoint> initialCheckpoints, RestoreMode restoreMode) {
        this(maxRetainedCheckpoints, initialCheckpoints, SharedStateRegistry.DEFAULT_FACTORY.create(Executors.directExecutor(), initialCheckpoints, restoreMode));
    }

    public EmbeddedCompletedCheckpointStore(int maxRetainedCheckpoints, Collection<CompletedCheckpoint> initialCheckpoints, SharedStateRegistry sharedStateRegistry) {
        super(sharedStateRegistry);
        Preconditions.checkArgument(maxRetainedCheckpoints > 0);
        this.maxRetainedCheckpoints = maxRetainedCheckpoints;
        this.checkpoints.addAll(initialCheckpoints);
    }

    @Override
    public CompletedCheckpoint addCheckpointAndSubsumeOldestOne(CompletedCheckpoint checkpoint, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup) throws Exception {
        if (this.shutdownStatus.get() != null) {
            EmbeddedCompletedCheckpointStore.throwAlreadyShutdownException(this.shutdownStatus.get());
        }
        this.checkpoints.addLast(checkpoint);
        CompletedCheckpoint completedCheckpoint = CheckpointSubsumeHelper.subsume(this.checkpoints, this.maxRetainedCheckpoints, cc -> {
            cc.markAsDiscardedOnSubsume();
            checkpointsCleaner.addSubsumedCheckpoint(cc);
        }).orElse(null);
        EmbeddedCompletedCheckpointStore.findLowest(this.checkpoints).ifPresent(id -> checkpointsCleaner.cleanSubsumedCheckpoints((long)id, this.getSharedStateRegistry().unregisterUnusedState((long)id), postCleanup, this.ioExecutor));
        return completedCheckpoint;
    }

    @VisibleForTesting
    void removeOldestCheckpoint() throws Exception {
        CompletedCheckpoint checkpointToSubsume = this.checkpoints.removeFirst();
        checkpointToSubsume.markAsDiscardedOnSubsume().discard();
        this.unregisterUnusedState(this.checkpoints);
    }

    @Override
    public void shutdown(JobStatus jobStatus, CheckpointsCleaner checkpointsCleaner) throws Exception {
        super.shutdown(jobStatus, checkpointsCleaner);
        if (this.shutdownStatus.compareAndSet(null, jobStatus)) {
            if (jobStatus.isGloballyTerminalState()) {
                this.checkpoints.clear();
            }
        } else {
            EmbeddedCompletedCheckpointStore.throwAlreadyShutdownException(this.shutdownStatus.get());
        }
    }

    @Override
    public List<CompletedCheckpoint> getAllCheckpoints() {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    @Override
    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    @Override
    public int getMaxNumberOfRetainedCheckpoints() {
        return this.maxRetainedCheckpoints;
    }

    @Override
    public boolean requiresExternalizedCheckpoints() {
        return false;
    }

    public Optional<JobStatus> getShutdownStatus() {
        return Optional.ofNullable(this.shutdownStatus.get());
    }
}

