/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.util.Preconditions;

public class CheckpointCoordinatorDeActivator
implements JobStatusListener {
    private final CheckpointCoordinator coordinator;
    private final boolean allTasksOutputNonBlocking;

    public CheckpointCoordinatorDeActivator(CheckpointCoordinator coordinator, boolean allTasksOutputNonBlocking) {
        this.coordinator = Preconditions.checkNotNull(coordinator);
        this.allTasksOutputNonBlocking = allTasksOutputNonBlocking;
    }

    @Override
    public void jobStatusChanges(JobID jobId, JobStatus newJobStatus, long timestamp) {
        if (newJobStatus == JobStatus.RUNNING && this.allTasksOutputNonBlocking) {
            this.coordinator.startCheckpointScheduler();
        } else {
            this.coordinator.stopCheckpointScheduler();
        }
    }
}

