/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.annotation.VisibleForTesting;

public class KeyAccountingUnit<K> {
    private final Map<K, Object> noConflictInFlightRecords;

    public KeyAccountingUnit(int initCapacity) {
        this.noConflictInFlightRecords = new ConcurrentHashMap<K, Object>(initCapacity);
    }

    public boolean occupy(Object record, K key) {
        return this.noConflictInFlightRecords.putIfAbsent(key, record) == null;
    }

    public void release(Object record, K key) {
        if (this.noConflictInFlightRecords.remove(key) != record) {
            throw new IllegalStateException(String.format("The record %s(%s) is trying to release key which it actually does not hold.", record, key));
        }
    }

    @VisibleForTesting
    public int occupiedCount() {
        return this.noConflictInFlightRecords.size();
    }
}

