/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.state;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.core.state.CompletedStateFuture;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureImpl;

@Experimental
public class StateFutureUtils {
    public static <V> StateFuture<V> completedVoidFuture() {
        return new CompletedStateFuture<Object>(null);
    }

    public static <V> StateFuture<V> completedFuture(V result) {
        return new CompletedStateFuture<V>(result);
    }

    public static <T> StateFuture<Collection<T>> combineAll(Collection<? extends StateFuture<? extends T>> futures) {
        int count = futures.size();
        if (count == 0) {
            return new CompletedStateFuture<Collection<T>>(Collections.emptyList());
        }
        if (count == 1) {
            StateFuture<Object> firstFuture = futures.stream().findFirst().get();
            return firstFuture.thenCompose(t -> StateFutureUtils.completedFuture(Collections.singletonList(t)));
        }
        Object[] results = new Object[count];
        StateFutureImpl pendingFuture = null;
        for (StateFuture<T> stateFuture : futures) {
            if (!(stateFuture instanceof StateFutureImpl)) continue;
            pendingFuture = (StateFutureImpl)stateFuture;
            break;
        }
        if (pendingFuture == null) {
            int i = 0;
            for (StateFuture<T> stateFuture : futures) {
                int index = i++;
                ((InternalStateFuture)stateFuture).thenSyncAccept(t -> {
                    results[index] = t;
                });
            }
            return new CompletedStateFuture<Collection<T>>(Arrays.asList(results));
        }
        int i = 0;
        AtomicInteger atomicInteger = new AtomicInteger(count);
        StateFutureImpl<Collection<T>> stateFutureImpl = pendingFuture.makeNewStateFuture();
        for (StateFuture<T> stateFuture : futures) {
            int index = i++;
            ((InternalStateFuture)stateFuture).thenSyncAccept(t -> {
                results[index] = t;
                if (countDown.decrementAndGet() == 0) {
                    ret.complete(Arrays.asList(results));
                }
            });
        }
        return stateFutureImpl;
    }
}

