/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.util.Preconditions;

@Deprecated
@PublicEvolving
public final class TypeInformationRawType<T>
extends LogicalType {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT = "RAW('%s', ?)";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = TypeInformationRawType.conversionSet(byte[].class.getName(), RawValueData.class.getName());
    private static final TypeInformation<?> DEFAULT_TYPE_INFO = Types.GENERIC(Object.class);
    private final TypeInformation<T> typeInfo;

    public TypeInformationRawType(boolean isNullable, TypeInformation<T> typeInfo) {
        super(isNullable, LogicalTypeRoot.RAW);
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "Type information must not be null.");
    }

    public TypeInformationRawType(TypeInformation<T> typeInfo) {
        this(true, typeInfo);
    }

    public TypeInformationRawType() {
        this(true, DEFAULT_TYPE_INFO);
    }

    public TypeInformation<T> getTypeInformation() {
        return this.typeInfo;
    }

    @Internal
    public RawType<T> resolve(ExecutionConfig config) {
        return new RawType<T>(this.isNullable(), this.typeInfo.getTypeClass(), this.typeInfo.createSerializer(config.getSerializerConfig()));
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new TypeInformationRawType<T>(isNullable, this.typeInfo);
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.typeInfo.getTypeClass().getName());
    }

    @Override
    public String asSerializableString() {
        throw new TableException("A raw type backed by type information has no serializable string representation. It needs to be resolved into a proper raw type.");
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.typeInfo.getTypeClass().isAssignableFrom(clazz) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return clazz.isAssignableFrom(this.typeInfo.getTypeClass()) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return this.typeInfo.getTypeClass();
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeInformationRawType that = (TypeInformationRawType)o;
        return this.typeInfo.equals(that.typeInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.typeInfo);
    }
}

