/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.functions.SqlLikeUtils;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ShowOperation;
import org.apache.flink.util.Preconditions;

@Internal
public class ShowTablesOperation
implements ShowOperation {
    private final String catalogName;
    private final String databaseName;
    private final boolean useLike;
    private final boolean notLike;
    private final String likePattern;
    private final String preposition;

    public ShowTablesOperation() {
        this.catalogName = null;
        this.databaseName = null;
        this.likePattern = null;
        this.useLike = false;
        this.notLike = false;
        this.preposition = null;
    }

    public ShowTablesOperation(String likePattern, boolean useLike, boolean notLike) {
        this.catalogName = null;
        this.databaseName = null;
        this.likePattern = useLike ? Preconditions.checkNotNull(likePattern, "Like pattern must not be null") : null;
        this.useLike = useLike;
        this.notLike = notLike;
        this.preposition = null;
    }

    public ShowTablesOperation(String catalogName, String databaseName, String likePattern, boolean useLike, boolean notLike, String preposition) {
        this.catalogName = Preconditions.checkNotNull(catalogName, "Catalog name must not be null");
        this.databaseName = Preconditions.checkNotNull(databaseName, "Database name must not be null");
        this.likePattern = useLike ? Preconditions.checkNotNull(likePattern, "Like pattern must not be null") : null;
        this.useLike = useLike;
        this.notLike = notLike;
        this.preposition = Preconditions.checkNotNull(preposition, "Preposition must not be null");
    }

    public String getLikePattern() {
        return this.likePattern;
    }

    public String getPreposition() {
        return this.preposition;
    }

    public boolean isUseLike() {
        return this.useLike;
    }

    public boolean isNotLike() {
        return this.notLike;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String asSummaryString() {
        StringBuilder builder = new StringBuilder().append("SHOW TABLES");
        if (this.preposition != null) {
            builder.append(String.format(" %s %s.%s", this.preposition, this.catalogName, this.databaseName));
        }
        if (this.useLike) {
            if (this.notLike) {
                builder.append(String.format(" %s LIKE %s", "NOT", this.likePattern));
            } else {
                builder.append(String.format(" LIKE %s", this.likePattern));
            }
        }
        return builder.toString();
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Set<String> tables;
        if (this.preposition == null) {
            tables = ctx.getCatalogManager().listTables();
        } else {
            Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.catalogName);
            if (catalog.databaseExists(this.databaseName)) {
                tables = ctx.getCatalogManager().listTables(this.catalogName, this.databaseName);
            } else {
                throw new ValidationException(String.format("Database '%s'.'%s' doesn't exist.", this.catalogName, this.databaseName));
            }
        }
        String[] rows = this.useLike ? (String[])tables.stream().filter(row -> this.notLike != SqlLikeUtils.like(row, this.likePattern, "\\")).sorted().toArray(String[]::new) : (String[])tables.stream().sorted().toArray(String[]::new);
        return TableResultUtils.buildStringArrayResult("table name", rows);
    }
}

