/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DayTimeIntervalType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

@Internal
public final class LogicalTypeJsonDeserializer
extends StdDeserializer<LogicalType> {
    private static final long serialVersionUID = 1L;

    LogicalTypeJsonDeserializer() {
        super(LogicalType.class);
    }

    @Override
    public LogicalType deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode logicalTypeNode = (JsonNode)jsonParser.readValueAsTree();
        if (logicalTypeNode.has("type")) {
            return this.deserializeInternal(logicalTypeNode);
        }
        throw new UnsupportedOperationException(String.format("Cannot parse this Json String:\n%s", logicalTypeNode.toPrettyString()));
    }

    private LogicalType deserializeInternal(JsonNode logicalTypeNode) {
        LogicalTypeRoot typeRoot = LogicalTypeRoot.valueOf(logicalTypeNode.get("type").asText());
        if (typeRoot.equals((Object)LogicalTypeRoot.NULL)) {
            return new NullType();
        }
        boolean isNullable = logicalTypeNode.get("nullable").asBoolean();
        switch (typeRoot) {
            case BOOLEAN: {
                return new BooleanType(isNullable);
            }
            case TINYINT: {
                return new TinyIntType(isNullable);
            }
            case SMALLINT: {
                return new SmallIntType(isNullable);
            }
            case INTEGER: {
                return new IntType(isNullable);
            }
            case BIGINT: {
                return new BigIntType(isNullable);
            }
            case FLOAT: {
                return new FloatType(isNullable);
            }
            case DOUBLE: {
                return new DoubleType(isNullable);
            }
            case DATE: {
                return new DateType(isNullable);
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return this.deserializeLengthFieldType(typeRoot, logicalTypeNode).copy(isNullable);
            }
            case DECIMAL: {
                return new DecimalType(isNullable, logicalTypeNode.get("precision").asInt(), logicalTypeNode.get("scale").asInt());
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.deserializeTimestamp(typeRoot, logicalTypeNode).copy(isNullable);
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return this.deserializeInterval(isNullable, typeRoot, logicalTypeNode);
            }
            case MAP: {
                return this.deserializeMap(logicalTypeNode).copy(isNullable);
            }
            case ARRAY: 
            case MULTISET: {
                return this.deserializeCollection(typeRoot, logicalTypeNode).copy(isNullable);
            }
            case ROW: {
                return this.deserializeRow(logicalTypeNode).copy(isNullable);
            }
            case RAW: {
                return this.deserializeRaw(logicalTypeNode).copy(isNullable);
            }
        }
        throw new UnsupportedOperationException(String.format("Unable to deserialize a logical type of type root '%s'. Please check the documentation for supported types.", typeRoot.name()));
    }

    private LogicalType deserializeLengthFieldType(LogicalTypeRoot typeRoot, JsonNode logicalTypeNode) {
        int length = logicalTypeNode.get("length").asInt();
        switch (typeRoot) {
            case CHAR: {
                return length == 0 ? CharType.ofEmptyLiteral() : new CharType(length);
            }
            case VARCHAR: {
                return length == 0 ? VarCharType.ofEmptyLiteral() : new VarCharType(length);
            }
            case BINARY: {
                return length == 0 ? BinaryType.ofEmptyLiteral() : new BinaryType(length);
            }
            case VARBINARY: {
                return length == 0 ? VarBinaryType.ofEmptyLiteral() : new VarBinaryType(length);
            }
        }
        throw new SqlGatewayException(String.format("Cannot convert JSON string '%s' to the logical type '%s', '%s', '%s' or '%s'.", logicalTypeNode.toPrettyString(), LogicalTypeRoot.CHAR.name(), LogicalTypeRoot.VARCHAR.name(), LogicalTypeRoot.BINARY.name(), LogicalTypeRoot.VARBINARY.name()));
    }

    private LogicalType deserializeTimestamp(LogicalTypeRoot typeRoot, JsonNode logicalTypeNode) {
        int precision = logicalTypeNode.get("precision").asInt();
        switch (typeRoot) {
            case TIME_WITHOUT_TIME_ZONE: {
                return new TimeType(precision);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return new TimestampType(precision);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return new ZonedTimestampType(precision);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new LocalZonedTimestampType(precision);
            }
        }
        throw new TableException("Timestamp type root expected.");
    }

    private LogicalType deserializeInterval(boolean isNullable, LogicalTypeRoot typeRoot, JsonNode logicalTypeNode) {
        int precision = logicalTypeNode.get("precision").asInt();
        switch (typeRoot) {
            case INTERVAL_YEAR_MONTH: {
                return new YearMonthIntervalType(isNullable, YearMonthIntervalType.YearMonthResolution.valueOf(logicalTypeNode.get("resolution").asText()), precision);
            }
            case INTERVAL_DAY_TIME: {
                return new DayTimeIntervalType(isNullable, DayTimeIntervalType.DayTimeResolution.valueOf(logicalTypeNode.get("resolution").asText()), precision, logicalTypeNode.get("fractionalPrecision").asInt());
            }
        }
        throw new TableException("Interval type root expected.");
    }

    private LogicalType deserializeMap(JsonNode logicalTypeNode) {
        JsonNode keyNode = logicalTypeNode.get("keyType");
        LogicalType keyType = this.deserializeInternal(keyNode);
        JsonNode valueNode = logicalTypeNode.get("valueType");
        LogicalType valueType = this.deserializeInternal(valueNode);
        return new MapType(keyType, valueType);
    }

    private LogicalType deserializeCollection(LogicalTypeRoot typeRoot, JsonNode logicalTypeNode) {
        JsonNode elementNode = logicalTypeNode.get("elementType");
        LogicalType elementType = this.deserializeInternal(elementNode);
        switch (typeRoot) {
            case ARRAY: {
                return new ArrayType(elementType);
            }
            case MULTISET: {
                return new MultisetType(elementType);
            }
        }
        throw new TableException("Collection type root expected.");
    }

    private LogicalType deserializeRow(JsonNode logicalTypeNode) {
        ArrayNode fieldNodes = (ArrayNode)logicalTypeNode.get("fields");
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        fieldNodes.forEach(fieldNode -> {
            String fieldName = fieldNode.get("name").asText();
            LogicalType fieldType = this.deserializeInternal(fieldNode.get("fieldType"));
            String description = null;
            if (fieldNode.has("description")) {
                description = fieldNode.get("description").asText();
            }
            fields.add(new RowType.RowField(fieldName, fieldType, description));
        });
        return new RowType(fields);
    }

    private LogicalType deserializeRaw(JsonNode logicalTypeNode) {
        String className = logicalTypeNode.get("class").asText();
        String serializer = logicalTypeNode.get("serializer").asText();
        return RawType.restore(LogicalTypeJsonDeserializer.class.getClassLoader(), className, serializer);
    }
}

