/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultResponseBodyImpl;
import org.apache.flink.table.gateway.rest.message.statement.FetchResultsResponseBody;
import org.apache.flink.table.gateway.rest.message.statement.NotReadyFetchResultResponse;
import org.apache.flink.table.gateway.rest.serde.ResultInfo;

public class FetchResultResponseBodyDeserializer
extends StdDeserializer<FetchResultsResponseBody> {
    private static final long serialVersionUID = 1L;

    protected FetchResultResponseBodyDeserializer() {
        super(FetchResultsResponseBody.class);
    }

    @Override
    public FetchResultsResponseBody deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        ResultSet.ResultType resultType = this.getResultType(jsonNode);
        if (resultType == ResultSet.ResultType.NOT_READY) {
            return new NotReadyFetchResultResponse(jsonNode.required("nextResultUri").asText());
        }
        boolean isQuery = jsonNode.required("isQueryResult").asBoolean();
        ResultInfo result = context.readValue(jsonNode.required("results").traverse(jsonParser.getCodec()), ResultInfo.class);
        ResultKind resultKind = ResultKind.valueOf(jsonNode.required("resultKind").asText());
        JobID jobID = jsonNode.has("jobID") ? JobID.fromHexString(jsonNode.get("jobID").asText()) : null;
        return new FetchResultResponseBodyImpl(resultType, isQuery, jobID, resultKind, result, jsonNode.has("nextResultUri") ? jsonNode.get("nextResultUri").asText() : null);
    }

    private ResultSet.ResultType getResultType(JsonNode serialized) throws IOException {
        if (!serialized.has("resultType")) {
            throw new IOException(String.format("Can not find the required field %s.", "resultType"));
        }
        return ResultSet.ResultType.valueOf(serialized.get("resultType").asText());
    }
}

