/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.statement;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.operation.OperationHandle;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.session.SessionMessageParameters;
import org.apache.flink.table.gateway.rest.message.statement.ExecuteStatementRequestBody;
import org.apache.flink.table.gateway.rest.message.statement.ExecuteStatementResponseBody;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class ExecuteStatementHandler
extends AbstractSqlGatewayRestHandler<ExecuteStatementRequestBody, ExecuteStatementResponseBody, SessionMessageParameters> {
    public ExecuteStatementHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<ExecuteStatementRequestBody, ExecuteStatementResponseBody, SessionMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<ExecuteStatementResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<ExecuteStatementRequestBody> request) {
        String statement = request.getRequestBody().getStatement();
        Long timeout = request.getRequestBody().getTimeout();
        timeout = timeout == null ? 0L : timeout;
        SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
        Map<String, String> executionConfigMap = request.getRequestBody().getExecutionConfig();
        Configuration executionConfig = executionConfigMap == null ? new Configuration() : Configuration.fromMap(executionConfigMap);
        OperationHandle operationHandle = this.service.executeStatement(sessionHandle, statement, timeout, executionConfig);
        return CompletableFuture.completedFuture(new ExecuteStatementResponseBody(operationHandle.getIdentifier().toString()));
    }
}

