/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.AbstractHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.NonLeaderRetrievalRestfulGateway;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;
import org.apache.flink.util.concurrent.FutureUtils;

public abstract class AbstractSqlGatewayRestHandler<R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
extends AbstractHandler<NonLeaderRetrievalRestfulGateway, R, M> {
    protected SqlGatewayService service;
    private final MessageHeaders<R, P, M> messageHeaders;

    protected AbstractSqlGatewayRestHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<R, P, M> messageHeaders) {
        super(() -> CompletableFuture.completedFuture(NonLeaderRetrievalRestfulGateway.INSTANCE), Time.seconds(1L), responseHeaders, messageHeaders);
        this.service = service;
        this.messageHeaders = messageHeaders;
    }

    @Override
    protected CompletableFuture<Void> respondToRequest(ChannelHandlerContext ctx, HttpRequest httpRequest, HandlerRequest<R> handlerRequest, NonLeaderRetrievalRestfulGateway gateway) {
        CompletableFuture<Object> response;
        try {
            response = this.handleRequest(SqlGatewayRestAPIVersion.fromURIToVersion(httpRequest.uri()), handlerRequest);
        }
        catch (RestHandlerException e) {
            response = FutureUtils.completedExceptionally(e);
        }
        return response.thenAccept(resp -> HandlerUtils.sendResponse(ctx, httpRequest, resp, this.messageHeaders.getResponseStatusCode(), (Map<String, String>)this.responseHeaders));
    }

    protected abstract CompletableFuture<P> handleRequest(@Nullable SqlGatewayRestAPIVersion var1, @Nonnull HandlerRequest<R> var2) throws RestHandlerException;
}

