/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.utils;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ThreadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtils.class);

    public static ThreadPoolExecutor newThreadPool(int poolSize, int poolQueueSize, long keepAliveMs, String threadPoolName) {
        LOG.info("Created thread pool {} with core size {}, max size {} and keep alive time {}ms.", new Object[]{threadPoolName, poolSize, poolQueueSize, keepAliveMs});
        return new ThreadPoolExecutor(poolSize, poolQueueSize, keepAliveMs, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ExecutorThreadFactory(threadPoolName));
    }
}

