/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.result;

import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.client.gateway.result.MaterializedCollectResultBase;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CollectionUtil;

public class MaterializedCollectStreamResult
extends MaterializedCollectResultBase {
    private final Map<RowData, Integer> rowPositionCache;

    @VisibleForTesting
    public MaterializedCollectStreamResult(StatementResult tableResult, int maxRowCount, int overcommitThreshold) {
        super(tableResult, maxRowCount, overcommitThreshold);
        int initialCapacity = MaterializedCollectStreamResult.computeMaterializedTableCapacity(maxRowCount);
        this.rowPositionCache = CollectionUtil.newHashMapWithExpectedSize(initialCapacity);
        this.retrievalThread.start();
    }

    public MaterializedCollectStreamResult(StatementResult tableResult, int maxRowCount) {
        this(tableResult, maxRowCount, MaterializedCollectStreamResult.computeMaterializedTableOvercommit(maxRowCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRecord(RowData row) {
        Object object = this.resultLock;
        synchronized (object) {
            boolean isInsertOp = row.getRowKind() == RowKind.INSERT || row.getRowKind() == RowKind.UPDATE_AFTER;
            row.setRowKind(RowKind.INSERT);
            if (isInsertOp) {
                this.processInsert(row);
            } else {
                this.processDelete(row);
            }
        }
    }

    private void processInsert(RowData row) {
        if (this.materializedTable.size() - this.validRowPosition >= this.maxRowCount) {
            this.cleanUp();
        }
        this.materializedTable.add(row);
        this.rowPositionCache.put(row, this.materializedTable.size() - 1);
    }

    private void processDelete(RowData row) {
        Integer cachedPos = this.rowPositionCache.get(row);
        int startSearchPos = cachedPos != null ? Math.min(cachedPos, this.materializedTable.size() - 1) : this.materializedTable.size() - 1;
        for (int i = startSearchPos; i >= this.validRowPosition; --i) {
            if (!((RowData)this.materializedTable.get(i)).equals(row)) continue;
            this.materializedTable.remove(i);
            this.rowPositionCache.remove(row);
            break;
        }
    }

    private void cleanUp() {
        RowData deleteRow = (RowData)this.materializedTable.get(this.validRowPosition);
        if (this.rowPositionCache.get(deleteRow) == this.validRowPosition) {
            this.rowPositionCache.remove(deleteRow);
        }
        this.materializedTable.set(this.validRowPosition, null);
        ++this.validRowPosition;
        if (this.validRowPosition >= this.overcommitThreshold) {
            this.materializedTable.subList(0, this.validRowPosition).clear();
            this.rowPositionCache.replaceAll((k, v) -> v - this.validRowPosition);
            this.validRowPosition = 0;
        }
    }
}

