/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.AbstractCatalogStore;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.exceptions.CatalogException;

@Internal
public class GenericInMemoryCatalogStore
extends AbstractCatalogStore {
    private final Map<String, CatalogDescriptor> descriptors = new HashMap<String, CatalogDescriptor>();

    @Override
    public void storeCatalog(String catalogName, CatalogDescriptor catalog) throws CatalogException {
        this.checkOpenState();
        if (this.descriptors.containsKey(catalogName)) {
            throw new CatalogException(String.format("Catalog %s already exists in the catalog store.", catalogName));
        }
        this.descriptors.put(catalogName, catalog);
    }

    @Override
    public void removeCatalog(String catalogName, boolean ignoreIfNotExists) throws CatalogException {
        this.checkOpenState();
        if (this.descriptors.containsKey(catalogName)) {
            this.descriptors.remove(catalogName);
        } else if (!ignoreIfNotExists) {
            throw new CatalogException(String.format("Catalog %s does not exist in the catalog store.", catalogName));
        }
    }

    @Override
    public Optional<CatalogDescriptor> getCatalog(String catalogName) {
        this.checkOpenState();
        return Optional.ofNullable(this.descriptors.get(catalogName));
    }

    @Override
    public Set<String> listCatalogs() {
        this.checkOpenState();
        return this.descriptors.keySet();
    }

    @Override
    public boolean contains(String catalogName) {
        this.checkOpenState();
        return this.descriptors.containsKey(catalogName);
    }
}

