/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractCatalogTable
implements CatalogTable {
    private final TableSchema tableSchema;
    private final List<String> partitionKeys;
    private final Map<String, String> options;
    private final String comment;

    public AbstractCatalogTable(TableSchema tableSchema, Map<String, String> options, String comment) {
        this(tableSchema, new ArrayList<String>(), options, comment);
    }

    public AbstractCatalogTable(TableSchema tableSchema, List<String> partitionKeys, Map<String, String> options, String comment) {
        this.tableSchema = Preconditions.checkNotNull(tableSchema, "tableSchema cannot be null");
        this.partitionKeys = Preconditions.checkNotNull(partitionKeys, "partitionKeys cannot be null");
        this.options = Preconditions.checkNotNull(options, "options cannot be null");
        Preconditions.checkArgument(options.entrySet().stream().allMatch(e -> e.getKey() != null && e.getValue() != null), "properties cannot have null keys or values");
        this.comment = comment;
    }

    @Override
    public boolean isPartitioned() {
        return !this.partitionKeys.isEmpty();
    }

    @Override
    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public TableSchema getSchema() {
        return this.tableSchema;
    }

    @Override
    public String getComment() {
        return this.comment != null ? this.comment : "";
    }
}

